<?php

use Illuminate\Support\Facades\Facade;

return [
    /*
    |--------------------------------------------------------------------------
    | Installation status
    |--------------------------------------------------------------------------
    |
    | This value is used to set the application as installed or not.
    |
    */

    'installed' => (bool)env('APP_INSTALLED', false),

    /*
    |--------------------------------------------------------------------------
    | CSRF additional exceptions
    |--------------------------------------------------------------------------
    |
    | This path load the csrf exceptions created for user custom routes.
    |
    */    
    'csrf_except' => file(__DIR__."/../.csrf_except"),

    /*
    |--------------------------------------------------------------------------
    | Codemayer API
    |--------------------------------------------------------------------------
    |
    | This URL is used to fetch remortely the available extensions, themes 
    | and fixes for vAlexa script.
    |
    */

    'codemayer_api' => env('CODEMAYER_API', 'https://www.codemayer.net/api'),

    /*
    |--------------------------------------------------------------------------
    | Application Name
    |--------------------------------------------------------------------------
    |
    | This value is the name of your application. This value is used when the
    | framework needs to place the application's name in a notification or
    | any other location as required by the application or its packages.
    |
    */

    'name' => env('APP_NAME', 'Laravel'),

    /*
    |--------------------------------------------------------------------------
    | Application Environment
    |--------------------------------------------------------------------------
    |
    | This value determines the "environment" your application is currently
    | running in. This may determine how you prefer to configure various
    | services the application utilizes. Set this in your ".env" file.
    |
    */

    'env' => env('APP_ENV', 'production'),

    /*
    |--------------------------------------------------------------------------
    | Application Debug Mode
    |--------------------------------------------------------------------------
    |
    | When your application is in debug mode, detailed error messages with
    | stack traces will be shown on every error that occurs within your
    | application. If disabled, a simple generic error page is shown.
    |
    */

    'debug' => (bool) env('APP_DEBUG', false),

    /*
    |--------------------------------------------------------------------------
    | Application URL
    |--------------------------------------------------------------------------
    |
    | This URL is used by the console to properly generate URLs when using
    | the Artisan command line tool. You should set this to the root of
    | your application so that it is used when running Artisan tasks.
    |
    */

    'url' => (php_sapi_name() === 'cli') ? '' : "{$_SERVER['REQUEST_SCHEME']}://{$_SERVER['HTTP_HOST']}",

    'asset_url' => env('ASSET_URL'),

    /*
    |--------------------------------------------------------------------------
    | Application Timezone
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default timezone for your application, which
    | will be used by the PHP date and date-time functions. We have gone
    | ahead and set this to a sensible default for you out of the box.
    |
    */

    'timezone' => 'UTC',

    /*
    |--------------------------------------------------------------------------
    | Application Locale Configuration
    |--------------------------------------------------------------------------
    |
    | The application locale determines the default locale that will be used
    | by the translation service provider. You are free to set this value
    | to any of the locales which will be supported by the application.
    |
    */

    'locale' => 'en',

    /*
    |--------------------------------------------------------------------------
    | Application Fallback Locale
    |--------------------------------------------------------------------------
    |
    | The fallback locale determines the locale to use when the current one
    | is not available. You may change the value to correspond to any of
    | the language folders that are provided through your application.
    |
    */

    'fallback_locale' => 'en',

    /*
    |--------------------------------------------------------------------------
    | Faker Locale
    |--------------------------------------------------------------------------
    |
    | This locale will be used by the Faker PHP library when generating fake
    | data for your database seeds. For example, this will be used to get
    | localized telephone numbers, street address information and more.
    |
    */

    'faker_locale' => 'en_US',

    /*
    |--------------------------------------------------------------------------
    | Encryption Key
    |--------------------------------------------------------------------------
    |
    | This key is used by the Illuminate encrypter service and should be set
    | to a random, 32 character string, otherwise these encrypted strings
    | will not be safe. Please do this before deploying an application!
    |
    */

    'key' => env('APP_KEY'),

    'cipher' => 'AES-256-CBC',

    /*
    |--------------------------------------------------------------------------
    | Maintenance Mode Driver
    |--------------------------------------------------------------------------
    |
    | These configuration options determine the driver used to determine and
    | manage Laravel's "maintenance mode" status. The "cache" driver will
    | allow maintenance mode to be controlled across multiple machines.
    |
    | Supported drivers: "file", "cache"
    |
    */

    'maintenance' => [
        'driver' => 'file',
        // 'store'  => 'redis',
    ],

    /*
    |--------------------------------------------------------------------------
    | Autoloaded Service Providers
    |--------------------------------------------------------------------------
    |
    | The service providers listed here will be automatically loaded on the
    | request to your application. Feel free to add your own services to
    | this array to grant expanded functionality to your applications.
    |
    */

    'providers' => [

        /*
         * Laravel Framework Service Providers...
         */
        Illuminate\Auth\AuthServiceProvider::class,
        Illuminate\Broadcasting\BroadcastServiceProvider::class,
        Illuminate\Bus\BusServiceProvider::class,
        Illuminate\Cache\CacheServiceProvider::class,
        Illuminate\Foundation\Providers\ConsoleSupportServiceProvider::class,
        Illuminate\Cookie\CookieServiceProvider::class,
        Illuminate\Database\DatabaseServiceProvider::class,
        Illuminate\Encryption\EncryptionServiceProvider::class,
        Illuminate\Filesystem\FilesystemServiceProvider::class,
        Illuminate\Foundation\Providers\FoundationServiceProvider::class,
        Illuminate\Hashing\HashServiceProvider::class,
        Illuminate\Mail\MailServiceProvider::class,
        Illuminate\Notifications\NotificationServiceProvider::class,
        Illuminate\Pagination\PaginationServiceProvider::class,
        Illuminate\Pipeline\PipelineServiceProvider::class,
        Illuminate\Queue\QueueServiceProvider::class,
        Illuminate\Redis\RedisServiceProvider::class,
        Illuminate\Auth\Passwords\PasswordResetServiceProvider::class,
        Illuminate\Session\SessionServiceProvider::class,
        Illuminate\Translation\TranslationServiceProvider::class,
        Illuminate\Validation\ValidationServiceProvider::class,
        Illuminate\View\ViewServiceProvider::class,
        hisorange\BrowserDetect\ServiceProvider::class,

        /*
         * Package Service Providers...
         */
        App\Providers\BladeCacheDirectiveServiceProvider::class,

        /*
         * Application Service Providers...
         */
        App\Providers\AppServiceProvider::class,
        App\Providers\AuthServiceProvider::class,
        // App\Providers\BroadcastServiceProvider::class,
        App\Providers\EventServiceProvider::class,
        App\Providers\RouteServiceProvider::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Class Aliases
    |--------------------------------------------------------------------------
    |
    | This array of class aliases will be registered when this application
    | is started. However, feel free to register as many as you wish as
    | the aliases are "lazy" loaded so they don't hinder performance.
    |
    */

    'aliases' => Facade::defaultAliases()->merge([
        'App' => Illuminate\Support\Facades\App::class,
        'Arr' => Illuminate\Support\Arr::class,
        'Artisan' => Illuminate\Support\Facades\Artisan::class,
        'Auth' => Illuminate\Support\Facades\Auth::class,
        'Blade' => Illuminate\Support\Facades\Blade::class,
        'Broadcast' => Illuminate\Support\Facades\Broadcast::class,
        'Bus' => Illuminate\Support\Facades\Bus::class,
        'Cache' => Illuminate\Support\Facades\Cache::class,
        'Config' => Illuminate\Support\Facades\Config::class,
        'Cookie' => Illuminate\Support\Facades\Cookie::class,
        'Crypt' => Illuminate\Support\Facades\Crypt::class,
        'DB' => Illuminate\Support\Facades\DB::class,
        'Eloquent' => Illuminate\Database\Eloquent\Model::class,
        'Event' => Illuminate\Support\Facades\Event::class,
        'File' => Illuminate\Support\Facades\File::class,
        'Gate' => Illuminate\Support\Facades\Gate::class,
        'Hash' => Illuminate\Support\Facades\Hash::class,
        'Http' => Illuminate\Support\Facades\Http::class,
        'Lang' => Illuminate\Support\Facades\Lang::class,
        'Log' => Illuminate\Support\Facades\Log::class,
        'Mail' => Illuminate\Support\Facades\Mail::class,
        'Notification' => Illuminate\Support\Facades\Notification::class,
        'Password' => Illuminate\Support\Facades\Password::class,
        'Queue' => Illuminate\Support\Facades\Queue::class,
        'Redirect' => Illuminate\Support\Facades\Redirect::class,
        'Redis' => Illuminate\Support\Facades\Redis::class,
        'Request' => Illuminate\Support\Facades\Request::class,
        'Response' => Illuminate\Support\Facades\Response::class,
        'Route' => Illuminate\Support\Facades\Route::class,
        'Schema' => Illuminate\Support\Facades\Schema::class,
        'Session' => Illuminate\Support\Facades\Session::class,
        'Storage' => Illuminate\Support\Facades\Storage::class,
        'Str' => Illuminate\Support\Str::class,
        'URL' => Illuminate\Support\Facades\URL::class,
        'Validator' => Illuminate\Support\Facades\Validator::class,
        'View' => Illuminate\Support\Facades\View::class,
        'Image' => Intervention\Image\Facades\Image::class,
        'PDF' => Barryvdh\DomPDF\Facade::class,
        'Captcha' => Mews\Captcha\Facades\Captcha::class,
        'BrowserDetect' => hisorange\BrowserDetect\Facade::class,
    ])->toArray(),


    'country_names' => '["Bangladesh","Belgium","Burkina Faso","Bulgaria","Bosnia and Herzegovina","Barbados","Wallis and Futuna","Saint Barthelemy","Bermuda","Brunei","Bolivia","Bahrain","Burundi","Benin","Bhutan","Jamaica","Bouvet Island","Botswana","Samoa","Bonaire, Saint Eustatius and Saba ","Brazil","Bahamas","Jersey","Belarus","Belize","Russia","Rwanda","Serbia","East Timor","Reunion","Turkmenistan","Tajikistan","Romania","Tokelau","Guinea-Bissau","Guam","Guatemala","South Georgia and the South Sandwich Islands","Greece","Equatorial Guinea","Guadeloupe","Japan","Guyana","Guernsey","French Guiana","Georgia","Grenada","United Kingdom","Gabon","El Salvador","Guinea","Gambia","Greenland","Gibraltar","Ghana","Oman","Tunisia","Jordan","Croatia","Haiti","Hungary","Hong Kong","Honduras","Heard Island and McDonald Islands","Venezuela","Puerto Rico","Palestinian Territory","Palau","Portugal","Svalbard and Jan Mayen","Paraguay","Iraq","Panama","French Polynesia","Papua New Guinea","Peru","Pakistan","Philippines","Pitcairn","Poland","Saint Pierre and Miquelon","Zambia","Western Sahara","Estonia","Egypt","South Africa","Ecuador","Italy","Vietnam","Solomon Islands","Ethiopia","Somalia","Zimbabwe","Saudi Arabia","Spain","Eritrea","Montenegro","Moldova","Madagascar","Saint Martin","Morocco","Monaco","Uzbekistan","Myanmar","Mali","Macao","Mongolia","Marshall Islands","Macedonia","Mauritius","Malta","Malawi","Maldives","Martinique","Northern Mariana Islands","Montserrat","Mauritania","Isle of Man","Uganda","Tanzania","Malaysia","Mexico","Israel","France","British Indian Ocean Territory","Saint Helena","Finland","Fiji","Falkland Islands","Micronesia","Faroe Islands","Nicaragua","Netherlands","Norway","Namibia","Vanuatu","New Caledonia","Niger","Norfolk Island","Nigeria","New Zealand","Nepal","Nauru","Niue","Cook Islands","Kosovo","Ivory Coast","Switzerland","Colombia","China","Cameroon","Chile","Cocos Islands","Canada","Republic of the Congo","Central African Republic","Democratic Republic of the Congo","Czech Republic","Cyprus","Christmas Island","Costa Rica","Curacao","Cape Verde","Cuba","Swaziland","Syria","Sint Maarten","Kyrgyzstan","Kenya","South Sudan","Suriname","Kiribati","Cambodia","Saint Kitts and Nevis","Comoros","Sao Tome and Principe","Slovakia","South Korea","Slovenia","North Korea","Kuwait","Senegal","San Marino","Sierra Leone","Seychelles","Kazakhstan","Cayman Islands","Singapore","Sweden","Sudan","Dominican Republic","Dominica","Djibouti","Denmark","British Virgin Islands","Germany","Yemen","Algeria","United States","Uruguay","Mayotte","United States Minor Outlying Islands","Lebanon","Saint Lucia","Laos","Tuvalu","Taiwan","Trinidad and Tobago","Turkey","Sri Lanka","Liechtenstein","Latvia","Tonga","Lithuania","Luxembourg","Liberia","Lesotho","Thailand","French Southern Territories","Togo","Chad","Turks and Caicos Islands","Libya","Vatican","Saint Vincent and the Grenadines","United Arab Emirates","Andorra","Antigua and Barbuda","Afghanistan","Anguilla","U.S. Virgin Islands","Iceland","Iran","Armenia","Albania","Angola","Antarctica","American Samoa","Argentina","Australia","Austria","Aruba","India","Aland Islands","Azerbaijan","Ireland","Indonesia","Ukraine","Qatar","Mozambique"]',

    'timezones' => [
        'Pacific/Midway'       => "(GMT-11:00) Midway Island",
        'US/Samoa'             => "(GMT-11:00) Samoa",
        'US/Hawaii'            => "(GMT-10:00) Hawaii",
        'US/Alaska'            => "(GMT-09:00) Alaska",
        'US/Pacific'           => "(GMT-08:00) Pacific Time (US &amp; Canada)",
        'America/Tijuana'      => "(GMT-08:00) Tijuana",
        'US/Arizona'           => "(GMT-07:00) Arizona",
        'US/Mountain'          => "(GMT-07:00) Mountain Time (US &amp; Canada)",
        'America/Chihuahua'    => "(GMT-07:00) Chihuahua",
        'America/Mazatlan'     => "(GMT-07:00) Mazatlan",
        'America/Mexico_City'  => "(GMT-06:00) Mexico City",
        'America/Monterrey'    => "(GMT-06:00) Monterrey",
        'Canada/Saskatchewan'  => "(GMT-06:00) Saskatchewan",
        'US/Central'           => "(GMT-06:00) Central Time (US &amp; Canada)",
        'US/Eastern'           => "(GMT-05:00) Eastern Time (US &amp; Canada)",
        'US/East-Indiana'      => "(GMT-05:00) Indiana (East)",
        'America/Bogota'       => "(GMT-05:00) Bogota",
        'America/Lima'         => "(GMT-05:00) Lima",
        'America/Caracas'      => "(GMT-04:30) Caracas",
        'Canada/Atlantic'      => "(GMT-04:00) Atlantic Time (Canada)",
        'America/La_Paz'       => "(GMT-04:00) La Paz",
        'America/Santiago'     => "(GMT-04:00) Santiago",
        'America/New_York'     => "(GMT-04:00 New York)",
        'Canada/Newfoundland'  => "(GMT-03:30) Newfoundland",
        'America/Buenos_Aires' => "(GMT-03:00) Buenos Aires",
        'Greenland'            => "(GMT-03:00) Greenland",
        'Atlantic/Stanley'     => "(GMT-02:00) Stanley",
        'Atlantic/Azores'      => "(GMT-01:00) Azores",
        'Atlantic/Cape_Verde'  => "(GMT-01:00) Cape Verde Is.",
        'Africa/Casablanca'    => "(GMT+01:00) Casablanca",
        'Europe/Dublin'        => "(GMT+00:00) Dublin",
        'Europe/Lisbon'        => "(GMT+00:00) Lisbon",
        'Europe/London'        => "(GMT+00:00) London",
        'Africa/Monrovia'      => "(GMT+00:00) Monrovia",
        'Europe/Amsterdam'     => "(GMT+01:00) Amsterdam",
        'Europe/Belgrade'      => "(GMT+01:00) Belgrade",
        'Europe/Berlin'        => "(GMT+01:00) Berlin",
        'Europe/Bratislava'    => "(GMT+01:00) Bratislava",
        'Europe/Brussels'      => "(GMT+01:00) Brussels",
        'Europe/Budapest'      => "(GMT+01:00) Budapest",
        'Europe/Copenhagen'    => "(GMT+01:00) Copenhagen",
        'Europe/Ljubljana'     => "(GMT+01:00) Ljubljana",
        'Europe/Madrid'        => "(GMT+01:00) Madrid",
        'Europe/Paris'         => "(GMT+01:00) Paris",
        'Europe/Prague'        => "(GMT+01:00) Prague",
        'Europe/Rome'          => "(GMT+01:00) Rome",
        'Europe/Sarajevo'      => "(GMT+01:00) Sarajevo",
        'Europe/Skopje'        => "(GMT+01:00) Skopje",
        'Europe/Stockholm'     => "(GMT+01:00) Stockholm",
        'Europe/Vienna'        => "(GMT+01:00) Vienna",
        'Europe/Warsaw'        => "(GMT+01:00) Warsaw",
        'Europe/Zagreb'        => "(GMT+01:00) Zagreb",
        'Europe/Athens'        => "(GMT+02:00) Athens",
        'Europe/Bucharest'     => "(GMT+02:00) Bucharest",
        'Africa/Cairo'         => "(GMT+02:00) Cairo",
        'Africa/Harare'        => "(GMT+02:00) Harare",
        'Europe/Helsinki'      => "(GMT+02:00) Helsinki",
        'Europe/Istanbul'      => "(GMT+02:00) Istanbul",
        'Asia/Jerusalem'       => "(GMT+02:00) Jerusalem",
        'Europe/Kiev'          => "(GMT+02:00) Kyiv",
        'Europe/Minsk'         => "(GMT+02:00) Minsk",
        'Europe/Riga'          => "(GMT+02:00) Riga",
        'Europe/Sofia'         => "(GMT+02:00) Sofia",
        'Europe/Tallinn'       => "(GMT+02:00) Tallinn",
        'Europe/Vilnius'       => "(GMT+02:00) Vilnius",
        'Asia/Baghdad'         => "(GMT+03:00) Baghdad",
        'Asia/Kuwait'          => "(GMT+03:00) Kuwait",
        'Africa/Nairobi'       => "(GMT+03:00) Nairobi",
        'Asia/Riyadh'          => "(GMT+03:00) Riyadh",
        'Europe/Moscow'        => "(GMT+03:00) Moscow",
        'Asia/Tehran'          => "(GMT+03:30) Tehran",
        'Asia/Baku'            => "(GMT+04:00) Baku",
        'Europe/Volgograd'     => "(GMT+04:00) Volgograd",
        'Asia/Muscat'          => "(GMT+04:00) Muscat",
        'Asia/Tbilisi'         => "(GMT+04:00) Tbilisi",
        'Asia/Yerevan'         => "(GMT+04:00) Yerevan",
        'Asia/Kabul'           => "(GMT+04:30) Kabul",
        'Asia/Karachi'         => "(GMT+05:00) Karachi",
        'Asia/Tashkent'        => "(GMT+05:00) Tashkent",
        'Asia/Kolkata'         => "(GMT+05:30) Kolkata",
        'Asia/Kathmandu'       => "(GMT+05:45) Kathmandu",
        'Asia/Yekaterinburg'   => "(GMT+06:00) Ekaterinburg",
        'Asia/Almaty'          => "(GMT+06:00) Almaty",
        'Asia/Dhaka'           => "(GMT+06:00) Dhaka",
        'Asia/Novosibirsk'     => "(GMT+07:00) Novosibirsk",
        'Asia/Bangkok'         => "(GMT+07:00) Bangkok",
        'Asia/Jakarta'         => "(GMT+07:00) Jakarta",
        'Asia/Krasnoyarsk'     => "(GMT+08:00) Krasnoyarsk",
        'Asia/Chongqing'       => "(GMT+08:00) Chongqing",
        'Asia/Hong_Kong'       => "(GMT+08:00) Hong Kong",
        'Asia/Kuala_Lumpur'    => "(GMT+08:00) Kuala Lumpur",
        'Australia/Perth'      => "(GMT+08:00) Perth",
        'Asia/Singapore'       => "(GMT+08:00) Singapore",
        'Asia/Taipei'          => "(GMT+08:00) Taipei",
        'Asia/Ulaanbaatar'     => "(GMT+08:00) Ulaan Bataar",
        'Asia/Urumqi'          => "(GMT+08:00) Urumqi",
        'Asia/Irkutsk'         => "(GMT+09:00) Irkutsk",
        'Asia/Seoul'           => "(GMT+09:00) Seoul",
        'Asia/Tokyo'           => "(GMT+09:00) Tokyo",
        'Australia/Adelaide'   => "(GMT+09:30) Adelaide",
        'Australia/Darwin'     => "(GMT+09:30) Darwin",
        'Asia/Yakutsk'         => "(GMT+10:00) Yakutsk",
        'Australia/Brisbane'   => "(GMT+10:00) Brisbane",
        'Australia/Canberra'   => "(GMT+10:00) Canberra",
        'Pacific/Guam'         => "(GMT+10:00) Guam",
        'Australia/Hobart'     => "(GMT+10:00) Hobart",
        'Australia/Melbourne'  => "(GMT+10:00) Melbourne",
        'Pacific/Port_Moresby' => "(GMT+10:00) Port Moresby",
        'Australia/Sydney'     => "(GMT+10:00) Sydney",
        'Asia/Vladivostok'     => "(GMT+11:00) Vladivostok",
        'Asia/Magadan'         => "(GMT+12:00) Magadan",
        'Pacific/Auckland'     => "(GMT+12:00) Auckland",
        'Pacific/Fiji'         => "(GMT+12:00) Fiji",
    ],

    'media_types' => [
        'mp3' => 'audio',
        'ogg' => 'audio',
        'wav' => 'audio',
        'falc' => 'audio',
        'mp4' => 'video',
        'webm' => 'video',
        'flv' => 'video',
        'pdf' => 'ebook',
    ],

    'item_types' => [
        'audio'   => 'Audio', 
        'video'   => 'Video',
        'graphic' => 'Graphic',
        'ebook'   => 'Ebook',
        '-'       => '-'
    ],

    'bulk_upload_columns' => [
        'name',
        'slug',
        'short_description',
        'overview',
        'notes',
        'active',
        'category',
        'cover',
        'version',
        'release_date',
        'last_update',
        'included_files',
        'tags',
        'preview',
        'software',
        'db',
        'compatible_browsers',
        'compatible_os',
        'high_resolution',
        'file_name',
        'file_host',
        'created_at',
        'deleted_at',
        'updated_at',
        'free',
        'featured',
        'trending',
        'views',
        'faq',
        'is_dir',
        'promotional_price_time',
        'stock',
        'hidden_content',
        'enable_license',
        'preview_url',
        'direct_download_link',
        'newest',
        'for_subscriptions',
        'type',
        'bpm',
        'bit_rate',
        'table_of_contents',
        'pages',
        'words',
        'language',
        'formats',
        'authors',
        'label',
        'additional_fields',
        'country_city',
        'regular_price',
        'minimum_price'
    ],

    "countries_cities" => [
        "Andorra" => [
            "les Escaldes",
            "Andorra la Vella"
        ],
        "United Arab Emirates" => [
            "Abu Dhabi",
            "Adh Dhayd",
            "Ajman",
            "Al Ain",
            "Al Fujayrah",
            "Ar Ruways",
            "Dibba Al-Fujairah",
            "Dibba Al-Hisn",
            "Dubai",
            "Khawr Fakkān",
            "Ras al-Khaimah",
            "Sharjah",
            "Umm al Qaywayn",
        ],
        "Afghanistan" => [
            "Andkhōy",
            "Asadābād",
            "Aībak",
            "Baghlān",
            "Balkh",
            "Barakī Barak",
            "Bāmyān",
            "Bāzārak",
            "Charikar",
            "Farah",
            "Fayzabad",
            "Gardēz",
            "Gereshk",
            "Ghazni",
            "Ghormach",
            "Herāt",
            "Jabal os Saraj",
            "Jalālābād",
            "Kabul",
            "Kafir Qala",
            "Kandahār",
            "Karukh",
            "Khanabad",
            "Khulm",
            "Khāsh",
            "Khōst",
            "Kunduz",
            "Kushk",
            "Lashkar Gāh",
            "Markaz-e Woluswalī-ye Āchīn",
            "Maymana",
            "Mazār-e Sharīf",
            "Mehtar Lām",
            "Nahrīn",
            "Paghmān",
            "Pul-e Khumrī",
            "Qarqīn",
            "Qarāwul",
            "Rustāq",
            "Sang-e Chārak",
            "Sar-e Pul",
            "Shahrak",
            "Shibirghān",
            "Shīnḏanḏ",
            "Taloqan",
            "Zaranj",
            "Ārt Khwājah",
            "Āsmār",
        ],
        "Antigua and Barbuda" => [
            "Saint John’s"
        ],
        "Anguilla" => [
            "The Valley"
        ],
        "Albania" => [
            "Berat",
            "Burrel",
            "Durrës",
            "Elbasan",
            "Fier",
            "Fier-Çifçi",
            "Gjirokastër",
            "Kavajë",
            "Korçë",
            "Krujë",
            "Kukës",
            "Kuçovë",
            "Laç",
            "Lezhë",
            "Lushnjë",
            "Patos Fshat",
            "Sarandë",
            "Shkodër",
            "Tirana",
            "Vlorë",
        ],
        "Armenia" => [
            "Abovyan",
            "Ararat",
            "Armavir",
            "Artashat",
            "Ashtarak",
            "Ejmiatsin",
            "Gavarr",
            "Goris",
            "Gyumri",
            "Hats’avan",
            "Hrazdan",
            "Kapan",
            "Masis",
            "Sevan",
            "Spitak",
            "Vanadzor",
            "Yerevan",
        ],
        "Angola" => [
            "Benguela",
            "Cabinda",
            "Caluquembe",
            "Camacupa",
            "Catabola",
            "Catumbela",
            "Caxito",
            "Caála",
            "Cuito",
            "Huambo",
            "Lobito",
            "Longonjo",
            "Luanda",
            "Luau",
            "Lubango",
            "Lucapa",
            "Luena",
            "Malanje",
            "Mbanza Congo",
            "Menongue",
            "Namibe",
            "Nzeto",
            "N’dalatando",
            "Saurimo",
            "Soio",
            "Sumbe",
            "Uíge",
        ],
        "Argentina" => [
            "Adrogué",
            "Aguilares",
            "Albardón",
            "Alderetes",
            "Allen",
            "Alta Gracia",
            "Aristóbulo del Valle",
            "Arroyito",
            "Arroyo Seco",
            "Avellaneda",
            "Azul",
            "Añatuya",
            "Bahía Blanca",
            "Barranqueras",
            "Bell Ville",
            "Bella Vista",
            "Buenos Aires",
            "Caleta Olivia",
            "Campana",
            "Capitán Bermúdez",
            "Carcarañá",
            "Casilda",
            "Castelli",
            "Catriel",
            "Caucete",
            "Cañada de Gómez",
            "Centenario",
            "Chacabuco",
            "Chajarí",
            "Charata",
            "Chilecito",
            "Chimbas",
            "Chivilcoy",
            "Cinco Saltos",
            "Cipolletti",
            "Colegiales",
            "Comodoro Rivadavia",
            "Concepción del Uruguay",
            "Concordia",
            "Coronda",
            "Coronel Suárez",
            "Corrientes",
            "Cosquín",
            "Crespo",
            "Cruz del Eje",
            "Curuzú Cuatiá",
            "Cutral-Có",
            "Córdoba",
            "Deán Funes",
            "Diamante",
            "Dolores",
            "El Bolsón",
            "El Soberbio",
            "Embalse",
            "Embarcación",
            "Esperanza",
            "Esquel",
            "Esquina",
            "Famaillá",
            "Federal",
            "Firmat",
            "Fontana",
            "Formosa",
            "Garupá",
            "General Enrique Mosconi",
            "General José de San Martín",
            "General Pico",
            "General Pinedo",
            "General Roca",
            "Gobernador Gálvez",
            "Gobernador Ingeniero Valentín Virasoro",
            "Goya",
            "Granadero Baigorria",
            "Gualeguay",
            "Gualeguaychú",
            "Gálvez",
            "Jardín América",
            "Jesús María",
            "Joaquín V. González",
            "Junín",
            "La Calera",
            "La Falda",
            "La Paz",
            "La Plata",
            "La Rioja",
            "Laboulaye",
            "Las Breñas",
            "Libertador General San Martín",
            "Lincoln",
            "Luján",
            "Machagai",
            "Mar del Plata",
            "Marcos Juárez",
            "Mendoza",
            "Mercedes",
            "Mercedes",
            "Monte Caseros",
            "Montecarlo",
            "Monteros",
            "Morteros",
            "Morón",
            "Necochea",
            "Neuquén",
            "Nueve de Julio",
            "Oberá",
            "Olavarría",
            "Palpalá",
            "Paraná",
            "Paso de los Libres",
            "Pergamino",
            "Pirané",
            "Plottier",
            "Pocito",
            "Pontevedra",
            "Posadas",
            "Presidencia Roque Sáenz Peña",
            "Puerto Eldorado",
            "Puerto Esperanza",
            "Puerto Iguazú",
            "Puerto Madryn",
            "Puerto Rico",
            "Punta Alta",
            "Pérez",
            "Quilmes",
            "Quitilipi",
            "Rafaela",
            "Rawson",
            "Reconquista",
            "Resistencia",
            "Retiro",
            "Rosario",
            "Rufino",
            "Río Ceballos",
            "Río Cuarto",
            "Río Gallegos",
            "Río Segundo",
            "Río Tercero",
            "Saladas",
            "Salta",
            "San Antonio Oeste",
            "San Carlos de Bariloche",
            "San Fernando del Valle de Catamarca",
            "San Francisco",
            "San Isidro",
            "San Javier",
            "San Jorge",
            "San José de Jáchal",
            "San Juan",
            "San Justo",
            "San Lorenzo",
            "San Luis del Palmar",
            "San Luis",
            "San Martín de los Andes",
            "San Martín",
            "San Miguel de Tucumán",
            "San Nicolás de los Arroyos",
            "San Pedro",
            "San Pedro",
            "San Rafael",
            "San Ramón de la Nueva Orán",
            "San Salvador de Jujuy",
            "San Vicente",
            "Santa Elena",
            "Santa Fe de la Vera Cruz",
            "Santa Lucía",
            "Santa Rosa",
            "Santiago del Estero",
            "Santo Tomé",
            "Santo Tomé",
            "Sunchales",
            "Tafí Viejo",
            "Tandil",
            "Tartagal",
            "Termas de Río Hondo",
            "Tigre",
            "Trelew",
            "Tres Arroyos",
            "Tres Isletas",
            "Unquillo",
            "Ushuaia",
            "Veinticinco de Mayo",
            "Venado Tuerto",
            "Vera",
            "Victoria",
            "Viedma",
            "Villa Allende",
            "Villa Carlos Paz",
            "Villa Constitución",
            "Villa Dolores",
            "Villa Gesell",
            "Villa Lugano",
            "Villa María",
            "Villa Mercedes",
            "Villa Nueva",
            "Villa Ocampo",
            "Villa Paula de Sarmiento",
            "Villa Regina",
            "Villa Santa Rita",
            "Villa Ángela",
            "Villaguay",
            "Yerba Buena",
            "Zapala",
            "Zárate",
        ],
        "American Samoa" => [
            "Pago Pago"
        ],
        "Austria" => [
            "Amstetten",
            "Ansfelden",
            "Baden",
            "Braunau am Inn",
            "Bregenz",
            "Dornbirn",
            "Feldkirch",
            "Graz",
            "Hallein",
            "Innsbruck",
            "Kapfenberg",
            "Klagenfurt am Wörthersee",
            "Klosterneuburg",
            "Krems an der Donau",
            "Kufstein",
            "Leoben",
            "Leonding",
            "Linz",
            "Lustenau",
            "Mödling",
            "Saalfelden am Steinernen Meer",
            "Salzburg",
            "Sankt Pölten",
            "Schwechat",
            "Spittal an der Drau",
            "Steyr",
            "Ternitz",
            "Traiskirchen",
            "Traun",
            "Vienna",
            "Villach",
            "Weinzierl bei Krems",
            "Wels",
            "Wiener Neustadt",
            "Wolfsberg",
        ],
        "Australia" => [
            "Adelaide Hills",
            "Adelaide",
            "Albany",
            "Albury",
            "Alice Springs",
            "Altona Meadows",
            "Armadale",
            "Armidale",
            "Ashfield",
            "Auburn",
            "Ballarat",
            "Balwyn North",
            "Bankstown",
            "Banora Point",
            "Bathurst",
            "Baulkham Hills",
            "Bendigo",
            "Berwick",
            "Blacktown",
            "Booval",
            "Boronia",
            "Bracken Ridge",
            "Brighton East",
            "Brisbane",
            "Broken Hill",
            "Brunswick",
            "Buderim",
            "Bunbury",
            "Bundaberg",
            "Bundoora",
            "Burnie",
            "Busselton",
            "Caboolture",
            "Cairns",
            "Caloundra",
            "Camberwell",
            "Canberra",
            "Canning Vale",
            "Carindale",
            "Caringbah",
            "Carlingford",
            "Carnegie",
            "Carnegie",
            "Carrum Downs",
            "Castle Hill",
            "Cessnock",
            "Cheltenham",
            "City of Parramatta",
            "Clayton",
            "Clayton",
            "Coburg",
            "Coffs Harbour",
            "Craigieburn",
            "Cranbourne",
            "Cranbourne",
            "Cronulla",
            "Dandenong North",
            "Dandenong",
            "Darwin",
            "Deception Bay",
            "Dee Why",
            "Deer Park",
            "Devonport",
            "Doncaster East",
            "Doncaster",
            "Dubbo",
            "Earlwood",
            "Echuca",
            "Eltham",
            "Endeavour Hills",
            "Engadine",
            "Epping",
            "Epping",
            "Essendon",
            "Ferntree Gully",
            "Forest Lake",
            "Forster",
            "Frankston East",
            "Frankston South",
            "Frankston",
            "Fremantle",
            "Gawler",
            "Geelong",
            "Geraldton",
            "Gladstone",
            "Glen Iris",
            "Glenferrie",
            "Glenmore Park",
            "Glenroy",
            "Gold Coast",
            "Gosnells",
            "Goulburn",
            "Granville",
            "Greensborough",
            "Griffith",
            "Hampton Park",
            "Hawthorn South",
            "Hillside",
            "Hobart",
            "Hoppers Crossing",
            "Hornsby",
            "Kalgoorlie",
            "Katoomba",
            "Kew",
            "Keysborough",
            "Kwinana",
            "Lalor",
            "Langwarrin",
            "Lara",
            "Launceston",
            "Lilydale",
            "Lismore",
            "Liverpool",
            "Logan City",
            "Mackay",
            "Maitland",
            "Malvern East",
            "Mandurah",
            "Maroubra",
            "Marrickville",
            "Maryborough",
            "Melbourne",
            "Melton",
            "Mildura",
            "Mill Park",
            "Moe",
            "Morayfield",
            "Mornington",
            "Morphett Vale",
            "Mosman",
            "Mount Eliza",
            "Mount Gambier",
            "Mount Isa",
            "Mount Martha",
            "Mulgrave",
            "Murray Bridge",
            "Narangba",
            "Narre Warren South",
            "Narre Warren",
            "Nerang",
            "Newcastle",
            "Noble Park",
            "North Ryde",
            "Northcote",
            "Nowra",
            "Orange",
            "Pakenham South",
            "Palmerston",
            "Paramatta",
            "Perth",
            "Point Cook",
            "Port Hedland",
            "Port Macquarie",
            "Port Stephens",
            "Preston",
            "Prospect",
            "Quakers Hill",
            "Queanbeyan",
            "Randwick",
            "Reservoir",
            "Richmond",
            "Rockhampton",
            "Rockingham",
            "Rowville",
            "Roxburgh Park",
            "Saint Albans",
            "Saint Kilda",
            "Seaford",
            "Shepparton",
            "South Brisbane",
            "South Grafton",
            "Southport",
            "Springvale",
            "St Albans",
            "Sunbury",
            "Sunnybank Hills",
            "Sunnybank",
            "Sunshine West",
            "Surfers Paradise",
            "Sydney",
            "Tamworth",
            "Taree",
            "Tarneit",
            "Taylors Lakes",
            "Thomastown",
            "Thornbury",
            "Thornbury",
            "Thornlie",
            "Toowoomba",
            "Townsville",
            "Traralgon",
            "Umina",
            "Wagga Wagga",
            "Wangaratta",
            "Wantirna South",
            "Warrnambool",
            "Werribee",
            "West Pennant",
            "Whyalla",
            "Willetton",
            "Wodonga",
            "Wollongong",
            "Woodridge",
            "Wyndham Vale",
        ],
        "Aruba" => [
            "Angochi",
            "Babijn",
            "Oranjestad",
        ],
        "Aland Islands" => [
            "Mariehamn"
        ],
        "Azerbaijan" => [
            "Agdzhabedy",
            "Aghsu",
            "Amirdzhan",
            "Astara",
            "Ağdam",
            "Ağdaş",
            "Baku",
            "Bakıxanov",
            "Barda",
            "Beylagan",
            "Bilajari",
            "Biny Selo",
            "Buzovna",
            "Divichibazar",
            "Dzhalilabad",
            "Fizuli",
            "Ganja",
            "Geoktschai",
            "Hacı Zeynalabdin",
            "Hacıqabul",
            "Hövsan",
            "Imishli",
            "Khirdalan",
            "Kyurdarmir",
            "Lankaran",
            "Lökbatan",
            "Mardakan",
            "Maştağa",
            "Mingelchaur",
            "Nakhchivan",
            "Neftçala",
            "Pushkino",
            "Qaraçuxur",
            "Qazax",
            "Quba",
            "Qusar",
            "Saatlı",
            "Sabirabad",
            "Sabunçu",
            "Salyan",
            "Shamakhi",
            "Shamkhor",
            "Sheki",
            "Shushi",
            "Sumqayıt",
            "Terter",
            "Ujar",
            "Xankandi",
            "Xaçmaz",
            "Yelenendorf",
            "Yeni Suraxanı",
            "Yevlakh",
            "Zabrat",
            "Zaqatala",
            "Şirvan",
            "Əhmədbəyli",
        ],
        "Bosnia and Herzegovina" => [
            "Banja Luka",
            "Bihać",
            "Bijeljina",
            "Bosanska Krupa",
            "Brčko",
            "Bugojno",
            "Cazin",
            "Doboj",
            "Goražde",
            "Gradačac",
            "Gračanica",
            "Konjic",
            "Mostar",
            "Prijedor",
            "Sarajevo",
            "Travnik",
            "Trebinje",
            "Tuzla",
            "Velika Kladuša",
            "Visoko",
            "Zenica",
        ],
        "Barbados" => [
            "Bridgetown"
        ],
        "Bangladesh" => [
            "Azimpur",
            "Badarganj",
            "Baniachang",
            "Barisāl",
            "Bera",
            "Bhairab Bāzār",
            "Bherāmāra",
            "Bhola",
            "Bhāndāria",
            "Bhātpāra Abhaynagar",
            "Bogra",
            "Burhānuddin",
            "Bājitpur",
            "Bāndarban",
            "Char Bhadrāsan",
            "Chhāgalnāiya",
            "Chhātak",
            "Chilmāri",
            "Chittagong",
            "Comilla",
            "Cox’s Bāzār",
            "Dhaka",
            "Dinājpur",
            "Dohār",
            "Farīdpur",
            "Fatikchari",
            "Feni",
            "Gafargaon",
            "Gaurnadi",
            "Habiganj",
            "Hājīganj",
            "Ishurdi",
            "Jamālpur",
            "Jessore",
            "Jhingergācha",
            "Joypur Hāt",
            "Kesabpur",
            "Khagrachhari",
            "Khulna",
            "Kishorganj",
            "Kushtia",
            "Kālia",
            "Kālīganj",
            "Lakshmīpur",
            "Lalmanirhat",
            "Lākshām",
            "Lālmohan",
            "Manikchari",
            "Mathba",
            "Maulavi Bāzār",
            "Mehendiganj",
            "Mirzāpur",
            "Morrelgonj",
            "Muktāgācha",
            "Mymensingh",
            "Mādārīpur",
            "Nabīnagar",
            "Nageswari",
            "Narail",
            "Narsingdi",
            "Nawābganj",
            "Netrakona",
            "Nāgarpur",
            "Nālchiti",
            "Nārāyanganj",
            "Paltan",
            "Panchagarh",
            "Parbatipur",
            "Patiya",
            "Phultala",
            "Pirojpur",
            "Pābna",
            "Pālang",
            "Pār Naogaon",
            "Pīrgaaj",
            "Rangpur",
            "Raojān",
            "Rāipur",
            "Rājshāhi",
            "Rāmganj",
            "Saidpur",
            "Sakhipur",
            "Sandwīp",
            "Sarankhola",
            "Sarishābāri",
            "Sherpur",
            "Shibganj",
            "Shāhzādpur",
            "Sirājganj",
            "Sylhet",
            "Sātkania",
            "Sātkhira",
            "Teknāf",
            "Thākurgaon",
            "Tungi",
            "Tungipāra",
            "Tāngāil",
            "Uttar Char Fasson",
        ],
        "Belgium" => [
            "Aalst",
            "Aalter",
            "Aarschot",
            "Andenne",
            "Ans",
            "Antwerpen",
            "Arlon",
            "Asse",
            "Ath",
            "Balen",
            "Beerse",
            "Beersel",
            "Beringen",
            "Beveren",
            "Bilzen",
            "Binche",
            "Blankenberge",
            "Boom",
            "Bornem",
            "Boussu",
            "Braine-l'Alleud",
            "Braine-le-Comte",
            "Brasschaat",
            "Brecht",
            "Brugge",
            "Brussels",
            "Charleroi",
            "Chasse Royale",
            "Chaudfontaine",
            "Châtelet",
            "Colfontaine",
            "Courcelles",
            "Deinze",
            "Denderleeuw",
            "Dendermonde",
            "Destelbergen",
            "Diepenbeek",
            "Diest",
            "Diksmuide",
            "Dilbeek",
            "Dour",
            "Duffel",
            "Edegem",
            "Eeklo",
            "Essen",
            "Eupen",
            "Evergem",
            "Fleurus",
            "Flémalle-Haute",
            "Fléron",
            "Frameries",
            "Geel",
            "Gembloux",
            "Genk",
            "Gent",
            "Geraardsbergen",
            "Grimbergen",
            "Haaltert",
            "Halle",
            "Hamme",
            "Harelbeke",
            "Hasselt",
            "Heist-op-den-Berg",
            "Helchteren",
            "Herent",
            "Herentals",
            "Herstal",
            "Herve",
            "Herzele",
            "Heusden",
            "Hoboken",
            "Hoogstraten",
            "Houthalen",
            "Huy",
            "Ieper",
            "Izegem",
            "Kalmthout",
            "Kapellen",
            "Kasterlee",
            "Knokke-Heist",
            "Koksijde",
            "Kontich",
            "Kortenberg",
            "Kortrijk",
            "La Louvière",
            "Lanaken",
            "Lebbeke",
            "Lede",
            "Lessines",
            "Leuven",
            "Lier",
            "Lille",
            "Liège",
            "Lochristi",
            "Lokeren",
            "Lommel",
            "Londerzeel",
            "Louvain-la-Neuve",
            "Maaseik",
            "Maasmechelen",
            "Maldegem",
            "Manage",
            "Marche-en-Famenne",
            "Mechelen",
            "Meise",
            "Menen",
            "Merelbeke",
            "Middelkerke",
            "Mol",
            "Mons",
            "Morlanwelz-Mariemont",
            "Mortsel",
            "Mouscron",
            "Namur",
            "Neerpelt",
            "Nijlen",
            "Ninove",
            "Nivelles",
            "Oostkamp",
            "Ostend",
            "Oudenaarde",
            "Oupeye",
            "Overijse",
            "Peer",
            "Pont-à-Celles",
            "Poperinge",
            "Putte",
            "Puurs",
            "Péruwelz",
            "Quaregnon",
            "Ranst",
            "Riemst",
            "Rixensart",
            "Roeselare",
            "Ronse",
            "Rotselaar",
            "Saint-Ghislain",
            "Saint-Nicolas",
            "Schilde",
            "Schoten",
            "Seraing",
            "Sint-Genesius-Rode",
            "Sint-Gillis-Waas",
            "Sint-Katelijne-Waver",
            "Sint-Kruis",
            "Sint-Niklaas",
            "Sint-Pieters-Leeuw",
            "Sint-Truiden",
            "Soignies",
            "Soumagne",
            "Stabroek",
            "Stekene",
            "Temse",
            "Tervuren",
            "Tessenderlo",
            "Tielt",
            "Tienen",
            "Tongeren",
            "Torhout",
            "Tournai",
            "Tubize",
            "Turnhout",
            "Verviers",
            "Vilvoorde",
            "Visé",
            "Walcourt",
            "Waregem",
            "Waterloo",
            "Wavre",
            "Wervik",
            "Westerlo",
            "Wetteren",
            "Wevelgem",
            "Willebroek",
            "Wuustwezel",
            "Zaventem",
            "Zedelgem",
            "Zele",
            "Zemst",
            "Zoersel",
            "Zonhoven",
            "Zottegem",
            "Zwevegem",
            "Zwijndrecht",
        ],
        "Burkina Faso" => [
            "Banfora",
            "Bobo-Dioulasso",
            "Boulsa",
            "Boussé",
            "Diapaga",
            "Djibo",
            "Dori",
            "Dédougou",
            "Fada N'gourma",
            "Gaoua",
            "Garango",
            "Gourcy",
            "Houndé",
            "Kaya",
            "Kokologo",
            "Kombissiri",
            "Kongoussi",
            "Koudougou",
            "Koupéla",
            "Léo",
            "Manga",
            "Nouna",
            "Orodara",
            "Ouagadougou",
            "Ouahigouya",
            "Pô",
            "Réo",
            "Tenkodogo",
            "Titao",
            "Tougan",
            "Yako",
            "Zorgo",
        ],
        "Bulgaria" => [
            "Asenovgrad",
            "Aytos",
            "Berkovitsa",
            "Blagoevgrad",
            "Botevgrad",
            "Burgas",
            "Cherven Bryag",
            "Chirpan",
            "Dimitrovgrad",
            "Dobrich",
            "Dupnitsa",
            "Gabrovo",
            "Gorna Oryakhovitsa",
            "Gotse Delchev",
            "Haskovo",
            "Kardzhali",
            "Karlovo",
            "Karnobat",
            "Kazanlŭk",
            "Kharmanli",
            "Kyustendil",
            "Lom",
            "Lovech",
            "Montana",
            "Nova Zagora",
            "Panagyurishte",
            "Pazardzhik",
            "Pernik",
            "Peshtera",
            "Petrich",
            "Pleven",
            "Plovdiv",
            "Popovo",
            "Rakovski",
            "Razgrad",
            "Ruse",
            "Samokov",
            "Sandanski",
            "Sevlievo",
            "Shumen",
            "Silistra",
            "Sliven",
            "Smolyan",
            "Sofia",
            "Stara Zagora",
            "Svilengrad",
            "Svishtov",
            "Targovishte",
            "Troyan",
            "Varna",
            "Veliko Tŭrnovo",
            "Velingrad",
            "Vidin",
            "Vratsa",
            "Yambol",
        ],
        "Bahrain" => [
            "Al Muharraq",
            "Ar Rifā‘",
            "Dār Kulayb",
            "Jidd Ḩafş",
            "Madīnat Ḩamad",
            "Madīnat ‘Īsá",
            "Manama",
            "Sitrah",
        ],
        "Burundi" => [
            "Bujumbura",
            "Bururi",
            "Gitega",
            "Kayanza",
            "Makamba",
            "Muramvya",
            "Muyinga",
            "Ngozi",
            "Rutana",
            "Ruyigi",
        ],
        "Benin" => [
            "Abomey",
            "Abomey-Calavi",
            "Allada",
            "Aplahoué",
            "Banikoara",
            "Bassila",
            "Bembèrèkè",
            "Bohicon",
            "Comé",
            "Cotonou",
            "Cové",
            "Dassa-Zoumé",
            "Djougou",
            "Dogbo",
            "Kandi",
            "Kétou",
            "Lokossa",
            "Malanville",
            "Natitingou",
            "Nikki",
            "Ouidah",
            "Parakou",
            "Pobé",
            "Porto-Novo",
            "Sakété",
            "Savalou",
            "Savé",
            "Tanguiéta",
            "Tchaourou",
        ],
        "Saint Barthelemy" => [
            "Gustavia"
        ],
        "Bermuda" => [
            "Hamilton"
        ],
        "Brunei" => [
            "Bandar Seri Begawan",
            "Kuala Belait",
            "Seria",
            "Tutong",
        ],
        "Bolivia" => [
            "Camiri",
            "Cobija",
            "Cochabamba",
            "Cotoca",
            "Guayaramerín",
            "Huanuni",
            "La Paz",
            "Llallagua",
            "Mizque",
            "Montero",
            "Oruro",
            "Potosí",
            "Punata",
            "Riberalta",
            "San Borja",
            "San Ignacio de Velasco",
            "Santa Cruz de la Sierra",
            "Santiago del Torno",
            "Sucre",
            "Tarija",
            "Trinidad",
            "Tupiza",
            "Villa Yapacaní",
            "Villamontes",
            "Villazón",
            "Warnes",
            "Yacuiba",
        ],
        "Bonaire, Saint Eustatius and Saba" => [
            "Kralendijk"
        ],
        "Brazil" => [
            "Abaetetuba",
            "Abaeté",
            "Abreu e Lima",
            "Acaraú",
            "Acopiara",
            "Adamantina",
            "Afogados da Ingazeira",
            "Aguaí",
            "Agudos",
            "Aimorés",
            "Alagoa Grande",
            "Alagoinhas",
            "Alegre",
            "Alegrete",
            "Alenquer",
            "Alfenas",
            "Almeirim",
            "Almenara",
            "Almirante Tamandaré",
            "Altamira",
            "Altos",
            "Além Paraíba",
            "Amaraji",
            "Amargosa",
            "Americana",
            "Amparo",
            "Américo Brasiliense",
            "Ananindeua",
            "Anastácio",
            "Andradas",
            "Andradina",
            "Angra dos Reis",
            "Anicuns",
            "Antonina",
            "Anápolis",
            "Aparecida de Goiânia",
            "Aparecida do Taboado",
            "Aparecida",
            "Apiaí",
            "Apodi",
            "Apucarana",
            "Aquidauana",
            "Aquiraz",
            "Aracaju",
            "Aracati",
            "Araci",
            "Aracruz",
            "Aragarças",
            "Araguari",
            "Araguaína",
            "Arapiraca",
            "Arapongas",
            "Araranguá",
            "Araraquara",
            "Araras",
            "Arari",
            "Araripina",
            "Araruama",
            "Araucária",
            "Araxá",
            "Araçatuba",
            "Araçoiaba da Serra",
            "Araçuaí",
            "Arcos",
            "Arcoverde",
            "Areia Branca",
            "Aripuanã",
            "Ariquemes",
            "Armação de Búzios",
            "Arraial do Cabo",
            "Arroio do Meio",
            "Arroio Grande",
            "Artur Nogueira",
            "Arujá",
            "Assis",
            "Astorga",
            "Atalaia",
            "Atibaia",
            "Augusto Corrêa",
            "Avaré",
            "Açu",
            "Bacabal",
            "Bagé",
            "Baixo Guandu",
            "Balneário Camboriú",
            "Balsas",
            "Bambuí",
            "Bandeirantes",
            "Barbacena",
            "Barbalha",
            "Barcarena",
            "Bariri",
            "Barra Bonita",
            "Barra de São Francisco",
            "Barra do Bugres",
            "Barra do Corda",
            "Barra do Garças",
            "Barra do Piraí",
            "Barra dos Coqueiros",
            "Barra Mansa",
            "Barra Velha",
            "Barra",
            "Barras",
            "Barreiras",
            "Barreirinhas",
            "Barreiro do Jaíba",
            "Barreiros",
            "Barretos",
            "Barrinha",
            "Barroso",
            "Barueri",
            "Barão de Cocais",
            "Bastos",
            "Batatais",
            "Baturité",
            "Bauru",
            "Bayeux",
            "Bebedouro",
            "Beberibe",
            "Bela Vista",
            "Belford Roxo",
            "Belo Horizonte",
            "Belo Jardim",
            "Belo Oriente",
            "Belém",
            "Belém",
            "Benevides",
            "Bento Gonçalves",
            "Bertioga",
            "Betim",
            "Bezerros",
            "Biguaçu",
            "Birigui",
            "Biritiba Mirim",
            "Blumenau",
            "Boa Esperança",
            "Boa Viagem",
            "Boa Vista",
            "Bocaiúva",
            "Boituva",
            "Bom Conselho",
            "Bom Despacho",
            "Bom Jesus da Lapa",
            "Bom Jesus do Itabapoana",
            "Botucatu",
            "Bragança Paulista",
            "Bragança",
            "Brasília",
            "Braço do Norte",
            "Brejo da Madre de Deus",
            "Brejo Santo",
            "Breves",
            "Brodósqui",
            "Brotas",
            "Brumadinho",
            "Brumado",
            "Brusque",
            "Buerarema",
            "Buri",
            "Buriti Bravo",
            "Buritis",
            "Buritizeiro",
            "Butiá",
            "Buíque",
            "Cabedelo",
            "Cabo Frio",
            "Cabo",
            "Cabreúva",
            "Cabrobó",
            "Cachoeira do Sul",
            "Cachoeira",
            "Cachoeiras de Macacu",
            "Cachoeirinha",
            "Cachoeiro de Itapemirim",
            "Cacoal",
            "Caetité",
            "Caeté",
            "Caicó",
            "Caieiras",
            "Cajamar",
            "Cajati",
            "Cajazeiras",
            "Cajueiro",
            "Cajuru",
            "Caldas Novas",
            "Camanducaia",
            "Camaquã",
            "Camaçari",
            "Cambará",
            "Cambebba",
            "Cambuí",
            "Cambé",
            "Cametá",
            "Camocim",
            "Campina Grande do Sul",
            "Campina Grande",
            "Campinas",
            "Campinas",
            "Campo Alegre",
            "Campo Belo",
            "Campo Formoso",
            "Campo Grande",
            "Campo Largo",
            "Campo Maior",
            "Campo Mourão",
            "Campo Verde",
            "Campos Belos",
            "Campos do Jordão",
            "Campos Gerais",
            "Campos Novos",
            "Campos Sales",
            "Campos",
            "Canavieiras",
            "Candelária",
            "Canela",
            "Canguaretama",
            "Canguçu",
            "Canindé",
            "Canoas",
            "Canoinhas",
            "Capanema",
            "Capela",
            "Capelinha",
            "Capim Grosso",
            "Capinzal",
            "Capitão Poço",
            "Capivari",
            "Capâo Bonito",
            "Capão da Canoa",
            "Caraguatatuba",
            "Carandaí",
            "Carangola",
            "Carapicuíba",
            "Caratinga",
            "Carauari",
            "Carazinho",
            "Carlos Barbosa",
            "Carmo do Cajuru",
            "Carmo do Paranaíba",
            "Carolina",
            "Carpina",
            "Caruaru",
            "Casa Branca",
            "Cascavel",
            "Cascavel",
            "Casimiro de Abreu",
            "Cassilândia",
            "Castanhal",
            "Castelo",
            "Castro",
            "Cataguases",
            "Catalão",
            "Catanduva",
            "Catende",
            "Catolé do Rocha",
            "Catu",
            "Caucaia",
            "Caxambu",
            "Caxias do Sul",
            "Caxias",
            "Caçador",
            "Caçapava do Sul",
            "Caçapava",
            "Ceará Mirim",
            "Celso Ramos",
            "Ceres",
            "Cerquilho",
            "Chapadinha",
            "Chapecó",
            "Charqueadas",
            "Chã Grande",
            "Cianorte",
            "Cláudio",
            "Coaraci",
            "Coari",
            "Codó",
            "Coelho Neto",
            "Colatina",
            "Colinas",
            "Colombo",
            "Colorado",
            "Conceição da Barra",
            "Conceição da Feira",
            "Conceição das Alagoas",
            "Conceição do Araguaia",
            "Conceição do Coité",
            "Conceição do Jacuípe",
            "Conchal",
            "Concórdia",
            "Condado",
            "Conde",
            "Conde",
            "Congonhas",
            "Conselheiro Lafaiete",
            "Contagem",
            "Cordeiro",
            "Cordeirópolis",
            "Corinto",
            "Cornélio Procópio",
            "Coroatá",
            "Coromandel",
            "Coronel Fabriciano",
            "Coronel Vivida",
            "Corumbá",
            "Coruripe",
            "Cosmópolis",
            "Cotia",
            "Coxim",
            "Crateús",
            "Crato",
            "Cravinhos",
            "Criciúma",
            "Cristalina",
            "Cruz Alta",
            "Cruz das Almas",
            "Cruzeiro do Oeste",
            "Cruzeiro do Sul",
            "Cruzeiro",
            "Cubatão",
            "Cuiabá",
            "Cupira",
            "Curitiba",
            "Curitibanos",
            "Currais Novos",
            "Cururupu",
            "Curvelo",
            "Custódia",
            "Cândido Mota",
            "Cícero Dantas",
            "Delmiro Gouveia",
            "Demerval Lobão",
            "Descalvado",
            "Diadema",
            "Diamantina",
            "Diamantino",
            "Divinópolis",
            "Dois Córregos",
            "Dois Vizinhos",
            "Dom Pedrito",
            "Dom Pedro",
            "Dourados",
            "Duque de Caxias",
            "Eirunepé",
            "Elói Mendes",
            "Embu Guaçu",
            "Embu",
            "Encantado",
            "Encruzilhada do Sul",
            "Entre Rios",
            "Erechim",
            "Escada",
            "Esmeraldas",
            "Esperantina",
            "Esperança",
            "Espinosa",
            "Esplanada",
            "Espírito Santo do Pinhal",
            "Esteio",
            "Estreito",
            "Estrela",
            "Estância Velha",
            "Estância",
            "Euclides da Cunha",
            "Eusébio",
            "Extremoz",
            "Farroupilha",
            "Feira de Santana",
            "Fernandópolis",
            "Ferraz de Vasconcelos",
            "Flores da Cunha",
            "Floresta",
            "Floriano",
            "Florianópolis",
            "Fonte Boa",
            "Formiga",
            "Formosa",
            "Forquilhinha",
            "Fortaleza",
            "Foz do Iguaçu",
            "Franca",
            "Francisco Beltrão",
            "Francisco Morato",
            "Franco da Rocha",
            "Frederico Westphalen",
            "Freguesia do Ribeirao da Ilha",
            "Frutal",
            "Gameleira",
            "Gandu",
            "Garanhuns",
            "Garibaldi",
            "Garça",
            "Gaspar",
            "Glória do Goitá",
            "Goiana",
            "Goianira",
            "Goianésia",
            "Goiatuba",
            "Goiás",
            "Goiânia",
            "Governador Valadares",
            "Grajaú",
            "Granja",
            "Gravataí",
            "Gravatá",
            "Guaiúba",
            "Guajará Mirim",
            "Guanambi",
            "Guanhães",
            "Guapimirim",
            "Guaporé",
            "Guarabira",
            "Guaraciaba do Norte",
            "Guaramirim",
            "Guaranésia",
            "Guarapari",
            "Guarapuava",
            "Guararapes",
            "Guararema",
            "Guaratinguetá",
            "Guaratuba",
            "Guariba",
            "Guarujá",
            "Guarulhos",
            "Guará",
            "Guaxupé",
            "Guaçuí",
            "Guaíba",
            "Guaíra",
            "Gurupi",
            "Herval",
            "Horizonte",
            "Hortolândia",
            "Humaitá",
            "Iaçu",
            "Ibaiti",
            "Ibaté",
            "Ibicaraí",
            "Ibiporã",
            "Ibirama",
            "Ibirataia",
            "Ibirité",
            "Ibitinga",
            "Ibiá",
            "Ibiúna",
            "Ibotirama",
            "Icó",
            "Igarapava",
            "Igarapé Açu",
            "Igarapé Miri",
            "Igarapé",
            "Igarassu",
            "Igaraçu do Tietê",
            "Igrejinha",
            "Iguape",
            "Iguatu",
            "Ijuí",
            "Ilha Solteira",
            "Ilhabela",
            "Ilhéus",
            "Imbituba",
            "Imbituva",
            "Imperatriz",
            "Indaial",
            "Indaiatuba",
            "Inhumas",
            "Ipaba",
            "Ipameri",
            "Ipatinga",
            "Iperó",
            "Ipiaú",
            "Ipirá",
            "Ipojuca",
            "Iporá",
            "Ipu",
            "Ipubi",
            "Ipueiras",
            "Iracemápolis",
            "Irati",
            "Irecê",
            "Itabaiana",
            "Itabaiana",
            "Itabaianinha",
            "Itaberaba",
            "Itaberaí",
            "Itabira",
            "Itabirito",
            "Itaboraí",
            "Itabuna",
            "Itacoatiara",
            "Itaguaí",
            "Itaitinga",
            "Itaituba",
            "Itajaí",
            "Itajubá",
            "Itajuípe",
            "Itamaraju",
            "Itamarandiba",
            "Itambé",
            "Itanhaém",
            "Itaocara",
            "Itapaci",
            "Itapagé",
            "Itaparica",
            "Itapecerica da Serra",
            "Itapecerica",
            "Itapecuru Mirim",
            "Itapema",
            "Itapemirim",
            "Itaperuna",
            "Itaperuçu",
            "Itapetinga",
            "Itapetininga",
            "Itapeva",
            "Itapevi",
            "Itapipoca",
            "Itapira",
            "Itapissuma",
            "Itaporanga",
            "Itapuranga",
            "Itaquaquecetuba",
            "Itaqui",
            "Itararé",
            "Itatiba",
            "Itatinga",
            "Itaí",
            "Itaúna",
            "Itororó",
            "Itu",
            "Ituberá",
            "Ituiutaba",
            "Itumbiara",
            "Itupeva",
            "Itupiranga",
            "Iturama",
            "Ituverava",
            "Itápolis",
            "Ivoti",
            "Içara",
            "Jaboatão dos Guararapes",
            "Jaboatão",
            "Jaboticabal",
            "Jacarezinho",
            "Jacareí",
            "Jaciara",
            "Jacobina",
            "Jacutinga",
            "Jaguaquara",
            "Jaguarari",
            "Jaguariaíva",
            "Jaguaribe",
            "Jaguariúna",
            "Jaguaruana",
            "Jaguarão",
            "Jales",
            "Janaúba",
            "Jandaia do Sul",
            "Jandira",
            "Januária",
            "Japeri",
            "Jaraguá do Sul",
            "Jaraguá",
            "Jardim",
            "Jardinópolis",
            "Jarinu",
            "Jaru",
            "Jataí",
            "Jatobá",
            "Jaú",
            "Jequitinhonha",
            "Jequié",
            "Jeremoabo",
            "Ji Paraná",
            "Joaçaba",
            "Joinville",
            "José Bonifácio",
            "José de Freitas",
            "João Câmara",
            "João Monlevade",
            "João Pessoa",
            "João Pinheiro",
            "Juatuba",
            "Juazeiro do Norte",
            "Juiz de Fora",
            "Jundiaí",
            "Júlio de Castilhos",
            "Ladário",
            "Lagarto",
            "Lages",
            "Lago da Pedra",
            "Lagoa da Prata",
            "Lagoa do Itaenga",
            "Lagoa Santa",
            "Lagoa Vermelha",
            "Laguna",
            "Lajeado",
            "Lajedo",
            "Lajinha",
            "Lapa",
            "Laranjal Paulista",
            "Laranjeiras do Sul",
            "Laranjeiras",
            "Lauro de Freitas",
            "Lavras da Mangabeira",
            "Lavras",
            "Leme",
            "Lençóis Paulista",
            "Leopoldina",
            "Limeira",
            "Limoeiro do Norte",
            "Limoeiro",
            "Linhares",
            "Lins",
            "Livramento do Brumado",
            "Loanda",
            "Londrina",
            "Lorena",
            "Louveira",
            "Lucas",
            "Luziânia",
            "Macapá",
            "Macatuba",
            "Macau",
            "Macaé",
            "Macaíba",
            "Maceió",
            "Machado",
            "Mafra",
            "Mairinque",
            "Mairiporã",
            "Mamanguape",
            "Manacapuru",
            "Manaus",
            "Mandaguari",
            "Mangaratiba",
            "Manhuaçu",
            "Manhumirim",
            "Marabá",
            "Maracaju",
            "Maracanaú",
            "Maracás",
            "Maragogi",
            "Maragogipe",
            "Marataizes",
            "Marau",
            "Marechal Cândido Rondon",
            "Marechal Deodoro",
            "Mari",
            "Marialva",
            "Mariana",
            "Maricá",
            "Maringá",
            "Martinópolis",
            "Marília",
            "Mascote",
            "Mata de São João",
            "Mateus Leme",
            "Matozinhos",
            "Matriz de Camaragibe",
            "Matão",
            "Mauá",
            "Maués",
            "Medeiros Neto",
            "Medianeira",
            "Mendes",
            "Miguel Pereira",
            "Miguelópolis",
            "Mineiros",
            "Miracema",
            "Mirandopólis",
            "Mocajuba",
            "Mococa",
            "Mogi das Cruzes",
            "Mogi Mirim",
            "Mogi-Gaucu",
            "Moju",
            "Mombaça",
            "Mongaguá",
            "Monte Alegre",
            "Monte Alto",
            "Monte Aprazível",
            "Monte Azul Paulista",
            "Monte Carmelo",
            "Monte Mor",
            "Monte Santo de Minas",
            "Monteiro",
            "Montenegro",
            "Montes Claros",
            "Morada Nova",
            "Moreno",
            "Morrinhos",
            "Morro Agudo",
            "Morro do Chapéu",
            "Mossoró",
            "Mucuri",
            "Muriaé",
            "Murici",
            "Muritiba",
            "Muzambinho",
            "Nanuque",
            "Natal",
            "Navegantes",
            "Naviraí",
            "Nazaré da Mata",
            "Nazaré",
            "Nepomuceno",
            "Nerópolis",
            "Nilópolis",
            "Niquelândia",
            "Niterói",
            "Nossa Senhora da Glória",
            "Nossa Senhora do Socorro",
            "Nova Cruz",
            "Nova Era",
            "Nova Friburgo",
            "Nova Granada",
            "Nova Iguaçu",
            "Nova Lima",
            "Nova Odessa",
            "Nova Olímpia",
            "Nova Petrópolis",
            "Nova Prata",
            "Nova Russas",
            "Nova Venécia",
            "Nova Viçosa",
            "Novo Hamburgo",
            "Novo Horizonte",
            "Oeiras",
            "Olinda",
            "Oliveira",
            "Olímpia",
            "Oriximiná",
            "Orleans",
            "Orlândia",
            "Orós",
            "Osasco",
            "Osvaldo Cruz",
            "Osório",
            "Ouricuri",
            "Ourinhos",
            "Ouro Branco",
            "Ouro Preto do Oeste",
            "Ouro Preto",
            "Pacajus",
            "Pacatuba",
            "Padre Bernardo",
            "Paiçandu",
            "Palhoça",
            "Palmares",
            "Palmas",
            "Palmas",
            "Palmeira das Missões",
            "Palmeira",
            "Palmital",
            "Palotina",
            "Panambi",
            "Paracambi",
            "Paracatu",
            "Paracuru",
            "Paragominas",
            "Paraguaçu Paulista",
            "Paraguaçu",
            "Paraipaba",
            "Paranaguá",
            "Paranapanema",
            "Paranavaí",
            "Paranaíba",
            "Paraty",
            "Paraíba do Sul",
            "Parelhas",
            "Parintins",
            "Parnamirim",
            "Parnaíba",
            "Parobé",
            "Pará de Minas",
            "Passo Fundo",
            "Passos",
            "Pato Branco",
            "Patos de Minas",
            "Patos",
            "Patrocínio",
            "Paty do Alferes",
            "Paulista",
            "Paulo Afonso",
            "Paulínia",
            "Pederneiras",
            "Pedra Azul",
            "Pedra Branca",
            "Pedreira",
            "Pedro II",
            "Pedro Leopoldo",
            "Pelotas",
            "Penalva",
            "Penedo",
            "Penha",
            "Pentecoste",
            "Penápolis",
            "Perdões",
            "Pereira Barreto",
            "Peruíbe",
            "Pesqueira",
            "Petrolina",
            "Petrópolis",
            "Picos",
            "Piedade",
            "Pilar do Sul",
            "Pilar",
            "Pimenta Bueno",
            "Pindamonhangaba",
            "Pindaré Mirim",
            "Pindobaçu",
            "Pinhais",
            "Pinheiral",
            "Pinheiro",
            "Pinhão",
            "Piracaia",
            "Piracanjuba",
            "Piracicaba",
            "Piracuruca",
            "Piraju",
            "Pirajuí",
            "Pirapora",
            "Pirapozinho",
            "Piraquara",
            "Pirassununga",
            "Piraí do Sul",
            "Piraí",
            "Pires do Rio",
            "Piripiri",
            "Piritiba",
            "Pitanga",
            "Pitangueiras",
            "Pitangui",
            "Piuí",
            "Piúma",
            "Planaltina",
            "Poconé",
            "Pombal",
            "Pombos",
            "Pomerode",
            "Pompéia",
            "Pompéu",
            "Ponta Grossa",
            "Ponta Porã",
            "Pontal",
            "Ponte Nova",
            "Pontes e Lacerda",
            "Porangatu",
            "Portel",
            "Porto Alegre",
            "Porto Calvo",
            "Porto Feliz",
            "Porto Ferreira",
            "Porto Seguro",
            "Porto União",
            "Porto Velho",
            "Portão",
            "Posse",
            "Pouso Alegre",
            "Poá",
            "Poços de Caldas",
            "Poções",
            "Prado",
            "Praia Grande",
            "Prata",
            "Presidente Dutra",
            "Presidente Epitácio",
            "Presidente Prudente",
            "Presidente Venceslau",
            "Promissão",
            "Propriá",
            "Prudentópolis",
            "Pôsto Fiscal Rolim de Moura",
            "Quaraí",
            "Quatro Barras",
            "Queimados",
            "Quirinópolis",
            "Quixadá",
            "Quixeramobim",
            "Rancharia",
            "Recife",
            "Regente Feijó",
            "Registro",
            "Resende",
            "Resplendor",
            "Riachão do Jacuípe",
            "Ribeira do Pombal",
            "Ribeirão da Ilha",
            "Ribeirão das Neves",
            "Ribeirão Pires",
            "Ribeirão Preto",
            "Ribeirão",
            "Rio Bonito",
            "Rio Branco do Sul",
            "Rio Branco",
            "Rio Brilhante",
            "Rio Claro",
            "Rio das Ostras",
            "Rio das Pedras",
            "Rio de Janeiro",
            "Rio do Sul",
            "Rio Formoso",
            "Rio Grande da Serra",
            "Rio Grande",
            "Rio Largo",
            "Rio Negrinho",
            "Rio Negro",
            "Rio Pardo",
            "Rio Preto da Eva",
            "Rio Real",
            "Rio Verde de Mato Grosso",
            "Rolante",
            "Rolândia",
            "Rondonópolis",
            "Rosário do Sul",
            "Rubiataba",
            "Russas",
            "Ruy Barbosa",
            "Sacramento",
            "Salgueiro",
            "Salinas",
            "Salinópolis",
            "Salto de Pirapora",
            "Salto",
            "Salvador",
            "Santa Bárbara d'Oeste",
            "Santa Cecília",
            "Santa Cruz Cabrália",
            "Santa Cruz das Palmeiras",
            "Santa Cruz do Capibaribe",
            "Santa Cruz do Rio Pardo",
            "Santa Cruz do Sul",
            "Santa Cruz",
            "Santa Fé do Sul",
            "Santa Gertrudes",
            "Santa Helena de Goiás",
            "Santa Helena",
            "Santa Inês",
            "Santa Isabel",
            "Santa Luzia",
            "Santa Luzia",
            "Santa Maria da Vitória",
            "Santa Maria",
            "Santa Quitéria do Maranhão",
            "Santa Quitéria",
            "Santa Rita do Passa Quatro",
            "Santa Rita do Sapucaí",
            "Santa Rita",
            "Santa Rosa de Viterbo",
            "Santa Rosa",
            "Santa Vitória do Palmar",
            "Santaluz",
            "Santana de Parnaíba",
            "Santana do Ipanema",
            "Santana do Livramento",
            "Santana do Paraíso",
            "Santana",
            "Santarém",
            "Santiago",
            "Santo Amaro da Imperatriz",
            "Santo Amaro",
            "Santo Anastácio",
            "Santo André",
            "Santo Antônio da Platina",
            "Santo Antônio de Jesus",
            "Santo Antônio de Posse",
            "Santo Antônio de Pádua",
            "Santo Antônio do Amparo",
            "Santo Antônio do Monte",
            "Santo Estêvão",
            "Santo Ângelo",
            "Santos Dumont",
            "Santos",
            "Sapiranga",
            "Sapucaia",
            "Saquarema",
            "Sarandi",
            "Sarandi",
            "Sarzedo",
            "Satuba",
            "Saubara",
            "Schroeder",
            "Seabra",
            "Sena Madureira",
            "Senador Canedo",
            "Senador Pompeu",
            "Senhor do Bonfim",
            "Seropédica",
            "Serra Negra",
            "Serra Talhada",
            "Serra",
            "Serrana",
            "Serrinha",
            "Sertânia",
            "Sertãozinho",
            "Sete Lagoas",
            "Sidrolândia",
            "Silva Jardim",
            "Simão Dias",
            "Simões Filho",
            "Sinop",
            "Sirinhaém",
            "Sobradinho",
            "Sobral",
            "Socorro",
            "Soledade",
            "Solânea",
            "Sorocaba",
            "Soure",
            "Sousa",
            "Sumaré",
            "Surubim",
            "Suzano",
            "São Bento do Sul",
            "São Bento",
            "São Bento",
            "São Bernardo do Campo",
            "São Borja",
            "São Caetano do Sul",
            "São Carlos",
            "São Cristóvão",
            "São Domingos do Maranhão",
            "São Fidélis",
            "São Francisco do Conde",
            "São Francisco do Sul",
            "São Francisco",
            "São Félix do Xingu",
            "São Gabriel da Cachoeira",
            "São Gabriel",
            "São Gonçalo do Amarante",
            "São Gonçalo do Sapucaí",
            "São Gotardo",
            "São Jerônimo",
            "São Joaquim da Barra",
            "São Joaquim",
            "São José de Mipibu",
            "São José de Ribamar",
            "São José do Egito",
            "São José do Rio Pardo",
            "São José do Rio Preto",
            "São José dos Campos",
            "São José dos Pinhais",
            "São José",
            "São João da Barra",
            "São João da Boa Vista",
            "São João de Meriti",
            "São João del Rei",
            "São João dos Inhamuns",
            "São João dos Patos",
            "São João Nepomuceno",
            "São Leopoldo",
            "São Lourenço da Mata",
            "São Lourenço do Sul",
            "São Lourenço",
            "São Luiz Gonzaga",
            "São Luís de Montes Belos",
            "São Luís do Quitunde",
            "São Luís",
            "São Manuel",
            "São Marcos",
            "São Mateus do Maranhão",
            "São Mateus do Sul",
            "São Mateus",
            "São Miguel do Araguaia",
            "São Miguel do Guamá",
            "São Miguel do Iguaçu",
            "São Miguel dos Campos",
            "São Paulo",
            "São Pedro da Aldeia",
            "São Pedro",
            "São Raimundo Nonato",
            "São Roque",
            "São Sebastião do Caí",
            "São Sebastião do Paraíso",
            "São Sebastião do Passé",
            "São Sebastião",
            "São Sepé",
            "São Vicente",
            "Tabatinga",
            "Tabira",
            "Taboão da Serra",
            "Taiobeiras",
            "Tamandaré",
            "Tambaú",
            "Tanabi",
            "Tanguá",
            "Tapes",
            "Tapiramutá",
            "Taquara",
            "Taquari",
            "Taquaritinga",
            "Taquarituba",
            "Tarauacá",
            "Tatuí",
            "Taubaté",
            "Tefé",
            "Telêmaco Borba",
            "Teodoro Sampaio",
            "Teresina",
            "Teresópolis",
            "Teutônia",
            "Teófilo Otoni",
            "Tianguá",
            "Tietê",
            "Tijucas",
            "Timbaúba",
            "Timbiras",
            "Timbó",
            "Timon",
            "Timóteo",
            "Tobias Barreto",
            "Toledo",
            "Tomé Açu",
            "Toritama",
            "Torres",
            "Trairi",
            "Tramandaí",
            "Tremembé",
            "Trindade",
            "Trindade",
            "Trindade",
            "Três Corações",
            "Três Coroas",
            "Três de Maio",
            "Três Lagoas",
            "Três Passos",
            "Três Pontas",
            "Três Rios",
            "Tubarão",
            "Tucano",
            "Tucumã",
            "Tucuruí",
            "Tuntum",
            "Tupaciguara",
            "Tupanciretã",
            "Tupã",
            "Ubaitaba",
            "Ubatuba",
            "Ubatã",
            "Uberaba",
            "Uberlândia",
            "Ubá",
            "Umuarama",
            "Una",
            "Unaí",
            "União da Vitória",
            "União dos Palmares",
            "União",
            "Uruaçu",
            "Uruguaiana",
            "Uruçuca",
            "Vacaria",
            "Valença do Piauí",
            "Valença",
            "Valença",
            "Valinhos",
            "Valparaíso",
            "Vargem Grande do Sul",
            "Vargem Grande",
            "Varginha",
            "Varjota",
            "Vassouras",
            "Vazante",
            "Venâncio Aires",
            "Vera Cruz",
            "Veranópolis",
            "Vespasiano",
            "Viamão",
            "Viana",
            "Viana",
            "Videira",
            "Vigia",
            "Vila Velha",
            "Vilhena",
            "Vinhedo",
            "Viradouro",
            "Visconde do Rio Branco",
            "Viseu",
            "Vitória da Conquista",
            "Vitória de Santo Antão",
            "Vitória do Mearim",
            "Vitória",
            "Viçosa do Ceará",
            "Viçosa",
            "Viçosa",
            "Volta Redonda",
            "Votorantim",
            "Votuporanga",
            "Várzea Alegre",
            "Várzea da Palma",
            "Várzea Grande",
            "Várzea Paulista",
            "Wenceslau Braz",
            "Xanxerê",
            "Xique Xique",
            "Ábidos",
            "Água Preta",
            "Águas Belas",
            "Águas de Lindóia",
            "Águas Vermelhas",
            "Álvares Machado",
        ],
        "Bahamas" => [
            "Freeport",
            "Lucaya",
            "Nassau",
        ],
        "Bhutan" => [
            "Phuntsholing",
            "Punākha",
            "Thimphu",
            "Tsirang"
        ],
        "Botswana" => [
            "Francistown",
            "Gaborone",
            "Janeng",
            "Kanye",
            "Letlhakane",
            "Lobatse",
            "Mahalapye",
            "Maun",
            "Mochudi",
            "Mogoditshane",
            "Molepolole",
            "Mosopa",
            "Palapye",
            "Ramotswa",
            "Selebi-Phikwe",
            "Serowe",
            "Thamaga",
            "Tonota",
        ],
        "Belarus" => [
            "Asipovichy",
            "Babruysk",
            "Baranovichi",
            "Brest",
            "Byaroza",
            "Bykhaw",
            "Dobrush",
            "Dzyarzhynsk",
            "Gomel",
            "Hlybokaye",
            "Horad Barysaw",
            "Horad Zhodzina",
            "Horki",
            "Hrodna",
            "Ivatsevichy",
            "Kalinkavichy",
            "Kalodzishchy",
            "Kobryn",
            "Krychaw",
            "Lida",
            "Luninyets",
            "Lyepyel’",
            "Mahilyow",
            "Maladzyechna",
            "Malinovka",
            "Mar’’ina Horka",
            "Masty",
            "Mazyr",
            "Minsk",
            "Navahrudak",
            "Navapolatsk",
            "Novoye Medvezhino",
            "Orsha",
            "Pastavy",
            "Pinsk",
            "Polatsk",
            "Pruzhany",
            "Rahachow",
            "Rechytsa",
            "Salihorsk",
            "Shchuchin",
            "Slonim",
            "Slutsk",
            "Smarhon’",
            "Stowbtsy",
            "Svyetlahorsk",
            "Vawkavysk",
            "Vilyeyka",
            "Vitebsk",
            "Zhlobin",
        ],
        "Belize" => [
            "Belize City",
            "Belmopan",
            "Orange Walk",
            "San Ignacio",
        ],
        "Canada" => [
            "Abbotsford",
            "Airdrie",
            "Ajax",
            "Alma",
            "Amos",
            "Ancaster",
            "Anmore",
            "Baie-Comeau",
            "Barrie",
            "Beaconsfield",
            "Bellechasse Regional County Municipality",
            "Belleville",
            "Beloeil",
            "Blainville",
            "Boisbriand",
            "Boucherville",
            "Bradford West Gwillimbury",
            "Brampton",
            "Brandon",
            "Brant",
            "Brantford",
            "Brockville",
            "Brossard",
            "Burlington",
            "Burnaby",
            "Calgary",
            "Cambridge",
            "Campbell River",
            "Camrose",
            "Candiac",
            "Chambly",
            "Charlottetown",
            "Chilliwack",
            "Châteauguay",
            "Clarence-Rockland",
            "Cobourg",
            "Cochrane",
            "Cole Harbour",
            "Collingwood",
            "Conception Bay South",
            "Coquitlam",
            "Corner Brook",
            "Cornwall",
            "Courtenay",
            "Cranbrook",
            "Côte-Saint-Luc",
            "Dartmouth",
            "Delta",
            "Deux-Montagnes",
            "Dieppe",
            "Dollard-Des Ormeaux",
            "Dorval",
            "Drummondville",
            "Duncan",
            "Edmonton",
            "Edmundston",
            "Etobicoke",
            "Fort Erie",
            "Fort McMurray",
            "Fort St. John",
            "Fredericton",
            "Gatineau",
            "Glace Bay",
            "Granby",
            "Grande Prairie",
            "Greater Napanee",
            "Greater Sudbury",
            "Guelph",
            "Halifax",
            "Hamilton",
            "Huntsville",
            "Joliette",
            "Jonquière",
            "Kamloops",
            "Kelowna",
            "Keswick",
            "Kingston",
            "Kirkland",
            "Kitchener",
            "L'Ancienne-Lorette",
            "L'Assomption",
            "La Prairie",
            "Ladner",
            "Langford",
            "Langley",
            "Langley",
            "Laval",
            "Leduc",
            "Lethbridge",
            "Lloydminster",
            "London",
            "Longueuil",
            "Lower Sacvkille",
            "Lévis",
            "Magog",
            "Maple Ridge",
            "Markham",
            "Mascouche",
            "Medicine Hat",
            "Midland",
            "Milton",
            "Mirabel",
            "Miramichi",
            "Mississauga",
            "Moncton",
            "Mont-Royal",
            "Mont-Saint-Hilaire",
            "Montréal",
            "Moose Jaw",
            "Mount Pearl",
            "Nanaimo",
            "New Glasgow",
            "New Westminster",
            "Newmarket",
            "Niagara Falls",
            "Norfolk County",
            "North Battleford",
            "North Bay",
            "North Cowichan",
            "North Vancouver",
            "North York",
            "Oak Bay",
            "Oakville",
            "Okanagan",
            "Orangeville",
            "Orillia",
            "Oshawa",
            "Ottawa",
            "Owen Sound",
            "Parksville",
            "Pembroke",
            "Penticton",
            "Petawawa",
            "Peterborough",
            "Pickering",
            "Pitt Meadows",
            "Pointe-Claire",
            "Port Alberni",
            "Port Colborne",
            "Port Moody",
            "Prince Albert",
            "Prince Edward",
            "Prince George",
            "Quinte West",
            "Québec",
            "Rayside-Balfour",
            "Red Deer",
            "Regina",
            "Repentigny",
            "Richmond Hill",
            "Richmond",
            "Rimouski",
            "Rivière-du-Loup",
            "Rouyn-Noranda",
            "Saguenay",
            "Saint John",
            "Saint-Augustin-de-Desmaures",
            "Saint-Basile-le-Grand",
            "Saint-Bruno-de-Montarville",
            "Saint-Constant",
            "Saint-Eustache",
            "Saint-Hyacinthe",
            "Saint-Jean-sur-Richelieu",
            "Saint-Jérôme",
            "Saint-Laurent",
            "Saint-Lazare",
            "Saint-Léonard",
            "Sainte-Catherine",
            "Sainte-Julie",
            "Sainte-Thérèse",
            "Salaberry-de-Valleyfield",
            "Salmon Arm",
            "Sarnia",
            "Saskatoon",
            "Sault Ste. Marie",
            "Scarborough",
            "Sept-Îles",
            "Shawinigan",
            "Sherbrooke",
            "Sherwood Park",
            "Sorel-Tracy",
            "Spruce Grove",
            "St. Albert",
            "St. Catharines",
            "St. John's",
            "St. Thomas",
            "Stratford",
            "Surrey",
            "Sydney",
            "Terrace",
            "Terrebonne",
            "Thetford-Mines",
            "Thorold",
            "Thunder Bay",
            "Timmins",
            "Toronto",
            "Trois-Rivières",
            "Truro",
            "Val-d'Or",
            "Vancouver",
            "Varennes",
            "Vaudreuil-Dorion",
            "Vaughan",
            "Vernon",
            "Victoria",
            "Victoriaville",
            "Walnut Grove",
            "Waterloo",
            "Welland",
            "West End",
            "West Kelowna",
            "West Vancouver",
            "Westmount",
            "White Rock",
            "Whitehorse",
            "Willowdale",
            "Windsor",
            "Winnipeg",
            "Woodstock",
            "Yellowknife",
            "Yorkton",
        ],
        "Cocos Islands" => [
            "West Island"
        ],
        "Democratic Republic of the Congo" => [
            "Aketi",
            "Bandundu",
            "Basoko",
            "Beni",
            "Boende",
            "Bolobo",
            "Bondo",
            "Bukama",
            "Bukavu",
            "Bulungu",
            "Bumba",
            "Bunia",
            "Businga",
            "Buta",
            "Butembo",
            "Demba",
            "Gandajika",
            "Gbadolite",
            "Gemena",
            "Goma",
            "Ilebo",
            "Inongo",
            "Isiro",
            "Kabalo",
            "Kabare",
            "Kabinda",
            "Kalemie",
            "Kambove",
            "Kamina",
            "Kampene",
            "Kananga",
            "Kasangulu",
            "Kasongo",
            "Kasongo-Lunda",
            "Kikwit",
            "Kindu",
            "Kinshasa",
            "Kipushi",
            "Kisangani",
            "Kolwezi",
            "Kongolo",
            "Libenge",
            "Likasi",
            "Lisala",
            "Lodja",
            "Lubao",
            "Lubumbashi",
            "Luebo",
            "Lusambo",
            "Mangai",
            "Masina",
            "Matadi",
            "Mbandaka",
            "Mbanza-Ngungu",
            "Mbuji-Mayi",
            "Mushie",
            "Mweka",
            "Mwene-Ditu",
            "Nioki",
            "Sake",
            "Tshela",
            "Tshikapa",
            "Uvira",
            "Wamba",
            "Watsa",
            "Yangambi",
        ],
        "Central African Republic" => [
            "Bambari",
            "Bangassou",
            "Bangui",
            "Batangafo",
            "Berbérati",
            "Bimbo",
            "Boda",
            "Bossangoa",
            "Bouar",
            "Bozoum",
            "Bria",
            "Carnot",
            "Damara",
            "Ippy",
            "Kaga Bandoro",
            "Mbaïki",
            "Mobaye",
            "Nola",
            "Paoua",
            "Sibut",
        ],
        "Republic of the Congo" => [
            "Brazzaville",
            "Dolisie",
            "Gamboma",
            "Impfondo",
            "Kayes",
            "Loandjili",
            "Madingou",
            "Mossendjo",
            "Ouésso",
            "Owando",
            "Pointe-Noire",
            "Sibiti",
        ],
        "Switzerland" => [
            "Aarau",
            "Adliswil",
            "Allschwil",
            "Baar",
            "Baden",
            "Basel",
            "Bellinzona",
            "Bern",
            "Biel/Bienne",
            "Carouge",
            "Chur",
            "Dietikon",
            "Dübendorf",
            "Emmen",
            "Frauenfeld",
            "Fribourg",
            "Genève",
            "Gossau",
            "Grenchen",
            "Herisau",
            "Horgen",
            "Jona",
            "Kloten",
            "Kreuzlingen",
            "Kriens",
            "Köniz",
            "La Chaux-de-Fonds",
            "Lancy",
            "Lausanne",
            "Le Châtelard",
            "Littau",
            "Lugano",
            "Luzern",
            "Meyrin",
            "Monthey",
            "Montreux",
            "Muttenz",
            "Neuchâtel",
            "Nyon",
            "Oberwinterthur (Kreis 2)",
            "Olten",
            "Onex",
            "Pully",
            "Rapperswil",
            "Renens",
            "Riehen",
            "Sankt Gallen",
            "Schaffhausen",
            "Seen (Kreis 3)",
            "Sierre",
            "Sitten",
            "Stadt Winterthur (Kreis 1)",
            "Steffisburg",
            "Thun",
            "Uster",
            "Vernier",
            "Vevey",
            "Wettingen",
            "Wil",
            "Winterthur",
            "Yverdon-les-Bains",
            "Zug",
            "Zürich (Kreis 10) / Höngg",
            "Zürich (Kreis 10) / Wipkingen",
            "Zürich (Kreis 10)",
            "Zürich (Kreis 11) / Affoltern",
            "Zürich (Kreis 11) / Oerlikon",
            "Zürich (Kreis 11) / Seebach",
            "Zürich (Kreis 11)",
            "Zürich (Kreis 12)",
            "Zürich (Kreis 2) / Wollishofen",
            "Zürich (Kreis 2)",
            "Zürich (Kreis 3) / Sihlfeld",
            "Zürich (Kreis 3)",
            "Zürich (Kreis 4)",
            "Zürich (Kreis 6) / Unterstrass",
            "Zürich (Kreis 6)",
            "Zürich (Kreis 7)",
            "Zürich (Kreis 8)",
            "Zürich (Kreis 9) / Albisrieden",
            "Zürich (Kreis 9) / Altstetten",
            "Zürich (Kreis 9)",
            "Zürich",
        ],
        "Ivory Coast" => [
            "Abengourou",
            "Abidjan",
            "Abobo",
            "Aboisso",
            "Adiaké",
            "Adzopé",
            "Affery",
            "Agboville",
            "Agnibilékrou",
            "Akoupé",
            "Anyama",
            "Arrah",
            "Bangolo",
            "Biankouma",
            "Bingerville",
            "Bondoukou",
            "Bongouanou",
            "Bonoua",
            "Bouaflé",
            "Bouaké",
            "Bouna",
            "Boundiali",
            "Béoumi",
            "Dabou",
            "Daloa",
            "Danané",
            "Daoukro",
            "Dimbokro",
            "Divo",
            "Duekoué",
            "Ferkessédougou",
            "Gagnoa",
            "Grand-Bassam",
            "Guiglo",
            "Issia",
            "Katiola",
            "Korhogo",
            "Lakota",
            "Man",
            "Mankono",
            "Odienné",
            "Oumé",
            "Sakassou",
            "San-Pédro",
            "Sassandra",
            "Sinfra",
            "Soubré",
            "Séguéla",
            "Tabou",
            "Tanda",
            "Tengrela",
            "Tiassalé",
            "Touba",
            "Toumodi",
            "Vavoua",
            "Yamoussoukro",
            "Zuénoula",
        ],
        "Cook Islands" => [
            "Avarua"
        ],
        "Chile" => [
            "Ancud",
            "Angol",
            "Antofagasta",
            "Arauco",
            "Arica",
            "Buin",
            "Cabrero",
            "Calama",
            "Cartagena",
            "Castro",
            "Cauquenes",
            "Cañete",
            "Chicureo Abajo",
            "Chiguayante",
            "Chillán",
            "Chimbarongo",
            "Coihaique",
            "Collipulli",
            "Concepción",
            "Constitución",
            "Copiapó",
            "Coquimbo",
            "Coronel",
            "Curanilahue",
            "Curicó",
            "Diego de Almagro",
            "El Monte",
            "Frutillar",
            "Graneros",
            "Hacienda La Calera",
            "Illapel",
            "Iquique",
            "La Laja",
            "La Ligua",
            "La Pintana",
            "La Serena",
            "La Unión",
            "Lampa",
            "Las Animas",
            "Lautaro",
            "Lebu",
            "Limache",
            "Linares",
            "Llaillay",
            "Lo Prado",
            "Loncoche",
            "Los Andes",
            "Los Ángeles",
            "Lota",
            "Machalí",
            "Melipilla",
            "Molina",
            "Mulchén",
            "Nacimiento",
            "Nueva Imperial",
            "Osorno",
            "Ovalle",
            "Paine",
            "Panguipulli",
            "Parral",
            "Penco",
            "Peñaflor",
            "Pucón",
            "Puente Alto",
            "Puerto Aisén",
            "Puerto Montt",
            "Puerto Natales",
            "Puerto Quellón",
            "Puerto Varas",
            "Punta Arenas",
            "Quillota",
            "Quilpué",
            "Rancagua",
            "Rengo",
            "Río Bueno",
            "San Antonio",
            "San Bernardo",
            "San Carlos",
            "San Felipe",
            "San Javier",
            "San Vicente de Tagua Tagua",
            "San Vicente",
            "Santa Cruz",
            "Santiago",
            "Talagante",
            "Talca",
            "Talcahuano",
            "Temuco",
            "Tocopilla",
            "Tomé",
            "Valdivia",
            "Vallenar",
            "Valparaíso",
            "Victoria",
            "Villa Alemana",
            "Villarrica",
            "Viña del Mar",
        ],
        "Cameroon" => [
            "Akonolinga",
            "Bafang",
            "Bafia",
            "Bafoussam",
            "Bali",
            "Bamenda",
            "Bamusso",
            "Bangangté",
            "Banyo",
            "Batouri",
            "Bertoua",
            "Bogo",
            "Buea",
            "Bélabo",
            "Dizangué",
            "Douala",
            "Dschang",
            "Edéa",
            "Eséka",
            "Fontem",
            "Foumban",
            "Foumbot",
            "Fundong",
            "Garoua Boulaï",
            "Garoua",
            "Guider",
            "Idenao",
            "Kaélé",
            "Kousséri",
            "Kribi",
            "Kumba",
            "Kumbo",
            "Lagdo",
            "Limbe",
            "Lolodorf",
            "Loum",
            "Mamfe",
            "Manjo",
            "Maroua",
            "Mbalmayo",
            "Mbandjok",
            "Mbanga",
            "Mbouda",
            "Melong",
            "Meïganga",
            "Mokolo",
            "Mora",
            "Mutengene",
            "Muyuka",
            "Nanga Eboko",
            "Ngaoundéré",
            "Nkongsamba",
            "Nkoteng",
            "Obala",
            "Penja",
            "Sangmélima",
            "Tcholliré",
            "Tibati",
            "Tiko",
            "Tonga",
            "Wum",
            "Yagoua",
            "Yaoundé",
            "Ébolowa",
        ],
        "China" => [
            "Acheng",
            "Altay",
            "Anbu",
            "Anda",
            "Anjiang",
            "Ankang",
            "Anlu",
            "Anqing",
            "Anqiu",
            "Anshan",
            "Anshun",
            "Anxiang",
            "Anyang",
            "Aral",
            "Babu",
            "Baicheng",
            "Baihe",
            "Baijiantan",
            "Baiquan",
            "Baise City",
            "Baishan",
            "Baishishan",
            "Baiyin",
            "Bamiantong",
            "Baoding",
            "Baoqing",
            "Baoshan",
            "Baotou",
            "Baoying",
            "Bayan",
            "Beibei",
            "Beichengqu",
            "Beidaihehaibin",
            "Beidao",
            "Beihai",
            "Beijing",
            "Beipiao",
            "Bei’an",
            "Bengbu",
            "Benxi",
            "Bianzhuang",
            "Bijie",
            "Binhe",
            "Binzhou",
            "Binzhou",
            "Bojia",
            "Boli",
            "Boshan",
            "Botou",
            "Bozhou",
            "Buhe",
            "Caidian",
            "Cangzhou",
            "Caohe",
            "Chaihe",
            "Changchun",
            "Changde",
            "Changji",
            "Changleng",
            "Changli",
            "Changling",
            "Changping",
            "Changqing",
            "Changsha",
            "Changshu City",
            "Changtu",
            "Changzhi",
            "Changzhou",
            "Chaohu",
            "Chaoyang",
            "Chaoyang",
            "Chaozhou",
            "Chengde",
            "Chengdu",
            "Chenghua",
            "Chengyang",
            "Chengyang",
            "Chengzhong",
            "Chengzihe",
            "Chenzhou",
            "Chifeng",
            "Chizhou",
            "Chonglong",
            "Chongqing",
            "Chuzhou",
            "Dadukou",
            "Dalai",
            "Dali",
            "Dalian",
            "Daliang",
            "Dalianwan",
            "Dandong",
            "Danjiangkou",
            "Danshui",
            "Daokou",
            "Daqing",
            "Dasha",
            "Dashiqiao",
            "Dashitou",
            "Datong",
            "Datong",
            "Dawukou",
            "Daxing",
            "Daye",
            "Dazhong",
            "Dazhou",
            "Dehui",
            "Dengzhou",
            "Deqing",
            "Deyang",
            "Dezhou",
            "Dingcheng",
            "Dingtao",
            "Dingzhou",
            "Dongcun",
            "Dongdu",
            "Dongfeng",
            "Dongguan",
            "Donghai",
            "Dongkan",
            "Dongling",
            "Dongning",
            "Dongsheng",
            "Dongtai",
            "Dongxing",
            "Dongyang",
            "Ducheng",
            "Dunhua",
            "Duobao",
            "Duyun",
            "Dêqên",
            "Encheng",
            "Enshi",
            "Erdaojiang",
            "Erenhot",
            "Ezhou",
            "Fangshan",
            "Feicheng",
            "Feicheng",
            "Fendou",
            "Fendou",
            "Fengcheng",
            "Fenghua",
            "Fenghuang",
            "Fengkou",
            "Fengrun",
            "Fengxian",
            "Fengxiang",
            "Fenyi",
            "Foshan",
            "Fuding",
            "Fujin",
            "Fuli",
            "Fuling",
            "Fuqing",
            "Fushun",
            "Fuxin",
            "Fuxin",
            "Fuyang",
            "Fuyang",
            "Fuyu",
            "Fuyu",
            "Fuyuan",
            "Fuzhou",
            "Gannan",
            "Gaogou",
            "Gaomi",
            "Gaoping",
            "Gaoyou",
            "Gaozhou",
            "Gejiu",
            "Genhe",
            "Gongchangling",
            "Gongzhuling",
            "Guangming",
            "Guangshui",
            "Guangyuan",
            "Guangzhou",
            "Guankou",
            "Gucheng Chengguanzhen",
            "Guigang",
            "Guilin",
            "Guiping",
            "Guiren",
            "Guixi",
            "Guiyang",
            "Guli",
            "Guozhen",
            "Gushu",
            "Gutao",
            "Guye",
            "Haicheng",
            "Haikou",
            "Haikou",
            "Hailar",
            "Hailin",
            "Hailun",
            "Haimen",
            "Haizhou",
            "Hami",
            "Hancheng",
            "Hancheng",
            "Hanchuan",
            "Handan",
            "Hangu",
            "Hangzhou",
            "Hanting",
            "Hanzhong",
            "Harbin",
            "Hebi",
            "Hechuan",
            "Hecun",
            "Hede",
            "Hefei",
            "Hegang",
            "Heihe",
            "Heishan",
            "Helong",
            "Hengshui",
            "Hengyang",
            "Hepingjie",
            "Hepo",
            "Heyuan",
            "Heze",
            "Hohhot",
            "Honggang",
            "Hongjiang",
            "Hongqiao",
            "Hotan",
            "Hoxtolgay",
            "Huadian",
            "Huai'an",
            "Huaibei",
            "Huaicheng",
            "Huaidian",
            "Huaihua",
            "Huainan",
            "Huaiyuan Chengguanzhen",
            "Huanan",
            "Huanggang",
            "Huangmei",
            "Huangnihe",
            "Huangpi",
            "Huangshan",
            "Huangshi",
            "Huangyan",
            "Huangzhou",
            "Huanren",
            "Huazhou",
            "Huazhou",
            "Huicheng",
            "Huilong",
            "Huinan",
            "Huizhou",
            "Hulan Ergi",
            "Hulan",
            "Humen",
            "Hunchun",
            "Huoqiu Chengguanzhen",
            "Hushitai",
            "Hutang",
            "Huzhou",
            "Jagdaqi",
            "Jalai Nur",
            "Jiamusi",
            "Jiangguanchi",
            "Jiangkou",
            "Jiangmen",
            "Jianguang",
            "Jiangyan",
            "Jiangyin",
            "Jiangyou",
            "Jian’ou",
            "Jiaojiang",
            "Jiaozhou",
            "Jiaozuo",
            "Jiashan",
            "Jiaxing",
            "Jiayuguan",
            "Jiazi",
            "Jidong",
            "Jiehu",
            "Jieshi",
            "Jieshou",
            "Jiexiu",
            "Jieyang",
            "Jijiang",
            "Jilin",
            "Jimo",
            "Jinan",
            "Jinchang",
            "Jincheng",
            "Jingdezhen",
            "Jinghong",
            "Jingling",
            "Jingmen",
            "Jingzhou",
            "Jinhua",
            "Jining",
            "Jining",
            "Jinji",
            "Jinjiang",
            "Jinjiang",
            "Jinsha",
            "Jinshi",
            "Jinxiang",
            "Jinzhou",
            "Jinzhou",
            "Jishu",
            "Jishui",
            "Jiujiang",
            "Jiupu",
            "Jiuquan",
            "Jiutai",
            "Jixi",
            "Ji’an",
            "Juegang",
            "Juye",
            "Kaifeng",
            "Kaihua",
            "Kaitong",
            "Kaiyuan",
            "Kaiyuan",
            "Kangding",
            "Kashgar",
            "Kuandian",
            "Kuche",
            "Kunming",
            "Kunshan",
            "Kunyang",
            "Laibin",
            "Laiwu",
            "Laixi",
            "Laiyang",
            "Langfang",
            "Langtou",
            "Langxiang",
            "Langzhong",
            "Lanxi",
            "Lanxi",
            "Lanzhou",
            "Laochenglu",
            "Laohekou",
            "Laojunmiao",
            "Lecheng",
            "Leiyang",
            "Lengshuijiang",
            "Lengshuitan",
            "Leshan",
            "Lhasa",
            "Lianghu",
            "Liangxiang",
            "Lianhe",
            "Lianjiang",
            "Lianran",
            "Lianshan",
            "Lianyuan",
            "Lianzhou",
            "Lianzhou",
            "Liaocheng",
            "Liaoyang",
            "Liaoyuan",
            "Liaozhong",
            "Licheng",
            "Licheng",
            "Lichuan",
            "Lijiang",
            "Lincheng",
            "Linfen",
            "Lingcheng",
            "Lingdong",
            "Linghai",
            "Lingyuan",
            "Linhai",
            "Linjiang",
            "Linkou",
            "Linping",
            "Linqiong",
            "Linqu",
            "Linshui",
            "Lintong",
            "Linxi",
            "Linxia Chengguanzhen",
            "Linyi",
            "Lishu",
            "Lishui",
            "Liuhe",
            "Liupanshui",
            "Longfeng",
            "Longgang",
            "Longjiang",
            "Longjing",
            "Longquan",
            "Loudi",
            "Loushanguan",
            "Luancheng",
            "Lubu",
            "Lucheng",
            "Luocheng",
            "Luofeng",
            "Luohe",
            "Luorong",
            "Luoyang",
            "Luoyang",
            "Luoyang",
            "Luqiao",
            "Luxu",
            "Lüshun",
            "Maba",
            "Mabai",
            "Macheng",
            "Majie",
            "Manzhouli",
            "Meihekou",
            "Meizhou",
            "Mengcheng Chengguanzhen",
            "Mengyin",
            "Mentougou",
            "Mianyang",
            "Minggang",
            "Mingguang",
            "Mingshui",
            "Mingshui",
            "Mingyue",
            "Minzhu",
            "Mishan",
            "Miyang",
            "Mizhou",
            "Mudanjiang",
            "Mudu",
            "Mujiayingzi",
            "Nagqu",
            "Nanchang",
            "Nanchong",
            "Nanding",
            "Nandu",
            "Nanfeng",
            "Nangandao",
            "Nangong",
            "Nanjing",
            "Nanlong",
            "Nanma",
            "Nanning",
            "Nanpiao",
            "Nanping",
            "Nantai",
            "Nantong",
            "Nanyang",
            "Nanzhang Chengguanzhen",
            "Nanzhou",
            "Nehe",
            "Neijiang",
            "Nenjiang",
            "Nianzishan",
            "Ningbo",
            "Ningde",
            "Ninghai",
            "Ninghai",
            "Ningyang",
            "Ordos",
            "Oroqen Zizhiqi",
            "Panshan",
            "Panshi",
            "Pengcheng",
            "Pingdingshan",
            "Pingdu",
            "Pingliang",
            "Pingnan",
            "Pingshan",
            "Pingxiang",
            "Pingyi",
            "Pingyin",
            "Pingzhuang",
            "Pizhou",
            "Poyang",
            "Pucheng",
            "Pulandian",
            "Pumiao",
            "Puning",
            "Puqi",
            "Putian",
            "Puyang Chengguanzhen",
            "Puyang",
            "Qamdo",
            "Qianguo",
            "Qianjiang",
            "Qianzhou",
            "Qingdao",
            "Qinggang",
            "Qingnian",
            "Qingquan",
            "Qingyang",
            "Qingyuan",
            "Qingzhou",
            "Qinhuangdao",
            "Qinnan",
            "Qinzhou",
            "Qionghu",
            "Qiongshan",
            "Qiqihar",
            "Quanzhou",
            "Qufu",
            "Qujing",
            "Quzhou",
            "Renqiu",
            "Rikaze",
            "Rizhao",
            "Runing",
            "Salaqi",
            "Sanchazi",
            "Sanming",
            "Sanshui",
            "Sanya",
            "Sayibage",
            "Shache",
            "Shahecheng",
            "Shancheng",
            "Shanghai",
            "Shangmei",
            "Shangqiu",
            "Shangrao",
            "Shangri-La",
            "Shangyu",
            "Shangzhi",
            "Shanhaiguan",
            "Shanhetun",
            "Shanting",
            "Shantou",
            "Shanwei",
            "Shaoguan",
            "Shaowu",
            "Shaoxing",
            "Shaping",
            "Shashi",
            "Shengli",
            "Shenjiamen",
            "Shenyang",
            "Shenzhen",
            "Shiguai",
            "Shihezi",
            "Shijiazhuang",
            "Shilin",
            "Shilong",
            "Shima",
            "Shiqi",
            "Shiqiao",
            "Shitanjing",
            "Shiwan",
            "Shixing",
            "Shiyan",
            "Shiyan",
            "Shizilu",
            "Shizuishan",
            "Shouguang",
            "Shuangcheng",
            "Shuangyang",
            "Shuangyashan",
            "Shulan",
            "Shunyi",
            "Siping",
            "Sishui",
            "Songjiang",
            "Songjianghe",
            "Songling",
            "Songling",
            "Songyang",
            "Suicheng",
            "Suifenhe",
            "Suihua",
            "Suileng",
            "Suining",
            "Suixi",
            "Suizhou",
            "Sujiatun",
            "Suozhen",
            "Suzhou",
            "Suzhou",
            "Tahe",
            "Taihe",
            "Taikang",
            "Tailai",
            "Taishan",
            "Taixing",
            "Taiyuan",
            "Taizhou",
            "Tai’an",
            "Tanggu",
            "Tangjiazhuang",
            "Tangping",
            "Tangshan",
            "Tangzhai",
            "Tantou",
            "Taozhuang",
            "Tengzhou",
            "Tianchang",
            "Tianfu",
            "Tianjin",
            "Tianpeng",
            "Tianshui",
            "Tieli",
            "Tieling",
            "Tongchuan",
            "Tongchuan",
            "Tongliao",
            "Tongren",
            "Tongshan",
            "Tongzhou",
            "Tumen",
            "Ulanhot",
            "Wacheng",
            "Wafangdian",
            "Wangkui",
            "Wangqing",
            "Wanning",
            "Wanxian",
            "Weichanglu",
            "Weifang",
            "Weihai",
            "Weinan",
            "Weining",
            "Wenling",
            "Wenshan City",
            "Wenshang",
            "Wenxing",
            "Wenzhou",
            "Wuchang",
            "Wucheng",
            "Wuchuan",
            "Wuda",
            "Wuhai",
            "Wuhan",
            "Wuhu",
            "Wusong",
            "Wuwei",
            "Wuxi",
            "Wuxi",
            "Wuxue",
            "Wuyang",
            "Wuzhou",
            "Xiamen",
            "Xiangcheng Chengguanzhen",
            "Xiangtan",
            "Xiangxiang",
            "Xiangyang",
            "Xianju",
            "Xianning",
            "Xiannü",
            "Xianshuigu",
            "Xiantao",
            "Xianyang",
            "Xiaogan",
            "Xiaolingwei",
            "Xiaoshan",
            "Xiaoshi",
            "Xiaoweizhai",
            "Xiashi",
            "Xiazhen",
            "Xiazhuang",
            "Xichang",
            "Xifeng",
            "Xihe",
            "Xilin Hot",
            "Ximei",
            "Xincheng",
            "Xindi",
            "Xindian",
            "Xingcheng",
            "Xinghua",
            "Xinglongshan",
            "Xingtai",
            "Xinhui",
            "Xining",
            "Xinji",
            "Xinmin",
            "Xinpu",
            "Xinqing",
            "Xinshi",
            "Xintai",
            "Xinyang",
            "Xinyi",
            "Xinyu",
            "Xinzhi",
            "Xinzhou",
            "Xinzhou",
            "Xiongzhou",
            "Xishan",
            "Xiulin",
            "Xiuyan",
            "Xiuying",
            "Xixiang",
            "Xi’an",
            "Xuanzhou",
            "Xucheng",
            "Xunchang",
            "Yakeshi",
            "Yancheng",
            "Yangchun",
            "Yangcun",
            "Yanggu",
            "Yangjiang",
            "Yangliuqing",
            "Yangquan",
            "Yangshuo",
            "Yangzhou",
            "Yanji",
            "Yanjiang",
            "Yanliang",
            "Yanta",
            "Yantai",
            "Yantongshan",
            "Yanzhou",
            "Yashan",
            "Yatou",
            "Yebaishou",
            "Yibin",
            "Yichang",
            "Yicheng",
            "Yicheng",
            "Yichun",
            "Yichun",
            "Yigou",
            "Yilan",
            "Yima",
            "Yinchuan",
            "Yingbazha",
            "Yingchuan",
            "Yingkou",
            "Yingshang Chengguanzhen",
            "Yinzhu",
            "Yishui",
            "Yiwu",
            "Yiyang",
            "Yongchuan",
            "Yongfeng",
            "Youhao",
            "Yuanping",
            "Yucheng",
            "Yuci",
            "Yudong",
            "Yueyang",
            "Yulin",
            "Yulin",
            "Yuncheng",
            "Yunfu",
            "Yunmeng Chengguanzhen",
            "Yunyang",
            "Yushu",
            "Yutan",
            "Yuxi",
            "Yuxia",
            "Yuyao",
            "Zalantun",
            "Zaoyang",
            "Zaozhuang",
            "Zhangjiagang",
            "Zhangjiajie",
            "Zhangjiakou Shi Xuanhua Qu",
            "Zhangjiakou",
            "Zhangye",
            "Zhangzhou",
            "Zhanjiang",
            "Zhaobaoshan",
            "Zhaodong",
            "Zhaogezhuang",
            "Zhaoqing",
            "Zhaotong",
            "Zhaoyuan",
            "Zhaozhou",
            "Zhengjiatun",
            "Zhengzhou",
            "Zhenjiang",
            "Zhenlai",
            "Zhenzhou",
            "Zhicheng",
            "Zhicheng",
            "Zhijiang",
            "Zhongshan",
            "Zhongshu",
            "Zhongxiang",
            "Zhongxing",
            "Zhoucheng",
            "Zhoucun",
            "Zhoukou",
            "Zhoushan",
            "Zhouzhuang",
            "Zhu Cheng City",
            "Zhuanghe",
            "Zhuangyuan",
            "Zhuhai",
            "Zhuji",
            "Zhujiajiao",
            "Zhumadian",
            "Zhuzhou",
            "Zibo",
            "Zigong",
            "Zijinglu",
            "Zoucheng",
            "Zunyi",
            "Ürümqi",
        ],
        "Colombia" => [
            "Acacías",
            "Aguachica",
            "Aguadas",
            "Aguazul",
            "Agustín Codazzi",
            "Andalucía",
            "Andes",
            "Anserma",
            "Apartadó",
            "Aracataca",
            "Arauca",
            "Ariguaní",
            "Arjona",
            "Armenia",
            "Ayapel",
            "Baranoa",
            "Barbosa",
            "Barbosa",
            "Barrancabermeja",
            "Barrancas",
            "Barranquilla",
            "Belalcazar",
            "Bello",
            "Belén de Umbría",
            "Bogotá",
            "Bucaramanga",
            "Buenaventura",
            "Buenaventura",
            "Buga",
            "Caicedonia",
            "Cajicá",
            "Calarcá",
            "Caldas",
            "Cali",
            "Campo de la Cruz",
            "Campoalegre",
            "Candelaria",
            "Carepa",
            "Carmen de Viboral",
            "Cartagena",
            "Cartago",
            "Caucasia",
            "Cereté",
            "Chaparral",
            "Chigorodó",
            "Chimichagua",
            "Chinchiná",
            "Chinú",
            "Chiquinquirá",
            "Chiriguaná",
            "Chía",
            "Circasia",
            "Ciudad Bolívar",
            "Ciénaga de Oro",
            "Ciénaga",
            "Corinto",
            "Corozal",
            "Curumaní",
            "Cúcuta",
            "Dos Quebradas",
            "Duitama",
            "El Bagre",
            "El Banco",
            "El Carmen de Bolívar",
            "El Cerrito",
            "El Charco",
            "El Copey",
            "El Retén",
            "Envigado",
            "Espinal",
            "Facatativá",
            "Flandes",
            "Florencia",
            "Florida",
            "Floridablanca",
            "Fonseca",
            "Fresno",
            "Fundación",
            "Funza",
            "Fusagasuga",
            "Galapa",
            "Garzón",
            "Girardot City",
            "Girón",
            "Granada",
            "Guacarí",
            "Honda",
            "Ibagué",
            "Ipiales",
            "Itagüí",
            "Jamundí",
            "La Ceja",
            "La Dorada",
            "La Estrella",
            "La Jagua de Ibirico",
            "La Mesa",
            "La Plata",
            "La Tebaida",
            "La Unión",
            "La Unión",
            "La Virginia",
            "Leticia",
            "Lorica",
            "Los Patios",
            "Lérida",
            "Líbano",
            "Madrid",
            "Magangué",
            "Maicao",
            "Malambo",
            "Manizales",
            "Manzanares",
            "Marinilla",
            "Mariquita",
            "María la Baja",
            "Medellín",
            "Melgar",
            "Mocoa",
            "Mompós",
            "Montelíbano",
            "Montenegro",
            "Montería",
            "Morales",
            "Morales",
            "Mosquera",
            "Municipio de Copacabana",
            "Málaga",
            "Neiva",
            "Ocaña",
            "Pacho",
            "Palmar de Varela",
            "Palmira",
            "Pamplona",
            "Pasto",
            "Patía",
            "Pereira",
            "Piedecuesta",
            "Pitalito",
            "Pivijay",
            "Planeta Rica",
            "Plato",
            "Popayán",
            "Pradera",
            "Puerto Asís",
            "Puerto Berrío",
            "Puerto Boyacá",
            "Puerto Colombia",
            "Puerto López",
            "Puerto Santander",
            "Puerto Tejada",
            "Quibdó",
            "Quimbaya",
            "Repelón",
            "Rionegro",
            "Riosucio",
            "Roldanillo",
            "Ríohacha",
            "Sabanagrande",
            "Sabanalarga",
            "Sabaneta",
            "Sahagún",
            "Salamina",
            "Sampués",
            "San Andrés",
            "San Benito Abad",
            "San Carlos",
            "San Carlos",
            "San Gil",
            "San Jacinto",
            "San José del Guaviare",
            "San Juan del Cesar",
            "San Juan Nepomuceno",
            "San Marcos",
            "San Martín",
            "San Onofre",
            "Santa Lucía",
            "Santa Marta",
            "Santa Rosa de Cabal",
            "Santander de Quilichao",
            "Santo Tomás",
            "Santuario",
            "Segovia",
            "Sevilla",
            "Sibaté",
            "Sincelejo",
            "Sincé",
            "Soacha",
            "Socorro",
            "Sogamoso",
            "Soledad",
            "Sonsón",
            "Sucre",
            "Tame",
            "Tierralta",
            "Tolú",
            "Tuluá",
            "Tumaco",
            "Tunja",
            "Turbaco",
            "Turbo",
            "Túquerres",
            "Ubaté",
            "Urrao",
            "Valledupar",
            "Villa del Rosario",
            "Villamaría",
            "Villanueva",
            "Villanueva",
            "Villavicencio",
            "Villeta",
            "Viterbo",
            "Yarumal",
            "Yopal",
            "Yumbo",
            "Zaragoza",
            "Zarzal",
            "Zipaquirá",
        ],
        "Costa Rica" => [
            "Alajuela",
            "Aserrí",
            "Calle Blancos",
            "Cartago",
            "Cañas",
            "Chacarita",
            "Colima",
            "Curridabat",
            "Esparza",
            "Guadalupe",
            "Guápiles",
            "Heredia",
            "Ipís",
            "Liberia",
            "Limón",
            "Mercedes",
            "Nicoya",
            "Paraíso",
            "Patarrá",
            "Puntarenas",
            "Purral",
            "Quesada",
            "San Diego",
            "San Felipe",
            "San Francisco",
            "San Isidro",
            "San José",
            "San José",
            "San Juan de Dios",
            "San Juan",
            "San Miguel",
            "San Pablo",
            "San Pedro",
            "San Rafael Abajo",
            "San Rafael Arriba",
            "San Rafael",
            "San Rafael",
            "San Vicente de Moravia",
            "San Vicente",
            "Siquirres",
            "Tejar",
            "Turrialba",
        ],
        "Cuba" => [
            "Abreus",
            "Aguada de Pasajeros",
            "Alamar",
            "Alquízar",
            "Amancio",
            "Arroyo Naranjo",
            "Arroyo Naranjo",
            "Artemisa",
            "Bahía Honda",
            "Banes",
            "Baracoa",
            "Baraguá",
            "Bartolomé Masó",
            "Bauta",
            "Bayamo",
            "Bejucal",
            "Boyeros",
            "Báguanos",
            "Cabaiguán",
            "Cacocum",
            "Caibarién",
            "Calimete",
            "Camagüey",
            "Camajuaní",
            "Campechuela",
            "Cauto Cristo",
            "Centro Habana",
            "Cerro",
            "Chambas",
            "Ciego de Ávila",
            "Cienfuegos",
            "Cifuentes",
            "Ciro Redondo",
            "Colombia",
            "Colón",
            "Condado",
            "Consolación del Sur",
            "Contramaestre",
            "Corralillo",
            "Cruces",
            "Cueto",
            "Cumanayagua",
            "Cárdenas",
            "Diez de Octubre",
            "Encrucijada",
            "Esmeralda",
            "Florencia",
            "Florida",
            "Fomento",
            "Gibara",
            "Guanabacoa",
            "Guanajay",
            "Guane",
            "Guantánamo",
            "Guisa",
            "Guáimaro",
            "Güines",
            "Güira de Melena",
            "Habana del Este",
            "Havana",
            "Holguín",
            "Jagüey Grande",
            "Jaruco",
            "Jatibonico",
            "Jesús Menéndez",
            "Jiguaní",
            "Jimaguayú",
            "Jobabo",
            "Jobabo",
            "Jovellanos",
            "La Habana Vieja",
            "La Salud",
            "La Sierpe",
            "Las Tunas",
            "Los Palacios",
            "Madruga",
            "Maisí",
            "Manicaragua",
            "Manzanillo",
            "Mariel",
            "Matanzas",
            "Media Luna",
            "Minas de Matahambre",
            "Minas",
            "Moa",
            "Morón",
            "Niquero",
            "Nueva Gerona",
            "Nuevitas",
            "Palma Soriano",
            "Palmira",
            "Pedro Betancourt",
            "Perico",
            "Pinar del Río",
            "Placetas",
            "Primero de Enero",
            "Puerto Padre",
            "Ranchuelo",
            "Regla",
            "Remedios",
            "Rodas",
            "Río Cauto",
            "Río Guayabal de Yateras",
            "Sagua de Tánamo",
            "Sagua la Grande",
            "San Antonio de los Baños",
            "San Cristobal",
            "San Germán",
            "San José de las Lajas",
            "San Luis",
            "San Miguel del Padrón",
            "Sancti Spíritus",
            "Santa Clara",
            "Santa Cruz del Norte",
            "Santa Cruz del Sur",
            "Santiago de Cuba",
            "Santiago de las Vegas",
            "Santo Domingo",
            "Sibanicú",
            "Trinidad",
            "Unión de Reyes",
            "Varadero",
            "Venezuela",
            "Vertientes",
            "Viñales",
            "Yaguajay",
            "Yara",
        ],
        "Cape Verde" => [
            "Santa Maria",
            "Praia",
            "Mindelo",
            "Cova Figueira"
        ],
        "Curacao" => [
            "Willemstad"
        ],
        "Christmas Island" => [
            "Flying Fish Cove"
        ],
        "Cyprus" => [
            "Protaras",
            "Paphos",
            "Nicosia",
            "Limassol",
            "Larnaca",
            "Kyrenia",
            "Famagusta"
        ],
        "Czech Republic" => [
            "Dvůr Králové nad Labem",
            "Znojmo",
            "Zlín",
            "Žďár nad Sázavou Druhy",
            "Žďár nad Sázavou",
            "Žatec",
            "Vyškov",
            "Vsetín",
            "Varnsdorf",
            "Valašské Meziříčí",
            "Ústí nad Orlicí",
            "Ústí nad Labem",
            "Uherský Brod",
            "Uherské Hradiště",
            "Trutnov",
            "Třinec",
            "Třebíč",
            "Teplice",
            "Tábor",
            "Svitavy",
            "Šumperk",
            "Strakonice",
            "Starý Bohumín",
            "Sokolov",
            "Slaný",
            "Rožnov pod Radhoštěm",
            "Rakovník",
            "Prostějov",
            "Prosek",
            "Příbram",
            "Přerov",
            "Prague",
            "Pilsen",
            "Písek",
            "Pelhřimov",
            "Pardubice",
            "Otrokovice",
            "Otrokovice",
            "Ostrov",
            "Ostrava",
            "Orlová",
            "Opava",
            "Olomouc",
            "Nový Jičín",
            "Neratovice",
            "Náchod",
            "Most",
            "Modřany",
            "Mladá Boleslav",
            "Mělník",
            "Louny",
            "Litvínov",
            "Litoměřice",
            "Liberec",
            "Libeň",
            "Letňany",
            "Kutná Hora",
            "Kroměříž",
            "Krnov",
            "Kralupy nad Vltavou",
            "Kopřivnice",
            "Kolín",
            "Klatovy",
            "Klášterec nad Ohří",
            "Kladno",
            "Karviná",
            "Karlovy Vary",
            "Kadaň",
            "Kadaň",
            "Jirkov",
            "Jindřichův Hradec",
            "Jihlava",
            "Jičín",
            "Jablonec nad Nisou",
            "Hranice",
            "Hradec Králové",
            "Hodonín",
            "Havlíčkův Brod",
            "Havířov",
            "Frýdek-Místek",
            "Děčín",
            "Chrudim",
            "Chomutov",
            "Cheb",
            "Český Těšín",
            "České Budějovice",
            "Česká Třebová",
            "Česká Lípa",
            "Bruntál",
            "Brno",
            "Břeclav",
            "Braník",
            "Brandýs nad Labem-Stará Boleslav",
            "Bohumín",
            "Blansko",
            "Bílina Kyselka",
            "Bílina",
            "Beroun",
            "Benešov",
            "Černý Most"
        ],
        "Germany" => [
            "Zwickau",
            "Zweibrücken",
            "Zulpich",
            "Zossen",
            "Zittau",
            "Zirndorf",
            "Zerbst",
            "Zeitz",
            "Zehlendorf",
            "Xanten",
            "Wurzen",
            "Würzburg",
            "Würselen",
            "Wuppertal",
            "Wunstorf",
            "Wülfrath",
            "Wörth am Rhein",
            "Worms",
            "Wolfsburg",
            "Wolfratshausen",
            "Wolfenbüttel",
            "Wolfen",
            "Witzenhausen",
            "Wittstock",
            "Wittmund",
            "Wittlich",
            "Wittenberge",
            "Wittenau",
            "Witten",
            "Wismar",
            "Wipperfürth",
            "Winterhude",
            "Winsen",
            "Winnenden",
            "Wilnsdorf",
            "Wilmersdorf",
            "Willich",
            "Wilhelmstadt",
            "Wilhelmshaven",
            "Wildeshausen",
            "Wiesloch",
            "Wiesbaden",
            "Wiehl",
            "Wetzlar",
            "Wetter (Ruhr)",
            "Westerstede",
            "Westend",
            "Wesseling",
            "Wesel",
            "Wertheim",
            "Wernigerode",
            "Werne",
            "Wermelskirchen",
            "Werl",
            "Werdohl",
            "Werder",
            "Werdau",
            "Wendlingen am Neckar",
            "Wenden",
            "Wendelstein",
            "Weiterstadt",
            "Weißwasser",
            "Weißenfels",
            "Weißenburg in Bayern",
            "Weinstadt-Endersbach",
            "Weinheim",
            "Weingarten",
            "Weimar",
            "Weilheim",
            "Weilerswist",
            "Weil der Stadt",
            "Weil am Rhein",
            "Weiden",
            "Weißensee",
            "Wegberg",
            "Weener",
            "Wedel",
            "Wedding",
            "Wassenberg",
            "Warstein",
            "Warendorf",
            "Waren",
            "Wardenburg",
            "Warburg",
            "Wangen im Allgäu",
            "Wandlitz",
            "Waltrop",
            "Walsrode",
            "Wallenhorst",
            "Waldshut-Tiengen",
            "Waldkraiburg",
            "Waldkirch",
            "Waldbröl",
            "Waiblingen",
            "Waghäusel",
            "Wadgassen",
            "Wadern",
            "Wachtberg",
            "Vreden",
            "Völklingen",
            "Voerde",
            "Vlotho",
            "Vilshofen",
            "Villingen-Schwenningen",
            "Viersen",
            "Viernheim",
            "Versmold",
            "Verl",
            "Verden",
            "Velbert",
            "Vechta",
            "Vechelde",
            "Vaterstetten",
            "Varel",
            "Vaihingen an der Enz",
            "Uetersen",
            "Uslar",
            "Unterschleißheim",
            "Unterhaching",
            "Unterkrozingen",
            "Unna",
            "Ulm",
            "Uelzen",
            "Überlingen",
            "Übach-Palenberg",
            "Tuttlingen",
            "Tübingen",
            "Trossingen",
            "Troisdorf",
            "Trier",
            "Traunstein",
            "Traunreut",
            "Torgau",
            "Tönisvorst",
            "Tettnang",
            "Templin",
            "Tempelhof",
            "Teltow",
            "Telgte",
            "Tegel",
            "Taunusstein",
            "Taufkirchen",
            "Syke",
            "Sundern",
            "Sulzbach-Rosenberg",
            "Sulzbach",
            "Suhl",
            "Stuttgart",
            "Stuhr",
            "Strausberg",
            "Straubing",
            "Stralsund",
            "Straelen",
            "Stolberg",
            "Stockelsdorf",
            "Stockach",
            "Stendal",
            "Stellingen",
            "Steinhagen",
            "Steinfurt",
            "Steilshoop",
            "Steglitz",
            "Staßfurt",
            "Starnberg",
            "Stadtlohn",
            "Stadthagen",
            "Stadtallendorf",
            "Stade",
            "Staaken",
            "Sprockhövel",
            "Springe",
            "Speyer",
            "Spenge",
            "Sonthofen",
            "Sonneberg",
            "Sondershausen",
            "Sömmerda",
            "Soltau",
            "Solingen",
            "Soest",
            "Sinzig",
            "Sinsheim",
            "Singen",
            "Sindelfingen",
            "Simmerath",
            "Sigmaringen",
            "Siegen",
            "Siegburg",
            "Senftenberg",
            "Senden",
            "Senden",
            "Selm",
            "Seligenstadt",
            "Selb",
            "Sehnde",
            "Seevetal",
            "Seesen",
            "Seelze",
            "Schwetzingen",
            "Schwerte",
            "Schwerin",
            "Schwelm",
            "Schweinfurt",
            "Schwedt (Oder)",
            "Schwarzenberg",
            "Schwanewede",
            "Schwandorf in Bayern",
            "Schwalmtal",
            "Schwalmstadt",
            "Schwalbach",
            "Schwäbisch Hall",
            "Schwäbisch Gmünd",
            "Schwabach",
            "Schrobenhausen",
            "Schramberg",
            "Schortens",
            "Schorndorf",
            "Schopfheim",
            "Schöneberg",
            "Schönebeck",
            "Schneverdingen",
            "Schneeberg",
            "Schmelz",
            "Schmargendorf",
            "Schmallenberg",
            "Schmalkalden",
            "Schlüchtern",
            "Schleswig",
            "Schkeuditz",
            "Schiffweiler",
            "Schifferstadt",
            "Saulgau",
            "Sasel",
            "Sarstedt",
            "Sankt Wendel",
            "Sankt Ingbert",
            "Sankt Augustin",
            "Sangerhausen",
            "Salzwedel",
            "Salzkotten",
            "Saarlouis",
            "Saarbrücken",
            "Saalfeld",
            "Rüsselsheim",
            "Rummelsburg",
            "Rudow",
            "Rudolstadt",
            "Rottweil",
            "Rottenburg",
            "Roth",
            "Rotenburg",
            "Rostock",
            "Rösrath",
            "Rosenheim",
            "Ronnenberg",
            "Rinteln",
            "Rietberg",
            "Riesa",
            "Riegelsberg",
            "Ribnitz-Damgarten",
            "Rheinfelden (Baden)",
            "Rheine",
            "Rheinberg",
            "Rheinbach",
            "Rhede",
            "Rheda-Wiedenbrück",
            "Reutlingen",
            "Renningen",
            "Rendsburg",
            "Remscheid",
            "Remagen",
            "Reinickendorf",
            "Reinheim",
            "Reinbek",
            "Reichenbach/Vogtland",
            "Regensburg",
            "Rees",
            "Recklinghausen",
            "Ravensburg",
            "Ratingen",
            "Rathenow",
            "Ratekau",
            "Rastede",
            "Rastatt",
            "Rahden",
            "Radolfzell am Bodensee",
            "Radevormwald",
            "Radebeul",
            "Radeberg",
            "Quickborn",
            "Quedlinburg",
            "Püttlingen",
            "Pulheim",
            "Puchheim",
            "Prenzlauer Berg",
            "Prenzlau",
            "Preetz",
            "Potsdam",
            "Porta Westfalica",
            "Poppenbüttel",
            "Plettenberg",
            "Plauen",
            "Pirna",
            "Pirmasens",
            "Pinneberg",
            "Pfungstadt",
            "Pfullingen",
            "Pforzheim",
            "Pfaffenhofen an der Ilm",
            "Petershagen",
            "Penzberg",
            "Peine",
            "Passau",
            "Pasing",
            "Parchim",
            "Papenburg",
            "Pankow",
            "Paderborn",
            "Oyten",
            "Overath",
            "Ottweiler",
            "Ottobrunn",
            "Osterholz-Scharmbeck",
            "Osnabrück",
            "Oschersleben",
            "Oschatz",
            "Oranienburg",
            "Opladen",
            "Olsberg",
            "Olpe",
            "Oldenburg",
            "Olching",
            "Öhringen",
            "Offenburg",
            "Offenbach",
            "Oerlinghausen",
            "Oer-Erkenschwick",
            "Oelde",
            "Odenthal",
            "Ochtrup",
            "Oberursel",
            "Obertshausen",
            "Oberschöneweide",
            "Ober-Ramstadt",
            "Oberkirch",
            "Oberhausen",
            "Oberasbach",
            "Nürtingen",
            "Nürnberg",
            "Nümbrecht",
            "Nottuln",
            "Northeim",
            "Nördlingen",
            "Nordhorn",
            "Nordhausen",
            "Norderstedt",
            "Nordenham",
            "Norden",
            "Nippes",
            "Nikolassee",
            "Nienburg",
            "Niederschönhausen",
            "Niederkrüchten",
            "Niederkassel",
            "Nieder-Ingelheim",
            "Nidderau",
            "Nidda",
            "Neu Wulmstorf",
            "Neuwied",
            "Neu-Ulm",
            "Neustrelitz",
            "Neustadt in Holstein",
            "Neustadt bei Coburg",
            "Neustadt",
            "Neustadt am Rübenberge",
            "Neue Neustadt",
            "Neuss",
            "Neuruppin",
            "Neunkirchen",
            "Neumünster",
            "Neumarkt in der Oberpfalz",
            "Neu Isenburg",
            "Neufahrn bei Freising",
            "Neuenhagen",
            "Neuburg an der Donau",
            "Neubrück",
            "Neubrandenburg",
            "Neu-Anspach",
            "Nettetal",
            "Netphen",
            "Neckarsulm",
            "Naumburg",
            "Nauen",
            "Nagold",
            "Munster",
            "Münster",
            "Hannoversch Münden",
            "Munich",
            "Müllheim",
            "Mülheim (Ruhr)",
            "Mühlheim am Main",
            "Stuttgart Mühlhausen",
            "Mühlhausen",
            "Mühldorf",
            "Mühlacker",
            "Much",
            "Mössingen",
            "Mosbach",
            "Moosburg",
            "Monheim am Rhein",
            "Mönchengladbach",
            "Mölln",
            "Moers",
            "Moabit",
            "Mittweida",
            "Minden",
            "Michelstadt",
            "Metzingen",
            "Mettmann",
            "Meschede",
            "Merzig",
            "Merseburg",
            "Meppen",
            "Menden",
            "Memmingen",
            "Melle",
            "Meissen",
            "Meiningen",
            "Meinerzhagen",
            "Meiderich",
            "Meerbusch",
            "Meerane",
            "Meckenheim",
            "Mechernich",
            "Mayen",
            "Marzahn",
            "Marsberg",
            "Marl",
            "Marktredwitz",
            "Marktoberdorf",
            "Markkleeberg",
            "Märkisches Viertel",
            "Marienfelde",
            "Mariendorf",
            "Marburg an der Lahn",
            "Marbach am Neckar",
            "Mannheim",
            "Mainz",
            "Maintal",
            "Mahlsdorf",
            "Magdeburg",
            "Lünen",
            "Lüneburg",
            "Ludwigshafen am Rhein",
            "Ludwigsfelde",
            "Ludwigsburg",
            "Lüdinghausen",
            "Lüdenscheid",
            "Luckenwalde",
            "Lübeck",
            "Lübbenau",
            "Lübbecke",
            "Loxstedt",
            "Losheim",
            "Lörrach",
            "Lohr am Main",
            "Lohne",
            "Löhne",
            "Lohmar",
            "Löbau",
            "Lippstadt",
            "Lingen",
            "Lindlar",
            "Lindau",
            "Limburg an der Lahn",
            "Limbach-Oberfrohna",
            "Lilienthal",
            "Lichterfelde",
            "Lichtenrade",
            "Lichtenfels",
            "Lichtenberg",
            "Leverkusen",
            "Leutkirch im Allgäu",
            "Leopoldshöhe",
            "Leonberg",
            "Lennestadt",
            "Lengerich",
            "Lemgo",
            "Leipzig",
            "Leinfelden-Echterdingen",
            "Leimen",
            "Leichlingen",
            "Lehrte",
            "Leer",
            "Lebach",
            "Laupheim",
            "Lauf an der Pegnitz",
            "Lauchhammer",
            "Lankwitz",
            "Langenhorn",
            "Langenhagen",
            "Langenfeld",
            "Langen",
            "Langen",
            "Landshut",
            "Landsberg am Lech",
            "Landau in der Pfalz",
            "Lampertheim",
            "Lahr",
            "Lahnstein",
            "Lage",
            "Laatzen",
            "Bad Laasphe",
            "Kürten",
            "Künzelsau",
            "Künzell",
            "Kulmbach",
            "Kronberg",
            "Kronach",
            "Kreuztal",
            "Kreuzberg",
            "Kreuzau",
            "Krefeld",
            "Köthen",
            "Korschenbroich",
            "Kornwestheim",
            "Korntal",
            "Korbach",
            "Köpenick",
            "Berlin Köpenick",
            "Konz",
            "Konstanz",
            "Königs Wusterhausen",
            "Königswinter",
            "Königstein im Taunus",
            "Königslutter am Elm",
            "Königsbrunn",
            "Köln",
            "Kolbermoor",
            "Koblenz",
            "Kleve",
            "Kleinmachnow",
            "Kitzingen",
            "Kirchlengern",
            "Kirchheim unter Teck",
            "Kirchhain",
            "Kierspe",
            "Kiel",
            "Kevelaer",
            "Kerpen",
            "Kempten (Allgäu)",
            "Kempen",
            "Kelkheim (Taunus)",
            "Kelheim",
            "Kehl",
            "Kaulsdorf",
            "Kaufbeuren",
            "Kassel",
            "Karow",
            "Karlstadt",
            "Karlsruhe",
            "Karlshorst",
            "Karlsfeld",
            "Karben",
            "Kamp-Lintfort",
            "Kamenz",
            "Kamen",
            "Kaltenkirchen",
            "Kaiserslautern",
            "Kaarst",
            "Jülich",
            "Jüchen",
            "Johannisthal",
            "Jena",
            "Itzehoe",
            "Isernhagen Farster Bauerschaft",
            "Iserlohn",
            "Ingolstadt",
            "Ilmenau",
            "Illingen",
            "Illertissen",
            "Idstein",
            "Idar-Oberstein",
            "Ibbenbüren",
            "Husum",
            "Hürth",
            "Hünfeld",
            "Hummelsbüttel",
            "Humboldtkolonie",
            "Hude",
            "Hückeswagen",
            "Hückelhoven",
            "Hoyerswerda",
            "Höxter",
            "Hövelhof",
            "Hörstel",
            "Horb am Neckar",
            "Homburg",
            "Holzwickede",
            "Holzminden",
            "Holzkirchen",
            "Hohenstein-Ernstthal",
            "Hohen Neuendorf",
            "Hofheim am Taunus",
            "Hofgeismar",
            "Hof",
            "Hockenheim",
            "Hochheim am Main",
            "Hochfeld",
            "Hille",
            "Hildesheim",
            "Hilden",
            "Hilchenbach",
            "Hiddenhausen",
            "Heusweiler",
            "Heusenstamm",
            "Hettstedt",
            "Hessisch Oldendorf",
            "Herzogenrath",
            "Herzogenaurach",
            "Herten",
            "Herrenberg",
            "Herne",
            "Hermsdorf",
            "Herford",
            "Herdecke",
            "Herborn",
            "Heppenheim an der Bergstrasse",
            "Hennigsdorf",
            "Hennef",
            "Hemmingen",
            "Hemer",
            "Helmstedt",
            "Hellersdorf",
            "Heinsberg",
            "Heilbad Heiligenstadt",
            "Heiligensee",
            "Heiligenhaus",
            "Heilbronn",
            "Heidenheim an der Brenz",
            "Heidenau",
            "Heidelberg",
            "Heide",
            "Hechingen",
            "Hattingen",
            "Hattersheim",
            "Haßloch",
            "Harsewinkel",
            "Haren",
            "Harburg",
            "Hannover",
            "Hanau am Main",
            "Hamminkeln",
            "Hamm",
            "Hameln",
            "Wandsbek",
            "Marienthal",
            "Hamburg-Mitte",
            "Eimsbüttel",
            "Altona",
            "Hamburg",
            "Halver",
            "Haltern",
            "Halstenbek",
            "Halle",
            "Halle (Saale)",
            "Haldensleben I",
            "Halberstadt",
            "Hakenfelde",
            "Haiger",
            "Hagen",
            "Haar",
            "Haan",
            "Gütersloh",
            "Güstrow",
            "Gunzenhausen",
            "Günzburg",
            "Gummersbach",
            "Guben",
            "Groß-Umstadt",
            "Großostheim",
            "Groß-Gerau",
            "Großenhain",
            "Gronau",
            "Gröbenzell",
            "Grimma",
            "Griesheim",
            "Grevenbroich",
            "Greven",
            "Greiz",
            "Greifswald",
            "Grefrath",
            "Göttingen",
            "Gotha",
            "Goslar",
            "Görlitz",
            "Göppingen",
            "Goch",
            "Glinde",
            "Glauchau",
            "Gladbeck",
            "Ginsheim-Gustavsburg",
            "Gilching",
            "Gifhorn",
            "Gießen",
            "Giengen an der Brenz",
            "Gevelsberg",
            "Gesundbrunnen",
            "Geseke",
            "Gescher",
            "Gersthofen",
            "Germersheim",
            "Germering",
            "Gerlingen",
            "Geretsried",
            "Gera",
            "Georgsmarienhütte",
            "Gelsenkirchen",
            "Gelnhausen",
            "Geldern",
            "Geislingen an der Steige",
            "Geilenkirchen",
            "Geesthacht",
            "Gauting",
            "Garmisch-Partenkirchen",
            "Garching bei München",
            "Garbsen",
            "Ganderkesee",
            "Gaggenau",
            "Fürth",
            "Fürstenwalde",
            "Fürstenfeldbruck",
            "Fulda",
            "Fröndenberg",
            "Frohnau",
            "Friesoythe",
            "Friedrichshain",
            "Friedrichshagen",
            "Friedrichshafen",
            "Friedrichsfelde",
            "Friedrichsdorf",
            "Friedenau",
            "Friedberg",
            "Friedberg",
            "Freudenstadt",
            "Freudenberg",
            "Freital",
            "Freising",
            "Freilassing",
            "Freiburg",
            "Freiberg am Neckar",
            "Freiberg",
            "Frechen",
            "Frankfurt am Main",
            "Frankfurt (Oder)",
            "Frankenthal",
            "Frankenberg",
            "Frankenberg",
            "Forst",
            "Forchheim",
            "Flörsheim",
            "Flensburg",
            "Finsterwalde",
            "Finnentrop",
            "Stuttgart Feuerbach",
            "Fellbach",
            "Falkensee",
            "Eutin",
            "Euskirchen",
            "Ettlingen",
            "Esslingen",
            "Essen",
            "Espelkamp",
            "Eschweiler",
            "Eschwege",
            "Eschborn",
            "Erwitte",
            "Erlangen",
            "Erkrath",
            "Erkelenz",
            "Erfurt",
            "Erftstadt",
            "Erding",
            "Eppingen",
            "Eppelborn",
            "Ennigerloh",
            "Ennepetal",
            "Enger",
            "Engelskirchen",
            "Emsdetten",
            "Emmerich",
            "Emmendingen",
            "Emden",
            "Eltville",
            "Elsdorf",
            "Elmshorn",
            "Ellwangen",
            "Eitorf",
            "Eislingen",
            "Eisenhüttenstadt",
            "Eisenach",
            "Einbeck",
            "Eilenburg",
            "Ehingen",
            "Eggenstein-Leopoldshafen",
            "Edewecht",
            "Eckernförde",
            "Eberswalde",
            "Ebersbach an der Fils",
            "Eberbach",
            "Düsseldorf",
            "Düren",
            "Dülmen",
            "Duisburg",
            "Duderstadt",
            "Dresden",
            "Drensteinfurt",
            "Dreieich",
            "Dortmund",
            "Dorsten",
            "Dormagen",
            "Donauwörth",
            "Donaueschingen",
            "Döbeln",
            "Ditzingen",
            "Dinslaken",
            "Dingolfing",
            "Dillingen an der Donau",
            "Dillingen",
            "Dillenburg",
            "Dietzenbach",
            "Diepholz",
            "Dieburg",
            "Deutz",
            "Detmold",
            "Dessau",
            "Delmenhorst",
            "Delitzsch",
            "Delbrück",
            "Deggendorf",
            "Datteln",
            "Darmstadt",
            "Damme",
            "Dahlem",
            "Dachau",
            "Cuxhaven",
            "Crimmitschau",
            "Crailsheim",
            "Cottbus",
            "Coswig",
            "Coesfeld",
            "Coburg",
            "Cloppenburg",
            "Clausthal-Zellerfeld",
            "Chemnitz",
            "Charlottenburg",
            "Cham",
            "Celle",
            "Castrop-Rauxel",
            "Calw",
            "Buxtehude",
            "Butzbach",
            "Bürstadt",
            "Burscheid",
            "Burghausen",
            "Burgdorf",
            "Burg bei Magdeburg",
            "Büren",
            "Bünde",
            "Bühl",
            "Büdingen",
            "Buckow",
            "Bückeburg",
            "Buchholz in der Nordheide",
            "Französisch Buchholz",
            "Buchen",
            "Brühl",
            "Brüggen",
            "Bruckmühl",
            "Bruchsal",
            "Bruchköbel",
            "Britz",
            "Brilon",
            "Bretten",
            "Bremervörde",
            "Bremerhaven",
            "Bremen",
            "Braunschweig",
            "Brandenburg an der Havel",
            "Bramsche",
            "Brakel",
            "Brake (Unterweser)",
            "Brackenheim",
            "Bottrop",
            "Bornheim",
            "Borna",
            "Borken",
            "Boppard",
            "Bonn",
            "Bönen",
            "Bogenhausen",
            "Bochum",
            "Bocholt",
            "Böblingen",
            "Bobingen",
            "Blomberg",
            "Blieskastel",
            "Blankenburg",
            "Bitterfeld-Wolfen",
            "Bingen am Rhein",
            "Bietigheim-Bissingen",
            "Biesdorf",
            "Bielefeld",
            "Biberach an der Riß",
            "Bexbach",
            "Beverungen",
            "Bernburg",
            "Bernau bei Berlin",
            "Berlin",
            "Bergneustadt",
            "Bergkamen",
            "Bergisch Gladbach",
            "Bergheim",
            "Bensheim",
            "Bendorf",
            "Bedburg",
            "Beckum",
            "Beckingen",
            "Bayreuth",
            "Bautzen",
            "Baunatal",
            "Baumschulenweg",
            "Bassum",
            "Bamberg",
            "Balingen",
            "Baiersbronn",
            "Baesweiler",
            "Bad Zwischenahn",
            "Bad Wildungen",
            "Bad Waldsee",
            "Bad Vilbel",
            "Bad Tölz",
            "Bad Soden am Taunus",
            "Bad Segeberg",
            "Bad Schwartau",
            "Bad Salzungen",
            "Bad Salzuflen",
            "Bad Säckingen",
            "Bad Reichenhall",
            "Bad Rappenau",
            "Bad Pyrmont",
            "Bad Oldesloe",
            "Bad Oeynhausen",
            "Bad Neustadt an der Saale",
            "Bad Neuenahr-Ahrweiler",
            "Bad Nauheim",
            "Bad Münstereifel",
            "Bad Münder am Deister",
            "Bad Mergentheim",
            "Bad Lippspringe",
            "Bad Langensalza",
            "Bad Kreuznach",
            "Bad Kissingen",
            "Bad Honnef",
            "Bad Homburg vor der Höhe",
            "Bad Hersfeld",
            "Bad Harzburg",
            "Bad Essen",
            "Baden-Baden",
            "Bad Dürkheim",
            "Bad Driburg",
            "Bad Berleburg",
            "Bad Bentheim",
            "Bad Aibling",
            "Backnang",
            "Babenhausen",
            "Aurich",
            "Augsburg",
            "Auerbach",
            "Aue",
            "Attendorn",
            "Aschersleben",
            "Ascheberg",
            "Aschaffenburg",
            "Bad Arolsen",
            "Arnstadt",
            "Arnsberg",
            "Apolda",
            "Ansbach",
            "Annaberg-Buchholz",
            "Angermünde",
            "Andernach",
            "Amberg",
            "Alzey",
            "Alzenau in Unterfranken",
            "Altglienicke",
            "Altenburg",
            "Altena",
            "Altdorf",
            "Alsfeld",
            "Alsdorf",
            "Alfter",
            "Alfeld",
            "Albstadt",
            "Aichach",
            "Ahrensburg",
            "Ahlen",
            "Ahaus",
            "Adlershof",
            "Achim",
            "Achern",
            "Aalen",
            "Vellmar",
            "Henstedt-Ulzburg",
            "Aachen",
            "Mörfelden-Walldorf",
            "Riedstadt",
            "Lauda-Königshofen",
            "Filderstadt",
            "Ostfildern",
            "Rodgau",
            "Gropiusstadt",
            "Seeheim-Jugenheim",
            "Charlottenburg-Nord",
            "Mitte",
            "Spremberg",
            "Rheinstetten",
            "Altstadt Sud",
            "Altstadt Nord",
            "Neuehrenfeld",
            "Bilderstoeckchen",
            "Stuttgart-Ost",
            "Bochum-Hordel",
            "St. Pauli",
            "Eidelstedt",
            "Halle Neustadt",
            "Bergedorf",
            "Spandau",
            "Berlin Schöneberg",
            "Berlin Treptow",
            "Niederrad",
            "Haselbachtal",
            "Barmbek-Nord",
            "Farmsen-Berne",
            "Falkenhagener Feld",
            "Neu-Hohenschönhausen",
            "Alt-Hohenschönhausen",
            "Fennpfuhl",
            "Hamburg-Nord",
            "Burg Unter-Falkenstein",
            "Neustadt/Nord",
            "Neustadt/Süd",
            "Kalk",
            "Mülheim",
            "Gartenstadt"
        ],
        "Djibouti" => [
            "Tadjoura",
            "Obock",
            "Djibouti",
            "Ḏânan",
            "'Ali Sabieh"
        ],
        "Denmark" => [
            "Viborg",
            "Vejle",
            "Vanløse",
            "Taastrup",
            "Svendborg",
            "Stenløse",
            "Sønderborg",
            "Slagelse",
            "Skive",
            "Silkeborg",
            "Roskilde",
            "Rødovre",
            "Ringsted",
            "Randers",
            "Odense",
            "Nykøbing Falster",
            "Nyborg",
            "Næstved",
            "Nørresundby",
            "Lillerød",
            "Korsør",
            "Køge",
            "Copenhagen",
            "Kolding",
            "Kalundborg",
            "Ishøj",
            "Hvidovre",
            "Horsens",
            "Hørsholm",
            "Holstebro",
            "Holbæk",
            "Hjørring",
            "Hillerød",
            "Herning",
            "Helsingør",
            "Haderslev",
            "Greve",
            "Glostrup",
            "Frederikshavn",
            "Frederiksberg",
            "Fredericia",
            "Farum",
            "Esbjerg",
            "Charlottenlund",
            "Birkerød",
            "Ballerup",
            "Århus",
            "Aalborg",
            "Albertslund",
            "Aabenraa"
        ],
        "Dominica" => [
            "Roseau"
        ],
        "Dominican Republic" => [
            "Villa Francisca",
            "Villa Consuelo",
            "Villa Bisonó",
            "Villa Altagracia",
            "Tamboril",
            "Santo Domingo",
            "Santiago de los Caballeros",
            "Santa Cruz de El Seibo",
            "Santa Cruz de Barahona",
            "San Pedro de Macorís",
            "San Juan de la Maguana",
            "San José de Ocoa",
            "San Francisco de Macorís",
            "San Fernando de Monte Cristi",
            "Puerto Plata",
            "Salvaleón de Higüey",
            "Salcedo",
            "Sabaneta",
            "Sabana Grande de Boyá",
            "Río Grande",
            "Quisqueya",
            "Punta Cana",
            "Neiba",
            "Nagua",
            "Monte Plata",
            "Moca",
            "Mao",
            "Las Matas de Farfán",
            "La Romana",
            "Jarabacoa",
            "Hato Mayor del Rey",
            "Esperanza",
            "Dajabón",
            "Cotuí",
            "Constanza",
            "Concepción de La Vega",
            "Ciudad Nueva",
            "Bonao",
            "Boca Chica",
            "San Cristóbal",
            "Bella Vista",
            "Bayaguana",
            "Baní",
            "Bajos de Haina",
            "Azua",
            "Santo Domingo Oeste"
        ],
        "Algeria" => [
            "Boumerdas",
            "Zeribet el Oued",
            "Zeralda",
            "Zemoura",
            "Touggourt",
            "Tolga",
            "Tlemcen",
            "Tizi Rached",
            "Tizi Ouzou",
            "Tizi-n-Tleta",
            "Tizi Gheniff",
            "Tissemsilt",
            "Tirmitine",
            "Tipasa",
            "Tindouf",
            "Timizart",
            "Timimoun",
            "el hed",
            "Tiaret",
            "Theniet el Had",
            "Thenia",
            "Telerghma",
            "Tébessa",
            "Tebesbest",
            "Tazoult-Lambese",
            "Tamanrasset",
            "Tamalous",
            "Tadmaït",
            "Sour el Ghozlane",
            "Souma",
            "Lardjem",
            "Souk Ahras",
            "Sougueur",
            "Skikda",
            "Sig",
            "Sidi Okba",
            "Sidi Moussa",
            "Sidi Mérouane",
            "Sidi Khaled",
            "Sidi ech Chahmi",
            "Sidi Bel Abbès",
            "Sidi Amrane",
            "Sidi Akkacha",
            "Sidi Aïssa",
            "Sidi Abdelli",
            "Sfizef",
            "Sétif",
            "Sedrata",
            "Seddouk",
            "Sebdou",
            "Saoula",
            "Salah Bey",
            "Saïda",
            "Rouissat",
            "Rouiba",
            "Rouached",
            "Robbah",
            "Remchi",
            "Relizane",
            "Reguiba",
            "Reghaïa",
            "Reggane",
            "Râs el Oued",
            "Râs el Aïoun",
            "Oum el Bouaghi",
            "Ouled Mimoun",
            "Oued Sly",
            "Oued Rhiou",
            "Oued Fodda",
            "Oued el Alleug",
            "Oued el Abtal",
            "Ouargla",
            "Oran",
            "Nedroma",
            "Naciria",
            "M’Sila",
            "Mouzaïa",
            "Mostaganem",
            "Mila",
            "Metlili Chaamba",
            "Messaad",
            "Meskiana",
            "Mers el Kebir",
            "Merouana",
            "Melouza",
            "Mekla",
            "Mehdia",
            "Megarine",
            "Meftah",
            "Médéa",
            "Mazouna",
            "Mascara",
            "Mansourah",
            "Mansoûra",
            "Makouda",
            "L’Arbaa Naït Irathen",
            "Larbaâ",
            "Lakhdaria",
            "Laghouat",
            "Ksar el Boukhari",
            "Ksar Chellala",
            "Kolea",
            "Khenchela",
            "Khemis Miliana",
            "Khemis el Khechna",
            "Kerkera",
            "Jijel",
            "Djidiouia",
            "Isser",
            "I-n-Salah",
            "Ighram",
            "Hennaya",
            "Héliopolis",
            "Hassi Messaoud",
            "Hammamet",
            "Hammam Bou Hadjar",
            "Hamma Bouziane",
            "Hadjout",
            "Guelma",
            "Ghardaïa",
            "Frenda",
            "Freha",
            "Feraoun",
            "Es Senia",
            "El Tarf",
            "El Oued",
            "El Malah",
            "El Kseur",
            "El Khroub",
            "El Kala",
            "El Idrissia",
            "El Hadjira",
            "El Hadjar",
            "El Eulma",
            "El Bayadh",
            "El Attaf",
            "Chlef",
            "El Aouinet",
            "El Amria",
            "El Affroun",
            "El Achir",
            "El Abiodh Sidi Cheikh",
            "El Abadia",
            "Ech Chettia",
            "Drean",
            "Draa el Mizan",
            "Draa Ben Khedda",
            "Douera",
            "Djelfa",
            "Djamaa",
            "Didouche Mourad",
            "Dellys",
            "Debila",
            "Dar el Beïda",
            "Dar Chioukh",
            "Constantine",
            "Chorfa",
            "Chiffa",
            "Chetouane",
            "Cheria",
            "Cheraga",
            "Chemini",
            "Chelghoum el Aïd",
            "Chebli",
            "Charef",
            "Chabet el Ameur",
            "Brezina",
            "Bou Tlelis",
            "Boumahra Ahmed",
            "Boukadir",
            "Bou Ismaïl",
            "Bouïra",
            "Bouinan",
            "Bou Hanifia el Hamamat",
            "Bougara",
            "Bougaa",
            "Boufarik",
            "Boudouaou",
            "Boudjima",
            "Boû Arfa",
            "Bordj Zemoura",
            "Bordj Ghdir",
            "Bordj el Kiffan",
            "Bordj Bou Arreridj",
            "Boghni",
            "Blida",
            "Biskra",
            "Birkhadem",
            "Birine",
            "Bir el Djir",
            "Bir el Ater",
            "Besbes",
            "Berrouaghia",
            "Berriane",
            "Berrahal",
            "Bensekrane",
            "Ben Mehidi",
            "Beni Saf",
            "Beni Mester",
            "Beni Mered",
            "Beni Douala",
            "Beni Amrane",
            "Bejaïa",
            "Béchar",
            "Batna",
            "Barika",
            "Barbacha",
            "Baraki",
            "Bab Ezzouar",
            "Azzaba",
            "Azazga",
            "Arris",
            "Arhribs",
            "Arbatache",
            "Aoulef",
            "Annaba",
            "Ammi Moussa",
            "Amizour",
            "Algiers",
            "Akbou",
            "Aïn Touta",
            "Aïn Temouchent",
            "Aïn Taya",
            "Aïn Smara",
            "Aïn Sefra",
            "Aïn Oussera",
            "’Aïn Merane",
            "Aïn Kercha",
            "Aïn Fakroun",
            "’Aïn el Turk",
            "’Aïn el Melh",
            "’Aïn el Hammam",
            "‘Aïn el Hadjel",
            "Aïn el Bya",
            "’Aïn el Berd",
            "’Aïn el Bell",
            "’Aïn Deheb",
            "Aïn Defla",
            "Aïn Bessem",
            "’Aïn Benian",
            "Aïn Beïda",
            "Aïn Arnat",
            "’Aïn Abid",
            "Aflou",
            "Adrar",
            "Abou el Hassan",
            "BABOR - VILLE"
        ],
        "Ecuador" => [
            "Zamora",
            "Yaguachi Nuevo",
            "Vinces",
            "Ventanas",
            "Velasco Ibarra",
            "Tulcán",
            "Tena",
            "Sucre",
            "Santo Domingo de los Colorados",
            "Santa Rosa",
            "Santa Elena",
            "San Lorenzo de Esmeraldas",
            "San Gabriel",
            "Samborondón",
            "Salinas",
            "Rosa Zarate",
            "Riobamba",
            "Quito",
            "Quevedo",
            "Puyo",
            "Pujilí",
            "Puerto Francisco de Orellana",
            "Portoviejo",
            "Playas",
            "Piñas",
            "Pelileo",
            "Pedro Carbo",
            "Pasaje",
            "Otavalo",
            "Naranjito",
            "Naranjal",
            "Montecristi",
            "Montalvo",
            "Manta",
            "Machala",
            "Machachi",
            "Macas",
            "Loja",
            "La Troncal",
            "Latacunga",
            "La Maná",
            "La Libertad",
            "Nueva Loja",
            "Jipijapa",
            "Ibarra",
            "Huaquillas",
            "Guayaquil",
            "Guaranda",
            "Gualaceo",
            "Esmeraldas",
            "El Triunfo",
            "Eloy Alfaro",
            "Cuenca",
            "Chone",
            "Cayambe",
            "Catamayo",
            "Cariamanga",
            "Calceta",
            "Boca Suno",
            "Balzar",
            "Bahía de Caráquez",
            "Babahoyo",
            "Azogues",
            "Atuntaqui",
            "Ambato",
            "Tutamandahostel"
        ],
        "Estonia" => [
            "Viljandi",
            "Tartu",
            "Tallinn",
            "Sillamäe",
            "Rakvere",
            "Pärnu",
            "Narva",
            "Maardu",
            "Kohtla-Järve"
        ],
        "Egypt" => [
            "Ziftá",
            "Toukh",
            "Tanda",
            "Ţāmiyah",
            "Ţalkhā",
            "Talā",
            "Ţahţā",
            "Sumusţā as Sulţānī",
            "Sohag",
            "Sīdī Sālim",
            "Shirbīn",
            "Shibīn al Qanāţir",
            "Shibīn al Kawm",
            "Samannūd",
            "Samālūţ",
            "Rosetta",
            "Ras Gharib",
            "Quwaysinā",
            "Quţūr",
            "Kousa",
            "Qinā",
            "Qalyūb",
            "Naj‘ Ḩammādī",
            "Minyat an Naşr",
            "Minūf",
            "Maţāy",
            "Mashtūl as Sūq",
            "Mersa Matruh",
            "Manfalūţ",
            "Mallawī",
            "Madīnat Sittah Uktūbar",
            "Kawm Umbū",
            "Kawm Ḩamādah",
            "Kafr Şaqr",
            "Kafr az Zayyāt",
            "Kafr ash Shaykh",
            "Kafr ad Dawwār",
            "Juhaynah",
            "Jirjā",
            "‘Izbat al Burj",
            "Iţsā",
            "Isnā",
            "Idkū",
            "Idfū",
            "Ibshawāy",
            "Ḩalwān",
            "Hihyā",
            "Ḩawsh ‘Īsá",
            "Fuwwah",
            "Farshūţ",
            "Fāraskūr",
            "Fāqūs",
            "Damietta",
            "Diyarb Najm",
            "Disūq",
            "Dishnā",
            "Dikirnis",
            "Dayrūţ",
            "Dayr Mawās",
            "Damanhūr",
            "Būsh",
            "Port Said",
            "Būr Safājah",
            "Bilqās",
            "Bilbays",
            "Basyūn",
            "Banī Suwayf",
            "Banī Mazār",
            "Banhā",
            "Zagazig",
            "Awsīm",
            "At Tall al Kabīr",
            "Asyūţ",
            "Aswan",
            "Suez",
            "Aş Şaff",
            "Ash Shuhadā’",
            "Ashmūn",
            "Al Wāsiţah",
            "Luxor",
            "Al Qūşīyah",
            "Al Quşayr",
            "Al Qurayn",
            "Al Qanāyāt",
            "Al Qanāţir al Khayrīyah",
            "Cairo",
            "Al Minyā",
            "Al Maţarīyah",
            "Al Manzilah",
            "Al Manşūrah",
            "Al Manshāh",
            "Al Maḩallah al Kubrá",
            "Al Khārijah",
            "Al Khānkah",
            "Al Jīzah",
            "Al Jamālīyah",
            "Ismailia",
            "Alexandria",
            "Al Ibrāhīmīyah",
            "Al Ḩawāmidīyah",
            "Al Ḩāmūl",
            "Hurghada",
            "Al Fayyūm",
            "Al Fashn",
            "Al Bawīţī",
            "Al Balyanā",
            "Al Bājūr",
            "Al Badārī",
            "Al ‘Ayyāţ",
            "Arish",
            "Akhmīm",
            "Ajā",
            "Ad Dilinjāt",
            "Abū Tīj",
            "Abū Qurqāş",
            "Abū Kabīr",
            "Abū al Maţāmīr",
            "Abnūb",
            "Az Zarqā",
            "Ain Sukhna"
        ],
        "Western Sahara" => [
            "Smara",
            "Laâyoune / El Aaiún",
            "Dakhla"
        ],
        "Eritrea" => [
            "Massawa",
            "Keren",
            "Barentu",
            "Asmara",
            "Assab",
            "Mendefera"
        ],
        "Spain" => [
            "Zubia",
            "Zafra",
            "Yecla",
            "Villena",
            "Villarrobledo",
            "Vila-real",
            "Villanueva de la Serena",
            "Villajoyosa",
            "Vícar",
            "Vélez-Málaga",
            "Valencia",
            "Valdepeñas",
            "Utrera",
            "Ubrique",
            "Úbeda",
            "Totana",
            "Torrox",
            "Torrevieja",
            "Torre-Pacheco",
            "Torrent",
            "Torremolinos",
            "Tomelloso",
            "Tomares",
            "Toledo",
            "Tías",
            "Telde",
            "Teguise",
            "Tarifa",
            "Talavera de la Reina",
            "Tacoronte",
            "Tavernes de la Valldigna",
            "Sueca",
            "Silla",
            "Sevilla",
            "San Vicent del Raspeig",
            "Santomera",
            "Santa Pola",
            "Santa Lucía",
            "Santafé",
            "Santa Eulària des Riu",
            "Santa Cruz de Tenerife",
            "Santa Cruz de la Palma",
            "Santa Brígida",
            "San Roque",
            "San Pedro del Pinatar",
            "San Pedro de Alcántara",
            "San Miguel De Abona",
            "Sanlúcar de Barrameda",
            "San Juan de Aznalfarache",
            "San Juan de Alicante",
            "San Javier",
            "San Isidro",
            "San Fernando",
            "La Laguna",
            "San Bartolomé de Tirajana",
            "San Bartolomé",
            "Sant Antoni de Portmany",
            "Sagunto",
            "Rota",
            "Roquetas de Mar",
            "Ronda",
            "Rojales",
            "Rincón de la Victoria",
            "Ribarroja",
            "Requena",
            "Realejo Alto",
            "Puçol",
            "Puerto Real",
            "Puertollano",
            "Puerto del Rosario",
            "Puerto de la Cruz",
            "Puente-Genil",
            "La Pobla de Vallbona",
            "Priego de Córdoba",
            "Pozoblanco",
            "Pollença",
            "Pilar de la Horadada",
            "Picassent",
            "Paterna",
            "Palma",
            "Palma del Río",
            "Pájara",
            "Paiporta",
            "Osuna",
            "Orihuela",
            "Ontinyent",
            "Onda",
            "Oliva",
            "Novelda",
            "Níjar",
            "Nerja",
            "Navalmoral de la Mata",
            "Murcia",
            "Mula",
            "Muchamiel",
            "Motril",
            "Morón de la Frontera",
            "Montilla",
            "Montijo",
            "Moncada",
            "Molina de Segura",
            "Moguer",
            "Mogán",
            "Mislata",
            "Mijas",
            "Mérida",
            "Melilla",
            "Mazarrón",
            "Maspalomas",
            "Massamagrell",
            "Martos",
            "Marratxí",
            "Marchena",
            "Marbella",
            "Maracena",
            "Manzanares",
            "Manises",
            "Manacor",
            "Málaga",
            "Mairena del Aljarafe",
            "Mairena del Alcor",
            "Maó",
            "Lucena",
            "Los Palacios y Villafranca",
            "Los Llanos de Aridane",
            "Los Barrios",
            "Los Alcázares",
            "Lorca",
            "Lora del Río",
            "Loja",
            "Llucmajor",
            "Llíria",
            "Linares",
            "Lepe",
            "Lebrija",
            "La Unión",
            "Las Torres de Cotillas",
            "Las Palmas de Gran Canaria",
            "La Solana",
            "Las Cabezas de San Juan",
            "La Roda",
            "La Rinconada",
            "La Orotava",
            "La Oliva",
            "la Nucia",
            "La Línea de la Concepción",
            "L'Eliana",
            "La Carolina",
            "Jumilla",
            "Jerez de la Frontera",
            "Javea",
            "Xàtiva",
            "Jaén",
            "Isla Cristina",
            "Ingenio",
            "Inca",
            "Icod de los Vinos",
            "Ibiza",
            "Ibi",
            "Huércal-Overa",
            "Huelva",
            "Hellín",
            "Güimar",
            "Guía de Isora",
            "Guardamar del Segura",
            "Guadix",
            "Granadilla de Abona",
            "Granada",
            "Gandia",
            "Gáldar",
            "Fuengirola",
            "Felanitx",
            "Estepona",
            "El Viso del Alcor",
            "El Puerto de Santa María",
            "El Ejido",
            "Elda",
            "Elche",
            "El Arahal",
            "Écija",
            "Dos Hermanas",
            "Don Benito",
            "Denia",
            "Daimiel",
            "Cullera",
            "Quart de Poblet",
            "Crevillente",
            "Coria del Río",
            "Córdoba",
            "Conil de la Frontera",
            "Coín",
            "Ciudad Real",
            "Cieza",
            "Xirivella",
            "Chipiona",
            "Chiclana de la Frontera",
            "Cehegín",
            "Catarroja",
            "Castilleja de la Cuesta",
            "Castelló de la Plana",
            "Cartaya",
            "Cártama",
            "Cartagena",
            "Carmona",
            "Carlet",
            "Carcaixent",
            "Caravaca",
            "Candelaria",
            "Campo de Criptana",
            "Campiña",
            "el Campello",
            "Camas",
            "Calvià",
            "Calp",
            "Callosa de Segura",
            "Cadiz",
            "Cáceres",
            "Cabra",
            "Burriana",
            "Burjassot",
            "Bormujos",
            "Bétera",
            "Berja",
            "Benidorm",
            "Benetússer",
            "Benalmádena",
            "Baza",
            "Barbate de Franco",
            "Bailén",
            "Baeza",
            "Baena",
            "Badajoz",
            "Ayamonte",
            "Atarfe",
            "Atamaría",
            "Aspe",
            "Arucas",
            "Arrecife",
            "Arona",
            "Armilla",
            "Arcos de la Frontera",
            "Archena",
            "Antequera",
            "Andújar",
            "Altea",
            "Almuñécar",
            "Almoradí",
            "Almonte",
            "Almería",
            "Almendralejo",
            "Almassora",
            "Almansa",
            "Aljaraque",
            "Alicante",
            "Alhaurín el Grande",
            "Alhaurín de la Torre",
            "Alhama de Murcia",
            "Algemesí",
            "Algeciras",
            "Alfafar",
            "Aldaia",
            "Alcúdia",
            "Alcoy",
            "Alzira",
            "Alcázar de San Juan",
            "Alcantarilla",
            "Alcalá la Real",
            "Alcalá de Guadaira",
            "Alboraya",
            "Albolote",
            "Albal",
            "Albacete",
            "Alaquàs",
            "Agüimes",
            "Águilas",
            "Adra",
            "Adeje",
            "Groa de Murviedro",
            "Zarautz",
            "Zaragoza",
            "Zamora",
            "Viveiro",
            "Gasteiz / Vitoria",
            "Vinaròs",
            "Villaviciosa de Odón",
            "Villaverde",
            "Villaquilambre",
            "Vilanova i la Geltrú",
            "Villanueva del Pardillo",
            "Villanueva de la Cañada",
            "Vilalba",
            "Vilagarcía de Arousa",
            "Vilafranca del Penedès",
            "Vila-seca",
            "Vilaseca",
            "Viladecans",
            "Vigo",
            "Vic",
            "Vicálvaro",
            "El Vendrell",
            "Valls",
            "Valladolid",
            "Valdemoro",
            "Rivas-Vaciamadrid",
            "Utebo",
            "Tui",
            "Tudela",
            "Tortosa",
            "Torrelodones",
            "Torrelavega",
            "Torrejón de Ardoz",
            "Torredembarra",
            "Tordera",
            "Tolosa",
            "Tetuán de las Victorias",
            "Teruel",
            "Teo",
            "Tàrrega",
            "Terrassa",
            "Tarragona",
            "Tarancón",
            "Soria",
            "Sitges",
            "Sestao",
            "Seseña",
            "Segovia",
            "Cerdanyola del Vallès",
            "Sant Vicenç dels Horts",
            "Barakaldo",
            "Santurtzi",
            "Sant Just Desvern",
            "Santiago de Compostela",
            "Santa Perpètua de Mogoda",
            "Santander",
            "Barberà del Vallès",
            "Santa Coloma de Gramenet",
            "San Sebastián de los Reyes",
            "Donostia / San Sebastián",
            "Sant Quirze del Vallès",
            "Sant Pere de Ribes",
            "San Martín de la Vega",
            "San Lorenzo de El Escorial",
            "Vilassar de Mar",
            "Sant Joan Despí",
            "Sanxenxo",
            "San Fernando de Henares",
            "Sant Feliu de Llobregat",
            "Sant Feliu de Guíxols",
            "Sant Cugat del Vallès",
            "Sant Celoni",
            "Sant Carles de la Ràpita",
            "Sant Boi de Llobregat",
            "Sant Andreu de Palomar",
            "San Andrés del Rabanedo",
            "Sant Andreu de la Barca",
            "Sant Adrià de Besòs",
            "Sama",
            "Salt",
            "Salou",
            "Salamanca",
            "Sabadell",
            "Rubí",
            "Roses",
            "Ripollet",
            "Ribeira",
            "Reus",
            "Errenteria",
            "Redondela",
            "Puente de Vallecas",
            "Ponteareas",
            "Premià de Mar",
            "Pozuelo de Alarcón",
            "Poio",
            "Portugalete",
            "Porriño",
            "Pontevedra",
            "Ponferrada",
            "Plasencia",
            "Pinto",
            "Pineda de Mar",
            "Parla",
            "Parets del Vallès",
            "Pamplona",
            "Palencia",
            "Palamós",
            "Palafrugell",
            "Oviedo",
            "Oria",
            "Ourense",
            "Olot",
            "Olesa de Montserrat",
            "Oleiros",
            "Nigrán",
            "Navalcarnero",
            "Narón",
            "Mungia",
            "Móstoles",
            "Moratalaz",
            "Monzón",
            "Montornès del Vallès",
            "Monforte de Lemos",
            "Arrasate / Mondragón",
            "Montcada i Reixac",
            "Mollet del Vallès",
            "Molins de Rei",
            "Moaña",
            "Miranda de Ebro",
            "Mieres",
            "Mejorada del Campo",
            "Medina del Campo",
            "Mataró",
            "El Masnou",
            "Martorell",
            "Marín",
            "Manresa",
            "Manlleu",
            "Malgrat de Mar",
            "Majadahonda",
            "Madrid",
            "Lugo",
            "Logroño",
            "Lloret de Mar",
            "Laudio / Llodio",
            "Lleida",
            "León",
            "Leioa",
            "Leganés",
            "Las Rozas de Madrid",
            "Lasarte",
            "La Pineda",
            "Lalín",
            "Laguna de Duero",
            "A Estrada",
            "A Coruña",
            "Irun",
            "Illescas",
            "Igualada",
            "Humanes de Madrid",
            "Huesca",
            "L'Hospitalet de Llobregat",
            "Hortaleza",
            "Hernani",
            "Gernika-Lumo",
            "Getxo",
            "Guadalajara",
            "Granollers",
            "Gràcia",
            "Gijón",
            "Getafe",
            "Girona",
            "Gavà",
            "Galdakao",
            "Galapagar",
            "Hondarribia",
            "Fuenlabrada",
            "Figueras",
            "Figueres",
            "Esplugues de Llobregat",
            "Esparreguera",
            "Ermua",
            "Erandio",
            "El Prat de Llobregat",
            "Ferrol",
            "El Astillero",
            "Ejea de los Caballeros",
            "Eibar",
            "Durango",
            "Culleredo",
            "Cuenca",
            "Coslada",
            "Cornellà de Llobregat",
            "Colmenar Viejo",
            "Collado-Villalba",
            "Ciudad Lineal",
            "Ciutadella",
            "Ciempozuelos",
            "Chamartín",
            "Castro-Urdiales",
            "Castelldefels",
            "Castellar del Vallès",
            "Cardedeu",
            "Carballo",
            "Canovelles",
            "Cangas do Morrazo",
            "Cambrils",
            "Cambre",
            "Camargo",
            "Calella",
            "Caldes de Montbui",
            "Calatayud",
            "Calahorra",
            "Calafell",
            "Burlata",
            "Burgos",
            "Boiro",
            "Boadilla del Monte",
            "Blanes",
            "Bilbao",
            "Bermeo",
            "Berga",
            "Benicàssim",
            "Benicarló",
            "Benavente",
            "Béjar",
            "Barcelona",
            "Barbastro",
            "Barañáin",
            "Barajas de Madrid",
            "Banyoles",
            "Balaguer",
            "Badalona",
            "Azuqueca de Henares",
            "Avilés",
            "Ávila",
            "Arteixo",
            "Arganda",
            "Aranjuez",
            "Aranda de Duero",
            "Amposta",
            "Amorebieta",
            "Amés",
            "Algorta",
            "Algete",
            "Alcorcón",
            "Alcobendas",
            "Alcañiz",
            "Alcalá de Henares",
            "Nou Barris",
            "Pinar de Chamartín",
            "Playa del Ingles",
            "Puerto del Carmen",
            "Ceuta",
            "Moncloa-Aravaca",
            "Eixample",
            "les Corts",
            "Sarrià-Sant Gervasi",
            "Horta-Guinardó",
            "Sants-Montjuïc",
            "Sant Martí",
            "Ciutat Vella",
            "Arganzuela",
            "San Blas",
            "Latina",
            "Usera",
            "Salamanca",
            "Chamberí",
            "Carabanchel",
            "City Center",
            "Retiro",
            "l'Alfàs del Pi",
            "Las Gabias",
            "Delicias",
            "Almozara",
            "Montecanal",
            "Oliver-Valdefierro",
            "Santutxu",
            "Los Realejos",
            "Pasaia",
            "Basauri",
            "Llefià",
            "Corvera de Asturias",
            "Tres Cantos",
            "Iturrama",
            "Ermitagaña",
            "Primer Ensanche",
            "Segundo Ensanche",
            "Fuencarral-El Pardo",
            "Villa de Vallecas",
            "Natahoyo"
        ],
        "Ethiopia" => [
            "Ziway",
            "Yirga ‘Alem",
            "Yabēlo",
            "Werota",
            "Wenjī",
            "Tippi",
            "Shashemenē",
            "Shambu",
            "Shakīso",
            "Sebeta",
            "Robīt",
            "Nejo",
            "Nazrēt",
            "Mojo",
            "Metu",
            "Metahāra",
            "Mendī",
            "Mekele",
            "Maych’ew",
            "Korem",
            "K’olīto",
            "Kibre Mengist",
            "Kemisē",
            "Kombolcha",
            "Jinka",
            "Jīma",
            "Jijiga",
            "Inda Silasē",
            "Harar",
            "Hāgere Hiywet",
            "Gondar",
            "Goba",
            "Waliso",
            "Ginir",
            "Gimbi",
            "Genet",
            "Gelemso",
            "Gebre Guracha",
            "Gambēla",
            "Finote Selam",
            "Fichē",
            "Felege Neway",
            "Dubti",
            "Dodola",
            "Dire Dawa",
            "Dīla",
            "Desē",
            "Dembī Dolo",
            "Bishoftu",
            "Debre Tabor",
            "Debre Mark’os",
            "Debre Birhan",
            "Debark’",
            "Butajīra",
            "Burē",
            "Bonga",
            "Bodītī",
            "Bichena",
            "Bedēsa",
            "Bedelē",
            "Batī",
            "Bako",
            "Bahir Dar",
            "Hawassa",
            "Āsosa",
            "Āsbe Teferī",
            "Asaita",
            "Āsasa",
            "Āreka",
            "Ārba Minch’",
            "Axum",
            "Hagere Maryam",
            "Āgaro",
            "Ādīs Zemen",
            "Addis Ababa",
            "Ādīgrat",
            "Addiet Canna",
            "Abomsa"
        ],
        "Finland" => [
            "Ylöjärvi",
            "Vihti",
            "Varkaus",
            "Vantaa",
            "Valkeakoski",
            "Vaasa",
            "Uusikaupunki",
            "Tuusula",
            "Turku",
            "Tornio",
            "Tampere",
            "Siilinjärvi",
            "Sibbo",
            "Seinäjoki",
            "Savonlinna",
            "Salo",
            "Rovaniemi",
            "Riihimäki",
            "Rauma",
            "Raisio",
            "Raahe",
            "Pori",
            "Pirkkala",
            "Oulu",
            "Nurmijärvi",
            "Nokia",
            "Mikkeli",
            "Mäntsälä",
            "Lovisa",
            "Lohja",
            "Lieto",
            "Lempäälä",
            "Laukaa",
            "Lappeenranta",
            "Lahti",
            "Kirkkonummi",
            "Kuusamo",
            "Kuopio",
            "Kouvola",
            "Kotka",
            "Korsholm",
            "Kokkola",
            "Kerava",
            "Kemi",
            "Karhula",
            "Kangasala",
            "Kajaani",
            "Kaarina",
            "Jyväskylä",
            "Joensuu",
            "Järvenpää",
            "Janakkala",
            "Jämsä",
            "Jakobstad",
            "Imatra",
            "Iisalmi",
            "Hyvinge",
            "Hollola",
            "Helsinki",
            "Heinola",
            "Haukipudas",
            "Hamina",
            "Hämeenlinna",
            "Forssa",
            "Espoo",
            "Porvoo",
            "Anjala",
            "Länsi-Turunmaa"
        ],
        "Fiji" => [
            "Suva",
            "Nadi",
            "Lautoka",
            "Labasa"
        ],
        "Falkland Islands" => [
            "Stanley"
        ],
        "Micronesia" => [
            "Palikir - National Government Center"
        ],
        "Faroe Islands" => [
            "Tórshavn"
        ],
        "France" => [
            "Yerres",
            "Wittenheim",
            "Wattrelos",
            "Wasquehal",
            "Voiron",
            "Vitry-sur-Seine",
            "Vitry-le-François",
            "Vitrolles",
            "Vitré",
            "Viry-Châtillon",
            "Viroflay",
            "Vincennes",
            "Villiers-sur-Marne",
            "Villiers-le-Bel",
            "Villeurbanne",
            "Villers-lès-Nancy",
            "Villepinte",
            "Villeparisis",
            "Villeneuve-sur-Lot",
            "Villeneuve-Saint-Georges",
            "Villeneuve-le-Roi",
            "Villeneuve-la-Garenne",
            "Villenave-d’Ornon",
            "Villemomble",
            "Villejuif",
            "Villefranche-sur-Saône",
            "Villefontaine",
            "Vigneux-sur-Seine",
            "Vierzon",
            "Vienne",
            "Vichy",
            "Vesoul",
            "Vertou",
            "Versailles",
            "Verrières-le-Buisson",
            "Vernon",
            "Verneuil-sur-Seine",
            "Verdun",
            "Vénissieux",
            "Vendôme",
            "Vence",
            "Vélizy-Villacoublay",
            "Vauréal",
            "Vaulx-en-Velin",
            "Vanves",
            "Vannes",
            "Vandœuvre-lès-Nancy",
            "Vallauris",
            "Valenciennes",
            "Valence",
            "Tulle",
            "Troyes",
            "Tremblay-en-France",
            "Trappes",
            "Tours",
            "Tournefeuille",
            "Tourlaville",
            "Tourcoing",
            "Toulouse",
            "Toulon",
            "Toul",
            "Torcy",
            "Thonon-les-Bains",
            "Thionville",
            "Thiais",
            "Tergnier",
            "Taverny",
            "Tassin-la-Demi-Lune",
            "Tarbes",
            "Talence",
            "Suresnes",
            "Sucy-en-Brie",
            "Strasbourg",
            "Stains",
            "Sotteville-lès-Rouen",
            "Sorgues",
            "Soisy-sous-Montmorency",
            "Soissons",
            "Six-Fours-les-Plages",
            "Sin-le-Noble",
            "Seynod",
            "Sèvres",
            "Sevran",
            "Sète",
            "Sens",
            "Senlis",
            "Sélestat",
            "Sedan",
            "Schiltigheim",
            "Sceaux",
            "Savigny-sur-Orge",
            "Savigny-le-Temple",
            "Saumur",
            "Sartrouville",
            "Sarreguemines",
            "Sarcelles",
            "Saran",
            "Sannois",
            "Sanary-sur-Mer",
            "Salon-de-Provence",
            "Sallanches",
            "Saint-Sébastien-sur-Loire",
            "Saint-Raphaël",
            "Saint-Quentin",
            "Saint-Priest",
            "Saint-Pol-sur-Mer",
            "Saint-Pierre-des-Corps",
            "Saint-Ouen-l’Aumône",
            "Saint-Ouen",
            "Saint-Omer",
            "Saint-Nazaire",
            "Saint-Michel-sur-Orge",
            "Saint-Médard-en-Jalles",
            "Saint-Maximin-la-Sainte-Baume",
            "Saint-Maur-des-Fossés",
            "Saint-Martin-d’Hères",
            "Saint-Mandé",
            "Saint-Malo",
            "Saint-Louis",
            "Saint-Lô",
            "Saint-Leu-la-Forêt",
            "Saint-Leu",
            "Saint-Laurent-du-Var",
            "Saint-Jean-de-la-Ruelle",
            "Saint-Jean-de-Braye",
            "Saint-Herblain",
            "Saint-Gratien",
            "Saint-Germain-en-Laye",
            "Saint-Genis-Laval",
            "Saint-Fons",
            "Saint-Étienne-du-Rouvray",
            "Saint-Étienne",
            "Saintes",
            "Sainte-Geneviève-des-Bois",
            "Sainte-Foy-lès-Lyon",
            "Saint-Égrève",
            "Saint-Dizier",
            "Saint-Dié-des-Vosges",
            "Saint-Denis",
            "Saint-Cyr-sur-Loire",
            "Saint-Cyr-l’École",
            "Saint-Cloud",
            "Saint-Chamond",
            "Saint-Brieuc",
            "Saint-Avold",
            "Saint-Avertin",
            "Saint-Amand-les-Eaux",
            "Rueil-Malmaison",
            "Royan",
            "Rouen",
            "Roubaix",
            "Rosny-sous-Bois",
            "Ronchin",
            "Romorantin-Lanthenay",
            "Romans-sur-Isère",
            "Romainville",
            "Roissy-en-Brie",
            "Rodez",
            "Rochefort",
            "Roanne",
            "Ris-Orangis",
            "Riom",
            "Rillieux-la-Pape",
            "Rezé",
            "Rennes",
            "Reims",
            "Rambouillet",
            "Quimper",
            "Puteaux",
            "Port-de-Bouc",
            "Pontoise",
            "Pontivy",
            "Pontarlier",
            "Pont-à-Mousson",
            "Poitiers",
            "Poissy",
            "Ploemeur",
            "Plaisir",
            "Plaisance-du-Touch",
            "Pierrefitte-sur-Seine",
            "Pessac",
            "Pertuis",
            "Perpignan",
            "Périgueux",
            "Pau",
            "Paris",
            "Pantin",
            "Pamiers",
            "Palaiseau",
            "Ozoir-la-Ferrière",
            "Oyonnax",
            "Outreau",
            "Oullins",
            "Osny",
            "Orvault",
            "Orsay",
            "Orly",
            "Orléans",
            "Orange",
            "Olivet",
            "Octeville",
            "Noyon",
            "Noisy-le-Sec",
            "Noisy-le-Grand",
            "Noisiel",
            "Nogent-sur-Oise",
            "Nogent-sur-Marne",
            "Niort",
            "Nîmes",
            "Nice",
            "Nevers",
            "Neuilly-sur-Seine",
            "Neuilly-sur-Marne",
            "Neuilly-Plaisance",
            "Narbonne",
            "Nantes",
            "Nanterre",
            "Nancy",
            "Muret",
            "Mulhouse",
            "Moulins",
            "Mougins",
            "Morsang-sur-Orge",
            "Morlaix",
            "Mont-Saint-Aignan",
            "Montrouge",
            "Montreuil",
            "Montpellier",
            "Montmorency",
            "Montluçon",
            "Montivilliers",
            "Montigny-lès-Metz",
            "Montigny-lès-Cormeilles",
            "Montigny-le-Bretonneux",
            "Montgeron",
            "Montfermeil",
            "Montesson",
            "Montereau-Fault-Yonne",
            "Montélimar",
            "Mont-de-Marsan",
            "Montceau-les-Mines",
            "Montbrison",
            "Montbéliard",
            "Montauban",
            "Montargis",
            "Mons-en-Barœul",
            "Moissy-Cramayel",
            "Mitry-Mory",
            "Miramas",
            "Millau",
            "Meyzieu",
            "Meylan",
            "Meudon",
            "Metz",
            "Mérignac",
            "Menton",
            "Melun",
            "Meaux",
            "Mayenne",
            "Maurepas",
            "Mauguio",
            "Maubeuge",
            "Massy",
            "Martigues",
            "Marseille",
            "Marmande",
            "Marly-le-Roi",
            "Marignane",
            "Marcq-en-Barœul",
            "Mantes-la-Ville",
            "Mantes-la-Jolie",
            "Manosque",
            "Mandelieu-la-Napoule",
            "Malakoff",
            "Maisons-Laffitte",
            "Maisons-Alfort",
            "Mâcon",
            "Lyon",
            "Lunéville",
            "Lunel",
            "Lucé",
            "Louviers",
            "Lourdes",
            "Lormont",
            "Lorient",
            "Loos",
            "Lons-le-Saunier",
            "Longjumeau",
            "Lomme",
            "Lognes",
            "Livry-Gargan",
            "L’Isle-sur-la-Sorgue",
            "Lisieux",
            "Lingolsheim",
            "Limoges",
            "Limeil-Brévannes",
            "Limay",
            "Lille",
            "Liévin",
            "Libourne",
            "L'Haÿ-les-Roses",
            "Le Vésinet",
            "Levallois-Perret",
            "Les Sables-d'Olonne",
            "Les Pennes-Mirabeau",
            "Les Pavillons-sous-Bois",
            "Les Mureaux",
            "Les Lilas",
            "Les Herbiers",
            "Les Clayes-sous-Bois",
            "Le Puy-en-Velay",
            "Le Pré-Saint-Gervais",
            "Le Pontet",
            "Le Plessis-Trévise",
            "Le Plessis-Robinson",
            "Le Petit-Quevilly",
            "Le Perreux-sur-Marne",
            "Le Pecq",
            "Lens",
            "Le Mée-sur-Seine",
            "Le Mans",
            "Le Kremlin-Bicêtre",
            "Le Havre",
            "Le Grand-Quevilly",
            "Le Creusot",
            "Le Chesnay",
            "Le Cannet",
            "Le Bouscat",
            "Le Blanc-Mesnil",
            "Laxou",
            "La Valette-du-Var",
            "Laval",
            "Lattes",
            "La Teste-de-Buch",
            "La Seyne-sur-Mer",
            "La Roche-sur-Yon",
            "La Rochelle",
            "Laon",
            "Lannion",
            "Lanester",
            "Landerneau",
            "Lambersart",
            "La Madeleine",
            "Lagny-sur-Marne",
            "La Garenne-Colombes",
            "La Garde",
            "La Flèche",
            "La Crau",
            "La Courneuve",
            "La Ciotat",
            "La Chapelle-sur-Erdre",
            "La Celle-Saint-Cloud",
            "Jouy-le-Moutier",
            "Joué-lés-Tours",
            "Joinville-le-Pont",
            "Ivry-sur-Seine",
            "Istres",
            "Issy-les-Moulineaux",
            "Issoire",
            "Illzach",
            "Illkirch-Graffenstaden",
            "Hyères",
            "Houilles",
            "Hérouville-Saint-Clair",
            "Herblay",
            "Hénin-Beaumont",
            "Hem",
            "Hazebrouck",
            "Hayange",
            "Hautmont",
            "Yutz",
            "Haubourdin",
            "Halluin",
            "Haguenau",
            "Guyancourt",
            "Gujan-Mestras",
            "Guéret",
            "Guérande",
            "Grigny",
            "Grenoble",
            "Grasse",
            "Grande-Synthe",
            "Gradignan",
            "Goussainville",
            "Gonesse",
            "Givors",
            "Gif-sur-Yvette",
            "Gien",
            "Gentilly",
            "Gennevilliers",
            "Garges-lès-Gonesse",
            "Gardanne",
            "Garches",
            "Gap",
            "Gagny",
            "Frontignan",
            "Fresnes",
            "Fréjus",
            "Franconville",
            "Fougères",
            "Fos-sur-Mer",
            "Forbach",
            "Fontenay-sous-Bois",
            "Fontenay-le-Comte",
            "Fontenay-aux-Roses",
            "Fontainebleau",
            "Fontaine",
            "Floirac",
            "Fleury-les-Aubrais",
            "Flers",
            "Firminy",
            "Fécamp",
            "Faches-Thumesnil",
            "Eysines",
            "Évry",
            "Évreux",
            "Étampes",
            "La Baule-Escoublac",
            "Ermont",
            "Éragny",
            "Équeurdreville-Hainneville",
            "Épinay-sur-Seine",
            "Épinal",
            "Épernay",
            "Elbeuf",
            "Élancourt",
            "Écully",
            "Échirolles",
            "Eaubonne",
            "Dunkerque",
            "Dreux",
            "Draveil",
            "Drancy",
            "Draguignan",
            "Douarnenez",
            "Douai",
            "Domont",
            "Dole",
            "Dijon",
            "Digne-les-Bains",
            "Dieppe",
            "Deuil-la-Barre",
            "Denain",
            "Décines-Charpieu",
            "Dax",
            "Dammarie-les-Lys",
            "Cugnaux",
            "Croix",
            "Créteil",
            "Crépy-en-Valois",
            "Creil",
            "Cran-Gevrier",
            "Cournon-d’Auvergne",
            "Courbevoie",
            "Coulommiers",
            "Couëron",
            "Coudekerque-Branche",
            "Cormeilles-en-Parisis",
            "Corbeil-Essonnes",
            "Conflans-Sainte-Honorine",
            "Concarneau",
            "Compiègne",
            "Combs-la-Ville",
            "Pontault-Combault",
            "Colomiers",
            "Colombes",
            "Colmar",
            "Cognac",
            "Cluses",
            "Clichy-sous-Bois",
            "Clichy",
            "Clermont-Ferrand",
            "Clamart",
            "Cholet",
            "Choisy-le-Roi",
            "Chilly-Mazarin",
            "Chevilly-Larue",
            "Cherbourg-Octeville",
            "Chenôve",
            "Chennevières-sur-Marne",
            "Chelles",
            "Chaville",
            "Chaumont",
            "Chatou",
            "Châtillon",
            "Châtenay-Malabry",
            "Châtellerault",
            "Château-Thierry",
            "Châteauroux",
            "Châteaudun",
            "Chartres",
            "Charleville-Mézières",
            "Charenton-le-Pont",
            "Champs-sur-Marne",
            "Champigny-sur-Marne",
            "Chambéry",
            "Chamalières",
            "Chalon-sur-Saône",
            "Châlons-en-Champagne",
            "Challans",
            "Cestas",
            "Cesson-Sévigné",
            "Cergy",
            "Cenon",
            "Cavaillon",
            "Castres",
            "Castelnau-le-Lez",
            "Carvin",
            "Carrières-sous-Poissy",
            "Carquefou",
            "Carpentras",
            "Carcassonne",
            "Canteleu",
            "Cannes",
            "Cambrai",
            "Caluire-et-Cuire",
            "Calais",
            "Cahors",
            "Cagnes-sur-Mer",
            "Caen",
            "Cachan",
            "Bry-sur-Marne",
            "Brunoy",
            "Bruay-la-Buissière",
            "Bron",
            "Brive-la-Gaillarde",
            "Brignoles",
            "Brie-Comte-Robert",
            "Brétigny-sur-Orge",
            "Brest",
            "Bressuire",
            "Bourgoin",
            "Bourg-lès-Valence",
            "Bourg-la-Reine",
            "Bourges",
            "Bourg-en-Bresse",
            "Boulogne-sur-Mer",
            "Boulogne-Billancourt",
            "Bouguenais",
            "Bordeaux",
            "Bonneuil-sur-Marne",
            "Bondy",
            "Boissy-Saint-Léger",
            "Bois-Colombes",
            "Bobigny",
            "Blois",
            "Blanquefort",
            "Blagnac",
            "Bischheim",
            "Biarritz",
            "Bezons",
            "Béziers",
            "Béthune",
            "Besançon",
            "Bergerac",
            "Berck",
            "Berck-Plage",
            "Belfort",
            "Bègles",
            "Beauvais",
            "Beaune",
            "Bayonne",
            "Bayeux",
            "Bastia",
            "Bar-le-Duc",
            "Balma",
            "Bagnols-sur-Cèze",
            "Bagnolet",
            "Bagneux",
            "Avon",
            "Avion",
            "Avignon",
            "Auxerre",
            "Autun",
            "Aurillac",
            "Aulnay-sous-Bois",
            "Audincourt",
            "Auch",
            "Aubervilliers",
            "Aubagne",
            "Athis-Mons",
            "Asnières-sur-Seine",
            "Arras",
            "Armentières",
            "Arles",
            "Argenteuil",
            "Argentan",
            "Arcueil",
            "Antony",
            "Antibes",
            "Annonay",
            "Annemasse",
            "Annecy-le-Vieux",
            "Annecy",
            "Angoulême",
            "Anglet",
            "Angers",
            "Amiens",
            "Allauch",
            "Alfortville",
            "Alès",
            "Alençon",
            "Albi",
            "Albertville",
            "Ajaccio",
            "Aix-les-Bains",
            "Aix-en-Provence",
            "Agen",
            "Agde",
            "Achères",
            "Abbeville",
            "Villeneuve-d'Ascq",
            "Les Ulis",
            "Bourgoin-Jallieu",
            "Marseille 01",
            "Marseille 02",
            "Marseille 03",
            "Marseille 04",
            "Marseille 05",
            "Marseille 06",
            "Marseille 07",
            "Marseille 08",
            "Marseille 10",
            "Marseille 09",
            "Marseille 11",
            "Marseille 12",
            "Marseille 13",
            "Marseille 14",
            "Marseille 15",
            "Marseille 16",
            "La Defense",
            "Saint-Quentin-en-Yvelines",
            "Cergy-Pontoise"
        ],
        "Gabon" => [
            "Tchibanga",
            "Port-Gentil",
            "Oyem",
            "Mouila",
            "Moanda",
            "Libreville",
            "Lambaréné",
            "Koulamoutou",
            "Franceville"
        ],
        "United Kingdom" => [
            "York",
            "Yeovil",
            "Yeadon",
            "Yate",
            "Wrexham",
            "Worthing",
            "Worksop",
            "Workington",
            "Worcester",
            "Woodford Green",
            "Wombwell",
            "Wolverhampton",
            "Wokingham",
            "Woking",
            "Witney",
            "Witham",
            "Wishaw",
            "Wisbech",
            "Winsford",
            "Windsor",
            "Winchester",
            "Wilmslow",
            "Willenhall",
            "Wigston Magna",
            "Wigan",
            "Widnes",
            "Wickford",
            "Whitstable",
            "Whitley Bay",
            "Whitehaven",
            "Whitefield",
            "Whickham",
            "Weymouth",
            "Weybridge",
            "Weston-super-Mare",
            "West Molesey",
            "Westhoughton",
            "West Bromwich",
            "West Bridgford",
            "Welwyn Garden City",
            "Wellington",
            "Wellingborough",
            "Welling",
            "Wednesfield",
            "Wednesbury",
            "Wath upon Dearne",
            "Watford",
            "Waterlooville",
            "Washington",
            "Warwick",
            "Warrington",
            "Warminster",
            "Ware",
            "Walton-on-Thames",
            "Waltham Abbey",
            "Walsall",
            "Wallsend",
            "Wallasey",
            "Walkden",
            "Wakefield",
            "Urmston",
            "Uckfield",
            "Stowmarket",
            "Stourport-on-Severn",
            "Stourbridge",
            "Stoke-on-Trent",
            "Stockton-on-Tees",
            "Stockport",
            "Stirling",
            "Stevenage",
            "Staveley",
            "Stamford",
            "Stalybridge",
            "Staines",
            "Stafford",
            "Spennymoor",
            "Spalding",
            "South Shields",
            "Southsea",
            "Southport",
            "South Ockendon",
            "Southend-on-Sea",
            "South Elmsall",
            "South Benfleet",
            "Southampton",
            "Southall",
            "Solihull",
            "Slough",
            "Sleaford",
            "Skelmersdale",
            "Skegness",
            "Sittingbourne",
            "Shrewsbury",
            "Shoreham-by-Sea",
            "Shoreham",
            "Shipley",
            "Sheffield",
            "Sevenoaks",
            "Selby",
            "Seaham",
            "Seaford",
            "Scunthorpe",
            "Scarborough",
            "Sandown",
            "Sandbach",
            "Salisbury",
            "Salford",
            "Sale",
            "Saint Neots",
            "St Helens",
            "St Austell",
            "Saint Andrews",
            "St Albans",
            "Ryton",
            "Ryde",
            "Rutherglen",
            "Rushden",
            "Runcorn",
            "Ruislip",
            "Rugeley",
            "Rugby",
            "Royton",
            "Royal Tunbridge Wells",
            "Rottingdean",
            "Rotherham",
            "Romsey",
            "Rochford",
            "Rochester",
            "Rochdale",
            "Risca",
            "Ripon",
            "Ripley",
            "Rhyl",
            "Rhondda",
            "Renfrew",
            "Reigate",
            "Redhill",
            "Redditch",
            "Redcar",
            "Reading",
            "Rayleigh",
            "Rawtenstall",
            "Rawmarsh",
            "Ramsgate",
            "Ramsbottom",
            "Purley",
            "Pudsey",
            "Prestwick",
            "Prestwich",
            "Preston",
            "Prestatyn",
            "Prescot",
            "Poulton le Fylde",
            "Potters Bar",
            "Portsmouth",
            "Portslade",
            "Portishead",
            "Porthcawl",
            "Port Glasgow",
            "Portadown",
            "Poole",
            "Pontypridd",
            "Pontypool",
            "Pontefract",
            "Polmont",
            "Plymstock",
            "Plymouth",
            "Pitsea",
            "Pinner",
            "Peterlee",
            "Peterhead",
            "Peterborough",
            "Perth",
            "Penzance",
            "Penicuik",
            "Penarth",
            "Paisley",
            "Paignton",
            "Oxford",
            "Oswestry",
            "Ossett",
            "Orpington",
            "Ormskirk",
            "Omagh",
            "Oldham",
            "Oadby",
            "Nuneaton",
            "Nottingham",
            "Norwich",
            "Northwich",
            "North Shields",
            "Northolt",
            "Lancing",
            "Northampton",
            "Northallerton",
            "Newtownards",
            "Newtownabbey",
            "Newton Mearns",
            "Newton-le-Willows",
            "Newton Aycliffe",
            "Newton Abbot",
            "Newry",
            "Newquay",
            "Newport Pagnell",
            "Newport",
            "Newport",
            "New Milton",
            "Newmarket",
            "New Malden",
            "Newcastle upon Tyne",
            "Newcastle under Lyme",
            "Newbury",
            "Newburn",
            "Newark on Trent",
            "Nelson",
            "Neath",
            "Nailsea",
            "Musselburgh",
            "Motherwell",
            "Morley",
            "Moreton",
            "Morecambe",
            "Mitcham",
            "Mirfield",
            "Milton Keynes",
            "Middleton",
            "Middlesbrough",
            "Mexborough",
            "Merthyr Tydfil",
            "Melton Mowbray",
            "Marple",
            "Marlow",
            "Market Harborough",
            "Margate",
            "March",
            "Mansfield Woodhouse",
            "Mansfield",
            "Mangotsfield",
            "Manchester",
            "Maltby",
            "Maldon",
            "Maidstone",
            "Maidenhead",
            "Maghull",
            "Maesteg",
            "Macclesfield",
            "Luton",
            "Lowestoft",
            "Louth",
            "Loughborough",
            "Longfield",
            "Long Eaton",
            "Londonderry County Borough",
            "Derry",
            "City of London",
            "London",
            "Lofthouse",
            "Llanelli",
            "Llandudno",
            "Livingston",
            "Liverpool",
            "Littlehampton",
            "Litherland",
            "Lisburn",
            "Lincoln",
            "Lichfield",
            "Leyland",
            "Lewes",
            "Letchworth",
            "Leighton Buzzard",
            "Leigh",
            "Leicester",
            "Leek",
            "Leeds",
            "Leatherhead",
            "Royal Leamington Spa",
            "Larne",
            "Larkhall",
            "Lancaster",
            "Kirkintilloch",
            "Kirkcaldy",
            "Kirkby in Ashfield",
            "Kirkby",
            "Kingswood",
            "Kingswinford",
            "Hull",
            "King's Lynn",
            "Kilwinning",
            "Kilmarnock",
            "Kidsgrove",
            "Kidlington",
            "Kidderminster",
            "Keynsham",
            "Kettering",
            "Kenilworth",
            "Kendal",
            "Kempston",
            "Keighley",
            "Johnstone",
            "Jarrow",
            "Islington",
            "Isleworth",
            "Irvine",
            "Coity",
            "Cobham",
            "Coatbridge",
            "Coalville",
            "Clydebank",
            "Clydach",
            "Clitheroe",
            "Clevedon",
            "Cleethorpes",
            "Cleckheaton",
            "Clacton-on-Sea",
            "Cirencester",
            "Christchurch",
            "Chorley",
            "Chislehurst",
            "Chipping Sodbury",
            "Chippenham",
            "Chichester",
            "Chester-le-Street",
            "Chesterfield",
            "Chester",
            "Chessington",
            "Cheshunt",
            "Chesham",
            "Cheltenham",
            "Chelsea",
            "Chelmsford",
            "Cheadle Hulme",
            "Chatham",
            "Chapletown",
            "Chalfont Saint Peter",
            "Caterham",
            "Castlereagh",
            "Castleford",
            "Carshalton",
            "Carrickfergus",
            "Carmarthen",
            "Carlisle",
            "Cardiff",
            "Canterbury",
            "Cannock",
            "Cambridge",
            "Camborne",
            "Camberley",
            "Caerphilly",
            "Buxton",
            "Bushey",
            "Bury St Edmunds",
            "Bury",
            "Burton upon Trent",
            "Burntwood",
            "Burnley",
            "Burnham-on-Sea",
            "Burgess Hill",
            "Buckley",
            "Buckhaven",
            "Brymbo",
            "Brownhills",
            "Bromsgrove",
            "Broadstairs",
            "Brixham",
            "Briton Ferry",
            "Bristol",
            "Brighton",
            "Brighouse",
            "Brierley Hill",
            "Bridlington",
            "Bridgwater",
            "Bridgend",
            "Brentwood",
            "Bredbury",
            "Bramhall",
            "Braintree",
            "Bradford",
            "Bracknell",
            "Bournemouth",
            "Boston",
            "Borehamwood",
            "Bootle",
            "Bolton",
            "Bognor Regis",
            "Blyth",
            "Bloxwich",
            "Bletchley",
            "Blackpool",
            "Blackburn",
            "Bishopstoke",
            "Bishops Stortford",
            "Bishopbriggs",
            "Bishop Auckland",
            "Birmingham",
            "Birkenhead",
            "Bingley",
            "Billingham",
            "Billericay",
            "Biggleswade",
            "Bideford",
            "Biddulph",
            "Bicester",
            "Bexley",
            "Bexhill-on-Sea",
            "Beverley",
            "Berwick-Upon-Tweed",
            "Berkhamsted",
            "Bentley",
            "Belper",
            "Bellshill",
            "Belfast",
            "Bedworth",
            "Bedlington",
            "Bedford",
            "Beckenham",
            "Bebington",
            "Bearsden",
            "Batley",
            "Bathgate",
            "Bath",
            "Basingstoke",
            "Basildon",
            "Barry",
            "Barrow in Furness",
            "Barrhead",
            "Barnstaple",
            "Barnsley",
            "Barnet",
            "Barking",
            "Banstead",
            "Bangor",
            "Bangor",
            "Banbury",
            "Banbridge",
            "Ballymena",
            "Baildon",
            "Ayr",
            "Aylesbury",
            "Atherton",
            "Ashton-under-Lyne",
            "Ashton in Makerfield",
            "Ashford",
            "Ascot",
            "Arnold",
            "Arbroath",
            "Antrim",
            "Andover",
            "Amersham",
            "Altrincham",
            "Alton",
            "Alloa",
            "Alfreton",
            "Aldridge",
            "Aldershot",
            "Airdrie",
            "Acton",
            "Acocks Green",
            "Accrington",
            "Abingdon",
            "Aberystwyth",
            "Abergele",
            "Aberdeen",
            "Aberdare",
            "Crosby",
            "Blackwood",
            "Neston",
            "Camden Town",
            "Telford",
            "Craigavon",
            "Bayswater",
            "Yateley",
            "Bowthorpe",
            "Hedge End",
            "Erskine",
            "Hale",
            "Amersham on the Hill",
            "Battersea",
            "South Croydon",
            "Hornchurch",
            "Surbiton",
            "Ewell",
            "Becontree",
            "Brixton",
            "Bethnal Green",
            "Failsworth",
            "Radcliffe",
            "Heywood",
            "Longsight",
            "Heavitree",
            "Ferndown",
            "Canary Wharf",
            "Lytham St Annes",
            "Hadley Wood",
            "Chapel Allerton",
            "Blackheath",
            "Kempston Hardwick",
            "Mendip",
            "Lower Earley",
            "Bartley Green",
            "Earlsfield",
            "Letchworth Garden City",
            "Shirley",
            "Stanley",
            "Rossendale",
            "Thornton-Cleveleys",
            "Deeside",
            "High Peak",
            "Hayling Island",
            "Isle of Lewis",
            "Shetland",
            "Orkney",
            "Holloway",
            "Harringay"
        ],
        "Grenada" => [
            "Saint George's"
        ],
        "Georgia" => [
            "Zugdidi",
            "Zestap’oni",
            "Ts’khinvali",
            "Tqvarch'eli",
            "Telavi",
            "Tbilisi",
            "Sokhumi",
            "Senak’i",
            "Samtredia",
            "Rust’avi",
            "P’ot’i",
            "Ozurgeti",
            "Och’amch’ire",
            "Marneuli",
            "Kutaisi",
            "Kobuleti",
            "Khashuri",
            "Gori",
            "Batumi",
            "Akhaltsikhe",
            "Stantsiya Novyy Afon",
            "Tsqaltubo"
        ],
        "French Guiana" => [
            "Saint-Laurent-du-Maroni",
            "Rémire-Montjoly",
            "Matoury",
            "Kourou",
            "Cayenne"
        ],
        "Guernsey" => [
            "Saint Peter Port"
        ],
        "Ghana" => [
            "Yendi",
            "Winneba",
            "Wenchi",
            "Wa",
            "Teshi Old Town",
            "Tema",
            "Techiman",
            "Tarkwa",
            "Tamale",
            "Takoradi",
            "Tafo",
            "Swedru",
            "Sunyani",
            "Suhum",
            "Shama Junction",
            "Sekondi-Takoradi",
            "Savelugu",
            "Saltpond",
            "Salaga",
            "Prestea",
            "Kasoa",
            "Akim Oda",
            "Obuasi",
            "Nungua",
            "Nsawam",
            "Nkawkaw",
            "Navrongo",
            "Mampong",
            "Medina Estates",
            "Kumasi",
            "Kpandu",
            "Konongo",
            "Koforidua",
            "Kintampo",
            "Keta",
            "Hohoe",
            "Ho",
            "Gbawe",
            "Foso",
            "Elmina",
            "Ejura",
            "Dunkwa",
            "Dome",
            "Cape Coast",
            "Bolgatanga",
            "Bibiani",
            "Berekum",
            "Begoro",
            "Bawku",
            "Axim",
            "Asamankese",
            "Apam",
            "Anloga",
            "Akwatia",
            "Agogo",
            "Achiaman",
            "Accra",
            "Aburi"
        ],
        "Gibraltar" => [
            "Gibraltar"
        ],
        "Greenland" => [
            "Nuuk"
        ],
        "Gambia" => [
            "Sukuta",
            "Lamin",
            "Farafenni",
            "Brikama",
            "Banjul",
            "Bakau"
        ],
        "Guinea" => [
            "Tougué",
            "Télimélé",
            "Siguiri",
            "Pita",
            "Nzérékoré",
            "Mamou",
            "Macenta",
            "Labé",
            "Kissidougou",
            "Kindia",
            "Kankan",
            "Kamsar",
            "Gueckedou",
            "Fria",
            "Coyah",
            "Conakry",
            "Camayenne",
            "Boké"
        ],
        "Guadeloupe" => [
            "Sainte-Rose",
            "Sainte-Anne",
            "Pointe-à-Pitre",
            "Petit-Bourg",
            "Les Abymes",
            "Le Moule",
            "Le Gosier",
            "Capesterre-Belle-Eau",
            "Basse-Terre",
            "Baie-Mahault"
        ],
        "Equatorial Guinea" => [
            "Ebebiyin",
            "Malabo",
            "Bata"
        ],
        "Greece" => [
            "Voúla",
            "Vólos",
            "Výronas",
            "Vári",
            "Trípoli",
            "Tríkala",
            "Thívai",
            "Spárti",
            "Salamína",
            "Rethymno",
            "Préveza",
            "Pýrgos",
            "Piraeus",
            "Petroúpolis",
            "Peristéri",
            "Pérama",
            "Pátra",
            "Palaió Fáliro",
            "Níkaia",
            "Néa Smýrni",
            "Néa Mákri",
            "Ílion",
            "Néa Ionía",
            "Néa Filadélfeia",
            "Néa Erythraía",
            "Moskháton",
            "Mytilíni",
            "Melíssia",
            "Mégara",
            "Artémida",
            "Livadeiá",
            "Lárisa",
            "Lamía",
            "Metamórfosi",
            "Kos",
            "Koropí",
            "Kórinthos",
            "Kifisiá",
            "Cholargós",
            "Chios",
            "Chaniá",
            "Chalkída",
            "Khalándrion",
            "Chaïdári",
            "Keratsíni",
            "Kardítsa",
            "Kamaterón",
            "Kallithéa",
            "Kalamáta",
            "Álimos",
            "Kaisarianí",
            "Irákleio",
            "Irákleion",
            "Ioánnina",
            "Glyfáda",
            "Galátsi",
            "Ellinikó",
            "Elefsína",
            "Dhafní",
            "Agios Dimitrios",
            "Agía Varvára",
            "Agía Paraskeví",
            "Athens",
            "Asprópyrgos",
            "Argyroúpoli",
            "Árta",
            "Árgos",
            "Áno Liósia",
            "Maroúsi",
            "Amaliáda",
            "Acharnés",
            "Aígio",
            "Aigáleo",
            "Agrínio",
            "Ródos",
            "Giannitsá",
            "Xánthi",
            "Véroia",
            "Thessaloníki",
            "Sykiés",
            "Sérres",
            "Ptolemaḯda",
            "Políchni",
            "Pylaía",
            "Peraía",
            "Panórama",
            "Orestiáda",
            "Oraiókastro",
            "Náousa",
            "Meneméni",
            "Kozáni",
            "Komotiní",
            "Kilkís",
            "Kavála",
            "Kateríni",
            "Kalamariá",
            "Flórina",
            "Édessa",
            "Dráma",
            "Alexandroúpoli",
            "Corfu",
            "Vrilissia",
            "Gérakas",
            "Ilioúpoli",
            "Korydallós",
            "Zográfos",
            "Péfki",
            "Ágioi Anárgyroi",
            "Agios Ioannis Rentis",
            "Néa Ionía"
        ],
        "South Georgia and the South Sandwich Islands" => [
            "Grytviken"
        ],
        "Guatemala" => [
            "Zacapa",
            "Villa Nueva",
            "Villa Canales",
            "Totonicapán",
            "Tecpán Guatemala",
            "Sumpango",
            "Sololá",
            "Santiago Sacatepéquez",
            "Santiago Atitlán",
            "Santa María de Jesús",
            "Santa Lucía Cotzumalguapa",
            "Santa Cruz del Quiché",
            "Santa Catarina Pinula",
            "San Pedro Sacatepéquez",
            "San Pedro Ayampuc",
            "San Pablo Jocopilas",
            "San Marcos",
            "San Lucas Sacatepéquez",
            "San Juan Sacatepéquez",
            "San José Pinula",
            "San Francisco El Alto",
            "San Cristóbal Verapaz",
            "San Benito",
            "Sanarate",
            "San Andrés Itzapa",
            "Salamá",
            "Retalhuleu",
            "Quetzaltenango",
            "Puerto San José",
            "Puerto Barrios",
            "Tiquisate",
            "Poptún",
            "Petapa",
            "Patzún",
            "Patzicía",
            "Panzós",
            "Palín",
            "Palencia",
            "Ostuncalco",
            "Nuevo San Carlos",
            "Nebaj",
            "Nahualá",
            "Morales",
            "Momostenango",
            "Mixco",
            "Mazatenango",
            "La Gomera",
            "La Esperanza",
            "Jutiapa",
            "Jocotenango",
            "Jalapa",
            "Jacaltenango",
            "Huehuetenango",
            "Gualán",
            "Fraijanes",
            "Flores",
            "Esquipulas",
            "Escuintla",
            "El Tejar",
            "El Palmar",
            "El Estor",
            "Cuilapa",
            "Comitancillo",
            "Comalapa",
            "Colomba",
            "Cobán",
            "Coatepeque",
            "Ciudad Vieja",
            "Guatemala City",
            "Chisec",
            "Chiquimula",
            "Chinautla",
            "Chimaltenango",
            "Chichicastenango",
            "Chicacao",
            "Cantel",
            "Barberena",
            "Asunción Mita",
            "Antigua Guatemala",
            "Amatitlán",
            "Alotenango"
        ],
        "Guam" => [
            "Tamuning-Tumon-Harmon Village",
            "Yigo Village",
            "Guam Government House",
            "Dededo Village",
            "Hagåtña",
            "Mangilao Village"
        ],
        "Guinea-Bissau" => [
            "Bissau",
            "Bafatá"
        ],
        "Guyana" => [
            "New Amsterdam",
            "Linden",
            "Georgetown"
        ],
        "Hong Kong" => [
            "Tsuen Wan",
            "Yuen Long Kau Hui",
            "Tuen Mun",
            "Tai Po",
            "Sha Tin",
            "Kowloon",
            "Hong Kong"
        ],
        "Honduras" => [
            "Puerto Cortez",
            "Yoro",
            "Villanueva",
            "Tocoa",
            "Tela",
            "Tegucigalpa",
            "Siguatepeque",
            "Santa Rosa de Copán",
            "Santa Bárbara",
            "San Pedro Sula",
            "San Lorenzo",
            "Potrerillos",
            "Olanchito",
            "La Paz",
            "La Lima",
            "La Ceiba",
            "Juticalpa",
            "El Progreso",
            "El Paraíso",
            "Danlí",
            "Comayagua",
            "Cofradía",
            "Ciudad Choluteca",
            "Choloma"
        ],
        "Croatia" => [
            "Zaprešić",
            "Zagreb",
            "Zadar",
            "Vukovar",
            "Virovitica",
            "Vinkovci",
            "Velika Gorica",
            "Varaždin",
            "Split",
            "Solin",
            "Slavonski Brod",
            "Požega",
            "Sisak",
            "Šibenik",
            "Sesvete",
            "Samobor",
            "Rijeka",
            "Pula",
            "Osijek",
            "Koprivnica",
            "Karlovac",
            "Dubrovnik",
            "Čakovec",
            "Bjelovar",
            "Zagreb- Stenjevec",
            "Zagreb - Centar"
        ],
        "Haiti" => [
            "Verrettes",
            "Thomazeau",
            "Saint-Raphaël",
            "Saint-Marc",
            "Port-de-Paix",
            "Port-au-Prince",
            "Tigwav",
            "Pétionville",
            "Miragoâne",
            "Lenbe",
            "Léogâne",
            "Kenscoff",
            "Jérémie",
            "Jacmel",
            "Hinche",
            "Gressier",
            "Grangwav",
            "Gonayiv",
            "Fond Parisien",
            "Désarmes",
            "Delmas 73",
            "Croix des Bouquets",
            "Les Cayes",
            "Carrefour",
            "Okap",
            "Ti Port-de-Paix"
        ],
        "Hungary" => [
            "Törökszentmiklós",
            "Tiszaújváros",
            "Szolnok",
            "Szentes",
            "Szeged",
            "Szarvas",
            "Sátoraljaújhely",
            "Püspökladány",
            "Ózd",
            "Orosháza",
            "Nyíregyháza",
            "Miskolc",
            "Mezőtúr",
            "Mezőkövesd",
            "Mátészalka",
            "Makó",
            "Kisvárda",
            "Kazincbarcika",
            "Karcag",
            "Hódmezővásárhely",
            "Hajdúszoboszló",
            "Hajdúnánás",
            "Hajdúböszörmény",
            "Gyula",
            "Gyomaendrőd",
            "Eger",
            "Debrecen",
            "Csongrád",
            "Berettyóújfalu",
            "Békéscsaba",
            "Békés",
            "Balmazújváros",
            "Abony",
            "Zalaegerszeg",
            "Veszprém",
            "Vecsés",
            "Várpalota",
            "Vác",
            "Tatabánya",
            "Tata",
            "Tapolca",
            "Szombathely",
            "Szigetszentmiklós",
            "Szentendre",
            "Szekszárd",
            "Székesfehérvár",
            "Százhalombatta",
            "Sopron",
            "Siófok",
            "Sárvár",
            "Salgótarján",
            "Pécs",
            "Parádsasvár",
            "Pápa",
            "Paks",
            "Oroszlány",
            "Nagykőrös",
            "Nagykanizsa",
            "Mosonmagyaróvár",
            "Monor",
            "Mohács",
            "Komló",
            "Komárom",
            "Kiskunhalas",
            "Kiskunfélegyháza",
            "Kiskőrös",
            "Keszthely",
            "Kecskemét",
            "Kaposvár",
            "Kalocsa",
            "Jászberény",
            "Hatvan",
            "Győr",
            "Gyöngyös",
            "Gyál",
            "Gödöllő",
            "Göd",
            "Fót",
            "Esztergom",
            "Érd",
            "Dunaújváros",
            "Dunakeszi",
            "Dunaharaszti",
            "Dombóvár",
            "Dabas",
            "Cegléd",
            "Budapest",
            "Budaörs",
            "Balassagyarmat",
            "Baja",
            "Ajka",
            "Budapest XII. kerület",
            "Budapest XI. kerület",
            "Budapest IX. kerület",
            "Budapest VIII. kerület",
            "Budapest VII. kerület",
            "Budapest VI. kerület",
            "Budapest XIV. kerület",
            "Budapest XIII. kerület",
            "Budapest IV. kerület",
            "Budapest XV. kerület",
            "Budapest XVI. kerület",
            "Budapest X. kerület",
            "Budapest XIX. kerület",
            "Budapest XVIII. kerület",
            "Budapest XXIII. kerület",
            "Budapest XXII. kerület",
            "Budapest XXI. kerület",
            "Budapest XX. kerület",
            "Budapest XVII. kerület",
            "Budapest III. kerület",
            "Budapest II. kerület",
            "Budapest I. kerület"
        ],
        "Indonesia" => [
            "Tongging",
            "Teluk Nibung",
            "Tebingtinggi",
            "Tanjungtiram",
            "Tanjungbalai",
            "Sunggal",
            "Stabat",
            "Singkil",
            "Sigli",
            "Sibolga",
            "Sabang",
            "Reuleuet",
            "Rantauprapat",
            "Percut",
            "Perbaungan",
            "Pematangsiantar",
            "Pangkalan Brandan",
            "Padangsidempuan",
            "Meulaboh",
            "Medan",
            "Lhokseumawe",
            "Langsa",
            "Labuhan Deli",
            "Kisaran",
            "Kabanjahe",
            "Deli Tua",
            "Bireun",
            "Binjai",
            "Berastagi",
            "Belawan",
            "Bandar",
            "Banda Aceh",
            "Yogyakarta",
            "Wonosobo",
            "Wonopringgo",
            "Wongsorejo",
            "Wiradesa",
            "Weru",
            "Weleri",
            "Welahan",
            "Wedi",
            "Watampone",
            "Wangon",
            "Wanaraja",
            "Waingapu",
            "Ungaran",
            "Makassar",
            "Ubud",
            "Tulungagung",
            "Tulangan Utara",
            "Tuban",
            "Tual",
            "Trucuk",
            "Trenggalek",
            "Tondano",
            "Tomohon",
            "Ternate",
            "Terbanggi Besar",
            "Tegal",
            "Tayu",
            "Tasikmalaya",
            "Tarub",
            "Tarakan",
            "Tanjungpinang",
            "Tanjung Pandan",
            "Bandar Lampung",
            "Tanjungagung",
            "Tanggulangin",
            "Tangerang",
            "Tabanan",
            "Surakarta",
            "Surabaya",
            "Sungai Raya",
            "Sungai Penuh",
            "Sungailiat",
            "Sumenep",
            "Sumedang Utara",
            "Sumberpucung",
            "Sumber",
            "Sumbawa Besar",
            "Sokaraja",
            "Sukabumi",
            "Srono",
            "Srandakan",
            "Sragen",
            "Sorong",
            "Soreang",
            "Solok",
            "Soko",
            "Sofifi",
            "Soe",
            "Sleman",
            "Slawi",
            "Situbondo",
            "Sinjai",
            "Singosari",
            "Singojuruh",
            "Singkawang",
            "Sengkang",
            "Singaraja",
            "Singaparna",
            "Simpang",
            "Sijunjung",
            "Sidoarjo",
            "Sidareja",
            "Sewon",
            "Serpong",
            "Serang",
            "Sepatan",
            "Semarang",
            "Selogiri",
            "Sawangan",
            "Sampit",
            "Sampang",
            "Samarinda",
            "Salatiga",
            "Ruteng",
            "Rengasdengklok",
            "Rembangan",
            "Rantepao",
            "Rangkasbitung",
            "Randudongkal",
            "Rajapolah",
            "Purwokerto",
            "Purwodadi",
            "Purwakarta",
            "Purbalingga",
            "Pundong",
            "Probolinggo",
            "Prigen",
            "Praya",
            "Candi Prambanan",
            "Poso",
            "Pontianak",
            "Ponorogo",
            "Polewali",
            "Plumbon",
            "Petarukan",
            "Prabumulih",
            "Pemangkat",
            "Pemalang",
            "Pelabuhanratu",
            "Pekanbaru",
            "Pekalongan",
            "Pecangaan",
            "Payakumbuh",
            "Pati",
            "Pasuruan",
            "Paseh",
            "Pasarkemis",
            "Parung",
            "Pariaman",
            "Parepare",
            "Pare",
            "Panji",
            "Pangkalpinang",
            "Pangkalanbuun",
            "Pandeglang",
            "Pandaan",
            "Pandak",
            "Panarukan",
            "Pamulang",
            "Pameungpeuk",
            "Pamekasan",
            "Pamanukan",
            "Palu",
            "Palopo",
            "Palimanan",
            "Palembang",
            "Palangkaraya",
            "Pakisaji",
            "Pageralam",
            "Padang",
            "Paciran",
            "Ngunut",
            "Ngoro",
            "Ngawi",
            "Nganjuk",
            "Negara",
            "Nabire",
            "Muntok",
            "Muntilan",
            "Muncar",
            "Mranggen",
            "Mojokerto",
            "Mojoagung",
            "Mlonggo",
            "Metro",
            "Mertoyudan",
            "Melati",
            "Maumere",
            "Mataram",
            "Martapura",
            "Margasari",
            "Margahayukencana",
            "Manokwari",
            "Manismata",
            "Manggar",
            "Mendaha",
            "Manado",
            "Malang",
            "Majene",
            "Majenang",
            "Majalengka",
            "Magelang",
            "Madiun",
            "Luwuk",
            "Lumajang",
            "Lubuklinggau",
            "Loa Janan",
            "Lembang",
            "Lebaksiu",
            "Lawang",
            "Lasem",
            "Lamongan",
            "Lahat",
            "Labuan Bajo",
            "Labuan",
            "Kutoarjo",
            "Kuta",
            "Kuningan",
            "Kudus",
            "Kuala Tungkal",
            "Kualakapuas",
            "Kroya",
            "Krian",
            "Kresek",
            "Kraksaan",
            "Kotabumi",
            "Klungkung",
            "Klaten",
            "Klangenan",
            "Kijang",
            "Ketanggungan",
            "Kertosono",
            "Kepanjen",
            "Kendari",
            "Kencong",
            "Kefamenanu",
            "Kedungwuni",
            "Kedungwaru",
            "Kediri",
            "Kebonarun",
            "Kebomas",
            "Kawalu",
            "Katabu",
            "Karangsembung",
            "Karangasem",
            "Karanganom",
            "Karangampel",
            "Kamal",
            "Kalianget",
            "Juwana",
            "Jombang",
            "Jogonalan",
            "Jember",
            "Jekulo",
            "Jatiwangi",
            "Jatiroto",
            "Jatibarang",
            "Jaten",
            "Jambi City",
            "Jakarta",
            "Indramayu",
            "Grogol",
            "Gresik",
            "Gorontalo",
            "Gongdanglegi Kulon",
            "Gombong",
            "Godean",
            "Genteng",
            "Gedangan",
            "Gebog",
            "Gampengrejo",
            "Gambiran Satu",
            "Galesong",
            "Ende",
            "Dumai",
            "Dukuhturi",
            "Driyorejo",
            "Dompu",
            "Diwek",
            "Depok",
            "Depok",
            "Denpasar",
            "Demak",
            "Delanggu",
            "Dampit",
            "Curup",
            "Curug",
            "Comal",
            "Colomadu",
            "Citeureup",
            "Cirebon",
            "Ciputat",
            "Cimahi",
            "Cileunyi",
            "Cileungsir",
            "Cikarang",
            "Cikampek",
            "Cicurug",
            "Cibinong",
            "Ciamis",
            "Cepu",
            "Ceper",
            "Caringin",
            "Ciampea",
            "Bulakamba",
            "Bukittinggi",
            "Buduran",
            "Buaran",
            "Boyolangu",
            "Boyolali",
            "Bontang",
            "Bondowoso",
            "Bojonegoro",
            "Bogor",
            "Blora",
            "Blitar",
            "Bitung",
            "Bima",
            "Besuki",
            "Bengkulu",
            "Bekasi",
            "Baturaja",
            "Baturaden",
            "Batu",
            "Batang",
            "Barabai",
            "Banyuwangi",
            "Banyumas",
            "Bantul",
            "Banjarmasin",
            "Banjaran",
            "Banjar",
            "Banjar",
            "Bangkalan",
            "Bangil",
            "Bandung",
            "Bambanglipuro",
            "Balung",
            "Balikpapan",
            "Balapulang",
            "Balaipungut",
            "Baki",
            "Baekrajan",
            "Babat",
            "Atambua",
            "Astanajapura",
            "Arjawinangun",
            "Amuntai",
            "Ambon",
            "Ambarawa",
            "Amahai",
            "Adiwerna",
            "Padalarang",
            "Ciranjang-hilir",
            "Cikupa",
            "Teluknaga",
            "Wonosari",
            "Gamping Lor",
            "Kasihan",
            "Ngemplak",
            "Kartasura",
            "Gatak",
            "Kupang",
            "Jayapura",
            "Abepura",
            "Seririt",
            "City of Balikpapan",
            "Pekan Bahapal",
            "South Tangerang"
        ],
        "Ireland" => [
            "Loch Garman",
            "Waterford",
            "Tralee",
            "Tallaght",
            "Swords",
            "Sligo",
            "Droichead Nua",
            "Navan",
            "Naas",
            "An Muileann gCearr",
            "Malahide",
            "Lucan",
            "Luimneach",
            "Letterkenny",
            "Leixlip",
            "Kilkenny",
            "Gaillimh",
            "Finglas",
            "Ennis",
            "Dún Laoghaire",
            "Dundalk",
            "Dublin",
            "Drogheda",
            "Cork",
            "Cluain Meala",
            "Celbridge",
            "Carlow",
            "Blanchardstown",
            "Balbriggan",
            "Athlone",
            "Sandyford",
            "Donaghmede"
        ],
        "Israel" => [
            "Jerusalem",
            "Safed",
            "Yehud",
            "Yavné",
            "Yafo",
            "Umm el Faḥm",
            "Tirat Karmel",
            "Tiberias",
            "Tel Aviv",
            "maalot Tarshīhā",
            "Tamra",
            "Sederot",
            "Sakhnīn",
            "Rosh Ha‘Ayin",
            "Rishon LeẔiyyon",
            "Ramla",
            "Ramat HaSharon",
            "Ramat Gan",
            "Ra'anana",
            "Qiryat Yam",
            "Qiryat Shemona",
            "Qiryat Moẕqin",
            "Qiryat Gat",
            "Qiryat Bialik",
            "Qiryat Ata",
            "Qalansuwa",
            "Petaẖ Tiqwa",
            "Or Yehuda",
            "Ofaqim",
            "Netivot",
            "Netanya",
            "Ness Ziona",
            "Nesher",
            "Nazareth",
            "Nahariya",
            "Migdal Ha‘Emeq",
            "Mevo Betar",
            "Maghār",
            "Lod",
            "Kfar Saba",
            "Karmi’el",
            "Kafr Qāsim",
            "Kafr Mandā",
            "Kafr Kannā",
            "Judeida Makr",
            "H̱olon",
            "Hod HaSharon",
            "Herzliyya",
            "Haifa",
            "H̱adera",
            "Giv‘at Shemu’él",
            "Giv‘atayim",
            "Tirah",
            "Eṭ Ṭaiyiba",
            "Er Reina",
            "Eilat",
            "Dimona",
            "Dāliyat el Karmil",
            "Bet Shemesh",
            "Bet She’an",
            "Bené Beraq",
            "Beersheba",
            "Bat Yam",
            "Ashqelon",
            "Ashdod",
            "‘Arad",
            "‘Akko",
            "‘Afula ‘Illit",
            "Modiin",
            "West Jerusalem",
            "Modiin Ilit",
            "Ariel"
        ],
        "Isle of Man" => [
            "Douglas"
        ],
        "India" => [
            "Pūnch",
            "Keelakarai",
            "Zunheboto",
            "Zamānia",
            "Zaidpur",
            "Zahirābād",
            "Yeola",
            "Yellāpur",
            "Yellandu",
            "Yelahanka",
            "Yavatmāl",
            "Yāval",
            "Yanam",
            "Yamunānagar",
            "Yādgīr",
            "Wokha",
            "Wer",
            "Wellington",
            "Wazīrganj",
            "Wāshīm",
            "Warud",
            "Warora",
            "Wāris Alīganj",
            "Wardha",
            "Wārāseonī",
            "Warangal",
            "Wanparti",
            "Wānkāner",
            "Wani",
            "Walajapet",
            "Wai",
            "Wādi",
            "Vyāra",
            "Vuyyūru",
            "Vrindāvan",
            "Vriddhāchalam",
            "Vizianagaram",
            "Vite",
            "Visnagar",
            "Visakhapatnam",
            "Vīsāvadar",
            "Virudunagar",
            "Viravanallūr",
            "Vīrarājendrapet",
            "Virār",
            "Vinukonda",
            "Villupuram",
            "Vikārābād",
            "Vijayawada",
            "Vijāpur",
            "Vidisha",
            "Vettūr",
            "Vettaikkaranpudur",
            "Vetapālem",
            "Verāval",
            "Vepagunta",
            "Venkatagiri",
            "Vemalwāda",
            "Velur",
            "Vellore",
            "Vejalpur",
            "Vedaraniyam",
            "Vayalār",
            "Vattalkundu",
            "Vāsudevanallūr",
            "Vasind",
            "Vāsco Da Gāma",
            "Vasa",
            "Varkala",
            "Varangaon",
            "Varanasi",
            "Vaniyambadi",
            "Vandavāsi",
            "Valsād",
            "Valparai",
            "Vallabh Vidyanagar",
            "Valabhīpur",
            "Vaikam",
            "Vaijāpur",
            "Vadodara",
            "Vadnagar",
            "Vadlapūdi",
            "Vādippatti",
            "Vadamadurai",
            "Vadakku Valliyūr",
            "Vāda",
            "Uttiramerūr",
            "Uttarkāshi",
            "Uttamapālaiyam",
            "Utraula",
            "Usilampatti",
            "Usehat",
            "Uravakonda",
            "Uran",
            "Upleta",
            "Uppal Kalan",
            "Unnāo",
            "Unjha",
            "Unhel",
            "Una",
            "Una",
            "Ūn",
            "Un",
            "Umreth",
            "Umred",
            "Umarkot",
            "Umarkhed",
            "Umaria",
            "Umarga",
            "Ullal",
            "Ulhasnagar",
            "Ujjain",
            "Ujhāni",
            "Udumalaippettai",
            "Udipi",
            "Udhampur",
            "Udgīr",
            "Udankudi",
            "Udalguri",
            "Udaipura",
            "Udaipur",
            "Udaipur",
            "Udaipur",
            "Ooty",
            "Bara Uchāna",
            "Turaiyūr",
            "Tura",
            "Tuni",
            "Tūndla",
            "Tumsar",
            "Tumkūr",
            "Tulsīpur",
            "Tuljāpur",
            "Tufānganj",
            "Tuensang",
            "Thiruvananthapuram",
            "Trichūr",
            "Tonk",
            "Tondi",
            "Tohāna",
            "Todaraisingh",
            "Todabhim",
            "Titlāgarh",
            "Titāgarh",
            "Tisaiyanvilai",
            "Tiruvottiyūr",
            "Cheyyar",
            "Tiruvannāmalai",
            "Tiruvallur",
            "Tiruvalla",
            "Thiruthani",
            "Tiruttangal",
            "Tirur",
            "Tiruppuvanam",
            "Tiruppur",
            "Tirupparangunram",
            "Tirupati",
            "Tirunelveli",
            "Tirumala",
            "Tirukkoyilur",
            "Tiruchengode",
            "Tiruchirappalli",
            "Tiruchchendur",
            "Tīrthahalli",
            "Tiptūr",
            "Tinsukia",
            "Tinnanūr",
            "Tindivanam",
            "Tilhar",
            "Tīkamgarh",
            "Tijāra",
            "Thoubāl",
            "Thiruvarur",
            "Thāsra",
            "Tharād",
            "Thanjāvūr",
            "Thānesar",
            "Thāne",
            "Thāna Bhawan",
            "Thān",
            "Thākurganj",
            "Thakurdwara",
            "Tezpur",
            "Terdāl",
            "Teonthar",
            "Thenkasi",
            "Teni",
            "Tellicherry",
            "Telhāra",
            "Tekkali",
            "Tekkalakote",
            "Tekāri",
            "Tehri",
            "Teghra",
            "Tāsgaon",
            "Tarn Tāran",
            "Tarikere",
            "Tharangambadi",
            "Tārānagar",
            "Tarāna",
            "Tāramangalam",
            "Tarakeswar",
            "Tāoru",
            "Tanuku",
            "Tāndūr",
            "Tānda",
            "Tāndā",
            "Tanakpur",
            "Tamlūk",
            "Talwāra",
            "Talwandi Bhai",
            "Taloda",
            "Talipparamba",
            "Tālīkota",
            "Taleigao",
            "Talegaon Dābhāde",
            "Tālcher",
            "Talāja",
            "Tāki",
            "Takhatpur",
            "Takhatgarh",
            "Tājpur",
            "Tādpatri",
            "Tādepallegūdem",
            "Tādepalle",
            "Suriāpet",
            "Suriānwān",
            "Surendranagar",
            "Sūratgarh",
            "Sūrat",
            "Sūrandai",
            "Sūrajgarh",
            "Supaul",
            "Sunel",
            "Sundarnagar",
            "Sundargarh",
            "Sunām",
            "Sulya",
            "Sūlūru",
            "Sulur",
            "Sultanpur",
            "Sultānpur",
            "Suket",
            "Sūjāngarh",
            "Suār",
            "Srivilliputhur",
            "Srīvardhan",
            "Srivaikuntam",
            "Srīsailain",
            "Srīrāmnagar",
            "Srīperumbūdūr",
            "Srīnivāspur",
            "Srinagar",
            "Srīnagar",
            "Sri Mādhopur",
            "Karanpur",
            "Chicacole",
            "Sri Dūngargarh",
            "Soygaon",
            "Soron",
            "Soro",
            "Sorada",
            "Sopur",
            "Sonīpat",
            "Songadh",
            "Sonepur",
            "Sonāri",
            "Sonāmukhi",
            "Sompeta",
            "Someshwar",
            "Solan",
            "Sojītra",
            "Sojat",
            "Sohna",
            "Sohāgpur",
            "Siwāna",
            "Siwān",
            "Sivakasi",
            "Sivagiri",
            "Sivagiri",
            "Sivaganga",
            "Siuri",
            "Sitārganj",
            "Sītāpur",
            "Sītāmarhi",
            "Siswā Bāzār",
            "Sisauli",
            "Sirūr",
            "Sirumugai",
            "Siruguppa",
            "Sirsilla",
            "Sirsi",
            "Sirsi",
            "Sirsāganj",
            "Sirsa",
            "Sironj",
            "Sirohi",
            "Sīrkāzhi",
            "Sirhind",
            "Sīra",
            "Sinnar",
            "Singur",
            "Singarāyakonda",
            "Singānallūr",
            "Sindhnūr",
            "Sindgi",
            "Shimla",
            "Simdega",
            "Silvassa",
            "Sillod",
            "Silchar",
            "Silao",
            "Sīkar",
            "Sikandra Rao",
            "Sikandarpur",
            "Sikandarābād",
            "Sikka",
            "Sijua",
            "Sihorā",
            "Sihor",
            "Sidlaghatta",
            "Sidhi",
            "Sidhaulī",
            "Siddipet",
            "Siddhapur",
            "Sibsāgar",
            "Shyamnagar",
            "Shujālpur",
            "Shrīrangapattana",
            "Shrīrāmpur",
            "Shrīgonda",
            "Shorāpur",
            "Shoranūr",
            "Sholinghur",
            "Solāpur",
            "Shivpuri",
            "Shīshgarh",
            "Shirpur",
            "Shirhatti",
            "Shirdi",
            "Shimoga",
            "Shillong",
            "Shiliguri",
            "Shikohābād",
            "Shikārpūr",
            "Shikārpur",
            "Shiggaon",
            "Shertallai",
            "Sherkot",
            "Sherghāti",
            "Sheopur",
            "Sheohar",
            "Sheoganj",
            "Shegaon",
            "Shāntipur",
            "Shamsābād",
            "Shamsābād",
            "Shāmli",
            "Shāmgarh",
            "Shājāpur",
            "Sheikhpura",
            "Shāhpura",
            "Shāhpura",
            "Shāhpur",
            "Shāhpur",
            "Shāhpur",
            "Shāhpur",
            "Shāhjānpur",
            "Shāhi",
            "Shāhganj",
            "Shahdol",
            "Shāhāda",
            "Shāhābād",
            "Shāhābād",
            "Shāhābād",
            "Shāhābād",
            "Serchhīp",
            "Seram",
            "Seoni Mālwa",
            "Seoni",
            "Seondha",
            "Seohāra",
            "Sendhwa",
            "Sehore",
            "Secunderabad",
            "Sāyla",
            "Sawāi Mādhopur",
            "Sāvda",
            "Savanūr",
            "Sāvantvādi",
            "Sausar",
            "Saundatti",
            "Sathyamangalam",
            "Sattur",
            "Sattenapalle",
            "Satna",
            "Sātāra",
            "Satānā",
            "Sāsvad",
            "Sarwār",
            "Sarkhej",
            "Sardulgarh",
            "Sardhana",
            "Sardārshahr",
            "Sarauli",
            "Sārangpur",
            "Saraipali",
            "Sarāi Mīr",
            "Sarāi Ākil",
            "Saoner",
            "Sānkrāil",
            "Sankeshwar",
            "Sangrūr",
            "Sāngola",
            "Sangod",
            "Sāngli",
            "Sangariā",
            "Sangāreddi",
            "Sangamner",
            "Sandūr",
            "Sandīla",
            "Sāndi",
            "Sancoale",
            "Sānchor",
            "Sanāwad",
            "Sanaur",
            "Sānand",
            "Samthar",
            "Samrāla",
            "Samdari",
            "Sāmbhar",
            "Sambhal",
            "Sambalpur",
            "Sāmba",
            "Samāstipur",
            "Sāmalkot",
            "Samālkha",
            "Sālūr",
            "Sālūmbar",
            "Salem",
            "Salāya",
            "Saktī",
            "Sakleshpur",
            "Saint Thomas Mount",
            "Sainthia",
            "Selu",
            "Saiha",
            "Saidpur",
            "Sāhibganj",
            "Sahāwar",
            "Sahaswān",
            "Sahaspur",
            "Saharsa",
            "Sahāranpur",
            "Sagauli",
            "Saugor",
            "Sāgar",
            "Safīpur",
            "Safidon",
            "Sādri",
            "Sadāseopet",
            "Sadalgi",
            "Sadābād",
            "Sabalgarh",
            "Rusera",
            "Rura",
            "Ropar",
            "Rūdarpur",
            "Roorkee",
            "Ron",
            "Rohtak",
            "Roha",
            "Robertsonpet",
            "Robertsganj",
            "Risod",
            "Rishra",
            "Rishīkesh",
            "Rīngas",
            "Richha",
            "Rewāri",
            "Rewa",
            "Revelganj",
            "Repalle",
            "Reoti",
            "Renukūt",
            "Renigunta",
            "Remuna",
            "Rehli",
            "Rāzām",
            "Rāybāg",
            "Rāyadrug",
            "Rāyachoti",
            "Rāya",
            "Raxaul",
            "Rāwatsār",
            "Rāwatbhāta",
            "Rāver",
            "Ratnagiri",
            "Ratlām",
            "Ratia",
            "Rāth",
            "Ratanpur",
            "Ratangarh",
            "Rasrā",
            "Rasipuram",
            "Rāpar",
            "Rānīpur",
            "Rānikhet",
            "Rānīganj",
            "Rānībennur",
            "Rānia",
            "Rangia",
            "Rangāpāra",
            "Ranchi",
            "Rānāvāv",
            "Rānāghāt",
            "Rāmtek",
            "Rampur Hat",
            "Rāmpura",
            "Rāmpura",
            "Rāmpur",
            "Rāmpur",
            "Rāmnagar",
            "Rāmnagar",
            "Rāmnagar",
            "Rāmjībanpur",
            "Rāmgundam",
            "Rāmgarh",
            "Rāmgarh",
            "Rāmganj Mandi",
            "Rameswaram",
            "Rāmāpuram",
            "Ramanathapuram",
            "Rāmanagaram",
            "Rāmachandrapuram",
            "Rājūra",
            "Rājula",
            "Rājsamand",
            "Rājpura",
            "Rajpur",
            "Rajpur",
            "Rājpīpla",
            "Rāj-Nāndgaon",
            "Rājmahal",
            "Rājkot",
            "Rājgurunagar",
            "Rājgīr",
            "Rājgarh",
            "Rājgarh",
            "Rājgarh",
            "Rājgarh",
            "Rajaori",
            "Rajapalaiyam",
            "Rājampet",
            "Rājaldesar",
            "Rājākhera",
            "Rājahmundry",
            "Rāisinghnagar",
            "Raisen",
            "Rāipur",
            "Raipur",
            "Raipur",
            "Rāikot",
            "Raigarh",
            "Rāiganj",
            "Rāichūr",
            "Rāhuri",
            "Rahimatpur",
            "Rāhatgarh",
            "Raghunathpur",
            "Rāghogarh",
            "Rafiganj",
            "Raebareli",
            "Rādhanpur",
            "Rabkavi",
            "Kollam",
            "Kasba",
            "Qādiān",
            "Puttūr",
            "Puttūr",
            "Pushkar",
            "Pusad",
            "Purwā",
            "Puruliya",
            "Purnia",
            "Pūrna",
            "Puri",
            "Pūranpur",
            "Pupri",
            "Punjai Puliyampatti",
            "Punganūru",
            "Pune",
            "Pūndri",
            "Punāsa",
            "Punalūr",
            "Pūnāhāna",
            "Pulwama",
            "Puliyangudi",
            "Pulivendla",
            "Pulgaon",
            "Pukhrāyān",
            "Pudukkottai",
            "Proddatūr",
            "Pratāpgarh",
            "Port Blair",
            "Porsa",
            "Porbandar",
            "Poonamalle",
            "Ponnūru",
            "Ponneri",
            "Ponnāni",
            "Puducherry",
            "Ponda",
            "Polūr",
            "Pollachi",
            "Polavaram",
            "Polasara",
            "Pokaran",
            "Pithorāgarh",
            "Pithāpuram",
            "Piro",
            "Piriyāpatna",
            "Piravam",
            "Pīpri",
            "Pipraich",
            "Pipili",
            "Pīpār",
            "Pinjaur",
            "Pindwāra",
            "Pināhat",
            "Pimpri",
            "Pilkhua",
            "Pīlibhīt",
            "Pilibangan",
            "Pilāni",
            "Pihānī",
            "Phulpur",
            "Phulera",
            "Phulabāni",
            "Phirangipuram",
            "Phillaur",
            "Phek",
            "Phaphūnd",
            "Phaltan",
            "Phalodi",
            "Phalauda",
            "Phagwāra",
            "Petlād",
            "Perundurai",
            "Perumpāvūr",
            "Periyanayakkanpalaiyam",
            "Periyakulam",
            "Peravurani",
            "Peranāmpattu",
            "Perambalur",
            "Penukonda",
            "Penugonda",
            "Pennāgaram",
            "Pennādam",
            "Pen",
            "Pehowa",
            "Peddāpuram",
            "Peddapalli",
            "Pedana",
            "Payyannūr",
            "Pawāyan",
            "Pāvugada",
            "Pauri",
            "Pawni",
            "Pātūr",
            "Pattukkottai",
            "Patti",
            "Patnāgarh",
            "Patna",
            "Patiāla",
            "Pāthri",
            "Patharia",
            "Pāthardih",
            "Pāthardi",
            "Pathānkot",
            "Pathanāmthitta",
            "Pathalgaon",
            "Pataudi",
            "Patancheru",
            "Pātan",
            "Patāmundai",
            "Pāsighāt",
            "Pasān",
            "Parvatsar",
            "Pārvatipuram",
            "Partūr",
            "Parola",
            "Parli Vaijnāth",
            "Parlākimidi",
            "Pariyāpuram",
            "Parīchhatgarh",
            "Pārdi",
            "Parbhani",
            "Paravūr",
            "Parāsia",
            "Paramagudi",
            "Parādīp Garh",
            "Pāppinisshēri",
            "Papanasam",
            "Pāonta Sāhib",
            "Panvel",
            "Panruti",
            "Panna",
            "Panmana",
            "Pānīpat",
            "Pānihāti",
            "Pandua",
            "Pāndhurnā",
            "Pandharpur",
            "French Rocks",
            "Panaji",
            "Panāgar",
            "Palwal",
            "Pāloncha",
            "Palani",
            "Palmaner",
            "Pallippatti",
            "Pallikondai",
            "Pallāvaram",
            "Pallappatti",
            "Palladam",
            "Pālkonda",
            "Pālitāna",
            "Paliā Kalān",
            "Pāli",
            "Pāli",
            "Palakkad",
            "Pālghar",
            "Palera",
            "Palāsa",
            "Pālanpur",
            "Pālakollu",
            "Pālakkodu",
            "Pākaur",
            "Pākāla",
            "Paithan",
            "Pahāsu",
            "Padrauna",
            "Padra",
            "Padmanābhapuram",
            "Padampur",
            "Padampur",
            "Padam",
            "Pachperwa",
            "Pāchora",
            "Ottappālam",
            "Osmanabad",
            "Orai",
            "Ongole",
            "Okha",
            "Ozar",
            "Obra",
            "Nūzvīd",
            "Nūrpur",
            "Nowrangapur",
            "North Lakhimpur",
            "North Guwāhāti",
            "Nongstoin",
            "Nokha",
            "Nohar",
            "Noāmundi",
            "Nizāmābād",
            "Nirmāli",
            "Nirmal",
            "Nipāni",
            "Neem ka Thana",
            "Nīmbāhera",
            "Nimāparha",
            "Nīmāj",
            "Nīlokheri",
            "Nīlēshwar",
            "Nilanga",
            "Nilakottai",
            "Nīlgiri",
            "Nihtaur",
            "Nidadavole",
            "Nichlaul",
            "Neyyāttinkara",
            "New Delhi",
            "Neral",
            "Nepānagar",
            "Nellore",
            "Nellikkuppam",
            "Nelamangala",
            "Nedumangād",
            "Nāyudupeta",
            "Nayāgarh",
            "Nawāshahr",
            "Nawalgarh",
            "Niwai",
            "Nawāda",
            "Nawābganj",
            "Nawābganj",
            "Nawābganj",
            "Nāwa",
            "Navalgund",
            "Navadwīp",
            "Nautanwa",
            "Naugachhia",
            "Nattam",
            "Nāthdwāra",
            "Nasrullāhganj",
            "Nāsriganj",
            "Nāspur",
            "Nasīrābād",
            "Nashik",
            "Narwar",
            "Narwāna",
            "Narsīpatnam",
            "Narsinghgarh",
            "Narsimhapur",
            "Nārnaund",
            "Nārnaul",
            "Nargund",
            "Naregal",
            "Nārāyanpet",
            "Narāyangarh",
            "Nāravārikuppam",
            "Naraura",
            "Narauli",
            "Narasaraopet",
            "Narasapur",
            "Narasannapeta",
            "Naraini",
            "Naraina",
            "Napāsar",
            "Nānpāra",
            "Nanjangūd",
            "Nāngloi Jāt",
            "Nāngal Township",
            "Nandyāl",
            "Nandurbar",
            "Nāndūra Buzurg",
            "Nandikotkūr",
            "Nandigāma",
            "Nāndgaon",
            "Nanded",
            "Nanauta",
            "Nāmrup",
            "Nambiyūr",
            "Nāmakkal",
            "Nāmagiripettai",
            "Nalhāti",
            "Nalgonda",
            "Naldurg",
            "Nakūr",
            "Naksalbāri",
            "Nakodar",
            "Najībābād",
            "Nainwa",
            "Nainpur",
            "Naini Tāl",
            "Naihāti",
            "Nahorkatiya",
            "Nāhan",
            "Nagpur",
            "Nāgod",
            "Nagīna",
            "Nāgercoil",
            "Nagda",
            "Nāgaur",
            "Nāgar Karnūl",
            "Nagari",
            "Nagar",
            "Nāgappattinam",
            "Nāgamangala",
            "Naduvannūr",
            "Nadiād",
            "Nādbai",
            "Nādāpuram",
            "Nabīnagar",
            "Nābha",
            "Mysore",
            "Muzaffarpur",
            "Muzaffarnagar",
            "Mūvattupula",
            "Muttupet",
            "Mussoorie",
            "Musiri",
            "Mushābani",
            "Murwāra",
            "Murtajāpur",
            "Murshidābād",
            "Murlīganj",
            "Morinda",
            "Murbād",
            "Murādnagar",
            "Munnar",
            "Monghyr",
            "Mungeli",
            "Mungaoli",
            "Mūndwa",
            "Mundra",
            "Mundgod",
            "Mundargi",
            "Multai",
            "Mūlki",
            "Mulgund",
            "Mulbāgal",
            "Muluppilagadu",
            "Mūl",
            "Muktsar",
            "Mukher",
            "Mukeriān",
            "Muhammadābād",
            "Muhammadābād",
            "Muhammadābād",
            "Mughal Sarāi",
            "Mudkhed",
            "Mudhol",
            "Mudgal",
            "Muddebihāl",
            "Mūdbidri",
            "Mubārakpur",
            "Mothīhāri",
            "Morwa",
            "Morsi",
            "Morena",
            "Morbi",
            "Morār",
            "Moram",
            "Morādābād",
            "Mon",
            "Mokokchūng",
            "Mokameh",
            "Moirāng",
            "Moga",
            "Modāsa",
            "Misrikh",
            "Mirzāpur",
            "Miriālgūda",
            "Mīrganj",
            "Mīrānpur Katra",
            "Mīrānpur",
            "Mīnjūr",
            "Milak",
            "Mihona",
            "Mhāsvād",
            "Mettur",
            "Mettupalayam",
            "Merta",
            "Mendarda",
            "Memāri",
            "Melur",
            "Mehndāwal",
            "Mehekar",
            "Meerut",
            "Medinīpur",
            "Medak",
            "Mayiladuthurai",
            "Mayāng Imphāl",
            "Mawāna",
            "Mavoor",
            "Māvelikara",
            "Maur",
            "Mauganj",
            "Maudaha",
            "Mau Aimma",
            "Mau",
            "Mau",
            "Mattanūr",
            "Mathura",
            "Mātābhānga",
            "Masaurhi Buzurg",
            "Marmagao",
            "Mārkāpur",
            "Mariāni",
            "Mariāhu",
            "Marhaura",
            "Margherita",
            "Marakkanam",
            "Mārahra",
            "Māpuca",
            "Mānwat",
            "Mānvi",
            "Manthani",
            "Mānsa",
            "Mānsa",
            "Manoharpur",
            "Mannargudi",
            "Mannārakkāt",
            "Manmād",
            "Mankāchar",
            "Mājalgaon",
            "Manjhanpur",
            "Manjeri",
            "Manihāri",
            "Maniar",
            "Mangrūl Pīr",
            "Māngrol",
            "Māngrol",
            "Manglaur",
            "Mangalore",
            "Mangaldai",
            "Mangalagiri",
            "Maner",
            "Mandya",
            "Māndvi",
            "Māndvi",
            "Māndu",
            "Mandsaur",
            "Mandlā",
            "Mandi",
            "Mandāwar",
            "Mandapeta",
            "Mandapam",
            "Māndalgarh",
            "Māndal",
            "Mancherāl",
            "Manāwar",
            "Mānāvadar",
            "Manāsa",
            "Manapparai",
            "Manamadurai",
            "Manali",
            "Mālvan",
            "Mālūr",
            "Mālpura",
            "Malpe",
            "Mallasamudram",
            "Malkāpur",
            "Malakanagiri",
            "Malīhābād",
            "Māler Kotla",
            "Mālegaon",
            "Malavalli",
            "Malaut",
            "Malappuram",
            "Mākum",
            "Maksi",
            "Makrāna",
            "Mairwa",
            "Mainpuri",
            "Maināguri",
            "Maihar",
            "Mahwah",
            "Mahudha",
            "Maholi",
            "Mahobā",
            "Mahmudābād",
            "Mahīshādal",
            "Mahgawān",
            "Maheshwar",
            "Mahendragarh",
            "Mahemdāvād",
            "Mahē",
            "Mahbūbnagar",
            "Mahbūbābād",
            "Mahāsamund",
            "Mahārāganj",
            "Mahārājgani",
            "Maham",
            "Mahālingpur",
            "Mahād",
            "Maghar",
            "Māgadi",
            "Madurāntakam",
            "Madurai",
            "Madukkūr",
            "Madukkarai",
            "Chennai",
            "Madikeri",
            "Madhyamgram",
            "Madhupur",
            "Maddagiri",
            "Madhubani",
            "Madhipura",
            "Madgaon",
            "Maddūr",
            "Madanapalle",
            "Machilīpatnam",
            "Machhlīshahr",
            "Māchhīwāra",
            "Mācherla",
            "Lunglei",
            "Lūnāvāda",
            "Ludhiāna",
            "Lucknow",
            "Luckeesarai",
            "Losal",
            "Loni",
            "Lonavla",
            "Lonār",
            "Lohārdaga",
            "Lingsugūr",
            "Limbdi",
            "Leteri",
            "Leh",
            "Lāwar Khās",
            "Laungowāl",
            "Latur",
            "Lāthi",
            "Lātehār",
            "Lar",
            "Lālsot",
            "Lālpur",
            "Lalitpur",
            "Lalgudi",
            "Lālgola",
            "Lālganj",
            "Lālganj",
            "Lakshmeshwar",
            "Laksar",
            "Lakhyabad",
            "Lakhnādon",
            "Lakhīmpur",
            "Lākheri",
            "Lāharpur",
            "Lahār",
            "Lādwa",
            "Lādnūn",
            "Lachhmangarh Sīkar",
            "Kuzhithurai",
            "Koothanallur",
            "Kuttampuzha",
            "Kutiyāna",
            "Kutiatodu",
            "Kushtagi",
            "Kurinjippādi",
            "Kurduvādi",
            "Kurandvād",
            "Kuppam",
            "Kunnamkulam",
            "Kunnamangalam",
            "Kunigal",
            "Kundla",
            "Kundgol",
            "Kundarkhi",
            "Kunda",
            "Kumta",
            "Kūmher",
            "Kumhāri",
            "Kumbhrāj",
            "Kumbakonam",
            "Kulu",
            "Kulti",
            "Kulpahār",
            "Kulittalai",
            "Kulgam",
            "Kukshi",
            "Kūkatpalli",
            "Kuju",
            "Kūdligi",
            "Kudachi",
            "Kuchera",
            "Kuchāman",
            "Kuchaiburi",
            "Krishnarājpet",
            "Krishnanagar",
            "Krishnagiri",
            "Kozhikode",
            "Koynanagar",
            "Kovvūr",
            "Kovūr",
            "Kovilpatti",
            "Kottūru",
            "Kottayam",
            "Kottagūdem",
            "Kotputli",
            "Kotma",
            "Kotdwāra",
            "Kotapārh",
            "Kotamangalam",
            "Kotagiri",
            "Kota",
            "Kotā",
            "Kosigi",
            "Kosi",
            "Kosamba",
            "Korwai",
            "Koregaon",
            "Korba",
            "Koratla",
            "Korāput",
            "Koppal",
            "Kopargaon",
            "Kopāganj",
            "Konnūr",
            "Konnagar",
            "Kondapalle",
            "Kondagaon",
            "Konch",
            "Konārka",
            "Kolasib",
            "Kollegāl",
            "Kolhāpur",
            "Kolāras",
            "Kolār",
            "Colachel",
            "Kokrajhar",
            "Kohima",
            "Koelwār",
            "Kodungallūr",
            "Kodoli",
            "Kodīnar",
            "Kodarmā",
            "Kodār",
            "Kodaikānāl",
            "Koch Bihār",
            "Koāth",
            "Kizhake Chālakudi",
            "Kithor",
            "Kishtwār",
            "Kishangarh",
            "Kishanganj",
            "Kīratpur",
            "Kiraoli",
            "Kinwat",
            "Kichha",
            "Khūtār",
            "Khurja",
            "Khurda",
            "Khurai",
            "Khunti",
            "Khuldābād",
            "Khowai",
            "Khopoli",
            "Khirkiyān",
            "Khilchipur",
            "Khetri",
            "Khetia",
            "Kheri",
            "Kherālu",
            "Khekra",
            "Khed Brahma",
            "Kheda",
            "Khātra",
            "Khatīma",
            "Khātegaon",
            "Khatauli",
            "Khārupatia",
            "Kharsia",
            "Kharkhauda",
            "Khargone",
            "Khardah",
            "Kharar",
            "Kharakvasla",
            "Kharagpur",
            "Kharagpur",
            "Khāpa",
            "Khanna",
            "Khandwa",
            "Khandela",
            "Khānāpur",
            "Khammam",
            "Khāmgaon",
            "Khambhāt",
            "Khambhāliya",
            "Khamaria",
            "Khalīlābād",
            "Khajurāho",
            "Khairāgarh",
            "Khairāgarh",
            "Khairābād",
            "Khair",
            "Khagaul",
            "Khagaria",
            "Khadki",
            "Khada",
            "Khāchrod",
            "Kesinga",
            "Keshorai Pātan",
            "Keshod",
            "Kerūr",
            "Kendrāparha",
            "Kenda",
            "Kemrī",
            "Kekri",
            "Kāyankulam",
            "Kayalpattinam",
            "Kawardha",
            "Kāvali",
            "Kattivākkam",
            "Kattanam",
            "Kātrās",
            "Kātpādi",
            "Kātoya",
            "Kātol",
            "Katihar",
            "Kathua",
            "Kāthor",
            "Katghora",
            "Katangi",
            "Katangi",
            "Kasrāwad",
            "Kashipur",
            "Kāsganj",
            "Kāsaragod",
            "Karwar",
            "Karur",
            "Kartārpur",
            "Kārsiyāng",
            "Karol Bāgh",
            "Karnāl",
            "Karmāla",
            "Kārkala",
            "Karjat",
            "Karīmnagar",
            "Karīmganj",
            "Karhal",
            "Karera",
            "Kareli",
            "Karauli",
            "Kāranja",
            "Karamsad",
            "Kāramadai",
            "Kāraikkudi",
            "Kāraikāl",
            "Karād",
            "Kapūrthala",
            "Kāpren",
            "Kapadvanj",
            "Kānth",
            "Kantābānji",
            "Kānt",
            "Kanpur",
            "Kannod",
            "Kanniyākumāri",
            "Kannauj",
            "Kānnangād",
            "Kannad",
            "Kānker",
            "Kānke",
            "Kankauli",
            "Kanigiri",
            "Kangayam",
            "Kandukūr",
            "Kāndla",
            "Kāndi",
            "Kāndhla",
            "Kānchipuram",
            "Kanakapura",
            "Kāmthi",
            "Kampli",
            "Cumbum",
            "Kāmārhāti",
            "Kāmāreddi",
            "Kāman",
            "Kamalganj",
            "Kāmākhyānagar",
            "Kalyani",
            "Kalyān",
            "Kalugumalai",
            "Kālpi",
            "Kalpetta",
            "Kālol",
            "Kālna",
            "Kalmeshwar",
            "Kallidaikurichchi",
            "Kallakkurichchi",
            "Kālka",
            "Kāliyāganj",
            "Kālimpong",
            "Kalghatgi",
            "Kālāvad",
            "Kālānwāli",
            "Kalānaur",
            "Kalamnūri",
            "Kalamb",
            "Kalakkādu",
            "Kakrāla",
            "Kākori",
            "Kākināda",
            "Kakching",
            "Kaithal",
            "Kairāna",
            "Kaimori",
            "Kaimganj",
            "Kailāshahar",
            "Kailāras",
            "Kaikalūr",
            "Kāgal",
            "Kadūr",
            "Kadod",
            "Kadiri",
            "Kadi",
            "Kadayanallur",
            "Kānchrāpāra",
            "Kachhwa",
            "Kabrāi",
            "Junnar",
            "Jūnāgarh",
            "Jūnāgadh",
            "Jumri Tilaiyā",
            "Jalandhar",
            "Jugsālai",
            "Jorhāt",
            "Jora",
            "Jolārpettai",
            "Jogbani",
            "Jodiya Bandar",
            "Jodhpur",
            "Jodhpur",
            "Jintūr",
            "Jīnd",
            "Jhūsi",
            "Jhunjhunūn",
            "Jhinjhāna",
            "Jhīnjhak",
            "Jhārsuguda",
            "Jharia",
            "Jhārgrām",
            "Jhānsi",
            "Jhanjhārpur",
            "Jhālu",
            "Jhālrapātan",
            "Jhalida",
            "Jhālāwār",
            "Jhajjar",
            "Jhā Jhā",
            "Jhābua",
            "Jewar",
            "Jevargi",
            "Jetpur",
            "Jeypore",
            "Jaynagar",
            "Jaynagar-Majilpur",
            "Jayamkondacholapuram",
            "Jāwad",
            "Jaunpur",
            "Jatāra",
            "Jatani",
            "Jaswantnagar",
            "Jaspur",
            "Jasidih",
            "Jashpurnagar",
            "Jasdan",
            "Jarwal",
            "Jaorā",
            "Jānsath",
            "Jānjgīr",
            "Jangipur",
            "Jangaon",
            "Jandiāla",
            "Jāmuria",
            "Jamūī",
            "Jāmtāra",
            "Jamshedpur",
            "Jāmnagar",
            "Jammu",
            "Jammalamadugu",
            "Jamkhandi",
            "Jambusar",
            "Jamālpur",
            "Jāmai",
            "Jāmadoba",
            "Jalpāiguri",
            "Jalor",
            "Jālna",
            "Jalgaon Jamod",
            "Jalgaon",
            "Jaleshwar",
            "Jalesar",
            "Jālaun",
            "Jalālpur",
            "Jalālpur",
            "Jalālī",
            "Jalālābād",
            "Jalālābad",
            "Jalālābād",
            "Jājpur",
            "Jaito",
            "Jaitāran",
            "Jaisingpur",
            "Jaisalmer",
            "Jais",
            "Jaipur",
            "Jahāzpur",
            "Jahāngīrābād",
            "Jahānābād",
            "Jagtiāl",
            "Jagraon",
            "Jaggayyapeta",
            "Jagdīspur",
            "Jagdīshpur",
            "Jagdalpur",
            "Jagatsinghapur",
            "Jagalūr",
            "Jagādhri",
            "Jabalpur",
            "Itimādpur",
            "Itārsi",
            "Itānagar",
            "Islāmpur",
            "Islāmpur",
            "Islāmnagar",
            "Irugūr",
            "Irinjālakuda",
            "Iringal",
            "Ingrāj Bāzār",
            "Indri",
            "Indore",
            "Indi",
            "Indergarh",
            "Indāpur",
            "Imphal",
            "Ilkal",
            "Igatpuri",
            "Idappadi",
            "Ichchāpuram",
            "Ichalkaranji",
            "Hyderabad",
            "Hadagalli",
            "Husainābād",
            "Hunsūr",
            "Hungund",
            "Hukeri",
            "Hugli",
            "Hubli",
            "Howli",
            "Hosūr",
            "Hospet",
            "Hoskote",
            "Hoshangābād",
            "Hosdurga",
            "Honnāli",
            "Honāvar",
            "Homnābād",
            "Hole Narsipur",
            "Holalkere",
            "Hojāi",
            "Hodal",
            "Hisuā",
            "Hisar",
            "Hiriyūr",
            "Hirekerūr",
            "Hīrākud",
            "Hinjilikatu",
            "Hingoli",
            "Hinganghāt",
            "Hindupur",
            "Hindoria",
            "Hindaun",
            "Himatnagar",
            "Hilsa",
            "Hazārībāg",
            "Hāveri",
            "Hatta",
            "Hāthras",
            "Hastināpur",
            "Hassan",
            "Hāsimāra",
            "Hasanpur",
            "Harūr",
            "Harsūd",
            "Harpanahalli",
            "Harpālpur",
            "Hārij",
            "Harihar",
            "Haridwar",
            "Hardoī",
            "Harda Khās",
            "Hāpur",
            "Hāora",
            "Hanumāngarh",
            "Hānsi",
            "Hāngal",
            "Handiā",
            "Hamīrpur",
            "Hamīrpur",
            "Halvad",
            "Hālol",
            "Haliyal",
            "Hālīsahar",
            "Haldwani",
            "Haldaur",
            "Hājo",
            "Hājīpur",
            "Hailākāndi",
            "Hāflong",
            "Hadgāon",
            "Hābra",
            "Gwalior",
            "Guskhara",
            "Guruvāyūr",
            "Guru Har Sahāi",
            "Gursarāi",
            "Gursahāiganj",
            "Gurmatkāl",
            "Gurgaon",
            "Gunupur",
            "Guntūr",
            "Guntakal Junction",
            "Gunnaur",
            "Gundlupet",
            "Guna",
            "Gummidipundi",
            "Gumla",
            "Gumia",
            "Guledagudda",
            "Gulbarga",
            "Gulāothi",
            "Gulābpura",
            "Gūduvāncheri",
            "Gūdūr",
            "Gudiyatham",
            "Gudivāda",
            "Gudalur",
            "Gubbi",
            "Goyerkāta",
            "Govardhan",
            "Gosāba",
            "Gorakhpur",
            "Gorakhpur",
            "Gobichettipalayam",
            "Gopālganj",
            "Gondiā",
            "Gondal",
            "Gondā City",
            "Gomoh",
            "Gola Gokarannāth",
            "Golāghāt",
            "Gokarna",
            "Gokak",
            "Gohāna",
            "Gohadi",
            "Godhra",
            "Godda",
            "Gobindpur",
            "Gobārdānga",
            "Goālpāra",
            "Girīdīh",
            "Gingee",
            "Giddarbāha",
            "Giddalūr",
            "Ghugus",
            "Ghoti Budrukh",
            "Ghosī",
            "Ghazīpur",
            "Ghāziābād",
            "Ghātsīla",
            "Ghātanji",
            "Ghātampur",
            "Ghātāl",
            "Gharaunda",
            "Gevrai",
            "Gaya",
            "Gauripur",
            "Goribidnūr",
            "Guwahati",
            "Garhwa",
            "Garui",
            "Gariadhar",
            "Garhshankar",
            "Garhmuktesar",
            "Garhākota",
            "Gannavaram",
            "Gangtok",
            "Gangolli",
            "Gangoh",
            "Gangāwati",
            "Gangārāmpur",
            "Gangāpur",
            "Gangāpur",
            "Gangāpur",
            "Gangānagar",
            "Gangākher",
            "Ghandinagar",
            "Gāndhīdhām",
            "Gandevi",
            "Gāndarbal",
            "Gajraula",
            "Gajendragarh",
            "Gadwāl",
            "Gadhinglaj",
            "Gadhada",
            "Gādarwāra",
            "Gadag",
            "Fort Gloster",
            "Forbesganj",
            "Fīrozpur Jhirka",
            "Ferozepore",
            "Fīrozābād",
            "Ferokh",
            "Fāzilka",
            "Fatwa",
            "Fatehpur Sīkri",
            "Fatehpur",
            "Fatehpur",
            "Fatehpur",
            "Fatehgarh Chūriān",
            "Fatehganj West",
            "Fatehābād",
            "Fatehābād",
            "Farrukhnagar",
            "Farrukhābād",
            "Farīdpur",
            "Farīdkot",
            "Farīdābād",
            "Farakka",
            "Fālākāta",
            "Faizpur",
            "Fyzābād",
            "Etāwah",
            "Erraguntla",
            "Erode",
            "Erāttupetta",
            "Erandol",
            "Emmiganūr",
            "Ellore",
            "Elūr",
            "Ellenabad",
            "Elamanchili",
            "Egra",
            "Dwārka",
            "Durgapur",
            "Durgāpur",
            "Durg",
            "Dūngarpur",
            "Ganj Dundwāra",
            "Dumraon",
            "Dumra",
            "Dumka",
            "Dum Duma",
            "Dam Dam",
            "Duliāgaon",
            "Dugda",
            "Dubrājpur",
            "Dornakal",
            "Dorāha",
            "Dongargarh",
            "Dondaicha",
            "Dombivli",
            "Dod Ballāpur",
            "Doda",
            "Diu",
            "Dīsa",
            "Diphu",
            "Dīnhāta",
            "Dindori",
            "Dindigul",
            "Dīnānagar",
            "Dimāpur",
            "Digras",
            "Dīglūr",
            "Dighwāra",
            "Digboi",
            "Dīg",
            "Dīdwāna",
            "Dicholi",
            "Dibrugarh",
            "Dibai",
            "Diamond Harbour",
            "Dhūri",
            "Dhupgāri",
            "Dhuliān",
            "Dhūlia",
            "Dhuburi",
            "Dhrol",
            "Dhrāngadhra",
            "Dhorāji",
            "Dhone",
            "Dholka",
            "Dhing",
            "Dhenkānāl",
            "Dhekiajuli",
            "Dhaurahra",
            "Dhaulpur",
            "Dhārūr",
            "Dhāruhera",
            "Dharmsāla",
            "Dharmavaram",
            "Dharmapuri",
            "Dharmanagar",
            "Dharmadam",
            "Dharmābād",
            "Dhāriwāl",
            "Dhāri",
            "Dharapuram",
            "Dharangaon",
            "Dharampur",
            "Dhār",
            "Dhanera",
            "Dhandhuka",
            "Dhanbād",
            "Dhanaura",
            "Dhanaula",
            "Dhamtari",
            "Dhāmpur",
            "Dhāmnod",
            "Dhāka",
            "Dewas",
            "Deoli",
            "Devgarh",
            "Devgadh Bāriya",
            "Devarkonda",
            "Devanhalli",
            "Devakottai",
            "Deūlgaon Rāja",
            "Deshnoke",
            "Depālpur",
            "Deori Khās",
            "Deoria",
            "Deoraniān",
            "Deoli",
            "Deolāli",
            "Deogarh",
            "Deoband",
            "Denkanikota",
            "Delhi",
            "Dehri",
            "Dehra Dūn",
            "Dausa",
            "Daund",
            "Daudnagar",
            "Dattāpur",
            "Datia",
            "Dātāganj",
            "Dasūya",
            "Dāsna",
            "Daryāpur",
            "Dārwha",
            "Dārjiling",
            "Darbhanga",
            "Dandeli",
            "Dinapore",
            "Damoh",
            "Dāmnagar",
            "Daman",
            "Daltonganj",
            "Dalsingh Sarai",
            "Dalkola",
            "Dākor",
            "Dohad",
            "Dahegām",
            "Dāhānu",
            "Dādri",
            "Dabwāli",
            "Dabra",
            "Daboh",
            "Dabhoi",
            "Cuttack",
            "Curchorem",
            "Cuncolim",
            "Cumbum",
            "Cuddapah",
            "Cuddalore",
            "Coondapoor",
            "Colonelganj",
            "Colgong",
            "Calangute",
            "Coimbatore",
            "Cochin",
            "Clement Town",
            "Chūru",
            "Churāchāndpur",
            "Chunār",
            "Chotila",
            "Chopda",
            "Chodavaram",
            "Rampachodavaram",
            "Chittūr",
            "Chittaurgarh",
            "Chittaranjan",
            "Chitradurga",
            "Chītāpur",
            "Chidawa",
            "Chīrāla",
            "Chīpurupalle",
            "Chiplūn",
            "Chintāmani",
            "Chinna Salem",
            "Chinnamanūr",
            "Chincholi",
            "Chillupār",
            "Chilakalūrupet",
            "Chikodi",
            "Chiknāyakanhalli",
            "Chikmagalūr",
            "Chikhli",
            "Chik Ballāpur",
            "Chidambaram",
            "Chicholi",
            "Chhoti Sādri",
            "Chhota Udepur",
            "Chhindwāra",
            "Chhibrāmau",
            "Chhatarpur",
            "Chhātāpur",
            "Chhāta",
            "Chharra",
            "Chhaprauli",
            "Chāpra",
            "Chhāpar",
            "Chhala",
            "Chhabra",
            "Chettipālaiyam",
            "Chetput",
            "Chennimalai",
            "Chengannūr",
            "Chengam",
            "Chengalpattu",
            "Chāvakkād",
            "Chaksu",
            "Chatrapur",
            "Chatra",
            "Chās",
            "Charthāwal",
            "Charkhi Dādri",
            "Charkhāri",
            "Chāpar",
            "Channarāyapatna",
            "Channapatna",
            "Channagiri",
            "Changanācheri",
            "Chāndor",
            "Chāndūr Bāzār",
            "Chāndūr",
            "Chāndur",
            "Chānda",
            "Chandrakona",
            "Chāndpur",
            "Chandigarh",
            "Chanderi",
            "Chanduasi",
            "Chandauli",
            "Chandannagar",
            "Chānasma",
            "Chamrajnagar",
            "Chāmpa",
            "Chamba",
            "Challapalle",
            "Challakere",
            "Chālisgaon",
            "Chalāla",
            "Chakradharpur",
            "Chaklāsi",
            "Chākia",
            "Chākan",
            "Chāībāsa",
            "Canning",
            "Cannanore",
            "Kolkata",
            "Byādgi",
            "Buxar",
            "Burla",
            "Burhar",
            "Burhānpur",
            "Būndu",
            "Būndi",
            "Buldāna",
            "Bulandshahr",
            "Budhlāda",
            "Budhāna",
            "Budaun",
            "Brājarājnagar",
            "Brahmapur",
            "Botād",
            "Borsad",
            "Borivli",
            "Bongaigaon",
            "Mumbai",
            "Bolpur",
            "Bokāro",
            "Bokajān",
            "Boisar",
            "Bodināyakkanūr",
            "Buddh Gaya",
            "Bodhan",
            "Bobbili",
            "Biswān",
            "Bissāu",
            "Bishnupur",
            "Bisauli",
            "Bīsalpur",
            "Birūr",
            "Bīrpur",
            "Birmitrapur",
            "Binka",
            "Bindki",
            "Etāwa",
            "Bilthra",
            "Bilsi",
            "Bilsanda",
            "Bilimora",
            "Bilhaur",
            "Bilgrām",
            "Bilgi",
            "Bīlāspur",
            "Bilāspur",
            "Bilāsipāra",
            "Bilāri",
            "Bilāra",
            "Bikramganj",
            "Bīkaner",
            "Bijnor",
            "Bijbiāra",
            "Bijāwar",
            "Bijapur",
            "Bihār",
            "Bihārīganj",
            "Bidhūna",
            "Bīdar",
            "Biaora",
            "Bhuvanagiri",
            "Bhusāval",
            "Bhūm",
            "Bhuj",
            "Bhudgaon",
            "Bhubaneshwar",
            "Bhuban",
            "Bhor",
            "Bhopal",
            "Bhongīr",
            "Bhongaon",
            "Bhogpur",
            "Bhiwāni",
            "Bhiwandi",
            "Bhitarwār",
            "Bhīnmāl",
            "Bhinga",
            "Bhindār",
            "Bhind",
            "Bhīmunipatnam",
            "Bhīmavaram",
            "Bhīlwāra",
            "Bhilai",
            "Bhīkhi",
            "Bhikangaon",
            "Bhāyāvadar",
            "Bhayandar",
            "Bhawānipatna",
            "Bhawānīgarh",
            "Bhawāniganj",
            "Bhāvnagar",
            "Bhavāni",
            "Bhattiprolu",
            "Bhātpāra",
            "Bhatkal",
            "Bhatinda",
            "Bhātāpāra",
            "Bhasāwar",
            "Bharwāri",
            "Bharūch",
            "Bharthana",
            "Bharatpur",
            "Bhānvad",
            "Bhānpurī",
            "Bhānpura",
            "Bhanjanagar",
            "Bhānder",
            "Bhandāra",
            "Bhālki",
            "Bhaisa",
            "Bhainsdehi",
            "Bhāgalpur",
            "Bhadreswar",
            "Bhadrāvati",
            "Bhadrakh",
            "Bhadrāchalam",
            "Bhādra",
            "Bhadohi",
            "Bhadaur",
            "Bhādāsar",
            "Bhachāu",
            "Bhabhua",
            "Beypore",
            "Bewar",
            "Betūl",
            "Bettiah",
            "Betamcherla",
            "Beri Khās",
            "Berasia",
            "Beohāri",
            "Bemetāra",
            "Belūr",
            "Belsand",
            "Belonia",
            "Bellary",
            "Belgaum",
            "Beldānga",
            "Bela",
            "Behror",
            "Behat",
            "Begusarai",
            "Begūn",
            "Begamganj",
            "Bedi",
            "Beāwar",
            "Bāzpur",
            "Bayāna",
            "Bawāna",
            "Bauda",
            "Batāla",
            "Baswa",
            "Bāsudebpur",
            "Bastī",
            "Bāsoda",
            "Basni",
            "Basmat",
            "Basi",
            "Basi",
            "Basi",
            "Basavana Bāgevādi",
            "Basavakalyān",
            "Barwāni",
            "Barwāla",
            "Bāruni",
            "Bāruipur",
            "Bārsi",
            "Barpeta",
            "Barpāli",
            "Barnāla",
            "Bārmer",
            "Barki Saria",
            "Barka Kāna",
            "Barjala",
            "Bari Sādri",
            "Bāri",
            "Barhiya",
            "Bārh",
            "Bargi",
            "Bargarh",
            "Bareilly",
            "Bārdoli",
            "Barddhamān",
            "Bar Bigha",
            "Baraut",
            "Barauli",
            "Bārāsat",
            "Bārāsat",
            "Baranagar",
            "Bārān",
            "Bāramūla",
            "Bārāmati",
            "Bārākpur",
            "Bāpatla",
            "Banūr",
            "Bantvāl",
            "Bāntva",
            "Bānswāra",
            "Bānswāda",
            "Bānsi",
            "Bānsdīh",
            "Bānsbāria",
            "Bannūr",
            "Banmankhi",
            "Bānkura",
            "Bānki",
            "Bānka",
            "Bāngarmau",
            "Bangārapet",
            "Bangaon",
            "Bangaon",
            "Banganapalle",
            "Bengaluru",
            "Banga",
            "Bandipura",
            "Bāndīkūi",
            "Bānda",
            "Banda",
            "Banat",
            "Bānapur",
            "Bāmor Kalān",
            "Bālurghāt",
            "Bālugaon",
            "Balrāmpur",
            "Bālotra",
            "Baloda Bāzār",
            "Balod",
            "Bāli",
            "Ballālpur",
            "Bāli",
            "Balasore",
            "Balarāmpur",
            "Bālāpur",
            "Balāngīr",
            "Bālāghāt",
            "Bālāchor",
            "Bakhtiyārpur",
            "Baj Baj",
            "Bairāgnia",
            "Byndoor",
            "Bail-Hongal",
            "Baihar",
            "Baidyabāti",
            "Bahraigh",
            "Bahjoi",
            "Baheri",
            "Baharampur",
            "Bahādurgarh",
            "Bahādurganj",
            "Bāh",
            "Bagulā",
            "Bāghpat",
            "Bāghdogra",
            "Bāgha Purāna",
            "Bāgepalli",
            "Bagasra",
            "Bagar",
            "Bagalkot",
            "Bagaha",
            "Bagaha",
            "Badvel",
            "Badūria",
            "Badnāwar",
            "Badlapur",
            "Bādāmi",
            "Badagara",
            "Bada Barabīl",
            "Bachhraon",
            "Babrāla",
            "Bābra",
            "Babīna",
            "Baberu",
            "Bābai",
            "Azamgarh",
            "Ajodhya",
            "Ayakudi",
            "Avanigadda",
            "Avinashi",
            "Āvadi",
            "Ausa",
            "Aurangābād",
            "Aurangabad",
            "Auraiya",
            "Aurād",
            "Attur",
            "Attingal",
            "Attili",
            "Atraulī",
            "Atmakūr",
            "Adirampattinam",
            "Athni",
            "Āthagarh",
            "Atarra",
            "Āsind",
            "Āsika",
            "Asifābād",
            "Ashta",
            "Ashta",
            "Ashoknagar",
            "Āsansol",
            "Āsandh",
            "Ārvi",
            "Aruppukkottai",
            "Arumuganeri",
            "Arukutti",
            "Arsikere",
            "Āron",
            "Arkalgūd",
            "Ariyalūr",
            "Arcot",
            "Arāria",
            "Arantāngi",
            "Ārani",
            "Ārangaon",
            "Arang",
            "Arāmbāgh",
            "Arakkonam",
            "Arrah",
            "Aonla",
            "Anūpshahr",
            "Anūppur",
            "Anūpgarh",
            "Anta",
            "Anshing",
            "Annur",
            "Annigeri",
            "Ankleshwar",
            "Anjār",
            "Anjangaon",
            "Anjad",
            "Angul",
            "Angamāli",
            "Anekal",
            "Andol",
            "Anthiyur",
            "Āndippatti",
            "Anantnag",
            "Anantapur",
            "Anandpur",
            "Ānand",
            "Anakāpalle",
            "Anaimalai",
            "Amudālavalasa",
            "Āmta",
            "Amroli",
            "Amroha",
            "Amritsar",
            "Amreli",
            "Amrāvati",
            "Amod",
            "Āmli",
            "Āmlāgora",
            "Amla",
            "Amet",
            "Ambur",
            "Ambikāpur",
            "Ambattūr",
            "Ambasamudram",
            "Ambāla",
            "Ambājogāi",
            "Ambāh",
            "Ambad",
            "Amarpur",
            "Amarpātan",
            "Amarnāth",
            "Amalner",
            "Amalāpuram",
            "Aluva",
            "Alwar",
            "Alot",
            "Along",
            "Alnāvar",
            "Almora",
            "Alleppey",
            "Allahābād",
            "Alīpur",
            "Alīgarh",
            "Alīganj",
            "Alībāg",
            "Ālangulam",
            "Ālangāyam",
            "Alandur",
            "Alandi",
            "Aland",
            "Akot",
            "Akola",
            "Aklera",
            "Akivīdu",
            "Akbarpur",
            "Akbarpur",
            "Akaltara",
            "Akalkot",
            "Ajra",
            "Ajnāla",
            "Ajmer",
            "Aizawl",
            "Ahraura",
            "Ahmadpur",
            "Ahmadnagar",
            "Ahmedabad",
            "Āgra",
            "Agartala",
            "Agar",
            "Afzalpur",
            "Afzalgarh",
            "Adūr",
            "Adra",
            "Ādoni",
            "Ādilābād",
            "Addanki",
            "Achhnera",
            "Achalpur",
            "Ābu Road",
            "Ābu",
            "Abohar",
            "Abhayāpuri",
            "Contai",
            "Haldia",
            "Srirāmpur",
            "Dumjor",
            "Bankra",
            "Chakapara",
            "Mahiari",
            "Dhulagari",
            "Pānchla",
            "Nangi",
            "Pujali",
            "Monoharpur",
            "Nabagrām",
            "Soyībug",
            "Singāpur",
            "Ghatkesar",
            "Vijayapura",
            "Ādampur",
            "Porur",
            "Madipakkam",
            "Perungudi",
            "Madambakkam",
            "Powai",
            "Navi Mumbai",
            "Murudeshwara",
            "Shivaji Nagar",
            "Greater Noida",
            "Mohali",
            "Pithampur",
            "Barbil",
            "Airoli",
            "Aluva",
            "Kotkapura",
            "Muvattupuzha",
            "Perumbavoor",
            "Vapi",
            "Baddi",
            "Noida",
            "Bhiwadi",
            "Mandideep",
            "Singrauli",
            "Birpara",
            "Jaigaon",
            "Akkarampalle",
            "Bellampalli",
            "Chemmumiahpet",
            "Gaddi Annaram",
            "Dasnapur",
            "Kanuru",
            "Lal Bahadur Nagar",
            "Malkajgiri",
            "Mandamarri",
            "Chinnachowk",
            "Kyathampalle",
            "Gajuwaka",
            "Manuguru",
            "Kalyandurg",
            "Ponnur",
            "Quthbullapur",
            "Ramanayyapeta",
            "Palwancha",
            "Barpeta Road",
            "Sathupalli",
            "Yanamalakuduru",
            "Marigaon",
            "Naharlagun",
            "Serilingampalle",
            "Silapathar",
            "Lumding Railway Colony",
            "Aistala",
            "Ashoknagar Kalyangarh",
            "Bahula",
            "Bhawanipur",
            "Zira",
            "Ramagundam",
            "Cherpulassery",
            "Kirandul",
            "Shiraguppi",
            "V.S.K.Valasai (Dindigul-Dist.)",
            "Neelankarai",
            "Injambakkam",
            "Kultali",
            "Shahbazpur",
            "Kumbalam",
            "Aroor",
            "Kadakkavoor",
            "Kalavoor",
            "Kalamassery",
            "Cherthala"
        ],
        "Iraq" => [
            "Zaxo",
            "Umm Qaşr",
            "Tozkhurmato",
            "Tikrīt",
            "Tallkayf",
            "Sīnah",
            "Sāmarrā’",
            "Nāḩīyat Saddat al Hindīyah",
            "Ruwāndiz",
            "Rāwah",
            "Al-Hamdaniya",
            "Mandalī",
            "Koysinceq",
            "Kifrī",
            "Kirkuk",
            "Karbala",
            "Erbil",
            "Hīt",
            "Ḩalabjah",
            "Ḩadīthah",
            "Dihok",
            "Jamjamāl",
            "Bayjī",
            "Baqubah",
            "Baynjiwayn",
            "Balad",
            "Baghdad",
            "Az Zubayr",
            "Aş Şuwayrah",
            "As Sulaymānīyah",
            "As Samawah",
            "Nāḩiyat ash Shināfīyah",
            "Ash Shaţrah",
            "Ash Shāmīyah",
            "Ar Ruţbah",
            "Ar Rumaythah",
            "Ramadi",
            "‘Aqrah",
            "An Nāşirīyah",
            "Najaf",
            "‘Anat al Qadīmah",
            "Imam Qasim",
            "Al Musayyib",
            "Al Mishkhāb",
            "Al Miqdādīyah",
            "Al Mawşil al Jadīdah",
            "Mosul",
            "Al Kūt",
            "Kufa",
            "Khāliş",
            "‘Alī al Gharbī",
            "Al Hindīyah",
            "Al Ḩillah",
            "Al Ḩayy",
            "Al Hārithah",
            "Nahiyat Ghammas",
            "Nāḩiyat al Fuhūd",
            "Al Fāw",
            "Al Fallūjah",
            "Basrah",
            "Al ‘Azīzīyah",
            "Al ‘Amārah",
            "‘Afak",
            "Ad Dujayl",
            "Ad Dīwānīyah",
            "Abū Ghurayb",
            "Al Başrah al Qadīmah",
            "Sinjār"
        ],
        "Iran" => [
            "Āzādshahr",
            "Kahrīz",
            "Nūrābād",
            "Īstgāh-e Rāh Āhan-e Garmsār",
            "Qarchak",
            "Shahre Jadide Andisheh",
            "Khorramdarreh",
            "Yasuj",
            "Āzādshahr",
            "Zarand",
            "Zanjān",
            "Yazd",
            "Varāmīn",
            "Torbat-e Ḩeydarīyeh",
            "Tonekābon",
            "Tehran",
            "Hashtpar",
            "Tākestān",
            "Takāb",
            "Taft",
            "Tabriz",
            "Tabas",
            "Sonqor",
            "Sirjan",
            "Shūshtar",
            "Shūsh",
            "Shīrvān",
            "Shiraz",
            "Shahr-e Kord",
            "Shahr-e Bābak",
            "Shādegān",
            "Semnān",
            "Semīrom",
            "Sāveh",
            "Sari",
            "Saqqez",
            "Sanandaj",
            "Salmās",
            "Shāhīn Dezh",
            "Sabzevar",
            "Rūdsar",
            "Robāţ Karīm",
            "Rāvar",
            "Rasht",
            "Rāmshīr",
            "Rāmhormoz",
            "Rafsanjān",
            "Qūchān",
            "Qorveh",
            "Qom",
            "Qeshm",
            "Qazvin",
            "Qarah Ẕīā’ od Dīn",
            "Farrokh Shahr",
            "Qā’en",
            "Sarpol-e Z̄ahāb",
            "Pīshvā",
            "Piranshahr",
            "Pāveh",
            "Pārsābād",
            "Oshnavīyeh",
            "Orūmīyeh",
            "Omīdīyeh",
            "Nūrābād",
            "Nowshahr",
            "Nīshābūr",
            "Neyrīz",
            "Nekā",
            "Naz̧arābād",
            "Naqadeh",
            "Nahāvand",
            "Mīnāb",
            "Mīāndoāb",
            "Meybod",
            "Mahrīz",
            "Masjed Soleymān",
            "Bardsīr",
            "Mashhad",
            "Marand",
            "Malāyer",
            "Malārd",
            "Mahābād",
            "Langarūd",
            "Kūhdasht",
            "Kīsh",
            "Khvoy",
            "Khvānsār",
            "Khorramshahr",
            "Khorramabad",
            "Khomeyn",
            "Khalkhāl",
            "Kermānshāh",
            "Kerman",
            "Kāzerūn",
            "Kāshmar",
            "Kāshān",
            "Karaj",
            "Kangāvar",
            "Kāmyārān",
            "Kalāleh",
            "Jūybār",
            "Javānrūd",
            "Īlām",
            "Harsīn",
            "Hamadān",
            "Gorgān",
            "Gonbad-e Kāvūs",
            "Gonābād",
            "Golpāyegān",
            "Gerāsh",
            "Bandar-e Ganāveh",
            "Fūman",
            "Fīrūzābād",
            "Fereydūnkenār",
            "Fasā",
            "Fārsān",
            "Esfarāyen",
            "Shahrud",
            "Dogonbadan",
            "Delījān",
            "Dehlorān",
            "Dehdasht",
            "Sūsangerd",
            "Darreh Shahr",
            "Dārāb",
            "Dāmghān",
            "Damāvand",
            "Chenārān",
            "Chālūs",
            "Bandar-e Būshehr",
            "Būkān",
            "Borūjerd",
            "Borūjen",
            "Borāzjān",
            "Bojnūrd",
            "Bīrjand",
            "Bījār",
            "Bonāb",
            "Behshahr",
            "Behbahān",
            "Bāneh",
            "Bandar-e Lengeh",
            "Bandar-e Anzalī",
            "Bandar ‘Abbās",
            "Bam",
            "Bahār",
            "Bāfq",
            "Bābolsar",
            "Bābol",
            "Aznā",
            "Hashtrūd",
            "Āstārā",
            "Āstāneh-ye Ashrafīyeh",
            "Asadābād",
            "Ardestān",
            "Ardakān",
            "Ardabīl",
            "Arāk",
            "Āmol",
            "Alvand",
            "Shahrīār",
            "Alīgūdarz",
            "Aleshtar",
            "Akbarābād",
            "‘Ajab Shīr",
            "Ahvaz",
            "Ahar",
            "Aghajari",
            "Ābyek",
            "Abhar",
            "Ābdānān",
            "Ābādeh",
            "Abadan",
            "Eqbālīyeh",
            "Shāhreẕā",
            "Rehnān",
            "Qahderījān",
            "Najafābād",
            "Khomeynī Shahr",
            "Kelīshād va Sūdarjān",
            "Falāvarjān",
            "Isfahan",
            "Dowlatābād",
            "Dorcheh Pīāz",
            "Zābol",
            "Zahedan",
            "Torbat-e Jām",
            "Tāybād",
            "Sarakhs",
            "Qaşr-e Qand",
            "Khāsh",
            "Īrānshahr",
            "Chabahar",
            "Mahdishahr",
            "Pasragad Branch"
        ],
        "Iceland" => [
            "Akureyri",
            "Reykjavík",
            "Kópavogur",
            "Hafnarfjörður"
        ],
        "Italy" => [
            "Vittoria",
            "Villabate",
            "Vibo Valentia",
            "Trapani",
            "Termini Imerese",
            "Siracusa",
            "Sinnai",
            "Siderno",
            "Sestu",
            "Selargius",
            "Scordia",
            "Scicli",
            "Sciacca",
            "San Giovanni la Punta",
            "San Giovanni in Fiore",
            "San Cataldo",
            "Rossano Stazione",
            "Rosolini",
            "Ribera",
            "Reggio Calabria",
            "Ragusa",
            "Quattromiglia",
            "Quartu Sant'Elena",
            "Pozzallo",
            "Porto Empedocle",
            "Piazza Armerina",
            "Paternò",
            "Partinico",
            "Palmi",
            "Palma di Montechiaro",
            "Palermo",
            "Palagonia",
            "Pachino",
            "Oristano",
            "Noto",
            "Niscemi",
            "Nicastro-Sambiase",
            "Monserrato",
            "Monreale",
            "Modica",
            "Misterbianco",
            "Misilmeri",
            "Milazzo",
            "Messina",
            "Mazara del Vallo",
            "Mascalucia",
            "Marsala",
            "Licata",
            "Lentini",
            "Iglesias",
            "Gioia Tauro",
            "Giarre",
            "Gela",
            "Floridia",
            "Favara",
            "Enna",
            "Crotone",
            "Cosenza",
            "Comiso",
            "Catanzaro",
            "Catania",
            "Castrovillari",
            "Castelvetrano",
            "Casarano",
            "Carini",
            "Carbonia",
            "Canicattì",
            "Caltanissetta",
            "Caltagirone",
            "Cagliari",
            "Bronte",
            "Biancavilla",
            "Belpasso",
            "Barcellona Pozzo di Gotto",
            "Bagheria",
            "Avola",
            "Augusta",
            "Assemini",
            "Amato",
            "Alcamo",
            "Agrigento",
            "Adrano",
            "Acireale",
            "Aci Catena",
            "Aci Castello",
            "Zola Predosa",
            "Voghera",
            "Vittorio Veneto",
            "Viterbo",
            "Vimodrone",
            "Vimercate",
            "Lancenigo-Villorba",
            "Villaricca",
            "Villafranca di Verona",
            "Vignola",
            "Vigevano",
            "Vicenza",
            "Viareggio",
            "Verona",
            "Vercelli",
            "Ventimiglia",
            "Venice",
            "Venaria Reale",
            "Velletri",
            "Vasto",
            "Varese",
            "Valenzano",
            "Valenza",
            "Valdagno",
            "Udine",
            "Triggiano",
            "Trieste",
            "Trezzano sul Naviglio",
            "Treviso",
            "Treviglio",
            "Trentola-Ducenta",
            "Trento",
            "Trecate",
            "Trani",
            "Tradate",
            "Tortona",
            "Torremaggiore",
            "Torre del Greco",
            "Torre Annunziata",
            "Turin",
            "Tolentino",
            "Tivoli",
            "Thiene",
            "Terzigno",
            "Terracina",
            "Terni",
            "Termoli",
            "Terlizzi",
            "Teramo",
            "Taranto",
            "Suzzara",
            "Sulmona",
            "Spoleto",
            "Sora",
            "Sondrio",
            "Somma Vesuviana",
            "Siena",
            "Sezze",
            "Seveso",
            "Settimo Torinese",
            "Sestri Levante",
            "Sesto San Giovanni",
            "Sesto Fiorentino",
            "Seriate",
            "Seregno",
            "Senigallia",
            "Senago",
            "Segrate",
            "Schio",
            "Scandicci",
            "Scafati",
            "Savona",
            "Savigliano",
            "Sava",
            "Sassuolo",
            "Sassari",
            "Sarzana",
            "Saronno",
            "Sarno",
            "San Vito dei Normanni",
            "Santeramo in Colle",
            "Sant'Antonio Abate",
            "Sant'Antimo",
            "Sant'Anastasia",
            "Santa Maria Capua Vetere",
            "San Severo",
            "San Sebastiano",
            "San Salvo",
            "San Remo",
            "Sannicandro Garganico",
            "San Miniato",
            "San Miniato Basso",
            "San Mauro Torinese",
            "San Lazzaro",
            "San Giuseppe Vesuviano",
            "San Giuliano Milanese",
            "San Giovanni Valdarno",
            "San Giovanni Rotondo",
            "San Giovanni Lupatoto",
            "San Giovanni in Persiceto",
            "San Giorgio a Cremano",
            "San Donato Milanese",
            "San Donà di Piave",
            "San Bonifacio",
            "San Benedetto del Tronto",
            "Salsomaggiore Terme",
            "Salerno",
            "Sacile",
            "Ruvo di Puglia",
            "Rutigliano",
            "Rozzano",
            "Rovigo",
            "Rovereto",
            "Rosignano Solvay-Castiglioncello",
            "Roseto degli Abruzzi",
            "Romano di Lombardia",
            "Rome",
            "Rocca di Papa",
            "Rivoli",
            "Rimini",
            "Rieti",
            "Riccione",
            "Rho",
            "Reggio nell'Emilia",
            "Ravenna",
            "Rapallo",
            "Qualiano",
            "Putignano",
            "Prato",
            "Pozzuoli",
            "Potenza",
            "Porto Torres",
            "Porto Sant'Elpidio",
            "Porto San Giorgio",
            "Portogruaro",
            "Civitanova Marche",
            "Portici",
            "Pordenone",
            "Pontedera",
            "Pompei",
            "Pomigliano d'Arco",
            "Pomezia",
            "Poggiomarino",
            "Poggibonsi",
            "Pistoia",
            "Pisa",
            "Piossasco",
            "Piombino",
            "Pioltello",
            "Pinerolo",
            "Pietrasanta",
            "Piacenza",
            "Pescara",
            "Pesaro",
            "Perugia",
            "Pavia",
            "Parma",
            "Parabiago",
            "Palo del Colle",
            "Palazzolo sull'Oglio",
            "Palagiano",
            "Pagani",
            "Padova",
            "Paderno Dugnano",
            "Ottaviano",
            "Ostuni",
            "Osimo",
            "Orta Nova",
            "Orbassano",
            "Olbia",
            "Oderzo",
            "Nuoro",
            "Novi Ligure",
            "Novate Milanese",
            "Novara",
            "Nova Milanese",
            "Nola",
            "Noicattaro",
            "Noci",
            "Nocera Superiore",
            "Nocera Inferiore",
            "Nichelino",
            "Nettuno",
            "Nerviano",
            "Nardò",
            "Napoli",
            "Mugnano di Napoli",
            "Muggiò",
            "Monza",
            "Montichiari",
            "Montevarchi",
            "Montesilvano Marina",
            "Monterotondo",
            "Montemurlo",
            "Montecchio Maggiore-Alte Ceccato",
            "Montecatini-Terme",
            "Montebelluna",
            "Monopoli",
            "Monfalcone",
            "Mondragone",
            "Mondovì",
            "Moncalieri",
            "Molfetta",
            "Mola di Bari",
            "Mogliano Veneto",
            "Modugno",
            "Modena",
            "Mirano",
            "Mirandola",
            "Mira Taglio",
            "Minturno",
            "Milano",
            "Mestre",
            "Mesagne",
            "Merano",
            "Mentana",
            "Melzo",
            "Melito di Napoli",
            "Melegnano",
            "Meda",
            "Matera",
            "Massafra",
            "Massa",
            "Martina Franca",
            "Marino",
            "Marina di Carrara",
            "Marigliano",
            "Mariano Comense",
            "Marcianise",
            "Marano di Napoli",
            "Mantova",
            "Manfredonia",
            "Manduria",
            "Malnate",
            "Magenta",
            "Maddaloni",
            "Macerata",
            "Lugo",
            "Lucera",
            "Lucca",
            "Lodi",
            "Livorno",
            "Lissone",
            "Limbiate",
            "Lido di Ostia",
            "Lido",
            "Legnano",
            "Legnago",
            "Lecco",
            "Lecce",
            "Latina",
            "La Spezia",
            "L'Aquila",
            "Lanciano",
            "Lainate",
            "Ladispoli",
            "Ivrea",
            "Isernia",
            "Ischia Porto",
            "Ischia",
            "Pallanza-Intra-Suna",
            "Imperia",
            "Imola",
            "Jesi",
            "Guidonia",
            "Grumo Nevano",
            "Grugliasco",
            "Grottaglie",
            "Grottaferrata",
            "Grosseto",
            "Gravina in Puglia",
            "Gragnano",
            "Gorizia",
            "Gorgonzola",
            "Giussano",
            "Giulianova",
            "Giugliano in Campania",
            "Giovinazzo",
            "Gioia del Colle",
            "Ginosa",
            "Ghedi",
            "Genzano di Roma",
            "Genoa",
            "Garbagnate Milanese",
            "Gallipoli",
            "Gallarate",
            "Galatina",
            "Gaeta",
            "Frosinone",
            "Frattaminore",
            "Frattamaggiore",
            "Frascati",
            "Francavilla Fontana",
            "Francavilla al Mare",
            "Fossano",
            "Fornacelle",
            "Formigine",
            "Formia",
            "Forlì",
            "Forio",
            "Fondi",
            "Follonica",
            "Foligno",
            "Foggia",
            "Fiumicino-Isola Sacra",
            "Florence",
            "Fiorano",
            "Fidenza",
            "Ferrara",
            "Fermo",
            "Fasano",
            "Fano",
            "Falconara Marittima",
            "Faenza",
            "Fabriano",
            "Ercolano",
            "Erba",
            "Empoli",
            "Eboli",
            "Domodossola",
            "Desio",
            "Desenzano del Garda",
            "Dalmine",
            "Cusano Milanino",
            "Cuneo",
            "Cremona",
            "Crema",
            "Corsico",
            "Correggio",
            "Cornaredo",
            "Cormano",
            "Cordenons",
            "Corato",
            "Copertino",
            "Conversano",
            "Conegliano",
            "Como",
            "Cologno Monzese",
            "Collegno",
            "Colleferro",
            "Colle di Val d'Elsa",
            "Civitavecchia",
            "Città di Castello",
            "Cisterna di Latina",
            "Ciriè",
            "Cinisello Balsamo",
            "Ciampino",
            "Chivasso",
            "Chioggia",
            "Chieti",
            "Chieri",
            "Chiavari",
            "Chiari",
            "Cesenatico",
            "Cesena",
            "Cesano Maderno",
            "Cervia",
            "Cerveteri",
            "Cernusco sul Naviglio",
            "Cerignola",
            "Cercola",
            "Cento",
            "Ceglie Messapica",
            "Cecina",
            "Cava Dè Tirreni",
            "Cattolica",
            "Castiglione delle Stiviere",
            "Castel Volturno",
            "Castel Maggiore",
            "Castellammare di Stabia",
            "Castelfranco Veneto",
            "Castelfranco Emilia",
            "Cassino",
            "Cassano d'Adda",
            "Casoria",
            "Caserta",
            "Cascina",
            "Casamassima",
            "Casalnuovo di Napoli",
            "Casale Monferrato",
            "Casalecchio di Reno",
            "Casal di Principe",
            "Carrara",
            "Carpi Centro",
            "Carmagnola",
            "Cardito",
            "Carate Brianza",
            "Capua",
            "Capannori",
            "Cantù",
            "Canosa di Puglia",
            "Campobasso",
            "Campi Bisenzio",
            "Camaiore",
            "Caivano",
            "Busto Arsizio",
            "Bussolengo",
            "Brusciano",
            "Brugherio",
            "Brindisi",
            "Bresso",
            "Bressanone",
            "Brescia",
            "Bra",
            "Bovisio-Masciago",
            "Boscoreale",
            "Borgomanero",
            "Bolzano",
            "Bologna",
            "Bollate",
            "Bitonto",
            "Bisceglie",
            "Biella",
            "Bergamo",
            "Benevento",
            "Belluno",
            "Battipaglia",
            "Bastia umbra",
            "Bassano del Grappa",
            "Barletta",
            "Bari",
            "Bareggio",
            "Bagnoli",
            "Bacoli",
            "Avezzano",
            "Aversa",
            "Avellino",
            "Asti",
            "Ascoli Piceno",
            "Arzignano",
            "Arzano",
            "Ariccia",
            "Arezzo",
            "Arese",
            "Ardea",
            "Arcore",
            "Aprilia",
            "Aosta",
            "Anzio",
            "Angri",
            "Andria",
            "Ancona",
            "Altamura",
            "Alpignano",
            "Alghero",
            "Alessandria",
            "Albignasego",
            "Albenga",
            "Albano Laziale",
            "Alba",
            "Agropoli",
            "Afragola",
            "Adelfia",
            "Acqui Terme",
            "Acquaviva delle Fonti",
            "Acilia-Castel Fusano-Ostia Antica",
            "Acerra",
            "Abbiategrasso",
            "Abano Terme",
            "Spinea-Orgnano",
            "Verbania",
            "Lumezzane",
            "Guidonia Montecelio",
            "Lamezia Terme",
            "Caronno Pertusella",
            "Cassano Magnago",
            "San Felice A Cancello",
            "San Nicola la Strada",
            "Quarto",
            "Orta di Atella",
            "Casavatore",
            "Volla",
            "Gravina di Catania",
            "Cesano Boscone",
            "Tor Lupara",
            "Torvaianica",
            "Bellaria-Igea Marina",
            "Villanova",
            "Marina di Ardea-Tor San Lorenzo",
            "San Paolo",
            "Monterusciello",
            "Romano Banco",
            "Casa Santa",
            "Arpino",
            "Paolo VI",
            "Corigliano Scalo"
        ],
        "Jersey" => [
            "Saint Helier"
        ],
        "Jamaica" => [
            "Spanish Town",
            "Savanna-la-Mar",
            "Portmore",
            "Old Harbour",
            "New Kingston",
            "Montego Bay",
            "May Pen",
            "Mandeville",
            "Linstead",
            "Kingston",
            "Half Way Tree"
        ],
        "Jordan" => [
            "Wādī as Sīr",
            "Umm as Summāq",
            "Saḩāb",
            "Mādabā",
            "Ma'an",
            "Kurayyimah",
            "Judita",
            "Jarash",
            "‘Izrā",
            "Irbid",
            "Zarqa",
            "Aydūn",
            "Aţ Ţafīlah",
            "As Salţ",
            "Safi",
            "Ar Ramthā",
            "‘Anjarah",
            "Amman",
            "Al Quwaysimah",
            "Mafraq",
            "Qīr Moāv",
            "Al Jubayhah",
            "Aqaba",
            "‘Ajlūn",
            "Karak City",
            "Russeifa"
        ],
        "Japan" => [
            "Shingū",
            "Atsugi",
            "Akashi",
            "Zushi",
            "Zama",
            "Yuza",
            "Gero",
            "Yukuhashi",
            "Yūki",
            "Yugawara",
            "Yoshikawa",
            "Yoshii",
            "Yoshida-kasugachō",
            "Yorii",
            "Yono",
            "Yonago",
            "Yokosuka",
            "Yokohama",
            "Yokkaichi",
            "Youkaichi",
            "Yawata",
            "Yatsushiro",
            "Yatsuomachi-higashikumisaka",
            "Yasugichō",
            "Yashiro",
            "Yashio-shi",
            "Yao",
            "Yanai",
            "Yanagawa",
            "Yamazakichō-nakabirose",
            "Yamaguchi",
            "Yamaga",
            "Yaizu",
            "Yaita",
            "Wakimachi",
            "Utsunomiya",
            "Uto",
            "Usuki",
            "Ushibuka",
            "Ureshinomachi-shimojuku",
            "Urayasu",
            "Uozu",
            "Umi",
            "Ujiie",
            "Uji",
            "Uenohara",
            "Ueno-ebisumachi",
            "Ueki",
            "Ueda",
            "Ube",
            "Tsuyama",
            "Tsushima",
            "Tsurusaki",
            "Tsuruoka",
            "Tsurugi-asahimachi",
            "Tsuruga",
            "Tsuma",
            "Tsukumiura",
            "Tsukawaki",
            "Tsubata",
            "Tsubame",
            "Tsu",
            "Toyota",
            "Toyoshina",
            "Toyooka",
            "Toyonaka",
            "Toyokawa",
            "Toyohashi",
            "Toyohama",
            "Toyama",
            "Tottori",
            "Tosu",
            "Tonoshō",
            "Tondabayashichō",
            "Tomioka",
            "Tomigusuku",
            "Tokyo",
            "Tokuyama",
            "Tokushima",
            "Tokorozawa",
            "Tokoname",
            "Toki",
            "Tōkamachi",
            "Togitsu",
            "Tochio-honchō",
            "Tochigi",
            "Toba",
            "Tenri",
            "Tennō",
            "Tawaramoto",
            "Tatsuno",
            "Tatsunochō-tominaga",
            "Tateyama",
            "Tatebayashi",
            "Tarumizu",
            "Tarui",
            "Tanushimarumachi-toyoki",
            "Tanuma",
            "Nishi-Tokyo-shi",
            "Tanashichō",
            "Tanabe",
            "Tanabe",
            "Tamano",
            "Tamana",
            "Tamamura",
            "Taketoyo",
            "Takeochō-takeo",
            "Takehara",
            "Takefu",
            "Takedamachi",
            "Takayama",
            "Takatsuki",
            "Takasaki",
            "Takarazuka",
            "Takaoka",
            "Takanabe",
            "Takamatsu",
            "Takaishi",
            "Takahashi",
            "Takahama",
            "Bungo-Takada-shi",
            "Tajimi",
            "Tahara",
            "Tagawa",
            "Tadotsu",
            "Suzuka",
            "Suzaka",
            "Suwa",
            "Susaki",
            "Sumoto",
            "Sukumo",
            "Suita",
            "Suibara",
            "Sugito",
            "Sueyoshichō-ninokata",
            "Sōka",
            "Sōja",
            "Sobue",
            "Shōbu",
            "Shōbara",
            "Shizuoka",
            "Shirone",
            "Shiraoka",
            "Shirahamachō-usazakiminami",
            "Shiozawa",
            "Shiojiri",
            "Shinshiro",
            "Shin’ichi",
            "Shingū",
            "Shimonoseki",
            "Shimodate",
            "Shimoda",
            "Minato",
            "Nishishinminato",
            "Shimada",
            "Shimabara",
            "Shiki",
            "Shido",
            "Shibushi",
            "Shibukawa",
            "Shibata",
            "Seto",
            "Setakamachi-takayanagi",
            "Satsumasendai",
            "Satte",
            "Sasebo",
            "Sasayama",
            "Sasaguri",
            "Sano",
            "Sanjō",
            "Sandachō",
            "Sakurai",
            "Saku",
            "Sakata",
            "Sakaiminato",
            "Sakaidechō",
            "Sakai-nakajima",
            "Sakai",
            "Sakai",
            "Sakado",
            "Saiki",
            "Sagara",
            "Saga",
            "Sabae",
            "Ryūō",
            "Ryōtsu-minato",
            "Ōzu",
            "Oyama",
            "Ōyama",
            "Owase",
            "Ōtsuki",
            "Ōtsu",
            "Ōtake",
            "Ōta",
            "Osaka",
            "Onomichi",
            "Onoda",
            "Ono",
            "Ono",
            "Ōno-hara",
            "Ōmuta",
            "Ōmura",
            "Ōme",
            "Ōmamachō-ōmama",
            "Ōmachi",
            "Ōkuchi-shinohara",
            "Okegawa",
            "Okazaki",
            "Okayama",
            "Okaya",
            "Ōkawa",
            "Ojiya",
            "Ōita",
            "Ōiso",
            "Ōi",
            "Ogōri-shimogō",
            "Ogawa",
            "Ōgaki",
            "Odawara",
            "Ōdachō-ōda",
            "Ōbu",
            "Obita",
            "Obama",
            "Nyūzen",
            "Numazu",
            "Numata",
            "Nonoichi",
            "Nōgata",
            "Noda",
            "Nobeoka",
            "Nishiwaki",
            "Nishio",
            "Nishinoomote",
            "Nishinomiya-hama",
            "Nirasaki",
            "Ninomiya",
            "Nikkō",
            "Niitsu-honchō",
            "Niimi",
            "Niihama",
            "Niigata",
            "Nichinan",
            "Naze",
            "Narutochō-mitsuishi",
            "Nara-shi",
            "Nanao",
            "Namerikawa",
            "Nakatsugawa",
            "Nakatsu",
            "Nakanojōmachi",
            "Nakano",
            "Nakamura",
            "Nakama",
            "Naha",
            "Nagoya",
            "Nago",
            "Nagasaki",
            "Nagareyama",
            "Nagaoka",
            "Nagano",
            "Nagahama",
            "Nabari",
            "Musashino",
            "Muroto-misakicho",
            "Muramatsu",
            "Murakami",
            "Mukō",
            "Muikamachi",
            "Morohongō",
            "Moriyama",
            "Moriguchi",
            "Mori",
            "Mizunami",
            "Miyoshi",
            "Miyazu",
            "Miyazaki",
            "Miyakonojō",
            "Miyata",
            "Mitsuke",
            "Mitsukaidō",
            "Mitake",
            "Mitaka-shi",
            "Mishima",
            "Mino",
            "Mino",
            "Minamirinkan",
            "Minamata",
            "Minakuchichō-matoba",
            "Mikuni",
            "Miki",
            "Mihara",
            "Mibu",
            "Menuma",
            "Matsutō",
            "Matsumoto",
            "Matsue",
            "Matsudo",
            "Matsubase",
            "Matsubara",
            "Masuda",
            "Maruoka",
            "Kamimaruko",
            "Marugame",
            "Makurazaki",
            "Maki",
            "Maizuru",
            "Maebashi",
            "Maebaru-chūō",
            "Machida",
            "Kyoto",
            "Kushikino",
            "Kusatsu",
            "Kurume",
            "Kuroda",
            "Kurihashi",
            "Kure",
            "Kurayoshi",
            "Kurashiki",
            "Kumamoto",
            "Kumagaya",
            "Kukichūō",
            "Kudamatsu",
            "Kozakai-chō",
            "Koshigaya",
            "Kosai-shi",
            "Kōnosu",
            "Kōnan",
            "Komoro",
            "Komono",
            "Komatsushimachō",
            "Komatsu",
            "Komaki",
            "Kokubunji",
            "Kokubu-matsuki",
            "Koga",
            "Koga",
            "Kōfu",
            "Kodamachō-kodamaminami",
            "Kochi",
            "Kobe",
            "Kobayashi",
            "Kitsuki",
            "Kitakyushu",
            "Kitakata",
            "Kitahama",
            "Kishiwada",
            "Kisarazu",
            "Kisai",
            "Kiryū",
            "Kikuchi",
            "Kazo",
            "Kawasaki",
            "Kawasaki",
            "Kawanishi",
            "Kawaguchi",
            "Kawagoe",
            "Katsuyama",
            "Kasukabe",
            "Kasugai",
            "Kashiwazaki",
            "Kashiwa",
            "Kashima",
            "Kashihara-shi",
            "Kashihara",
            "Kaseda-shirakame",
            "Kasaoka",
            "Kasamatsuchō",
            "Kariya",
            "Karatsu",
            "Kanzakimachi-kanzaki",
            "Kanuma",
            "Kanoya",
            "Kan’onjichō",
            "Kannabechō-yahiro",
            "Kanie",
            "Kanekomachi",
            "Kanda",
            "Kanazawa",
            "Kanaya",
            "Kamojimachō-jōgejima",
            "Kamogatachō-kamogata",
            "Kamo",
            "Kamirenjaku",
            "Kaminokawa",
            "Kamiichi",
            "Kameyama",
            "Kameoka",
            "Kameda-honchō",
            "Kamakura",
            "Kakogawachō-honmachi",
            "Kakegawa",
            "Kakamigahara",
            "Kashima-shi",
            "Kajiki",
            "Kaizuka",
            "Kainan",
            "Kagoshima",
            "Kadoma",
            "Izumo",
            "Izumiōtsu",
            "Izumi",
            "Izumi",
            "Iwatsuki",
            "Iwata",
            "Iwakura",
            "Iwakuni",
            "Iwai",
            "Iwade",
            "Itsukaichi",
            "Itoman",
            "Itoigawa",
            "Itō",
            "Itami",
            "Ishiki",
            "Ishikawa",
            "Ishii",
            "Ishige",
            "Ishigaki",
            "Isesaki",
            "Isehara",
            "Ise",
            "Isawa",
            "Isahaya",
            "Inuyama",
            "Ino",
            "Innoshima",
            "Inazawa",
            "Ina",
            "Imarichō-kō",
            "Imaichi",
            "Ikoma",
            "Ikeda",
            "Ikedachō",
            "Ijūin",
            "Iizuka",
            "Iiyama",
            "Iida",
            "Ichinomiya",
            "Ibusuki",
            "Ibaraki",
            "Ibara",
            "Hotaka",
            "Honjō",
            "Hondo",
            "Hōfu",
            "Hitoyoshi",
            "Hita",
            "Hisai-motomachi",
            "Hiroshima",
            "Hiratsuka",
            "Hiratachō",
            "Hirara",
            "Hirakata",
            "Hirado",
            "Hino",
            "Hino",
            "Himimachi",
            "Himeji",
            "Hikone",
            "Hiji",
            "Hekinan",
            "Hayama",
            "Hatsukaichi",
            "Hatogaya-honchō",
            "Hashimoto",
            "Hanyū",
            "Hannō",
            "Handa",
            "Hamanoichi",
            "Hamamatsu",
            "Hamakita",
            "Hamada",
            "Hakui",
            "Haibara-akanedai",
            "Hagi",
            "Katsuren-haebaru",
            "Hadano",
            "Hachiōji",
            "Ōmihachiman",
            "Gyōda",
            "Gushikawa",
            "Gōtsuchō",
            "Gotenba",
            "Gosen",
            "Gose",
            "Gojō",
            "Gōdo",
            "Gobō",
            "Ginowan",
            "Gifu-shi",
            "Gamagōri",
            "Futtsu",
            "Honchō",
            "Fukuyama",
            "Fukuroi",
            "Fukura",
            "Fukuoka",
            "Fukumitsu",
            "Nishifukuma",
            "Fukui-shi",
            "Fukuechō",
            "Fukuchiyama",
            "Fukiage-fujimi",
            "Fukayachō",
            "Fujisawa",
            "Fujioka",
            "Fujioka",
            "Fujinomiya",
            "Fujieda",
            "Fuji",
            "Fuchūchō",
            "Enzan",
            "Daitōchō",
            "Chōfugaoka",
            "Chiryū",
            "Chino",
            "Chikushino-shi",
            "Chigasaki",
            "Chichibu",
            "Chatan",
            "Beppu",
            "Ayabe",
            "Atami",
            "Ashiya",
            "Ashikaga",
            "Arai",
            "Annaka",
            "Anjō",
            "Anan",
            "Amagi",
            "Amagasaki",
            "Akune",
            "Kariya",
            "Aki",
            "Aioi",
            "Ageoshimo",
            "Okinawa",
            "Kushima",
            "Hikari",
            "Nagato",
            "Hasuda",
            "Kamifukuoka",
            "Sayama",
            "Fussa",
            "Asaka",
            "Wako",
            "Shimotoda",
            "Kimitsu",
            "Miura",
            "Wakayama",
            "Iyo",
            "Uwajima",
            "Saijō",
            "Ōzu",
            "Matsuyama",
            "Masaki-chō",
            "Kawanoechō",
            "Hōjō",
            "Yuzawa",
            "Yotsukaidō",
            "Yonezawa",
            "Yokotemachi",
            "Yōkaichiba",
            "Yanagawamachi-saiwaichō",
            "Yamoto",
            "Yamagata",
            "Yamada",
            "Yachimata",
            "Watari",
            "Wakuya",
            "Ushiku",
            "Tsukuba",
            "Toride",
            "Tōno",
            "Tomobe",
            "Tomiya",
            "Tōgane",
            "Tendō",
            "Takahata",
            "Takahagi",
            "Sukagawa",
            "Shizukuishi",
            "Shisui",
            "Shiroishi",
            "Shiroi",
            "Shiogama",
            "Shinjō",
            "Sendai",
            "Sawara",
            "Sakura",
            "Sagae",
            "Ryūgasaki",
            "Rifu",
            "Ōtsuchi",
            "Ōtawara",
            "Ōmiya",
            "Omigawa",
            "Ōmagari",
            "Okunoya",
            "Ōkawara",
            "Ōhara",
            "Ōfunato",
            "Obanazawa",
            "Ōarai",
            "Ōami",
            "Nihommatsu",
            "Narutō",
            "Narita",
            "Namie",
            "Naka",
            "Nagai",
            "Motomiya",
            "Motegi",
            "Moriya",
            "Morioka",
            "Mooka",
            "Mobara",
            "Mizusawa",
            "Miyako",
            "Mito",
            "Miharu",
            "Matsushima",
            "Mashiko",
            "Marumori",
            "Makabe",
            "Kuroiso",
            "Kōriyama",
            "Kogota",
            "Kitakami",
            "Kitaibaraki",
            "Kamogawa",
            "Katsuura",
            "Katsuta",
            "Katori-shi",
            "Kasama",
            "Karasuyama",
            "Kaminoyama",
            "Kamaishi",
            "Kakuda",
            "Iwase",
            "Iwanuma",
            "Iwaki",
            "Itako",
            "Ishioka",
            "Ishinomaki",
            "Ishikawa",
            "Inawashiro",
            "Ichinoseki",
            "Ichihara",
            "Hobaramachi",
            "Hitachi",
            "Higashine",
            "Hasaki",
            "Hanamaki",
            "Furukawa",
            "Funehikimachi-funehiki",
            "Funaishikawa",
            "Fukushima",
            "Fujishiro",
            "Edosaki",
            "Daigo",
            "Chiba",
            "Asahi",
            "Ami",
            "Akita",
            "Abiko",
            "Akitashi",
            "Bihoro",
            "Wakkanai",
            "Tomakomai",
            "Tōbetsu",
            "Mutsu",
            "Takikawa",
            "Takanosu",
            "Sunagawa",
            "Shizunai-furukawachō",
            "Shiraoi",
            "Shimo-furano",
            "Shibetsu",
            "Sapporo",
            "Rumoi",
            "Otofuke",
            "Otaru",
            "Ōdate",
            "Obihiro",
            "Noshiro",
            "Nemuro",
            "Nayoro",
            "Nanae",
            "Namioka",
            "Muroran",
            "Mombetsu",
            "Misawa",
            "Yoichi",
            "Makubetsu",
            "Kushiro",
            "Kuroishi",
            "Shimokizukuri",
            "Kitami",
            "Kamiiso",
            "Iwanai",
            "Iwamizawa",
            "Ishikari",
            "Ichinohe",
            "Kitahiroshima",
            "Hirosaki",
            "Hanawa",
            "Hakodate",
            "Hachinohe",
            "Fukagawa",
            "Ebetsu",
            "Date",
            "Chitose",
            "Bibai",
            "Ashibetsu",
            "Asahikawa",
            "Aomorishi",
            "Abashiri",
            "Goshogawara",
            "Aso",
            "Nanto-shi",
            "Kawage",
            "Neyagawa",
            "Hitachi-Naka",
            "Inashiki",
            "Ōnojō",
            "Minokamo",
            "Gujō",
            "Jōetsu",
            "Saitama",
            "Higashimurayama-shi",
            "Fujikawaguchiko",
            "Dazaifu",
            "Kamigyō-ku",
            "Buzen",
            "Sendai"
        ],
        "Kenya" => [
            "Webuye",
            "Wajir",
            "Voi",
            "Thika",
            "Rongai",
            "Pumwani",
            "Nyeri",
            "Nyahururu",
            "Narok",
            "Nanyuki",
            "Nakuru",
            "Naivasha",
            "Nairobi",
            "Mumias",
            "Muhoroni",
            "Moyale",
            "Mombasa",
            "Molo",
            "Migori",
            "Meru",
            "Mbale",
            "Marsabit",
            "Maralal",
            "Mandera",
            "Malindi",
            "Makueni",
            "Machakos",
            "Lugulu",
            "Lodwar",
            "Lamu",
            "Kitui",
            "Kitale",
            "Kisumu",
            "Kisii",
            "Kilifi",
            "Kiambu",
            "Keruguya",
            "Kericho",
            "Karuri",
            "Kapenguria",
            "Kakamega",
            "Kabarnet",
            "Isiolo",
            "Homa Bay",
            "Garissa",
            "Embu",
            "Eldoret",
            "Busia",
            "Bungoma",
            "Athi River",
            "Siaya",
            "Ol Kalou"
        ],
        "Kyrgyzstan" => [
            "Suluktu",
            "Isfana",
            "Balykchy",
            "Tokmok",
            "Tash-Kumyr",
            "Talas",
            "Kyzyl-Suu",
            "Uzgen",
            "Osh",
            "Naryn",
            "Kyzyl-Kyya",
            "Kara Suu",
            "Karakol",
            "Kara-Balta",
            "Kant",
            "Jalal-Abad",
            "Iradan",
            "Cholpon-Ata",
            "Bishkek",
            "Bazar-Korgon",
            "At-Bashi",
            "Toktogul",
            "Osh City"
        ],
        "Cambodia" => [
            "Phnom Penh",
            "Ta Khmau",
            "Takeo",
            "Svay Rieng",
            "Stung Treng",
            "Sisŏphŏn",
            "Siem Reap",
            "Prey Veng",
            "Pursat",
            "Phumĭ Véal Srê",
            "Sâmraông",
            "Tbêng Méanchey",
            "Paôy Pêt",
            "Pailin",
            "Lumphăt",
            "Koh Kong",
            "Kratié",
            "Kampot",
            "Kampong Thom",
            "Kampong Speu",
            "Sihanoukville",
            "Kampong Chhnang",
            "Kampong Cham",
            "Ban Lŭng",
            "Battambang",
            "Smach Mean Chey"
        ],
        "Kiribati" => [
            "Tarawa"
        ],
        "Comoros" => [
            "Moutsamoudou",
            "Moroni"
        ],
        "Saint Kitts and Nevis" => [
            "Basseterre"
        ],
        "North Korea" => [
            "Yŏnan-ŭp",
            "Wŏnsan",
            "T’ongch’ŏn-ŭp",
            "Sŭngho 1-tong",
            "Sunan",
            "Songnim",
            "Sil-li",
            "Sinmak",
            "Sinanju",
            "Sariwŏn",
            "Samho-rodongjagu",
            "Pyongyang",
            "P’yŏngsŏng",
            "Ongjin",
            "Namp’o",
            "Kusŏng",
            "Kujang-ŭp",
            "Kowŏn-ŭp",
            "Kosan",
            "Kangdong-ŭp",
            "Kaesŏng",
            "Hwangju-ŭp",
            "Hŭngnam",
            "Hŭkkyo-ri",
            "Hoeyang",
            "Hamhŭng",
            "Haeju",
            "Chunghwa",
            "Chŏngju",
            "Changyŏn",
            "Chaeryŏng-ŭp",
            "Ayang-ni",
            "Anju",
            "Anbyŏn-ŭp",
            "Anak",
            "Yuktae-dong",
            "Ŭiju",
            "Sŏnbong",
            "Sinŭiju",
            "Sakchu-ŭp",
            "Yŏnggwang-ŭp",
            "Onsŏng",
            "Nanam",
            "Namyang-dong",
            "Najin",
            "Musan-ŭp",
            "Kyŏngsŏng",
            "Kilju",
            "Kapsan-ŭp",
            "Kanggye-si",
            "Iwŏn-ŭp",
            "Hyesan-dong",
            "Hyesan-si",
            "Hongwŏn",
            "Hoeryŏng",
            "Chongjin",
            "Aoji-ri"
        ],
        "South Korea" => [
            "Heung-hai",
            "Enjitsu",
            "Neietsu",
            "Eisen",
            "Reiko",
            "Yŏng-dong",
            "Eisen",
            "Yeoju",
            "Yesan",
            "Yangsan",
            "Yangp'yŏng",
            "Yangju",
            "Yanggu",
            "Wŏnju",
            "Wanju",
            "Waegwan",
            "Ulsan",
            "Uijeongbu-si",
            "Tangjin",
            "Taesal-li",
            "Daejeon",
            "Daegu",
            "Taisen-ri",
            "T’aebaek",
            "Suwon-si",
            "Suncheon",
            "Seoul",
            "Suisan",
            "Jenzan",
            "Seonghwan",
            "Sokcho",
            "Sangju",
            "Santyoku",
            "Fuyo",
            "Busan",
            "Bucheon-si",
            "Puan",
            "Beolgyo",
            "Pohang",
            "Osan",
            "Asan",
            "Okcheon",
            "Kosong",
            "Nonsan",
            "Nangen",
            "Naju",
            "Munsan",
            "Mungyeong",
            "Muan",
            "Moppo",
            "Miryang",
            "Gyeongsan-si",
            "Kyonju",
            "Kwangyang",
            "Gwangju",
            "Gwangju",
            "Kurye",
            "Guri-si",
            "Kunwi",
            "Kunsan",
            "Kinzan",
            "Gumi",
            "Goyang-si",
            "Goseong",
            "Gongju",
            "Kyosai",
            "Koesan",
            "Koch'ang",
            "Kimje",
            "Kimhae",
            "Gimcheon",
            "Gijang",
            "Gapyeong",
            "Kang-neung",
            "Ganghwa-gun",
            "Iksan",
            "Incheon",
            "Imsil",
            "Icheon-si",
            "Hwasun",
            "Hwaseong-si",
            "Hwacheon",
            "Hongsung",
            "Hongch’ŏn",
            "Hayang",
            "Haenam",
            "Chuncheon",
            "Jeonju",
            "Cheongsong gun",
            "Cheongju-si",
            "Cheonan",
            "Chinju",
            "Chinch'ŏn",
            "Jinan-gun",
            "Jeju City",
            "Changwon",
            "Changsu",
            "Anyang-si",
            "Anseong",
            "Ansan-si",
            "Andong",
            "Gaigeturi",
            "Sinhyeon",
            "Yeosu",
            "Yŏnmu",
            "Tonghae",
            "Pubal",
            "Seongnam-si",
            "Hanam",
            "Hwado",
            "Namyangju",
            "Ungsang",
            "Wabu",
            "Naesŏ",
            "Hwawŏn",
            "Kwangmyŏng",
            "Sinan",
            "Seogwipo",
            "Changnyeong"
        ],
        "Kuwait" => [
            "Janūb as Surrah",
            "Ḩawallī",
            "Bayān",
            "As Sālimīyah",
            "Ar Rumaythīyah",
            "Ar Riqqah",
            "Al Manqaf",
            "Al Mahbūlah",
            "Kuwait City",
            "Al Jahrā’",
            "Al Faḩāḩīl",
            "Al Finţās",
            "Al Farwānīyah",
            "Al Aḩmadī",
            "Ad Dasmah",
            "Salwá",
            "Ar Rābiyah",
            "Şabāḩ as Sālim"
        ],
        "Cayman Islands" => [
            "George Town"
        ],
        "Kazakhstan" => [
            "Zhanaozen",
            "Shalqar",
            "Shalkar",
            "Oral",
            "Kandyagash",
            "Qulsary",
            "Khromtau",
            "Karagandy",
            "Embi",
            "Balyqshy",
            "Atyrau",
            "Aqtöbe",
            "Aktau",
            "Aqsay",
            "Zyryanovsk",
            "Zhosaly",
            "Zhezqazghan",
            "Dzhetygara",
            "Zhangatas",
            "Ayteke Bi",
            "Taraz",
            "Zaysan",
            "Yanykurgan",
            "Vannovka",
            "Ush-Tyube",
            "Turkestan",
            "Temirtau",
            "Tekeli",
            "Tasböget",
            "Talghar",
            "Taldykorgan",
            "Taldyqorghan",
            "Shymkent",
            "Chu",
            "Shemonaīkha",
            "Shchūchīnsk",
            "Semey",
            "Saryaghash",
            "Sarkand",
            "Sorang",
            "Rudnyy",
            "Kyzylorda",
            "Kostanay",
            "Karatau",
            "Kapshagay",
            "Petropavl",
            "Pavlodar",
            "Zharkent",
            "Ust-Kamenogorsk",
            "Sarykemer",
            "Merke",
            "Makīnsk",
            "Lisakovsk",
            "Baykonyr",
            "Ridder",
            "Lenger",
            "Kokshetau",
            "Kentau",
            "Esik",
            "Georgīevka",
            "Aksu",
            "Otegen Batyra",
            "Ekibastuz",
            "Shīeli",
            "Shardara",
            "Burunday",
            "Aksu",
            "Balqash",
            "Ayagoz",
            "Atbasar",
            "Arys",
            "Arkalyk",
            "Aral",
            "Astana",
            "Almaty",
            "Akkol’",
            "Abay",
            "Stepnogorsk",
            "Kyzyl-Orda"
        ],
        "Laos" => [
            "Vientiane",
            "Xam Nua",
            "Savannakhét",
            "Pakxé",
            "Muang Xay",
            "Vangviang",
            "Muang Phônsavan",
            "Muang Pakxan",
            "Thakhèk",
            "Luang Prabang",
            "Ban Houakhoua",
            "Phonsavan"
        ],
        "Lebanon" => [
            "Zahlé",
            "Tripoli",
            "Tyre",
            "Sidon",
            "Ra’s Bayrūt",
            "Djounie",
            "Jbaïl",
            "Habboûch",
            "Bcharré",
            "Beirut",
            "Baalbek",
            "En Nâqoûra",
            "Nabatîyé et Tahta"
        ],
        "Saint Lucia" => [
            "Castries"
        ],
        "Liechtenstein" => [
            "Vaduz"
        ],
        "Sri Lanka" => [
            "Welisara",
            "Weligama",
            "Wattala",
            "Vavuniya",
            "Valvedditturai",
            "Trincomalee",
            "Ratnapura",
            "Puttalam",
            "Point Pedro",
            "Pita Kotte",
            "Peliyagoda",
            "Panadura",
            "Nuwara Eliya",
            "Negombo",
            "Mulleriyawa",
            "Dehiwala-Mount Lavinia",
            "Moratuwa",
            "Matara",
            "Maharagama",
            "Kurunegala",
            "Sri Jayewardenepura Kotte",
            "Kotikawatta",
            "Kolonnawa",
            "Kelaniya",
            "Katunayaka",
            "Kandy",
            "Kandana",
            "Kalutara",
            "Kalmunai",
            "Jaffna",
            "Ja Ela",
            "Homagama",
            "Hendala",
            "Hatton",
            "Hanwella Ihala",
            "Gampola",
            "Galle",
            "Galkissa",
            "Eravur Town",
            "Dambulla",
            "Colombo",
            "Chilaw",
            "Beruwala",
            "Bentota",
            "Batticaloa",
            "Battaramulla South",
            "Badulla",
            "Anuradhapura",
            "Ampara",
            "Ambalangoda",
            "Shanjeev Home",
            "Mount Lavinia"
        ],
        "Liberia" => [
            "Zwedru",
            "New Yekepa",
            "Voinjama",
            "Monrovia",
            "Kakata",
            "Harper",
            "Greenville",
            "Gbarnga",
            "Buchanan",
            "Bensonville"
        ],
        "Lesotho" => [
            "Quthing",
            "Qacha’s Nek",
            "Mohale’s Hoek",
            "Maseru",
            "Maputsoe",
            "Mafeteng",
            "Leribe",
            "Butha-Buthe"
        ],
        "Lithuania" => [
            "Visaginas",
            "Vilnius",
            "Utena",
            "Ukmerge",
            "Telsiai",
            "Taurage",
            "Silute",
            "Šiauliai",
            "Rokiškis",
            "Radviliskis",
            "Plunge",
            "Panevėžys",
            "Palanga",
            "Fabijoniškės",
            "Mazeikiai",
            "Marijampolė",
            "Kretinga",
            "Klaipėda",
            "Kėdainiai",
            "Kaunas",
            "Jonava",
            "Gargždai",
            "Druskininkai",
            "Alytus",
            "Aleksotas",
            "Dainava (Kaunas)",
            "Šilainiai",
            "Eiguliai",
            "Pašilaičiai",
            "Pilaitė",
            "Justiniškės",
            "Šeškinė",
            "Lazdynai",
            "Vilkpėdė",
            "Naujamiestis"
        ],
        "Luxembourg" => [
            "Luxembourg",
            "Esch-sur-Alzette",
            "Dudelange"
        ],
        "Latvia" => [
            "Valmiera",
            "Ventspils",
            "Vec-Liepāja",
            "Tukums",
            "Salaspils",
            "Riga",
            "Rēzekne",
            "Ogre",
            "Liepāja",
            "Jūrmala",
            "Jelgava",
            "Jēkabpils",
            "Daugavpils",
            "Cēsis"
        ],
        "Libya" => [
            "Tobruk",
            "Sulūq",
            "Darnah",
            "Benghazi",
            "Az Zuwaytīnah",
            "At Tāj",
            "Tūkrah",
            "Al Qubbah",
            "Al Marj",
            "Al Jawf",
            "Al Bayḑā’",
            "Al Abyār",
            "Ajdabiya",
            "Zuwārah",
            "Zliten",
            "Zalţan",
            "Yafran",
            "Waddān",
            "Tarhuna",
            "Tripoli",
            "Tagiura",
            "Sirte",
            "Şurmān",
            "Şabrātah",
            "Sabhā",
            "Nālūt",
            "Murzuq",
            "Mizdah",
            "Mişrātah",
            "Masallātah",
            "Hūn",
            "Zawiya",
            "Ghat",
            "Gharyan",
            "Brak",
            "Banī Walīd",
            "Az Zintān",
            "Az Zāwīyah",
            "Awbārī",
            "Al Khums",
            "Al Jadīd"
        ],
        "Morocco" => [
            "Zaïo",
            "Zagora",
            "Youssoufia",
            "Tiznit",
            "Tirhanimîne",
            "Tinghir",
            "Tiflet",
            "Tétouan",
            "Taza",
            "Taroudant",
            "Taourirt",
            "Taounate",
            "Tan-Tan",
            "Tangier",
            "Tahla",
            "Souq Larb’a al Gharb",
            "Sidi Yahia El Gharb",
            "Sidi Slimane",
            "Sidi Qacem",
            "Sidi Ifni",
            "Sidi Bennour",
            "Settat",
            "Sefrou",
            "Sale",
            "Safi",
            "Rabat",
            "Oulad Teïma",
            "Oujda",
            "Oued Zem",
            "Ouezzane",
            "Ouarzazat",
            "Nador",
            "Mohammedia",
            "Midelt",
            "Meknès",
            "Mechraa Bel Ksiri",
            "Martil",
            "Marrakesh",
            "Larache",
            "Ksar El Kebir",
            "Khouribga",
            "Khenifra",
            "Kenitra",
            "Kasba Tadla",
            "Jerada",
            "Imzoûrene",
            "Guercif",
            "Guelmim",
            "Fkih Ben Salah",
            "Fès al Bali",
            "Fes",
            "Essaouira",
            "El Jadida",
            "El Hajeb",
            "El Aïoun",
            "Chefchaouene",
            "Casablanca",
            "Bouznika",
            "Berkane",
            "Beni Mellal",
            "Berrechid",
            "Azrou",
            "Azemmour",
            "Asilah",
            "Khemisset",
            "Al Hoceïma",
            "Ahfir",
            "Agadir",
            "Skhirate",
            "Boujniba",
            "Dakhla"
        ],
        "Monaco" => [
            "Monte-Carlo",
            "Monaco"
        ],
        "Moldova" => [
            "Edineţ",
            "Ungheni",
            "Tiraspolul",
            "Straşeni",
            "Bilicenii Vechi",
            "Soroca",
            "Slobozia",
            "Rîbniţa",
            "Orhei",
            "Hînceşti",
            "Căuşeni",
            "Floreşti",
            "Dubăsari",
            "Drochia",
            "Comrat",
            "Chişinău",
            "Ceadîr-Lunga",
            "Cahul",
            "Bender",
            "Bălţi"
        ],
        "Montenegro" => [
            "Podgorica",
            "Pljevlja",
            "Nikšić",
            "Herceg-Novi",
            "Cetinje",
            "Budva",
            "Bijelo Polje",
            "Bar"
        ],
        "Saint Martin" => [
            "Marigot"
        ],
        "Madagascar" => [
            "Toamasina",
            "Vondrozo",
            "Vohipaho",
            "Vohibinany",
            "Vavatenina",
            "Vangaindrano",
            "Tsiroanomandidy",
            "Tsiombe",
            "Tsaratanana",
            "Toliara",
            "Fort Dauphin",
            "Soavinandriana",
            "Soanindrariny",
            "Soanierana Ivongo",
            "Sitampiky",
            "Sambava",
            "Sakaraha",
            "Sahavato",
            "Sadabe",
            "Nosy Varika",
            "Morondava",
            "Moramanga",
            "Miandrivazo",
            "Miandrarivo",
            "Marovoay",
            "Marolambo",
            "Maroantsetra",
            "Manjakandriana",
            "Mananjary",
            "Mananara",
            "Manakara",
            "Maintirano",
            "Mahanoro",
            "Mahajanga",
            "Maevatanana",
            "Ikongo",
            "Ikalamavony",
            "Ihosy",
            "Ifanadiana",
            "Fianarantsoa",
            "Fenoarivo Be",
            "Fenoarivo Atsinanana",
            "Faratsiho",
            "Farafangana",
            "Fandriana",
            "Betioky",
            "Betafo",
            "Beroroha",
            "Belo sur Tsiribihina",
            "Beloha",
            "Bealanana",
            "Arivonimamo",
            "Antsohimbondrona",
            "Antsohihy",
            "Antsiranana",
            "Antsirabe",
            "Antanifotsy",
            "Antananarivo",
            "Antalaha",
            "Ankazondandy",
            "Ankazobe",
            "Ankazoabo",
            "Anjozorobe",
            "Hell-Ville",
            "Andilamena",
            "Andapa",
            "Ampasimanolotra",
            "Amparafaravola",
            "Ampanihy",
            "Ampahana",
            "Ambovombe",
            "Ambositra",
            "Ambohitrolomahitsy",
            "Amboasary",
            "Amboanjo",
            "Ambilobe",
            "Ambatondrazaka",
            "Ambatolampy",
            "Ambatofinandrahana",
            "Ambato Boeny",
            "Ambarakaraka",
            "Ambanja",
            "Ambalavao",
            "Alarobia"
        ],
        "Marshall Islands" => [
            "Majuro",
            "RMI Capitol"
        ],
        "Macedonia" => [
            "Желино",
            "Vinica",
            "Veles",
            "Tetovo",
            "Теарце",
            "Студеничани",
            "Strumica",
            "Struga",
            "Shtip",
            "Skopje",
            "Сарај",
            "Ресен",
            "Радовиш",
            "Prilep",
            "Ohrid",
            "Неготино",
            "Negotino",
            "Липково",
            "Kumanovo",
            "Крива Паланка",
            "Kochani",
            "Kičevo",
            "Kavadarci",
            "Kamenjane",
            "Gostivar",
            "Gevgelija",
            "Delcevo",
            "Debar",
            "Brvenica",
            "Bogovinje",
            "Bitola",
            "Šuto Orizare",
            "Butel",
            "Čair",
            "Ilinden",
            "Kisela Voda",
            "Centar Župa"
        ],
        "Mali" => [
            "Yorosso",
            "Timbuktu",
            "Sikasso",
            "Ségou",
            "San",
            "Sagalo",
            "Mopti",
            "Markala",
            "Koutiala",
            "Koulikoro",
            "Kolokani",
            "Kayes",
            "Kati",
            "Kangaba",
            "Gao",
            "Djénné",
            "Bougouni",
            "Banamba",
            "Bamako",
            "Bafoulabé"
        ],
        "Myanmar" => [
            "Yenangyaung",
            "Nyaungdon",
            "Yamethin",
            "Wakema",
            "Twante",
            "Taungoo",
            "Thongwa",
            "Thayetmyo",
            "Thaton",
            "Tharyarwady",
            "Thanatpin",
            "Thanatpin",
            "Dawei",
            "Taunggyi",
            "Taungdwingyi",
            "Syriam",
            "Sittwe",
            "Shwebo",
            "Sagaing",
            "Yangon",
            "Pyu",
            "Pyinmana",
            "Pyay",
            "Pyapon",
            "Bago",
            "Paungde",
            "Pakokku",
            "Hpa-an",
            "Nyaunglebin",
            "Myitkyina",
            "Myingyan",
            "Myawadi",
            "Myanaung",
            "Mudon",
            "Mawlamyinegyunn",
            "Mawlamyine",
            "Monywa",
            "Mogok",
            "Minbu",
            "Myeik",
            "Meiktila",
            "Pyin Oo Lwin",
            "Mawlaik",
            "Maubin",
            "Martaban",
            "Mandalay",
            "Magway",
            "Loikaw",
            "Letpandan",
            "Lashio",
            "Kyaukse",
            "Kyaikto",
            "Kyaiklat",
            "Kyaikkami",
            "Kayan",
            "Kanbe",
            "Hinthada",
            "Hakha",
            "Chauk",
            "Bogale",
            "Bhamo",
            "Pathein",
            "Myaydo",
            "Nay Pyi Taw"
        ],
        "Mongolia" => [
            "Uliastay",
            "Ulaangom",
            "Ölgiy",
            "Khovd",
            "Altai",
            "Ulan Bator",
            "Sühbaatar",
            "Murun-kuren",
            "Mandalgovi",
            "Hovd",
            "Erdenet",
            "Dzüünharaa",
            "Darhan",
            "Dalandzadgad",
            "Saynshand",
            "Bulgan",
            "Bayanhongor",
            "Bayanhongor",
            "Baruun-Urt",
            "Arvayheer",
            "Зуунмод"
        ],
        "Macao" => [
            "Macau"
        ],
        "Northern Mariana Islands" => [
            "Saipan"
        ],
        "Martinique" => [
            "Saint-Joseph",
            "Sainte-Marie",
            "Petite Rivière Salée",
            "Le Robert",
            "Le Lamentin",
            "Le François",
            "La Trinité",
            "Fort-de-France",
            "Ducos"
        ],
        "Mauritania" => [
            "Zouerate",
            "Tékane",
            "Sélibaby",
            "Rosso",
            "Nouakchott",
            "Nouâdhibou",
            "Néma",
            "Kiffa",
            "Kaédi",
            "Atar",
            "Aleg"
        ],
        "Montserrat" => [
            "Plymouth",
            "Brades"
        ],
        "Malta" => [
            "Żabbar",
            "Valletta",
            "Qormi",
            "Mosta",
            "Birkirkara"
        ],
        "Mauritius" => [
            "Vacoas",
            "Triolet",
            "Saint Pierre",
            "Quatre Bornes",
            "Port Louis",
            "Mahébourg",
            "Goodlands",
            "Curepipe",
            "Centre de Flacq",
            "Bel Air Rivière Sèche",
            "Le Hochet"
        ],
        "Maldives" => [
            "Male"
        ],
        "Malawi" => [
            "Karonga",
            "Zomba",
            "Salima",
            "Rumphi",
            "Nsanje",
            "Nkhotakota",
            "Mzuzu",
            "Mzimba",
            "Mulanje",
            "Mchinji",
            "Mangochi",
            "Liwonde",
            "Lilongwe",
            "Kasungu",
            "Dedza",
            "Blantyre",
            "Balaka"
        ],
        "Mexico" => [
            "Gustavo A. Madero",
            "San Fernando",
            "Zumpango",
            "Zumpango del Río",
            "Zacualtipán",
            "Zacatlán",
            "Zacatepec",
            "Yecapixtla",
            "Yautepec",
            "Xoxocotla",
            "Xonacatlán",
            "Xochitepec",
            "Xochimilco",
            "Xicotepec de Juárez",
            "Xico",
            "San Miguel Xico Viejo",
            "Álvaro Obregón",
            "Villahermosa",
            "Gustavo A. Madero",
            "Villa Cuauhtémoc Otzolotepec",
            "Veracruz",
            "Venustiano Carranza",
            "Valle Hermoso",
            "Valladolid",
            "Uman",
            "Tuxtla Gutiérrez",
            "Tuxpan de Rodríguez Cano",
            "Tultitlán",
            "Tultepec",
            "Tulancingo",
            "Tula de Allende",
            "Toluca",
            "Tlazcalancingo",
            "Tlaquiltenango",
            "Tlapa de Comonfort",
            "Tlapacoyan",
            "Tlalpan",
            "Tlalnepantla",
            "Tlahuac",
            "Tizimín",
            "Tizayuca",
            "Tixtla de Guerrero",
            "Ticul",
            "Santiago Tíanguistenco",
            "Tezontepec de Aldama",
            "Teziutlan",
            "Texcoco de Mora",
            "Tequixquiac",
            "Tequisquiapan",
            "Cuautitlán Izcalli",
            "Tepoztlán",
            "Tepotzotlán",
            "Tepeji de Ocampo",
            "Tepeaca",
            "Tepatlaxco de Hidalgo",
            "Teoloyucan",
            "Tenosique de Pino Suárez",
            "Tenango de Arista",
            "Temixco",
            "Temapache",
            "Teloloapan",
            "Tecax",
            "Tehuacán",
            "Tecamachalco",
            "Teapa",
            "Taxco de Alarcón",
            "Tapachula",
            "Tantoyuca",
            "Tampico",
            "Tamazunchale",
            "Santo Domingo Tehuantepec",
            "Santiago Tuxtla",
            "Santiago Pinotepa Nacional",
            "Santiago Tulantepec",
            "Moyotzingo",
            "Santa María Chimalhuacán",
            "Santa Cruz Xoxocotlán",
            "Tecamac de Felipe Villanueva",
            "Chiautempan",
            "San Salvador El Seco",
            "San Salvador Atenco",
            "San Pablo de las Salinas",
            "San Pablo Autopan",
            "San Miguel Zinacantepec",
            "Coatlinchán",
            "San Mateo Atenco",
            "San Martin Texmelucan de Labastida",
            "Teolocholco",
            "Teotihuacán de Arista",
            "San Juan del Río",
            "Tuxtepec",
            "San Francisco Acuautla",
            "Sanctorum",
            "San Cristóbal de las Casas",
            "San Andres Tuxtla",
            "Salina Cruz",
            "Río Verde",
            "Río Bravo",
            "Río Blanco",
            "Reynosa",
            "Puerto Escondido",
            "Puente de Ixtla",
            "Puebla",
            "Progreso de Alvaro Obregon",
            "Progreso de Castro",
            "Poza Rica de Hidalgo",
            "Polanco",
            "Playa del Carmen",
            "Pijijiapan",
            "Peto",
            "Perote",
            "Paraiso",
            "Papantla de Olarte",
            "Pánuco",
            "Palmarito Tochapán",
            "Palenque",
            "Pachuca de Soto",
            "Ozumba de Alzate",
            "Oxkutzkab",
            "Orizaba",
            "Ometepec",
            "Ocozocoautla de Espinosa",
            "Ocoyoacac",
            "Ocosingo",
            "Oaxaca de Juárez",
            "Nuevo Laredo",
            "Nogales",
            "Nicolás Romero",
            "Naucalpan de Juárez",
            "Naranjos",
            "Villa Nanchital",
            "Motul",
            "Motozintla",
            "Montemorelos",
            "Santiago Momoxpan",
            "Mixquiahuala de Juarez",
            "Misantla",
            "Miramar",
            "Minatitlan",
            "Milpa Alta",
            "Miahuatlán de Porfirio Díaz",
            "Metepec",
            "Mérida",
            "Matías Romero",
            "Heroica Matamoros",
            "Martínez de la Torre",
            "Mapastepec",
            "Malinaltepec",
            "Magdalena Contreras",
            "Macuspana",
            "Reyes Acozac",
            "Los Reyes La Paz",
            "Linares",
            "Lerma de Villada",
            "Lerdo de Tejada",
            "Las Margaritas",
            "Las Choapas",
            "La Isla",
            "Kanasín",
            "Juchitán de Zaragoza",
            "Jojutla",
            "Jiutepec",
            "Jalpa de Méndez",
            "Xalapa de Enríquez",
            "Izúcar de Matamoros",
            "San Jerónimo Ixtepec",
            "Ixtapan de la Sal",
            "Ixtapaluca",
            "Iztapalapa",
            "Ixtac Zoquitlán",
            "Iztacalco",
            "Ixmiquilpan",
            "Iguala de la Independencia",
            "Hunucmá",
            "Huixtla",
            "Huitzuco de los Figueroa",
            "Huimanguillo",
            "Huejutla de Reyes",
            "Huejotzingo",
            "Huauchinango",
            "Huatusco de Chicuellar",
            "Ciudad de Huajuapan de León",
            "Frontera Comalapa",
            "Frontera",
            "Fortín de las Flores",
            "Felipe Carrillo Puerto",
            "Escárcega",
            "Emiliano Zapata",
            "Emiliano Zapata",
            "Ciudad Mante",
            "Ecatepec",
            "Cunduacán",
            "Cuernavaca",
            "Cuautlancingo",
            "Cuautla Morelos",
            "Cuautitlán",
            "Cuautepec de Hinojosa",
            "Cuajimalpa",
            "San Miguel de Cozumel",
            "Coyotepec",
            "Coyoacán",
            "Cosoleacaque",
            "Cosamaloapan de Carpio",
            "Córdoba",
            "San Bernardino Contla",
            "Comitán",
            "Comalcalco",
            "Coatzintla",
            "Coatzacoalcos",
            "Coatepec",
            "Coacalco",
            "Ciudad Victoria",
            "Ciudad Valles",
            "Ciudad Serdán",
            "Ciudad Sahagun",
            "Ciudad Nezahualcoyotl",
            "Ciudad Miguel Alemán",
            "Ciudad Mendoza",
            "Ciudad Madero",
            "Ciudad Fernández",
            "Mexico City",
            "Ciudad del Carmen",
            "Cintalapa de Figueroa",
            "Cholula",
            "Chilpancingo de los Bravos",
            "Chilapa de Alvarez",
            "Chignahuapan",
            "Chiconcuac",
            "San Vicente Chicoloapan",
            "Chichén-Itzá",
            "Chiautla",
            "Chiapa de Corzo",
            "Chetumal",
            "Champotón",
            "Chalco de Díaz Covarrubias",
            "Cerro Azul",
            "Catemaco",
            "Carlos A. Carrillo",
            "Cardenas",
            "Cárdenas",
            "Capulhuac",
            "Cancún",
            "Campeche",
            "Calpulalpan",
            "Cadereyta",
            "Berriozábal",
            "Banderilla",
            "Azcapotzalco",
            "Axochiapan",
            "Atlixco",
            "Atlacomulco",
            "Ciudad López Mateos",
            "Apizaco",
            "Apan",
            "Amozoc de Mota",
            "Amecameca",
            "Heroica Alvarado",
            "Altotonga",
            "Altepexi",
            "Altamira",
            "Allende",
            "Álamo",
            "Ajalpan",
            "Agua Dulce",
            "Actopan",
            "Acayucan",
            "Acatzingo de Hidalgo",
            "Acatlán de Osorio",
            "Acapulco de Juárez",
            "Acajete",
            "San Antonio de la Cal",
            "Hidalgo",
            "Río de Teapa",
            "Huamantla",
            "Zacatelco",
            "Tlaxcala de Xicohtencatl",
            "Papalotla",
            "Vicente Guerrero",
            "Tonalá",
            "Arriaga",
            "San Andrés Cholula",
            "Tampico",
            "Alto Lucero",
            "San Mateo Otzacatipan",
            "Santa María Totoltepec",
            "San Lorenzo Acopilco",
            "Benito Juarez",
            "Venustiano Carranza",
            "Miguel Hidalgo",
            "Cuauhtémoc",
            "Huixquilucan",
            "Melchor Ocampo",
            "Huilango",
            "Santiago Teyahualco",
            "Ojo de Agua",
            "Buenavista",
            "Miguel Alemán (La Doce)",
            "Leyva Solano",
            "Cihuatlán",
            "Guadalupe Victoria",
            "Ixtapa-Zihuatanejo",
            "Zapotlanejo",
            "Zapotiltic",
            "Zapopan",
            "Zamora",
            "Zacoalco de Torres",
            "Zacatecas",
            "Zacapú",
            "Yuriria",
            "Yurécuaro",
            "Villagrán",
            "Ciudad Frontera",
            "García",
            "Ciudad de Villa de Álvarez",
            "Valle de Santiago",
            "Valle de Bravo",
            "Uruapan",
            "Uriangato",
            "Tuxpan",
            "Torreon",
            "Tonalá",
            "Tlaquepaque",
            "Tlajomulco de Zúñiga",
            "Tijuana",
            "Tesistán",
            "Tequila",
            "Tepic",
            "Tepatitlán de Morelos",
            "Tepalcatepec",
            "Teocaltiche",
            "Tejupilco de Hidalgo",
            "Tecoman",
            "Tecate",
            "Tangancícuaro de Arista",
            "Tamazula de Gordiano",
            "Tala",
            "Tacámbaro de Codallos",
            "Sombrerete",
            "Soledad Díez Gutiérrez",
            "Silao",
            "Sayula",
            "Santiago Papasquiaro",
            "Santiago Ixcuintla",
            "Santiago",
            "Santa Rosa Jauregui",
            "Santa Catarina",
            "Santa Anita",
            "San Sebastián el Grande",
            "San Pedro",
            "San Nicolás de los Garza",
            "San Miguel el Alto",
            "San Miguel de Papasquiaro",
            "San Miguel de Allende",
            "San Luis Río Colorado",
            "San Luis Potosí",
            "San Luis de la Paz",
            "San Luis de la Paz",
            "Cabo San Lucas",
            "San Juan de los Lagos",
            "San José Iturbide",
            "San José del Cabo",
            "San Francisco del Rincón",
            "San Felipe",
            "San Felipe",
            "San Buenaventura",
            "Nicolás R Casillas",
            "Salvatierra",
            "Saltillo",
            "Salamanca",
            "Sahuayo de Morelos",
            "Sabinas Hidalgo",
            "Ciudad Sabinas",
            "Rosarito",
            "Romita",
            "Río Grande",
            "Rincón de Romos",
            "Ramos Arizpe",
            "Santiago de Querétaro",
            "Puruándiro",
            "Puerto Vallarta",
            "Puerto Peñasco",
            "Piedras Negras",
            "Petatlán",
            "Pénjamo",
            "Pátzcuaro",
            "Parras de la Fuente",
            "Paracho de Verduzco",
            "Palau",
            "Ojinaga",
            "Ocotlán",
            "Nuevo México",
            "Nuevo Casas Grandes",
            "Nueva Rosita",
            "Nueva Italia de Ruiz",
            "Nochistlán",
            "Navolato",
            "Navojoa",
            "Nava",
            "Moroleón",
            "Morelia",
            "Monterrey",
            "Monclova",
            "Mexicali",
            "Pedro Meoqui",
            "Melchor Múzquiz",
            "Medina",
            "Mazatlán",
            "Matehuala",
            "Matamoros",
            "Marfil",
            "Maravatío",
            "Manzanillo",
            "Rodolfo Sánchez Taboada",
            "Magdalena de Kino",
            "San Pedro Madera",
            "Los Mochis",
            "Loreto",
            "León",
            "Las Pintas de Arriba",
            "La Piedad Cavadas",
            "La Paz",
            "La Orilla",
            "Lagos de Moreno",
            "La Cruz",
            "La Barca",
            "Santa Cruz de Juventino Rosas",
            "Jocotepec",
            "Jiquílpan de Juárez",
            "Jiménez",
            "Jesús María",
            "Jerez de García Salinas",
            "Jaral del Progreso",
            "Jamay",
            "Jalostotitlán",
            "Ixtlán del Río",
            "Ixtapa",
            "Irapuato",
            "Huetamo de Núñez",
            "Huatabampo",
            "Hidalgo del Parral",
            "Heróica Zitácuaro",
            "Nogales",
            "Heroica Caborca",
            "Hermosillo",
            "Heroica Guaymas",
            "Guasave",
            "Guanajuato",
            "Guamúchil",
            "Guadalupe",
            "Guadalupe",
            "Guadalajara",
            "Gomez Palacio",
            "Juan Jose Rios",
            "General Escobedo",
            "Garza García",
            "Fresnillo",
            "Escuinapa de Hidalgo",
            "Ensenada",
            "Encarnación de Díaz",
            "Empalme",
            "Pueblo Nuevo",
            "El Salto",
            "El Pueblito",
            "El Grullo",
            "Victoria de Durango",
            "Culiacán",
            "Cuauhtémoc",
            "Villa de Costa Rica",
            "Cortazar",
            "Compostela",
            "Comonfort",
            "Colima",
            "Ciudad Obregón",
            "Ciudad Lerdo",
            "Ciudad Juárez",
            "Ciudad Hidalgo",
            "Ciudad Guzmán",
            "Ciudad Delicias",
            "Ciudad Constitución",
            "Ciudad Camargo",
            "Ciudad Anáhuac",
            "Ciudad Altamirano",
            "Ciudad Acuña",
            "Chihuahua",
            "Chapala",
            "Celaya",
            "Castaños",
            "Cananea",
            "Villa Juárez",
            "Calvillo",
            "Víctor Rosales",
            "Autlán de Navarro",
            "Atoyac de Álvarez",
            "Atotonilco el Alto",
            "Armeria",
            "Arcelia",
            "Arandas",
            "Apodaca",
            "Apatzingán",
            "Apaseo el Grande",
            "Apaseo el Alto",
            "Ameca",
            "Allende",
            "Allende",
            "Aguascalientes",
            "Agua Prieta",
            "Acaponeta",
            "Acámbaro",
            "Abasolo",
            "Anáhuac",
            "Dolores Hidalgo Cuna de la Independencia Nacional",
            "Guacamayas",
            "Ciudad Lázaro Cárdenas",
            "Colonia del Valle",
            "Colonia Lindavista",
            "Colonia Nativitas",
            "Las Delicias",
            "San Pedro Garza Garcia",
            "Soledad de Graciano Sánchez",
            "Manzanillo",
            "Naucalpan de Juárez",
            "Hacienda Santa Fe",
            "Fuentes del Valle",
            "San Salvador Tizatlalli",
            "Jardines de la Silla (Jardines)",
            "San Buenaventura",
            "Colonia Santa Teresa",
            "San Jerónimo Cuatro Vientos",
            "San Martín Azcatepec",
            "Fraccionamiento Real Palmas",
            "Pórticos de San Antonio",
            "San Isidro",
            "Centro Familiar la Soledad",
            "San José Guadalupe Otzacatipan",
            "Las Pintitas",
            "Emiliano Zapata",
            "San Antonio Tecómitl",
            "Licenciado Benito Juárez (Campo Gobierno)",
            "Teotihuacán de Arista",
            "Jesús del Monte",
            "San Jorge Pueblo Nuevo",
            "Manuel Ojinaga",
            "Terrazas del Valle",
            "La Ermita",
            "Lomas del Sur",
            "Parque Industrial Ciudad Mitras",
            "Mitras Poniente",
            "Villa del Prado 2da Sección",
            "Tres de Mayo",
            "Don Antonio",
            "Heroica Ciudad de Tlaxiaco",
            "Ciudad de Huitzuco",
            "Casa Blanca",
            "La Providencia Siglo XXI",
            "Ampliación San Mateo (Colonia Solidaridad)",
            "Fraccionamiento Ciudad Olmeca",
            "San Rafael Tlanalapan",
            "Tecámac de Felipe Villanueva",
            "Venceremos",
            "Alborada Jaltenco",
            "Crucecita"
        ],
        "Malaysia" => [
            "Padang Mat Sirat",
            "Kuah",
            "Jerantut",
            "Raub",
            "Batu Pahat",
            "Parit Raja",
            "Pekan Nenas",
            "Pontian Kechil",
            "Kampung Pasir Gudang Baru",
            "Kota Tinggi",
            "Taman Senai",
            "Kulai",
            "Skudai",
            "Johor Bahru",
            "Kluang",
            "Yong Peng",
            "Mersing",
            "Segamat",
            "Tangkak",
            "Muar",
            "Bakri",
            "Labis",
            "Kuala Selangor",
            "Batang Berjuntai",
            "Batu Arang",
            "Shah Alam",
            "Klang",
            "Cukai",
            "Kuala Lipis",
            "Papar",
            "Kota Kinabalu",
            "Donggongon",
            "Putatan",
            "Kinarut",
            "Ranau",
            "Semporna",
            "Victoria",
            "Beaufort",
            "Lahad Datu",
            "Sandakan",
            "Keningau",
            "Tawau",
            "Paka",
            "Kertih",
            "Kulim",
            "Bagan Serai",
            "Bedong",
            "Simpang Empat",
            "Taiping",
            "Kuala Kangsar",
            "Ipoh",
            "Gua Musang",
            "Kuala Terengganu",
            "Marang",
            "Tampin",
            "Alor Gajah",
            "Kampung Ayer Keroh",
            "Sungai Udang",
            "Malacca",
            "Banting",
            "Jenjarum",
            "Semenyih",
            "Seremban",
            "Port Dickson",
            "Sepang",
            "Bahau",
            "Kuala Pilah",
            "Pekan",
            "Mentekab",
            "Temerluh",
            "Butterworth",
            "Perai",
            "Bukit Mertajam",
            "Nibong Tebal",
            "Parit Buntar",
            "Tasek Glugor",
            "George Town",
            "Serendah",
            "Rawang",
            "Petaling Jaya",
            "Kuala Lumpur",
            "Sabak Bernam",
            "Sungai Besar",
            "Kuantan",
            "Batu Gajah",
            "Kampar",
            "Tapah Road",
            "Bidur",
            "Lumut",
            "Teluk Intan",
            "Gurun",
            "Sungai Petani",
            "Kepala Batas",
            "Tanah Merah",
            "Kuching",
            "Simanggang",
            "Sarikei",
            "Sibu",
            "Kangar",
            "Jitra",
            "Kuala Kedah",
            "Alor Setar",
            "Pasir Mas",
            "Kota Bharu",
            "Kudat",
            "Kapit",
            "Bintulu",
            "Limbang",
            "Miri",
            "Ulu Tiram",
            "Tanjung Tokong",
            "Tanjung Sepat",
            "Permatang Kuching",
            "Peringat",
            "Ladang Seri Kundang",
            "Pantai Remis",
            "Kuang",
            "Klebang Besar",
            "Kampung Tanjung Karang",
            "Kampung Sungai Ara",
            "Kampung Simpang Renggam",
            "Kampong Pangkal Kalong",
            "Kampong Masjid Tanah",
            "Kampong Kadok",
            "Kampong Dungun",
            "Kampung Bukit Baharu",
            "Kampung Baru Subang",
            "Kampung Baharu Nilai",
            "Kampong Baharu Balakong",
            "Kampung Ayer Molek",
            "Bukit Rambai",
            "Bentong Town",
            "Batu Berendam",
            "Putrajaya",
            "Bandar Labuan",
            "Subang Jaya",
            "Putra Heights",
            "Pantai Cenang"
        ],
        "Mozambique" => [
            "Xai-Xai",
            "Dondo",
            "Macia",
            "Tete",
            "Ressano Garcia",
            "Quelimane",
            "Pemba",
            "Nampula",
            "Nacala",
            "Montepuez",
            "Mocímboa",
            "Ilha de Moçambique",
            "Maxixe",
            "Matola",
            "Maputo",
            "Manjacaze",
            "Lichinga",
            "Inhambane",
            "Cuamba",
            "Chokwé",
            "Chimoio",
            "Chibuto",
            "Beira",
            "António Enes",
            "Mutuáli"
        ],
        "Namibia" => [
            "Katima Mulilo",
            "Windhoek",
            "Swakopmund",
            "Rundu",
            "Rehoboth",
            "Otjiwarongo",
            "Oshakati",
            "Okahandja",
            "Lüderitz",
            "Keetmanshoop",
            "Grootfontein",
            "Gobabis",
            "Walvis Bay"
        ],
        "New Caledonia" => [
            "Nouméa",
            "Mont-Dore",
            "Dumbéa"
        ],
        "Niger" => [
            "Birni N Konni",
            "Zinder",
            "Tillabéri",
            "Tibiri",
            "Tessaoua",
            "Téra",
            "Tanout",
            "Tahoua",
            "Niamey",
            "Nguigmi",
            "Mirriah",
            "Mayahi",
            "Matamey",
            "Maradi",
            "Magaria",
            "Madaoua",
            "Illéla",
            "Gaya",
            "Dosso",
            "Dogondoutchi",
            "Diffa",
            "Dakoro",
            "Ayorou",
            "Alaghsas",
            "Agadez"
        ],
        "Norfolk Island" => [
            "Kingston"
        ],
        "Nigeria" => [
            "Zuru",
            "Zungeru",
            "Zaria",
            "Yola",
            "Yenagoa",
            "Wukari",
            "Wudil",
            "Warri",
            "Wamba",
            "Uyo",
            "Uromi",
            "Umuahia",
            "Ughelli",
            "Ugep",
            "Uga",
            "Ubiaja",
            "Tegina",
            "Tambuwal",
            "Talata Mafara",
            "Takum",
            "Suleja",
            "Sokoto",
            "Soba",
            "Saki",
            "Shagamu",
            "Sapele",
            "Rijau",
            "Rano",
            "Potiskum",
            "Port Harcourt",
            "Pindiga",
            "Patigi",
            "Pankshin",
            "Ozubulu",
            "Oyo",
            "Oyan",
            "Owo",
            "Owerri",
            "Otukpa",
            "Otan Ayegbaju",
            "Osogbo",
            "Orita Eruwa",
            "Onitsha",
            "Ondo",
            "Olupona",
            "Okuta",
            "Okrika",
            "Okigwe",
            "Okene",
            "Oke Mesi",
            "Oke Ila",
            "Ohafia-Ifigh",
            "Ogwashi-Uku",
            "Oguta",
            "Ogoja",
            "Ogaminana",
            "Offa",
            "Ode",
            "Obudu",
            "Obonoma",
            "Numan",
            "Nsukka",
            "Nnewi",
            "Nkwerre",
            "Nkpor",
            "Nguru",
            "Nasarawa",
            "Nafada",
            "Mubi",
            "Moriki",
            "Monguno",
            "Mokwa",
            "Modakeke",
            "Minna",
            "Marte",
            "Malumfashi",
            "Makurdi",
            "Makoko",
            "Maiduguri",
            "Magumeri",
            "Lokoja",
            "Lere",
            "Lapai",
            "Lalupon",
            "Lagos",
            "Lafiagi",
            "Lafia",
            "Kwale",
            "Kumo",
            "Kumagunnam",
            "Kukawa",
            "Kuje",
            "Kontagora",
            "Kiyawa",
            "Kisi",
            "Keffi",
            "Kaura Namoda",
            "Katsina-Ala",
            "Katsina",
            "Kari",
            "Kano",
            "Kamba",
            "Kaiama",
            "Kagoro",
            "Kafanchan",
            "Kaduna",
            "Kachia",
            "Kabba",
            "Jos",
            "Jimeta",
            "Jega",
            "Jebba",
            "Jalingo",
            "Iwo",
            "Itu",
            "Isieke",
            "Ise-Ekiti",
            "Isanlu-Itedoijowa",
            "Ipoti",
            "Iperu",
            "Inisa",
            "Ilorin",
            "Ilobu",
            "Illela",
            "Ilesa",
            "Ilaro",
            "Ila Orangun",
            "Ikot Ekpene",
            "Ikom",
            "Ikirun",
            "Ikire",
            "Ikere-Ekiti",
            "Ikeja",
            "Ijero-Ekiti",
            "Ijebu-Ode",
            "Ijebu-Jesa",
            "Ijebu-Igbo",
            "Ihiala",
            "Igede-Ekiti",
            "Igbo-Ukwu",
            "Igbor",
            "Igbo-Ora",
            "Igboho",
            "Igbeti",
            "Igbara-Odo",
            "Ifo",
            "Idanre",
            "Idah",
            "Ibi",
            "Ibeto",
            "Ibadan",
            "Hadejia",
            "Gwoza",
            "Gwarzo",
            "Gwaram",
            "Gwadabawa",
            "Gusau",
            "Gummi",
            "Gumel",
            "Gombi",
            "Gombe",
            "Gembu",
            "Geidam",
            "Gbongan",
            "Gaya",
            "Gashua",
            "Garko",
            "Ganye",
            "Gamboru",
            "Funtua",
            "Fiditi",
            "Ezza-Ohu",
            "Esuk Oron",
            "Epe",
            "Enugu-Ukwu",
            "Enugu-Ezike",
            "Enugu",
            "Emure-Ekiti",
            "Elele",
            "Ekpoma",
            "Eket",
            "Ejigbo",
            "Eha Amufu",
            "Egbe",
            "Effon Alaiye",
            "Effium",
            "Ebute Ikorodu",
            "Dutsen Wai",
            "Dutse",
            "Dukku",
            "Doma",
            "Dikwa",
            "Deba",
            "Daura",
            "Daura",
            "Darazo",
            "Damboa",
            "Damaturu",
            "Calabar",
            "Burutu",
            "Bukuru",
            "Buguma",
            "Bonny",
            "Bode Saadu",
            "Biu",
            "Birnin Kudu",
            "Birnin Kebbi",
            "Sofo-Birnin-Gwari",
            "Billiri",
            "Bida",
            "Benin City",
            "Bende",
            "Beli",
            "Bauchi",
            "Baro",
            "Bama",
            "Badagry",
            "Babana",
            "Azare",
            "Awka",
            "Awgu",
            "Auchi",
            "Asaba",
            "Argungu",
            "Aramoko-Ekiti",
            "Apomu",
            "Anchau",
            "Amaigbo",
            "Akwanga",
            "Akure",
            "Aku",
            "Ajaokuta",
            "Agulu",
            "Agbor",
            "Afikpo",
            "Ado Odo",
            "Ado-Ekiti",
            "Abuja",
            "Abeokuta",
            "Abakaliki",
            "Aba",
            "Degema Hulk"
        ],
        "Nicaragua" => [
            "Tipitapa",
            "Somoto",
            "Somotillo",
            "Siuna",
            "San Rafael del Sur",
            "San Marcos",
            "Rivas",
            "Río Blanco",
            "Rama",
            "Puerto Cabezas",
            "Ocotal",
            "Nueva Guinea",
            "Nandaime",
            "Nagarote",
            "Matagalpa",
            "Masaya",
            "Masatepe",
            "Managua",
            "León",
            "La Paz Centro",
            "Juigalpa",
            "Jinotepe",
            "Jinotega",
            "Jalapa",
            "Granada",
            "Estelí",
            "El Viejo",
            "El Crucero",
            "Diriamba",
            "Corinto",
            "Chinandega",
            "Chichigalpa",
            "Camoapa",
            "Boaco",
            "Bluefields",
            "Ciudad Sandino"
        ],
        "Netherlands" => [
            "Zwolle",
            "Zwijndrecht",
            "Zutphen",
            "Zundert",
            "Zoetermeer",
            "Zevenaar",
            "Zeist",
            "Zeewolde",
            "Zandvoort",
            "Zaltbommel",
            "Zaanstad",
            "Zaandam",
            "Wolvega",
            "Woerden",
            "Woensdrecht",
            "Wisch",
            "Winterswijk",
            "Winschoten",
            "Wijk bij Duurstede",
            "Wijchen",
            "Wierden",
            "Westervoort",
            "Werkendam",
            "Weesp",
            "Weert",
            "Wassenaar",
            "Wageningen",
            "Waddinxveen",
            "Waalwijk",
            "Waalre",
            "Vught",
            "Voorst",
            "Voorschoten",
            "Voorhout",
            "Voorburg",
            "Volendam",
            "Vlissingen",
            "Vlagtwedde",
            "Vlaardingen",
            "Vianen",
            "Venray",
            "Venlo",
            "Velsen-Zuid",
            "Velp",
            "Veldhoven",
            "Veghel",
            "Veere",
            "Veenendaal",
            "Veendam",
            "Valkenswaard",
            "Utrecht",
            "Urk",
            "Uithoorn",
            "Uden",
            "Tubbergen",
            "Tongelre",
            "Tilburg",
            "Tiel",
            "Terneuzen",
            "Tegelen",
            "Steenwijk",
            "Steenbergen",
            "Staphorst",
            "Stadskanaal",
            "Spijkenisse",
            "Someren",
            "Soest",
            "Sneek",
            "Sliedrecht",
            "Sittard",
            "Sint-Oedenrode",
            "'s-Hertogenbosch",
            "'s-Gravenzande",
            "The Hague",
            "Schijndel",
            "Schiedam",
            "Scheveningen",
            "Schagen",
            "Rucphen",
            "Rotterdam",
            "Roosendaal",
            "Roermond",
            "Rijswijk",
            "Ridderkerk",
            "Rhoon",
            "Rhenen",
            "Raalte",
            "Putten",
            "Purmerend",
            "Pijnacker",
            "Papendrecht",
            "Oud-Beijerland",
            "Oss",
            "Oosterhout",
            "Oldenzaal",
            "Oldebroek",
            "Oisterwijk",
            "Oegstgeest",
            "Nuth",
            "Nunspeet",
            "Nuenen",
            "Noordwijkerhout",
            "Noordwijk-Binnen",
            "Nijmegen",
            "Nijkerk",
            "Nieuwegein",
            "Nederweert",
            "Naarden",
            "Naaldwijk",
            "Mijdrecht",
            "Middelharnis",
            "Middelburg",
            "Meppel",
            "Meerssen",
            "Medemblik",
            "Maastricht",
            "Maassluis",
            "Maarssen",
            "Losser",
            "Loon op Zand",
            "Lisse",
            "Lindenholt",
            "Lichtenvoorde",
            "Leusden",
            "Lelystad",
            "Leiderdorp",
            "Leiden",
            "Leeuwarden",
            "Leerdam",
            "Leek",
            "Krimpen aan den IJssel",
            "Korrewegwijk",
            "Kerkrade",
            "Katwijk aan Zee",
            "Kampen",
            "IJsselstein",
            "Huizen",
            "Houten",
            "Horst",
            "Hoorn",
            "Hoogezand",
            "Hoogeveen",
            "Hoofddorp",
            "Hoge Vucht",
            "Hoensbroek",
            "Hilversum",
            "Hilvarenbeek",
            "Hillegom",
            "Heusden",
            "Hengelo",
            "Hendrik-Ido-Ambacht",
            "Helmond",
            "Hellevoetsluis",
            "Heiloo",
            "Heesch",
            "Heerlen",
            "Heerhugowaard",
            "Heerenveen",
            "Heerde",
            "Heemstede",
            "Heemskerk",
            "Harlingen",
            "Harenkarspel",
            "Haren",
            "Harderwijk",
            "Hardenberg",
            "Haarlem",
            "Haaksbergen",
            "Groningen",
            "Groesbeek",
            "Gouda",
            "Gorinchem",
            "Goirle",
            "Goes",
            "Gennep",
            "Gendringen",
            "Geldrop",
            "Geldermalsen",
            "Geertruidenberg",
            "Ermelo",
            "Epe",
            "Enschede",
            "Enkhuizen",
            "Emmen",
            "Emmeloord",
            "Elst",
            "Elburg",
            "Eindhoven",
            "Eibergen",
            "Eersel",
            "Ede",
            "Duiven",
            "Druten",
            "Dronten",
            "Drimmelen",
            "Driebergen-Rijsenburg",
            "Drachten",
            "Dordrecht",
            "Dongen",
            "Doetinchem",
            "Diemen",
            "Deventer",
            "Den Helder",
            "Delfzijl",
            "Delft",
            "Delfshaven",
            "De Bilt",
            "Dalfsen",
            "Culemborg",
            "Cuijk",
            "Cranendonck",
            "Castricum",
            "Capelle aan den IJssel",
            "Bussum",
            "Bunschoten",
            "Brunssum",
            "Brummen",
            "Broek op Langedijk",
            "Broek in Waterland",
            "Breda",
            "Boxtel",
            "Boskoop",
            "Borssele",
            "Borne",
            "Born",
            "Borger",
            "Bodegraven",
            "Bloemendaal",
            "Bladel",
            "Beverwijk",
            "Beuningen",
            "Best",
            "Bergschenhoek",
            "Bergeijk",
            "Bergen op Zoom",
            "Benthuizen",
            "Beek",
            "Barneveld",
            "Barendrecht",
            "Baarn",
            "Asten",
            "Assen",
            "Arnhem",
            "Apeldoorn",
            "Anloo",
            "Amsterdam",
            "Amstelveen",
            "Amersfoort",
            "Alphen aan den Rijn",
            "Almere Stad",
            "Almelo",
            "Alkmaar",
            "Alblasserdam",
            "Aalten",
            "Aalsmeer",
            "Amsterdam-Zuidoost",
            "Berkel en Rodenrijs",
            "Ypenburg"
        ],
        "Norway" => [
            "Trondheim",
            "Tromsø",
            "Tønsberg",
            "Steinkjer",
            "Stavanger",
            "Skien",
            "Sarpsborg",
            "Sandnes",
            "Sandefjord",
            "Porsgrunn",
            "Oslo",
            "Moss",
            "Molde",
            "Mo i Rana",
            "Lillehammer",
            "Larvik",
            "Kristiansund",
            "Kristiansand",
            "Kongsberg",
            "Horten",
            "Haugesund",
            "Harstad",
            "Hamar",
            "Halden",
            "Gjøvik",
            "Fredrikstad",
            "Drammen",
            "Bodø",
            "Bergen",
            "Arendal",
            "Ålesund",
            "Askøy",
            "Ytrebygda"
        ],
        "Nepal" => [
            "Wāling",
            "Tulsīpur",
            "Tīkāpur",
            "Tānsen",
            "Sirāhā",
            "Rājbirāj",
            "Pokhara",
            "Pātan",
            "Panauti̇̄",
            "Malangwa",
            "Mahendranagar",
            "Lahān",
            "Kirtipur",
            "Khāndbāri",
            "Kathmandu",
            "Janakpur",
            "Jaleswar",
            "Ithari",
            "Ilām",
            "Hetauda",
            "Gulariyā",
            "Gaur",
            "Dharān Bāzār",
            "Dhankutā",
            "Dhangarhi",
            "Dārchulā",
            "Dailekh",
            "Dadeldhurā",
            "Butwāl",
            "Bīrganj",
            "Birātnagar",
            "Bharatpur",
            "Bhairāhawā",
            "Bhadrapur",
            "Banepā",
            "Bāglung",
            "Birendranagar",
            "Dipayal",
            "Nepalgunj"
        ],
        "Nauru" => [
            "Yaren"
        ],
        "Niue" => [
            "Alofi"
        ],
        "New Zealand" => [
            "Wellington",
            "Wanganui",
            "Timaru",
            "Taupo",
            "Pukekohe East",
            "Porirua",
            "Paraparaumu",
            "Palmerston North",
            "North Shore",
            "New Plymouth",
            "Nelson",
            "Napier",
            "Manukau City",
            "Mangere",
            "Lower Hutt",
            "Invercargill",
            "Hastings",
            "Hamilton",
            "Dunedin",
            "Christchurch",
            "Auckland",
            "Levin",
            "Gisborne",
            "Masterton",
            "Tauranga",
            "Papakura",
            "Whakatane",
            "Ashburton",
            "Whangarei",
            "Cambridge",
            "Rotorua",
            "Blenheim",
            "Upper Hutt",
            "Taradale",
            "Waitakere"
        ],
        "Oman" => [
            "Sur",
            "Sohar",
            "Sufālat Samā’il",
            "Shināş",
            "Şalālah",
            "Şaḩam",
            "Nizwá",
            "Muscat",
            "Khasab",
            "Izkī",
            "‘Ibrī",
            "Ibrā’",
            "Bidbid",
            "Bawshar",
            "Barkā’",
            "Bahlā’",
            "Badīyah",
            "As Suwayq",
            "Seeb",
            "Rustaq",
            "Al Liwā’",
            "Al Khābūrah",
            "Al Buraymī",
            "Ādam",
            "Yanqul"
        ],
        "Panama" => [
            "Vista Alegre",
            "Veracruz",
            "Tocumen",
            "Santiago de Veraguas",
            "San Miguelito",
            "Puerto Armuelles",
            "Pedregal",
            "Panamá",
            "Pacora",
            "Nuevo Arraiján",
            "Las Cumbres",
            "La Concepción",
            "La Chorrera",
            "La Cabima",
            "David",
            "Colón",
            "Chitré",
            "Chilibre",
            "Chepo",
            "Changuinola",
            "Cativá",
            "Arraiján",
            "Alcalde Díaz",
            "Aguadulce"
        ],
        "Peru" => [
            "Yurimaguas",
            "Virú",
            "Uchiza",
            "Tumbes",
            "Trujillo",
            "Tocache",
            "Tingo María",
            "Tambo Grande",
            "Talara",
            "Sullana",
            "Sechura",
            "Santiago de Cao",
            "San Pedro de Lloc",
            "Saña",
            "Rioja",
            "Querecotillo",
            "Pucallpa",
            "Piura",
            "Pimentel",
            "Picsi",
            "Paita",
            "Paiján",
            "Pacasmayo",
            "Moyobamba",
            "Monsefú",
            "Moche",
            "Marcavelica",
            "La Unión",
            "Laredo",
            "La Peca",
            "Lambayeque",
            "Juanjuí",
            "Jaén",
            "Iquitos",
            "Huaraz",
            "Huánuco",
            "Huamachuco",
            "Guadalupe",
            "Ferreñafe",
            "Coishco",
            "Chulucanas",
            "Chongoyape",
            "Chocope",
            "Chimbote",
            "Chiclayo",
            "Chepén",
            "Chachapoyas",
            "Catacaos",
            "Cajamarca",
            "Bellavista",
            "Bagua Grande",
            "La Breita",
            "Zarumilla",
            "Yunguyo",
            "Yanacancha",
            "Tarma",
            "Tambopata",
            "Tacna",
            "Santiago de Surco",
            "Sicuani",
            "Satipo",
            "San Vicente de Cañete",
            "Santa Ana",
            "San Isidro",
            "San Clemente",
            "Puno",
            "Puerto Maldonado",
            "Pisco",
            "Paramonga",
            "Nuevo Imperial",
            "Nazca",
            "Moquegua",
            "Mollendo",
            "Minas de Marcona",
            "Mala",
            "Lima",
            "La Oroya",
            "Junín",
            "Juliaca",
            "Jauja",
            "Imperial",
            "Ilo",
            "Ilave",
            "Ica",
            "Huaura",
            "Huarmey",
            "Huaral",
            "Huanta",
            "Huancayo",
            "Huancavelica",
            "Hualmay",
            "Huacho",
            "Cusco",
            "Chosica",
            "Chincha Alta",
            "Chaupimarca",
            "Chancay",
            "Cerro de Pasco",
            "Camaná",
            "Callao",
            "Barranca",
            "Ayaviri",
            "Ayacucho",
            "Arequipa",
            "Andahuaylas",
            "Abancay",
            "La Rinconada"
        ],
        "French Polynesia" => [
            "Punaauia",
            "Papeete",
            "Faaa"
        ],
        "Papua New Guinea" => [
            "Wewak",
            "Port Moresby",
            "Popondetta",
            "Mount Hagen",
            "Mendi",
            "Madang",
            "Lae",
            "Kokopo",
            "Kimbe",
            "Goroka",
            "Daru",
            "Bulolo",
            "Arawa"
        ],
        "Philippines" => [
            "Zamboanga",
            "Wao",
            "Virac",
            "Vigan",
            "Victorias",
            "Victoria",
            "Veruela",
            "Valencia",
            "Urdaneta",
            "Ualog",
            "Tupi",
            "Tuguegarao City",
            "Trento",
            "Toledo",
            "Tiwi",
            "Ternate",
            "Teresa",
            "Telabastagan",
            "Taytay",
            "Tayabas",
            "Tarlac City",
            "Tanza",
            "Tanjay",
            "Tangub",
            "Tandag",
            "Tanay",
            "Tanauan",
            "Tanauan",
            "Taloc",
            "Talisay",
            "Talisay",
            "Talisay",
            "Talavera",
            "Talacogon",
            "Tagum",
            "Taguig",
            "Tagudin",
            "Tagoloan",
            "Tagbilaran City",
            "Tagas",
            "Tacurong",
            "Tabuk",
            "Tabaco",
            "Taal",
            "Surigao",
            "Surallah",
            "Subic",
            "Suay",
            "Sorsogon",
            "Solano",
            "Solana",
            "Sitangkai",
            "Sipalay",
            "Silang",
            "Sibulan",
            "Sexmoan",
            "Sebu",
            "Sariaya",
            "San Vicente",
            "Santo Tomas",
            "Santol",
            "Santiago",
            "Santa Rosa",
            "Santa Maria",
            "Santa Maria",
            "Santa Cruz",
            "Santa Cruz",
            "Santa Cruz",
            "Santa Catalina",
            "Santa Barbara",
            "Santa Ana",
            "San Simon",
            "San Pedro",
            "San Pascual",
            "San Pablo",
            "San Nicolas",
            "San Narciso",
            "San Miguel",
            "San Miguel",
            "San Mateo",
            "San Mateo",
            "San Mariano",
            "San Marcelino",
            "San Luis",
            "San Leonardo",
            "San Juan",
            "San Jose del Monte",
            "San Jose",
            "San Jose",
            "San Ildefonso",
            "San Francisco",
            "Aurora",
            "San Francisco",
            "San Fernando",
            "San Fernando",
            "San Fernando",
            "San Antonio",
            "San Antonio",
            "San Antonio",
            "Sampaloc",
            "Samal",
            "Samal",
            "Sagay",
            "Sablayan",
            "Roxas",
            "Roxas City",
            "Roxas",
            "Romblon",
            "Rizal",
            "Recodo",
            "Ramos",
            "Ramon",
            "Quiapo",
            "Quezon City",
            "Quezon",
            "Quezon",
            "Pulupandan",
            "Pulong Santa Cruz",
            "Pulilan",
            "Puerto Princesa",
            "Port Area",
            "Porac",
            "Polomolok",
            "Polangui",
            "Plaridel",
            "Pio",
            "Pinamungahan",
            "Pinamalayan",
            "Pililla",
            "Pilar",
            "Pila",
            "Peñaranda",
            "Patuto",
            "Passi",
            "Parang",
            "Paraiso",
            "Papaya",
            "Paombong",
            "Pantubig",
            "Paniqui",
            "Pangil",
            "Pandi",
            "Pandacaqui",
            "Panalanoy",
            "Panabo",
            "Palo",
            "Palayan City",
            "Pagbilao",
            "Pagaluñgan",
            "Pagadian",
            "Paete",
            "Pacol",
            "Ozamiz City",
            "Oroquieta",
            "Ormoc",
            "Orion",
            "Orani",
            "Olongapo",
            "Obando",
            "Noveleta",
            "Norzagaray",
            "New Corella",
            "Nasugbu",
            "Narra",
            "Naic",
            "Nagcarlan",
            "Naga",
            "Naga",
            "Nabunturan",
            "Nabua",
            "Muricay",
            "Murcia",
            "Muñoz",
            "Morong",
            "Morong",
            "Rodriguez",
            "Monkayo",
            "Molave",
            "Minglanilla",
            "Midsayap",
            "Meycauayan",
            "Mexico",
            "Mercedes",
            "Mendez-Nuñez",
            "Mauban",
            "Mati",
            "Masinloc",
            "Masbate",
            "Masantol",
            "Mariveles",
            "Marilao",
            "Mariano",
            "Marawi City",
            "Maramag",
            "Maragondon",
            "Mantampay",
            "Mansilingan",
            "Mansalay",
            "Manolo Fortich",
            "Manila",
            "Manibaug Pasig",
            "Mangaldan",
            "Mandaue City",
            "Mandaluyong City",
            "Mankayan",
            "Manay",
            "Manapla",
            "Manaoag",
            "Mamburao",
            "Mamatid",
            "Malvar",
            "Maluso",
            "Maluñgun",
            "Malolos",
            "Malita",
            "Malilipot",
            "Malaybalay",
            "Malapatan",
            "Malanday",
            "Malabanban Norte",
            "Makati City",
            "Mahayag",
            "Magsaysay",
            "Magarao",
            "Maganoy",
            "Magalang",
            "Mabalacat City",
            "Maasin",
            "Maao",
            "Lupon",
            "Lumbang",
            "Lucena",
            "Lucban",
            "Lubao",
            "Los Baños",
            "Lopez",
            "Loma de Gato",
            "Loboc",
            "Lipa City",
            "Lingayen",
            "Limay",
            "Liloan",
            "Lilio",
            "Libon",
            "Libertad",
            "Legaspi",
            "Laur",
            "La Trinidad",
            "Lapu-Lapu City",
            "La Paz",
            "Laoang",
            "Laoag",
            "Lala",
            "Laguilayan",
            "La Castellana",
            "La Carlota",
            "Labo",
            "Koronadal",
            "Kidapawan",
            "Kawit",
            "Kalibo (poblacion)",
            "Kabankalan",
            "Kabacan",
            "Jose Pañganiban",
            "Jolo",
            "Jasaan",
            "Jalajala",
            "Jagna",
            "Jaen",
            "Itogon",
            "Isulan",
            "Isabela",
            "City of Isabela",
            "Irosin",
            "Iriga City",
            "Ipil",
            "Indang",
            "Imus",
            "Iloilo",
            "Iligan City",
            "Ilagan",
            "Iba",
            "Hinigaran",
            "Himamaylan",
            "Hermosa",
            "Hagonoy",
            "Guyong",
            "Gumaca",
            "Guiset East",
            "Guimba",
            "Guihulñgan",
            "Guiguinto",
            "Goa",
            "Glan",
            "Gerona",
            "General Trias",
            "General Tinio",
            "General Santos",
            "General Mamerto Natividad",
            "Gapan",
            "Escalante",
            "Saravia",
            "Dumaguete",
            "Don Carlos",
            "Domalanoan",
            "Dologon",
            "Dipolog",
            "Dinalupihan",
            "Digos",
            "Diadi",
            "Del Pilar",
            "Davao",
            "Dasmariñas",
            "Dapitan",
            "Danao",
            "Danao",
            "Daet",
            "Cuenca",
            "Cotabato",
            "Cordova",
            "Consolacion",
            "Concepcion",
            "Concepcion Ibaba",
            "Compostela",
            "Compostela",
            "Cebu City",
            "Cavite City",
            "Catbalogan",
            "Catarman",
            "Catanauan",
            "Castillejos",
            "Carmona",
            "Cogan",
            "Carigara",
            "Cardona",
            "Carcar",
            "Capas",
            "Canlaon",
            "Candelaria",
            "Candaba",
            "Camiling",
            "Calumpit",
            "Calumpang",
            "Calbayog City",
            "Calauan",
            "Calauag",
            "Calatagan",
            "Calasiao",
            "Calapan",
            "Calamba",
            "Calaca",
            "Calabanga",
            "Cainta",
            "Cagayan de Oro",
            "Cadiz",
            "Cabiao",
            "Cabayangan",
            "Cabanatuan City",
            "Cabagan",
            "Cabadbaran",
            "Butuan",
            "Bustos",
            "Boroon",
            "Burgos",
            "Bunawan",
            "Buluan",
            "Bulaon",
            "Bulan",
            "Bulacan",
            "Buhi",
            "Bugo",
            "Buenavista",
            "Budta",
            "Botolan",
            "Borongan",
            "Bongao",
            "Bongabon",
            "Bogo",
            "Bocaue",
            "Bislig",
            "Binonga",
            "Binmaley",
            "Binangonan",
            "Binalbagan",
            "Bignay Uno",
            "Bayugan",
            "Bayombong",
            "Baybay",
            "Bayawan",
            "Bayambang",
            "Bay",
            "Bauang",
            "Bauan",
            "Bato",
            "Batangas",
            "Batac City",
            "Baras",
            "Bantayan",
            "Bansalan",
            "Bañga",
            "Banaybanay",
            "Bambang",
            "Baliuag",
            "Balayan",
            "Balanga",
            "Balamban",
            "Balagtas",
            "Bais",
            "Bah-Bah",
            "Baguio",
            "Bago City",
            "Baggabag B",
            "Bacoor",
            "Bacolod City",
            "Babo-Pangulo",
            "Baao",
            "Atimonan",
            "Asia",
            "Aringay",
            "Arayat",
            "Aparri",
            "Apalit",
            "Antipolo",
            "Angono",
            "Angeles City",
            "Angat",
            "Amadeo",
            "Alicia",
            "Aliaga",
            "Alaminos",
            "Alabel",
            "Agoo",
            "Abuyog",
            "Abucay",
            "Bagong Pagasa",
            "Malingao",
            "Pasig City",
            "Pandan",
            "Apas"
        ],
        "Pakistan" => [
            "Chuhar Jamāli",
            "Rāwala Kot",
            "Pīr jo Goth",
            "Khairpur",
            "Zhob",
            "Zaida",
            "Zāhir Pīr",
            "Zafarwāl",
            "Yazman",
            "Wazīrābād",
            "Warburton",
            "Wārāh",
            "Vihāri",
            "Utmānzai",
            "Uthal",
            "Usta Muhammad",
            "Umarkot",
            "Ubauro",
            "Turbat",
            "Topi",
            "Toba Tek Singh",
            "Thul",
            "Thatta",
            "Thāru Shāh",
            "Taunsa",
            "Tānk",
            "Tangi",
            "Tando Muhammad Khān",
            "Tando Jām",
            "Tando Allāhyār",
            "Tando Ādam",
            "Tāndliānwāla",
            "Talhār",
            "Talamba",
            "Talagang",
            "Tāl",
            "Swābi",
            "Surkhpur",
            "Sukkur",
            "Sukheke Mandi",
            "Sodhra",
            "Sīta Road",
            "Sinjhoro",
            "Sillānwāli",
            "Sibi",
            "Sialkot",
            "Shujāābād",
            "Shorko",
            "Shikārpur",
            "Sheikhupura",
            "Sharqpur",
            "Shakargarr",
            "Shahr Sultān",
            "Shāhpur Chākar",
            "Shahkot",
            "Shāhdādpur",
            "Shāhdādkot",
            "Shabqadar",
            "Sehwān",
            "Sargodha",
            "Sarāi Sidhu",
            "Sarāi Naurang",
            "Sarāi Ālamgīr",
            "Sangla Hill",
            "Sānghar",
            "Sambriāl",
            "Sakrand",
            "Sāhīwāl",
            "Sahiwal",
            "Sādiqābād",
            "Rohri",
            "Renāla Khurd",
            "Rawalpindi",
            "Ratodero",
            "Rānīpur",
            "Rājanpur",
            "Rāja Jang",
            "Rāiwind",
            "Rādhan",
            "Rabwāh",
            "Quetta",
            "Kambar",
            "Qādirpur Rān",
            "Pishin",
            "Pīr Mahal",
            "Pindi Gheb",
            "Pindi Bhattiān",
            "Pind Dādan Khān",
            "Phālia",
            "Peshawar",
            "Pattoki",
            "Pasrūr",
            "Pasni",
            "Pāno Āqil",
            "Pākpattan",
            "Pahārpur",
            "Pad Īdan",
            "Pabbi",
            "Okāra",
            "Nushki",
            "Nawābshāh",
            "Naushahro Fīroz",
            "Naushahra Virkān",
            "Naudero",
            "Nasīrābād",
            "Nārowāl",
            "Nārang",
            "Naukot",
            "Nankāna Sāhib",
            "Muzaffargarh",
            "Muzaffarābād",
            "Mustafābād",
            "Murree",
            "Murīdke",
            "Multān",
            "Moro",
            "Mithi",
            "Mitha Tiwāna",
            "Mīrpur Māthelo",
            "Mirpur Khas",
            "Mingora",
            "Minchinābād",
            "Miānwāli",
            "Miān Channūn",
            "Mehrābpur",
            "Mehar",
            "Mātli",
            "Matiāri",
            "Mastung",
            "Mardan",
            "Mānsehra",
            "Mangla",
            "Mandi Bahāuddīn",
            "Mānānwāla",
            "Māmu Kānjan",
            "Malir Cantonment",
            "Malakwāl",
            "Mailsi",
            "Mach",
            "Loralai",
            "Lodhrān",
            "Layyah",
            "Lārkāna",
            "Lāliān",
            "Lāla Mūsa",
            "Lakki Marwat",
            "Lahore",
            "Ladhewāla Warāich",
            "Lāchi",
            "Kunri",
            "Kunjāh",
            "Kundiān",
            "Kulāchi",
            "Kot Samāba",
            "Kotri",
            "Kot Rādha Kishan",
            "Kot Mūmin",
            "Kot Malik",
            "Kotli Lohārān",
            "Kotli",
            "Kot Ghulām Muhammad",
            "Kot Diji",
            "Kot Addu",
            "Kohāt",
            "Khushāb",
            "Khurriānwāla",
            "Khewra",
            "Khāriān",
            "Khārān",
            "Khānpur",
            "Khānpur",
            "Khāngarh",
            "Khāngāh Dogrān",
            "Khalābat",
            "Khairpur Nathan Shāh",
            "Khairpur",
            "Khairpur",
            "Kasūr",
            "Kashmor",
            "Karor",
            "Karachi",
            "Kanganpur",
            "Kandiāro",
            "Kandhkot",
            "Kāmra",
            "Kamoke",
            "Kamīr",
            "Kamar Mushāni",
            "Kamālia",
            "Kalūr Kot",
            "Kallar Kahār",
            "Kāleke Mandi",
            "Kalāt",
            "Kālābāgh",
            "Kahūta",
            "Kohror Pakka",
            "Kāhna",
            "Kabīrwāla",
            "Johi",
            "Jīwani",
            "Jhumra",
            "Jhol",
            "Jhelum",
            "Jhawāriān",
            "Jhang Sadr",
            "Jauharābād",
            "Jatoi Shimāli",
            "Jarānwāla",
            "Jand",
            "Jāmpur",
            "Jalālpur Pīrwāla",
            "Jalālpur",
            "Jahāniān Shāh",
            "Jacobābād",
            "Islamabad",
            "Hyderabad",
            "Hujra",
            "Hingorja",
            "Hazro",
            "Haveliān",
            "Haveli",
            "Hāsilpur",
            "Hasan Abdāl",
            "Haru Zbad",
            "Harnoli",
            "Harīpur",
            "Hangu",
            "Hāla",
            "Hāfizābād",
            "Hadāli",
            "Gwadar",
            "Gujrāt",
            "Gujrānwāla",
            "Gūjar Khān",
            "Gojra",
            "Ghotki",
            "Ghauspur",
            "Ghāro",
            "Garh Mahārāja",
            "Gambat",
            "Fort Abbās",
            "Fazalpur",
            "Chak Two Hundred Forty-Nine TDA",
            "Faruka",
            "Faqīrwāli",
            "Faisalābād",
            "Eminābād",
            "Dunyāpur",
            "Dunga Bunga",
            "Dullewāla",
            "Dīr",
            "Dīpālpur",
            "Dinga",
            "Dijkot",
            "Digri",
            "Dhoro Naro",
            "Dhanot",
            "Dera Ismāīl Khān",
            "Dera Ghazi Khan",
            "Dera Bugti",
            "Daur",
            "Dāūd Khel",
            "Daska",
            "Darya Khān",
            "Dājal",
            "Dadu",
            "Dādhar",
            "Chūniān",
            "Chūhar Kāna",
            "Chor",
            "Choa Saidān Shāh",
            "Chishtiān Mandi",
            "Chiniot",
            "Chīchāwatni",
            "Chawinda",
            "Charsadda",
            "Chaman",
            "Chakwāl",
            "Chak Āzam Saffo",
            "Būrewāla",
            "Bhopālwāla",
            "Bhit Shāh",
            "Bhimbar",
            "Bhera",
            "Bhawāna",
            "Bhān",
            "Bhalwāl",
            "Bhakkar",
            "Bhāi Pheru",
            "Bela",
            "Bat Khela",
            "Basīrpur",
            "Bannu",
            "Bahāwalpur",
            "Bahāwalnagar",
            "Badīn",
            "Baddomalhi",
            "Attock City",
            "Ārifwāla",
            "Amangarh",
            "Alīpur",
            "Akora",
            "Ahmadpur East",
            "Abbottābād",
            "Bahāwalnagar",
            "Nowshera Cantonment",
            "Ahmadpur Siāl",
            "New Bādāh",
            "Tando Ghulām Ali",
            "Sethārja Old",
            "Risālpur",
            "Malakwal City"
        ],
        "Poland" => [
            "Żyrardów",
            "Żoliborz",
            "Zielonka",
            "Zamość",
            "Zambrów",
            "Ząbki",
            "Wyszków",
            "Wołomin",
            "Wola",
            "Włochy",
            "Wieliczka",
            "Wesoła",
            "Wawer",
            "Warsaw",
            "Ursus",
            "Tomaszów Mazowiecki",
            "Tomaszów Lubelski",
            "Tarnów",
            "Tarnobrzeg",
            "Targówek",
            "Szczytno",
            "Świdnik",
            "Suwałki",
            "Sulejówek",
            "Staszów",
            "Starachowice",
            "Stalowa Wola",
            "Śródmieście",
            "Sokołów Podlaski",
            "Sokółka",
            "Sochaczew",
            "Skierniewice",
            "Skarżysko-Kamienna",
            "Siemiatycze",
            "Siedlce",
            "Sanok",
            "Sandomierz",
            "Rzeszów",
            "Ropczyce",
            "Rembertów",
            "Rawa Mazowiecka",
            "Radzyń Podlaski",
            "Radom",
            "Pułtusk",
            "Puławy",
            "Przeworsk",
            "Przemyśl",
            "Przasnysz",
            "Pruszków",
            "Płońsk",
            "Pisz",
            "Pionki",
            "Piastów",
            "Piaseczno",
            "Otwock",
            "Ostrów Mazowiecka",
            "Ostrowiec Świętokrzyski",
            "Ostrołęka",
            "Opoczno",
            "Olsztyn",
            "Olecko",
            "Ochota",
            "Nowy Targ",
            "Nowy Sącz",
            "Nowy Dwór Mazowiecki",
            "Nisko",
            "Mrągowo",
            "Mokotów",
            "Mława",
            "Mińsk Mazowiecki",
            "Milanówek",
            "Mielec",
            "Międzyrzec Podlaski",
            "Marki",
            "Łuków",
            "Lublin",
            "Lubartów",
            "Łomża",
            "Łomianki",
            "Lidzbark Warmiński",
            "Legionowo",
            "Łęczna",
            "Łapy",
            "Łańcut",
            "Krosno",
            "Krasnystaw",
            "Kraśnik",
            "Kozienice",
            "Konstancin-Jeziorna",
            "Końskie",
            "Kobyłka",
            "Kielce",
            "Kętrzyn",
            "Kabaty",
            "Józefów",
            "Jędrzejów",
            "Jasło",
            "Jarosław",
            "Hrubieszów",
            "Hajnówka",
            "Grodzisk Mazowiecki",
            "Grajewo",
            "Gorlice",
            "Giżycko",
            "Gierłoż",
            "Garwolin",
            "Ełk",
            "Działdowo",
            "Dęblin",
            "Dębica",
            "Ciechanów",
            "Chełm",
            "Busko-Zdrój",
            "Brzesko",
            "Bochnia",
            "Biłgoraj",
            "Bielsk Podlaski",
            "Bielany",
            "Białystok",
            "Białołeka",
            "Biała Podlaska",
            "Bemowo",
            "Bartoszyce",
            "Augustów",
            "Żywiec",
            "Żory",
            "Złotów",
            "Złotoryja",
            "Zielona Góra",
            "Zgorzelec",
            "Zgierz",
            "Zduńska Wola",
            "Zawiercie",
            "Żary",
            "Zakopane",
            "Żagań",
            "Zabrze",
            "Ząbkowice Śląskie",
            "Września",
            "Wrocław",
            "Wodzisław Śląski",
            "Włocławek",
            "Wieluń",
            "Wejherowo",
            "Wałcz",
            "Wałbrzych",
            "Wągrowiec",
            "Wadowice",
            "Ustroń",
            "Ustka",
            "Tychy",
            "Turek",
            "Trzebinia",
            "Trzcianka",
            "Toruń",
            "Tczew",
            "Tarnowskie Góry",
            "Szczecinek",
            "Szczecin",
            "Szamotuły",
            "Świnoujście",
            "Świętochłowice",
            "Świebodzin",
            "Świecie",
            "Świebodzice",
            "Świdwin",
            "Świdnica",
            "Swarzędz",
            "Sulechów",
            "Strzelce Opolskie",
            "Strzegom",
            "Starogard Gdański",
            "Stargard Szczeciński",
            "Środa Wielkopolska",
            "Śrem",
            "Sosnowiec",
            "Sopot",
            "Solec Kujawski",
            "Słupsk",
            "Słubice",
            "Skawina",
            "Sierpc",
            "Sieradz",
            "Siemianowice Śląskie",
            "Rypin",
            "Rydułtowy",
            "Rybnik",
            "Rumia",
            "Ruda Śląska",
            "Reda",
            "Rawicz",
            "Radzionków",
            "Radomsko",
            "Radlin",
            "Racibórz",
            "Pyskowice",
            "Pszczyna",
            "Pruszcz Gdański",
            "Prudnik",
            "Poznań",
            "Polkowice",
            "Police",
            "Płock",
            "Pleszew",
            "Piotrków Trybunalski",
            "Piła",
            "Piekary Śląskie",
            "Pabianice",
            "Ozorków",
            "Oświęcim",
            "Ostrów Wielkopolski",
            "Ostróda",
            "Orzesze",
            "Opole",
            "Olkusz",
            "Oleśnica",
            "Oława",
            "Oborniki",
            "Nysa",
            "Nowy Tomyśl",
            "Nowogard",
            "Nowa Sól",
            "Nowa Ruda",
            "Namysłów",
            "Nakło nad Notecią",
            "Myszków",
            "Mysłowice",
            "Myślenice",
            "Mikołów",
            "Międzyrzecz",
            "Malbork",
            "Luboń",
            "Lubliniec",
            "Lubin",
            "Lubań",
            "Łowicz",
            "Łódź",
            "Libiąż",
            "Leszno",
            "Legnica",
            "Lędziny",
            "Łęczyca",
            "Lębork",
            "Łaziska Górne",
            "Łask",
            "Kwidzyn",
            "Kutno",
            "Krotoszyn",
            "Krapkowice",
            "Kraków",
            "Koszalin",
            "Kostrzyn nad Odrą",
            "Kościerzyna",
            "Kościan",
            "Konstantynów Łódzki",
            "Konin",
            "Kołobrzeg",
            "Koło",
            "Knurów",
            "Kluczbork",
            "Kłodzko",
            "Kęty",
            "Kędzierzyn-Koźle",
            "Katowice",
            "Kartuzy",
            "Kamienna Góra",
            "Kalisz",
            "Jelenia Góra",
            "Jelcz",
            "Jaworzno",
            "Jawor",
            "Jastrzębie Zdrój",
            "Jarocin",
            "Inowrocław",
            "Iława",
            "Gubin",
            "Gryfino",
            "Gryfice",
            "Grudziądz",
            "Gostynin",
            "Gostyń",
            "Gorzów Wielkopolski",
            "Goleniów",
            "Gniezno",
            "Głuchołazy",
            "Głowno",
            "Głogów",
            "Gliwice",
            "Gdynia",
            "Gdańsk",
            "Fordon",
            "Elbląg",
            "Dzierżoniów",
            "Dąbrowa Górnicza",
            "Częstochowa",
            "Czerwionka-Leszczyny",
            "Czeladź",
            "Czechowice-Dziedzice",
            "Cieszyn",
            "Chrzanów",
            "Choszczno",
            "Chorzów",
            "Chojnice",
            "Chodzież",
            "Chełmża",
            "Chełmno",
            "Bytów",
            "Bytom",
            "Bydgoszcz",
            "Brzeg",
            "Brodnica",
            "Braniewo",
            "Bolesławiec",
            "Boguszów-Gorce",
            "Bogatynia",
            "Bieruń",
            "Bielsko-Biala",
            "Bielawa",
            "Białogard",
            "Bełchatów",
            "Będzin",
            "Andrychów",
            "Aleksandrów Łódzki",
            "Ursynów",
            "Praga Północ",
            "Praga Południe",
            "Jelcz Laskowice"
        ],
        "Saint Pierre and Miquelon" => [
            "Saint-Pierre"
        ],
        "Pitcairn" => [
            "Adamstown"
        ],
        "Puerto Rico" => [
            "Aguadilla",
            "Arecibo",
            "Barceloneta",
            "Bayamón",
            "Caguas",
            "Candelaria",
            "Carolina",
            "Cataño",
            "Cayey",
            "Fajardo",
            "Guayama",
            "Guaynabo",
            "Humacao",
            "Levittown",
            "Manatí",
            "Mayagüez",
            "Ponce",
            "San Juan",
            "Trujillo Alto",
            "Vega Baja",
            "Yauco"
        ],
        "Palestinian Territory" => [
            "Rafaḩ",
            "An Nuşayrāt",
            "Khān Yūnis",
            "Jabālyā",
            "Gaza",
            "Dayr al Balaḩ",
            "Bayt Lāhyā",
            "Bayt Ḩānūn",
            "Banī Suhaylā",
            "Al Burayj",
            "‘Abasān al Kabīrah",
            "Yuta",
            "Ţūlkarm",
            "Ţūbās",
            "Sa‘īr",
            "Ramallah",
            "Qalqīlyah",
            "Qabāţīyah",
            "Nablus",
            "Janīn",
            "Idhnā",
            "Ḩalḩūl",
            "Dūrā",
            "Bethlehem",
            "Bayt Jālā",
            "Banī Na‘īm",
            "Balāţah",
            "Az̧ Z̧āhirīyah",
            "As Samū‘",
            "Ar Rām wa Ḑāḩiyat al Barīd",
            "Jericho",
            "Al Yāmūn",
            "Hebron",
            "Al Bīrah",
            "Al ‘Ayzarīyah",
            "Old City",
            "Al Qarārah",
            "Az Zuwāydah",
            "East Jerusalem"
        ],
        "Portugal" => [
            "Vila Franca de Xira",
            "Vialonga",
            "Torres Vedras",
            "Tomar",
            "Sintra",
            "Sesimbra",
            "Setúbal",
            "São João da Talha",
            "São Domingos de Rana",
            "Santarém",
            "Santa Iria da Azóia",
            "Sacavém",
            "Rio de Mouro",
            "Ramada",
            "Queluz",
            "Quarteira",
            "Póvoa de Santa Iria",
            "Portimão",
            "Portalegre",
            "Pontinha",
            "Pombal",
            "Pinhal Novo",
            "Piedade",
            "Peniche",
            "Parede",
            "Palmela",
            "Paço de Arcos",
            "Olhão",
            "Odivelas",
            "Montijo",
            "Monte Estoril",
            "Monsanto",
            "Moita",
            "Marinha Grande",
            "Loures",
            "Loulé",
            "Lisbon",
            "Linda-a-Velha",
            "Leiria",
            "Laranjeiro",
            "Lagos",
            "Funchal",
            "Faro",
            "Évora",
            "Estoril",
            "Entroncamento",
            "Corroios",
            "Charneca",
            "Castelo Branco",
            "Cascais",
            "Carnaxide",
            "Carcavelos",
            "Caparica",
            "Camarate",
            "Câmara de Lobos",
            "Caldas da Rainha",
            "Cacém",
            "Belas",
            "Beja",
            "Barreiro",
            "Arrentela",
            "Amora",
            "Amadora",
            "Almada",
            "Algés",
            "Alcabideche",
            "Albufeira",
            "Viseu",
            "Vila Real",
            "Vilar de Andorinho",
            "Vila Nova de Gaia",
            "Vila do Conde",
            "Viana do Castelo",
            "Valongo",
            "Sequeira",
            "Senhora da Hora",
            "São Pedro da Cova",
            "São Mamede de Infesta",
            "São João da Madeira",
            "Rio Tinto",
            "Póvoa de Varzim",
            "Porto",
            "Ponte de Lima",
            "Pedroso",
            "Ovar",
            "Oliveira do Douro",
            "Monção",
            "Matosinhos",
            "Maia",
            "Leça do Bailio",
            "Leça da Palmeira",
            "Ílhavo",
            "Guimarães",
            "Guarda",
            "Gondomar",
            "Feira",
            "Fânzeres",
            "Fafe",
            "Esposende",
            "Esposende",
            "Ermesinde",
            "Custoias",
            "Covilhã",
            "Coimbra",
            "Canidelo",
            "Bragança",
            "Braga",
            "Bougado",
            "Barcelos",
            "Baguim do Monte",
            "Aveiro",
            "Águas Santas",
            "Ponta Delgada"
        ],
        "Palau" => [
            "Melekeok"
        ],
        "Paraguay" => [
            "Villarrica",
            "Villa Hayes",
            "Villa Elisa",
            "San Lorenzo",
            "San Juan Bautista",
            "San Antonio",
            "Presidente Franco",
            "Pilar",
            "Pedro Juan Caballero",
            "Nemby",
            "Limpio",
            "Lambaré",
            "Itauguá",
            "Itá",
            "Fernando de la Mora",
            "Encarnación",
            "Coronel Oviedo",
            "Concepción",
            "Colonia Mariano Roque Alonso",
            "Ciudad del Este",
            "Capiatá",
            "Caazapá",
            "Caaguazú",
            "Caacupé",
            "Asunción"
        ],
        "Qatar" => [
            "Umm Şalāl Muḩammad",
            "Ar Rayyān",
            "Al Wakrah",
            "Al Khawr",
            "Doha"
        ],
        "Reunion" => [
            "Saint-Pierre",
            "Saint-Paul",
            "Saint-Louis",
            "Saint-Leu",
            "Saint-Joseph",
            "Sainte-Suzanne",
            "Sainte-Marie",
            "Saint-Denis",
            "Saint-Benoît",
            "Saint-André",
            "Le Tampon",
            "Le Port",
            "La Possession",
            "Piton Saint-Leu"
        ],
        "Romania" => [
            "Zimnicea",
            "Zărnești",
            "Zalău",
            "Vulcan",
            "Voluntari",
            "Vişeu de Sus",
            "Vatra Dornei",
            "Vaslui",
            "Urziceni",
            "Turnu Măgurele",
            "Turda",
            "Tulcea",
            "Târnăveni",
            "Târgu Secuiesc",
            "Târgu Neamţ",
            "Târgu-Mureş",
            "Târgu Jiu",
            "Târgovişte",
            "Timişoara",
            "Tecuci",
            "Suceava",
            "Slatina",
            "Şimleu Silvaniei",
            "Sighetu Marmaţiei",
            "Sibiu",
            "Sfântu-Gheorghe",
            "Sebeş",
            "Satu Mare",
            "Salonta",
            "Săcele",
            "Roșiorii de Vede",
            "Roman",
            "Râşnov",
            "Râmnicu Vâlcea",
            "Râmnicu Sărat",
            "Reşiţa",
            "Reghin-Sat",
            "Rădăuți",
            "Popeşti-Leordeni",
            "Ploieşti",
            "Piteşti",
            "Piatra Neamţ",
            "Petroşani",
            "Petrila",
            "Pantelimon",
            "Orăştie",
            "Oradea",
            "Olteniţa",
            "Odorheiu Secuiesc",
            "Ocna Mureş",
            "Năvodari",
            "Motru",
            "Moreni",
            "Moineşti",
            "Mizil",
            "Miercurea-Ciuc",
            "Mediaş",
            "Medgidia",
            "Mangalia",
            "Lupeni",
            "Lugoj",
            "Luduş",
            "Iaşi",
            "Huşi",
            "Hunedoara",
            "Gura Humorului",
            "Giurgiu",
            "Gherla",
            "Gheorgheni",
            "Galaţi",
            "Găeşti",
            "Focșani",
            "Filiaşi",
            "Fetești-Gară",
            "Feteşti",
            "Fălticeni",
            "Făgăraș",
            "Drobeta-Turnu Severin",
            "Drăgăşani",
            "Dorohoi",
            "Deva",
            "Dej",
            "Curtea de Argeş",
            "Cugir",
            "Craiova",
            "Corabia",
            "Constanţa",
            "Comăneşti",
            "Codlea",
            "Cluj-Napoca",
            "Cisnădie",
            "Câmpulung Moldovenesc",
            "Câmpina",
            "Câmpia Turzii",
            "Cernavodă",
            "Carei",
            "Caransebeş",
            "Caracal",
            "Calafat",
            "Buzău",
            "Buhuşi",
            "Buftea",
            "Bucharest",
            "Breaza",
            "Braşov",
            "Brăila",
            "Brad",
            "Botoşani",
            "Borşa",
            "Bocşa",
            "Blaj",
            "Bistriţa",
            "Bârlad",
            "Balş",
            "Băileşti",
            "Băicoi",
            "Baia Sprie",
            "Baia Mare",
            "Bacău",
            "Arad",
            "Alexandria",
            "Alba Iulia",
            "Aiud",
            "Adjud",
            "Baia Mare",
            "Paşcani",
            "Mioveni",
            "Sighișoara",
            "Slobozia",
            "Sector 1",
            "Sector 2",
            "Sector 3",
            "Sector 4",
            "Sector 5",
            "Sector 6"
        ],
        "Serbia" => [
            "Zrenjanin",
            "Zemun",
            "Zaječar",
            "Vršac",
            "Vranje",
            "Trstenik",
            "Stara Pazova",
            "Sremčica",
            "Smederevska Palanka",
            "Smederevo",
            "Senta",
            "Prokuplje",
            "Požarevac",
            "Pirot",
            "Pančevo",
            "Obrenovac",
            "Novi Pazar",
            "Nova Pazova",
            "Niš",
            "Negotin",
            "Leskovac",
            "Lazarevac",
            "Kruševac",
            "Kraljevo",
            "Kragujevac",
            "Kikinda",
            "Jagodina",
            "Inđija",
            "Gornji Milanovac",
            "Ćuprija",
            "Čačak",
            "Bor",
            "Belgrade",
            "Bečej",
            "Aranđelovac",
            "Vrbas",
            "Valjevo",
            "Užice",
            "Subotica",
            "Sremska Mitrovica",
            "Sombor",
            "Šabac",
            "Ruma",
            "Novi Sad",
            "Bačka Topola",
            "Bačka Palanka",
            "Apatin",
            "Knjazevac"
        ],
        "Russia" => [
            "Udomlya",
            "Sosnovka",
            "Sasovo",
            "Zyuzino",
            "Zyablikovo",
            "Zverevo",
            "Zvenigorod",
            "Zlatoust",
            "Zimovniki",
            "Zhulebino",
            "Zhukovskiy",
            "Zhukovka",
            "Zhirnovsk",
            "Zhigulevsk",
            "Zherdevka",
            "Zheleznovodsk",
            "Zheleznogorsk",
            "Zheleznodorozhnyy",
            "Zernograd",
            "Zelenokumsk",
            "Zelenograd",
            "Zelenodolsk",
            "Zelenchukskaya",
            "Zavolzh’ye",
            "Zarechnyy",
            "Zaraysk",
            "Zapolyarnyy",
            "Zamoskvorech’ye",
            "Zainsk",
            "Yur’yev-Pol’skiy",
            "Yoshkar-Ola",
            "Yeysk",
            "Yessentukskaya",
            "Yessentuki",
            "Yershov",
            "Yemva",
            "Yelizavetinskaya",
            "Yelets",
            "Yelan’",
            "Yelabuga",
            "Yegor’yevsk",
            "Yegorlykskaya",
            "Yefremov",
            "Yasnyy",
            "Yasnogorsk",
            "Yasenevo",
            "Yartsevo",
            "Yaroslavl",
            "Yaransk",
            "Yanaul",
            "Yagry",
            "Yablonovskiy",
            "Vyshniy Volochëk",
            "Vyselki",
            "Vyksa",
            "Vykhino-Zhulebino",
            "Vyborg",
            "Vyazniki",
            "Vyaz’ma",
            "Vyatskiye Polyany",
            "Vsevolozhsk",
            "Votkinsk",
            "Vostryakovo",
            "Vostryakovo",
            "Voskresensk",
            "Voronezh",
            "Altuf’yevskiy",
            "Vorob’yovo",
            "Volzhskiy",
            "Volzhsk",
            "Vol’sk",
            "Volokolamsk",
            "Vologda",
            "Volkhov",
            "Nagornyy",
            "Volgorechensk",
            "Volgograd",
            "Volgodonsk",
            "Vnukovo",
            "Novovladykino",
            "Vladimir",
            "Vladikavkaz",
            "Vidnoye",
            "Vichuga",
            "Veshnyaki",
            "Vereshchagino",
            "Venëv",
            "Vel’sk",
            "Velikiy Ustyug",
            "Velikiye Luki",
            "Vatutino",
            "Valuyki",
            "Valday",
            "Vagonoremont",
            "Uzlovaya",
            "Uvarovo",
            "Uva",
            "Ust’-Labinsk",
            "Ust’-Katav",
            "Ust’-Dzheguta",
            "Usman’",
            "Uryupinsk",
            "Urus-Martan",
            "Uritsk",
            "Unecha",
            "Ulyanovsk",
            "Ukhta",
            "Uglich",
            "Ufa",
            "Uchkeken",
            "Uchaly",
            "Uchaly",
            "Tyrnyauz",
            "Tver",
            "Tuymazy",
            "Tutayev",
            "Tula",
            "Tuchkovo",
            "Tuapse",
            "Tsimlyansk",
            "Trubchevsk",
            "Troparëvo",
            "Troitskaya",
            "Troitsk",
            "Tosno",
            "Torzhok",
            "Tomilino",
            "Tol’yatti",
            "Timashëvsk",
            "Tikhvin",
            "Tikhoretsk",
            "Teykovo",
            "Terek",
            "Tyoply Stan",
            "Temryuk",
            "Tekstil’shchiki",
            "Tbilisskaya",
            "Tambov",
            "Agidel’",
            "Taganrog",
            "Taganskiy",
            "Syzran’",
            "Syktyvkar",
            "Svobody",
            "Sviblovo",
            "Svetogorsk",
            "Svetlyy",
            "Svetlograd",
            "Suvorovskaya",
            "Suvorov",
            "Surovikino",
            "Surkhakhi",
            "Sukhinichi",
            "Stupino",
            "Strunino",
            "Stroitel’",
            "Strogino",
            "Sterlitamak",
            "Stavropol’",
            "Staryy Oskol",
            "Staroshcherbinovskaya",
            "Starominskaya",
            "Starodub",
            "Staraya Russa",
            "Staraya Kupavna",
            "Staraya Derevnya",
            "Sovetsk",
            "Sovetsk",
            "Sosnovyy Bor",
            "Sosnovaya Polyana",
            "Sosnogorsk",
            "Sortavala",
            "Sorochinsk",
            "Solntsevo",
            "Solnechnogorsk",
            "Sol’-Iletsk",
            "Solikamsk",
            "Sokol’niki",
            "Sokol",
            "Sokol",
            "Sofrino",
            "Sochi",
            "Sobinka",
            "Smolensk",
            "Slobodskoy",
            "Slobodka",
            "Slavyansk-na-Kubani",
            "Slantsy",
            "Skopin",
            "Skhodnya",
            "Sim",
            "Sibay",
            "Shuya",
            "Shushary",
            "Shumerlya",
            "Mikhaylovsk",
            "Shilovo",
            "Sheksna",
            "Shebekino",
            "Shchukino",
            "Shchigry",
            "Shcherbinka",
            "Shchelkovo",
            "Shchëkino",
            "Shatura",
            "Shar’ya",
            "Shali",
            "Shakhun’ya",
            "Shakhty",
            "Severskaya",
            "Severo-Zadonsk",
            "Severoural’sk",
            "Severomorsk",
            "Severodvinsk",
            "Severnyy",
            "Setun’",
            "Sestroretsk",
            "Sertolovo",
            "Serpukhov",
            "Sergiyev Posad",
            "Sergach",
            "Serdobsk",
            "Semiluki",
            "Semikarakorsk",
            "Semënovskoye",
            "Semënov",
            "Sel’tso",
            "Segezha",
            "Satka",
            "Sarov",
            "Saratov",
            "Sarapul",
            "Saransk",
            "Saraktash",
            "Saint Petersburg",
            "Samara",
            "Sal’sk",
            "Salavat",
            "Safonovo",
            "Rzhev",
            "Rybnoye",
            "Rybinsk",
            "Rybatskoye",
            "Ryazhsk",
            "Ryazan’",
            "Ruzayevka",
            "Rublëvo",
            "Rtishchevo",
            "Rostov-na-Donu",
            "Rostov",
            "Rostokino",
            "Rossosh’",
            "Rossosh’",
            "Roslavl’",
            "Roshal’",
            "Rodniki",
            "Revda",
            "Reutov",
            "Razumnoye",
            "Rayevskiy",
            "Rasskazovo",
            "Ramenki",
            "Pyatigorsk",
            "Pushkino",
            "Pushkin",
            "Pushchino",
            "Pugachev",
            "Pskov",
            "Protvino",
            "Proletarsk",
            "Prokhladnyy",
            "Priyutovo",
            "Privolzhskiy",
            "Privolzhsk",
            "Priozërsk",
            "Primorsko-Akhtarsk",
            "Pridonskoy",
            "Povorino",
            "Kotlovka",
            "Annino",
            "Polyarnyye Zori",
            "Polyarnyy",
            "Pokrovskoye-Streshnëvo",
            "Pokrov",
            "Pokhvistnevo",
            "Podporozh’ye",
            "Podol’sk",
            "Pochep",
            "Ryazanskiy",
            "Plavsk",
            "Pikalëvo",
            "Petushki",
            "Petrozavodsk",
            "Petrovskaya",
            "Petrovsk",
            "Petrodvorets",
            "Peterhof",
            "Pestovo",
            "Pervoural’sk",
            "Perovo",
            "Perm",
            "Pereslavl’-Zalesskiy",
            "Novo-Peredelkino",
            "Penza",
            "Pechora",
            "Pavlovskiy Posad",
            "Pavlovskaya",
            "Pavlovsk",
            "Pavlovsk",
            "Pashkovskiy",
            "Pallasovka",
            "Ozëry",
            "Ozerki",
            "Otradnyy",
            "Otradnoye",
            "Otradnoye",
            "Otradnaya",
            "Ostrov",
            "Ostrogozhsk",
            "Ostashkov",
            "Ostankinskiy",
            "Osa",
            "Orsk",
            "Orlovskiy",
            "Orenburg",
            "Orël",
            "Orekhovo-Zuyevo",
            "Orekhovo-Borisovo Severnoye",
            "Ordzhonikidzevskaya",
            "Onega",
            "Omutninsk",
            "Olenegorsk",
            "Tsotsin-Yurt",
            "Oktyabr’skiy",
            "Odintsovo",
            "Ochër",
            "Ochakovo-Matveyevskoye",
            "Obninsk",
            "Nytva",
            "Nyandoma",
            "Nurlat",
            "Novyy Oskol",
            "Novyye Kuz’minki",
            "Novyye Cherëmushki",
            "Novozybkov",
            "Novovoronezh",
            "Novouzensk",
            "Novoul’yanovsk",
            "Novotroitsk",
            "Novotitarovskaya",
            "Novoshakhtinsk",
            "Novorossiysk",
            "Novopokrovskaya",
            "Novopavlovsk",
            "Novomoskovsk",
            "Novomichurinsk",
            "Novokuz’minki",
            "Novokuybyshevsk",
            "Novokubansk",
            "Novokhovrino",
            "Novogireyevo",
            "Novodvinsk",
            "Novocherkassk",
            "Novocheboksarsk",
            "Novoanninskiy",
            "Novoaleksandrovsk",
            "Velikiy Novgorod",
            "Novaya Usman’",
            "Novaya Derevnya",
            "Noginsk",
            "Nizhnyaya Tura",
            "Nizhniy Tagil",
            "Nizhniy Novgorod",
            "Nizhniy Lomov",
            "Nizhnekamsk",
            "Nikulino",
            "Nikol’skoye",
            "Nikol’skoye",
            "Nikol’sk",
            "Nikolayevsk",
            "Nikel’",
            "Nezlobnaya",
            "Nevinnomyssk",
            "Nevel’",
            "Nesterovskaya",
            "Nerekhta",
            "Nelidovo",
            "Neftekamsk",
            "Neftegorsk",
            "Nazran’",
            "Navashino",
            "Nar'yan-Mar",
            "Nartkala",
            "Naro-Fominsk",
            "Nal’chik",
            "Nakhabino",
            "Naberezhnyye Chelny",
            "Mytishchi",
            "Murom",
            "Murmansk",
            "Mtsensk",
            "Mozhga",
            "Mozhaysk",
            "Mozdok",
            "Mostovskoy",
            "Moscow",
            "Morshansk",
            "Morozovsk",
            "Monino",
            "Monchegorsk",
            "Mirnyy",
            "Mineralnye Vody",
            "Millerovo",
            "Mikhaylovka",
            "Mikhalkovo",
            "Michurinsk",
            "Metallostroy",
            "Menzelinsk",
            "Mendeleyevsk",
            "Meleuz",
            "Melenki",
            "Medvezh’yegorsk",
            "Medvedovskaya",
            "Medvedevo",
            "Mednogorsk",
            "Maykop",
            "Matveyevskoye",
            "Marks",
            "Mar’ino",
            "Mar’ina Roshcha",
            "Manturovo",
            "Yaroslavskiy",
            "Maloyaroslavets",
            "Malgobek",
            "Malakhovka",
            "Makhachkala",
            "Magnitogorsk",
            "Lyudinovo",
            "Lyublino",
            "Lyubertsy",
            "Lytkarino",
            "Lys’va",
            "Lyskovo",
            "Luzhniki",
            "Lukhovitsy",
            "Luga",
            "Losino-Petrovskiy",
            "Lomonosov",
            "Lodeynoye Pole",
            "Lobnya",
            "Livny",
            "Liski",
            "Lipetsk",
            "Likino-Dulevo",
            "Likhobory",
            "Lianozovo",
            "L’govskiy",
            "Levoberezhnaya",
            "Komendantsky aerodrom",
            "Lermontov",
            "Leonovo",
            "Leninskiye Gory",
            "Leninsk",
            "Leninogorsk",
            "Tsaritsyno",
            "Leningradskaya",
            "Yubileyny",
            "Lefortovo",
            "Lebedyan’",
            "Lazarevskoye",
            "Lakinsk",
            "Labinsk",
            "Dugulubgey",
            "Kuznetsk",
            "Kuz’minki",
            "Kuvandyk",
            "Kuskovo",
            "Kushva",
            "Kushchëvskaya",
            "Kusa",
            "Kur’yanovo",
            "Kursk",
            "Kurovskoye",
            "Kurganinsk",
            "Kurchatov",
            "Kurchaloy",
            "Kupchino",
            "Kungur",
            "Kumertau",
            "Kulebaki",
            "Kukmor",
            "Kudymkar",
            "Kudepsta",
            "Kubinka",
            "Kstovo",
            "Krymsk",
            "Kropotkin",
            "Kronshtadt",
            "Krasnyy Sulin",
            "Biryulëvo Zapadnoye",
            "Krasnoye Selo",
            "Krasnovishersk",
            "Krasnoufimsk",
            "Krasnokamsk",
            "Krasnogvardeyskoye",
            "Krasnogorsk",
            "Krasnodar",
            "Krasnoarmeyskaya",
            "Krasnoarmeysk",
            "Krasnoarmeysk",
            "Presnenskiy",
            "Koz’modem’yansk",
            "Kozhukhovo",
            "Kozeyevo",
            "Kozel’sk",
            "Kovylkino",
            "Kovrov",
            "Kovdor",
            "Kotovsk",
            "Kotovo",
            "Kotlas",
            "Kotel’nikovo",
            "Kotel’niki",
            "Kotel’nich",
            "Kostroma",
            "Kostomuksha",
            "Kosaya Gora",
            "Koryazhma",
            "Korenovsk",
            "Konstantinovsk",
            "Kondrovo",
            "Kondopoga",
            "Konakovo",
            "Kommunar",
            "Kolpino",
            "Kolomyagi",
            "Kolomna",
            "Kolomenskoye",
            "Kol’chugino",
            "Kokhma",
            "Klintsy",
            "Klin",
            "Klimovsk",
            "Kizlyar",
            "Kizilyurt",
            "Kizel",
            "Kislovodsk",
            "Kirzhach",
            "Kirsanov",
            "Kirovsk",
            "Kirovsk",
            "Kirovo-Chepetsk",
            "Kirov",
            "Kirov",
            "Kirishi",
            "Kireyevsk",
            "Kingisepp",
            "Kineshma",
            "Kinel’-Cherkassy",
            "Kinel’",
            "Kimry",
            "Kimovsk",
            "Khot'kovo",
            "Khosta",
            "Khoroshëvo-Mnevniki",
            "Kholmskiy",
            "Khimki",
            "Khasavyurt",
            "Kharabali",
            "Khadyzhensk",
            "Kazan",
            "Katav-Ivanovsk",
            "Kastanayevo",
            "Kaspiysk",
            "Kasimov",
            "Kashira",
            "Kashin",
            "Karachev",
            "Karachayevsk",
            "Karabulak",
            "Karabanovo",
            "Kapotnya",
            "Kantyshevo",
            "Kanevskaya",
            "Kandalaksha",
            "Kanash",
            "Kamyzyak",
            "Kamyshin",
            "Kamensk-Shakhtinskiy",
            "Kaluga",
            "Kalininsk",
            "Korolev",
            "Kaliningrad",
            "Kalach-na-Donu",
            "Kalach",
            "Kachkanar",
            "Kabanovo",
            "Izobil’nyy",
            "Izmaylovo",
            "Izhevsk",
            "Izberbash",
            "Ivanteyevka",
            "Ivanovskoye",
            "Ivanovo",
            "Istra",
            "Ishimbay",
            "Ipatovo",
            "Inza",
            "Inozemtsevo",
            "Il’skiy",
            "Igra",
            "Gus’-Khrustal’nyy",
            "Gusev",
            "Gul’kevichi",
            "Gukovo",
            "Gudermes",
            "Gubkin",
            "Gubakha",
            "Gryazovets",
            "Gryazi",
            "Groznyy",
            "Gribanovskiy",
            "Grazhdanka",
            "Goryachiy Klyuch",
            "Goryachevodskiy",
            "Gorodishche",
            "Gorodets",
            "Gorelovo",
            "Gol’yanovo",
            "Golitsyno",
            "Glazov",
            "Giaginskaya",
            "Georgiyevsk",
            "Gelendzhik",
            "Gay",
            "Gavrilov-Yam",
            "Gatchina",
            "Galich",
            "Gagarin",
            "Furmanov",
            "Fryazino",
            "Fryazevo",
            "Frolovo",
            "Fili",
            "Ezhva",
            "Engel’s",
            "Enem",
            "Elista",
            "Elektrougli",
            "Elektrostal’",
            "Elektrogorsk",
            "Ekazhevo",
            "Dzerzhinskiy",
            "Dzerzhinsk",
            "Dyurtyuli",
            "Dyat’kovo",
            "Dubovka",
            "Dubna",
            "Dorogomilovo",
            "Donskoye",
            "Donskoy",
            "Donetsk",
            "Domodedovo",
            "Dolgoprudnyy",
            "Dobryanka",
            "Dmitrov",
            "Divnoye",
            "Dinskaya",
            "Dimitrovgrad",
            "Desnogorsk",
            "Derbent",
            "Zapadnoye Degunino",
            "Dedovsk",
            "Davydkovo",
            "Davlekanovo",
            "Dankov",
            "Danilov",
            "Dagestanskiye Ogni",
            "Dachnoye",
            "Chusovoy",
            "Chudovo",
            "Chistopol’",
            "Chishmy",
            "Chernyanka",
            "Chernyakhovsk",
            "Chernushka",
            "Chernogolovka",
            "Cherkessk",
            "Cherepovets",
            "Cherëmushki",
            "Chekhov",
            "Chegem",
            "Cheboksary",
            "Chaykovskiy",
            "Chapayevsk",
            "Buzuluk",
            "Buynaksk",
            "Buy",
            "Buturlinovka",
            "Businovo",
            "Buinsk",
            "Buguruslan",
            "Bugul’ma",
            "Budënnovsk",
            "Bryukhovetskaya",
            "Bryansk",
            "Bronnitsy",
            "Brateyevo",
            "Borovichi",
            "Borisoglebsk",
            "Bor",
            "Bol’shaya Setun’",
            "Bologoye",
            "Boksitogorsk",
            "Boguchar",
            "Bogorodskoye",
            "Bogorodsk",
            "Bogoroditsk",
            "Bobrov",
            "Blagoveshchensk",
            "Blagodarnyy",
            "Biryulëvo",
            "Birsk",
            "Bibirevo",
            "Bezhetsk",
            "Bezenchuk",
            "Beslan",
            "Berezniki",
            "Beloretsk",
            "Belorechensk",
            "Beloozërskiy",
            "Belgorod",
            "Belëv",
            "Belebey",
            "Belaya Kalitva",
            "Belaya Glina",
            "Baymak",
            "Bavly",
            "Bataysk",
            "Barysh",
            "Balezino",
            "Balashov",
            "Balashikha",
            "Balakovo",
            "Novaya Balakhna",
            "Balabanovo",
            "Baksan",
            "Bakal",
            "Bagayevskaya",
            "Babushkin",
            "Azov",
            "Avtury",
            "Avtovo",
            "Atkarsk",
            "Astrakhan",
            "Asha",
            "Arzgir",
            "Arzamas",
            "Arsk",
            "Armavir",
            "Arkhangel’sk",
            "Argun",
            "Ardon",
            "Apsheronsk",
            "Aprelevka",
            "Apatity",
            "Anna",
            "Andreyevskoye",
            "Anapa",
            "Amin’yevo",
            "Al’met’yevsk",
            "Aleksin",
            "Alekseyevka",
            "Alekseyevka",
            "Aleksandrovskoye",
            "Aleksandrovsk",
            "Aleksandrov",
            "Alatyr’",
            "Levoberezhnyy",
            "Aksay",
            "Akhtyrskiy",
            "Akhtubinsk",
            "Agryz",
            "Afipskiy",
            "Adler",
            "Achkhoy-Martan",
            "Abinsk",
            "Abdulino",
            "Vasil’yevo",
            "Ryl’sk",
            "Neftekumsk",
            "Alagir",
            "Persianovka",
            "Annino",
            "Dagomys",
            "Pavlovo",
            "Belidzhi",
            "Lesnoy",
            "Trëkhgornyy",
            "Mirnyy",
            "Znamensk",
            "Zarechnyy",
            "Kochubeyevskoye",
            "Vnukovo",
            "Moskovskiy",
            "Usinsk",
            "Obukhovo",
            "Staryy Malgobek",
            "Zavodoukovsk",
            "Zarinsk",
            "Zarechnyy",
            "Yuzhnyy",
            "Yuzhnoural’sk",
            "Yurga",
            "Yeniseysk",
            "Yemanzhelinsk",
            "Yekaterinburg",
            "Yashkino",
            "Yarovoye",
            "Yalutorovsk",
            "Vorkuta",
            "Vorgashor",
            "Verkhnyaya Salda",
            "Verkhnyaya Pyshma",
            "Verkhniy Ufaley",
            "Uzhur",
            "Zelenogorsk",
            "Uray",
            "Tyumen",
            "Turinsk",
            "Troitsk",
            "Topki",
            "Tomsk",
            "Toguchin",
            "Tobol’sk",
            "Tayshet",
            "Tayga",
            "Tavda",
            "Tatarsk",
            "Tashtagol",
            "Tarko-Sale",
            "Tara",
            "Talnakh",
            "Tal’menka",
            "Talitsa",
            "Talitsa",
            "Sysert’",
            "Suzun",
            "Surgut",
            "Sukhoy Log",
            "Strezhevoy",
            "Sredneuralsk",
            "Sovetskiy",
            "Sosnovoborsk",
            "Slavgorod",
            "Shushenskoye",
            "Shumikha",
            "Sharypovo",
            "Shadrinsk",
            "Serov",
            "Sayanogorsk",
            "Salekhard",
            "Rubtsovsk",
            "Rezh",
            "Reftinskiy",
            "Promyshlennaya",
            "Prokop’yevsk",
            "Poykovskiy",
            "Polysayevo",
            "Polevskoy",
            "Plast",
            "Osinniki",
            "Omsk",
            "Ob’",
            "Nyagan",
            "Noyabrsk",
            "Novyy Urengoy",
            "Novosilikatnyy",
            "Novosibirsk",
            "Novokuznetsk",
            "Novoaltaysk",
            "Norilsk",
            "Nizhnyaya Salda",
            "Nizhnevartovsk",
            "Nizhneudinsk",
            "Nev’yansk",
            "Nefteyugansk",
            "Nazarovo",
            "Nadym",
            "Myski",
            "Minusinsk",
            "Miass",
            "Mezhdurechensk",
            "Megion",
            "Mayma",
            "Mariinsk",
            "Linëvo",
            "Lesosibirsk",
            "Leninsk-Kuznetsky",
            "Labytnangi",
            "Kyzyl",
            "Kyshtym",
            "Kuybyshev",
            "Kurtamysh",
            "Kurgan",
            "Kupino",
            "Kulunda",
            "Krasnoyarsk",
            "Krasnoural’sk",
            "Krasnotur’insk",
            "Krasnoobsk",
            "Korkino",
            "Kopeysk",
            "Yugorsk",
            "Kolpashevo",
            "Kodinsk",
            "Kochenëvo",
            "Kiselëvsk",
            "Kirovgrad",
            "Khanty-Mansiysk",
            "Kemerovo",
            "Kedrovka",
            "Kayyerkan",
            "Kataysk",
            "Kasli",
            "Kartaly",
            "Karpinsk",
            "Karasuk",
            "Karabash",
            "Kansk",
            "Kamyshlov",
            "Kamensk-Ural’skiy",
            "Kamen’-na-Obi",
            "Kaltan",
            "Kalachinsk",
            "Ivdel’",
            "Iskitim",
            "Ishim",
            "Irbit",
            "Ilanskiy",
            "Gur’yevsk",
            "Gornyak",
            "Gorno-Altaysk",
            "Dudinka",
            "Divnogorsk",
            "Degtyarsk",
            "Chunskiy",
            "Chernogorsk",
            "Cherepanovo",
            "Chelyabinsk",
            "Chebarkul’",
            "Borovskiy",
            "Borodino",
            "Bolotnoye",
            "Bogotol",
            "Bogdanovich",
            "Biysk",
            "Beryozovsky",
            "Berëzovskiy",
            "Berëzovka",
            "Berdsk",
            "Beloyarskiy",
            "Belovo",
            "Barnaul",
            "Barabinsk",
            "Asino",
            "Asbest",
            "Artëmovskiy",
            "Aramil",
            "Anzhero-Sudzhensk",
            "Aleysk",
            "Alapayevsk",
            "Akademgorodok",
            "Achinsk",
            "Abaza",
            "Abakan",
            "Snezhinsk",
            "Ozersk",
            "Zheleznogorsk",
            "Novoural’sk",
            "Seversk",
            "Gubkinskiy",
            "Raduzhny",
            "Muravlenko",
            "Lyantor",
            "Zima",
            "Zheleznogorsk-Ilimskiy",
            "Zeya",
            "Yakutsk",
            "Vyazemskiy",
            "Vrangel’",
            "Vladivostok",
            "Vikhorevka",
            "Ust’-Kut",
            "Ust’-Ilimsk",
            "Ussuriysk",
            "Usol’ye-Sibirskoye",
            "Ulan-Ude",
            "Udachny",
            "Tynda",
            "Tulun",
            "Trudovoye",
            "Fokino",
            "Svobodnyy",
            "Spassk-Dal’niy",
            "Slyudyanka",
            "Shimanovsk",
            "Shelekhov",
            "Severobaykal’sk",
            "Raychikhinsk",
            "Petrovsk-Zabaykal’skiy",
            "Partizansk",
            "Neryungri",
            "Nerchinsk",
            "Nakhodka",
            "Mirny",
            "Luchegorsk",
            "Lesozavodsk",
            "Lensk",
            "Kyakhta",
            "Krasnokamensk",
            "Komsomolsk-on-Amur",
            "Khabarovsk",
            "Kavalerovo",
            "Irkutsk",
            "Gusinoozyorsk",
            "Dal’nerechensk",
            "Chita",
            "Cheremkhovo",
            "Borzya",
            "Bol’shoy Kamen’",
            "Bodaybo",
            "Blagoveshchensk",
            "Birobidzhan",
            "Bikin",
            "Belogorsk",
            "Baykal’sk",
            "Aykhal",
            "Artëm",
            "Arsen’yev",
            "Angarsk",
            "Amursk",
            "Aldan",
            "Dal'negorsk",
            "Bratsk",
            "Sayansk",
            "Khabarovsk Vtoroy",
            "Markova",
            "Vilyuchinsk",
            "Yuzhno-Sakhalinsk",
            "Yelizovo",
            "Vanino",
            "Sovetskaya Gavan’",
            "Poronaysk",
            "Petropavlovsk-Kamchatsky",
            "Okha",
            "Nikolayevsk-on-Amure",
            "Nevel’sk",
            "Magadan",
            "Korsakov",
            "Kholmsk",
            "Baltiysk",
            "Isakogorka",
            "Krasnoznamensk",
            "Chertanovo Yuzhnoye",
            "Zagor’ye",
            "Orekhovo-Borisovo",
            "Metrogorodok",
            "Kogalym",
            "Pyt-Yakh",
            "Langepas",
            "Lesnoy",
            "Zarya",
            "Raduzhnyy",
            "Nizhnesortymskiy",
            "Pokachi",
            "Izluchinsk",
            "Kurortnyy",
            "Chernaya Rechka",
            "Untolovo",
            "Petrogradka",
            "Vasyl'evsky Ostrov",
            "Parnas",
            "Kalininskiy",
            "Krasnogvargeisky",
            "Admiralteisky",
            "Krestovskiy ostrov",
            "Akademicheskoe",
            "Finlyandskiy",
            "Centralniy",
            "Svetlanovskiy",
            "Sampsonievskiy",
            "Vostochnoe Degunino"
        ],
        "Rwanda" => [
            "Rwamagana",
            "Musanze",
            "Nzega",
            "Kigali",
            "Kibuye",
            "Kibungo",
            "Gitarama",
            "Cyangugu",
            "Gisenyi",
            "Byumba",
            "Butare"
        ],
        "Saudi Arabia" => [
            "Yanbu",
            "Umm Lajj",
            "Ţurayf",
            "Turabah",
            "Tārūt",
            "Tabuk",
            "Ţubarjal",
            "Sulţānah",
            "Sayhāt",
            "Şāmitah",
            "Sakakah",
            "Şafwá",
            "Şabyā",
            "Raḩīmah",
            "Rābigh",
            "Qal‘at Bīshah",
            "Najrān",
            "Mecca",
            "Khamis Mushait",
            "Jizan",
            "Jeddah",
            "Ha'il",
            "Duba",
            "Buraydah",
            "Abqaiq",
            "Badr Ḩunayn",
            "Az Zulfi",
            "Dhahran",
            "Aţ Ţaraf",
            "Ta’if",
            "As Sulayyil",
            "Riyadh",
            "Ar Rass",
            "‘Ar‘ar",
            "An Nimāş",
            "Qurayyat",
            "Al Wajh",
            "Al ‘Ulá",
            "Al Qayşūmah",
            "Al Qaţīf",
            "Al Munayzilah",
            "Al Mubarraz",
            "Al Mithnab",
            "Medina",
            "Khobar",
            "Al Khafjī",
            "Al Jumūm",
            "Al Jubayl",
            "Al Hufūf",
            "Al Bukayrīyah",
            "Al Baţţālīyah",
            "Al Bāḩah",
            "‘Afīf",
            "Ad Dilam",
            "Ad Dawādimī",
            "Dammam",
            "Abū ‘Arīsh",
            "Abha",
            "Ash Shafā",
            "Unaizah"
        ],
        "Solomon Islands" => [
            "Honiara"
        ],
        "Seychelles" => [
            "Victoria"
        ],
        "Sudan" => [
            "Zalingei",
            "Wad Medani",
            "Umm Ruwaba",
            "Omdurman",
            "Tokār",
            "Tandaltī",
            "Singa",
            "Shendi",
            "Sawākin",
            "Sinnar",
            "Rabak",
            "Maiurno",
            "Kosti",
            "Kuraymah",
            "Kināna",
            "Kassala",
            "Kadugli",
            "Doka",
            "Dilling",
            "Port Sudan",
            "Berber",
            "Bārah",
            "Atbara",
            "As Sūkī",
            "Ar Ruseris",
            "Ar Rahad",
            "An Nuhūd",
            "El Obeid",
            "Al Qiţena",
            "Al Qadarif",
            "Al Mijlad",
            "Al Manāqil",
            "Khartoum",
            "Geneina",
            "Al Hilāliyya",
            "Al Ḩawātah",
            "Al Hasaheisa",
            "El Fasher",
            "El Bauga",
            "Ad Douiem",
            "El Daein",
            "Ad Dindar",
            "Ed Damer",
            "Ad-Damazin",
            "Abū Zabad",
            "Abu Jibeha"
        ],
        "Sweden" => [
            "Umeå",
            "Skellefteå",
            "Piteå",
            "Luleå",
            "Kiruna",
            "Boden",
            "Ystad",
            "Visby",
            "Växjö",
            "Västervik",
            "Västerås",
            "Värnamo",
            "Varberg",
            "Vänersborg",
            "Vallentuna",
            "Uppsala",
            "Upplands Väsby",
            "Uddevalla",
            "Tumba",
            "Tullinge",
            "Trollhättan",
            "Trelleborg",
            "Täby",
            "Sundsvall",
            "Sundbyberg",
            "Stockholm",
            "Solna",
            "Sollentuna",
            "Södertälje",
            "Skövde",
            "Skara",
            "Sandviken",
            "Råsunda",
            "Partille",
            "Östersund",
            "Östermalm",
            "Oskarshamn",
            "Örnsköldsvik",
            "Örebro",
            "Nyköping",
            "Norrtälje",
            "Norrköping",
            "Nässjö",
            "Nacka",
            "Motala",
            "Mölndal",
            "Märsta",
            "Malmö",
            "Lund",
            "Linköping",
            "Lidköping",
            "Lidingö",
            "Lerum",
            "Landskrona",
            "Kungsbacka",
            "Kungälv",
            "Kristinehamn",
            "Kristianstad",
            "Köping",
            "Katrineholm",
            "Karlstad",
            "Karlskrona",
            "Karlskoga",
            "Karlshamn",
            "Kalmar",
            "Jönköping",
            "Jakobsberg",
            "Huskvarna",
            "Huddinge",
            "Helsingborg",
            "Hässleholm",
            "Härnösand",
            "Haninge",
            "Halmstad",
            "Göteborg",
            "Gävle",
            "Gamla Uppsala",
            "Falun",
            "Falköping",
            "Falkenberg",
            "Eslöv",
            "Eskilstuna",
            "Enköping",
            "Bromma",
            "Borlänge",
            "Borås",
            "Boo",
            "Årsta",
            "Ängelholm",
            "Alingsås",
            "Åkersberga",
            "Majorna"
        ],
        "Singapore" => [
            "Singapore"
        ],
        "Saint Helena" => [
            "Jamestown"
        ],
        "Slovenia" => [
            "Trbovlje",
            "Velenje",
            "Ptuj",
            "Novo Mesto",
            "Maribor",
            "Ljubljana",
            "Kranj",
            "Koper",
            "Celje"
        ],
        "Svalbard and Jan Mayen" => [
            "Longyearbyen"
        ],
        "Slovakia" => [
            "Vranov nad Topľou",
            "Trebišov",
            "Stará Ľubovňa",
            "Spišská Nová Ves",
            "Snina",
            "Rožňava",
            "Rimavská Sobota",
            "Prešov",
            "Poprad",
            "Michalovce",
            "Košice",
            "Kežmarok",
            "Humenné",
            "Bardejov",
            "Zvolen",
            "Zlaté Moravce",
            "Žilina",
            "Žiar nad Hronom",
            "Trnava",
            "Trenčín",
            "Skalica",
            "Senica",
            "Sellye",
            "Ružomberok",
            "Púchov",
            "Prievidza",
            "Považská Bystrica",
            "Piešťany",
            "Pezinok",
            "Partizánske",
            "Nové Zámky",
            "Nové Mesto nad Váhom",
            "Nitra",
            "Martin",
            "Malacky",
            "Lučenec",
            "Liptovský Mikuláš",
            "Levice",
            "Kysucké Nové Mesto",
            "Komárno",
            "Hlohovec",
            "Handlová",
            "Galanta",
            "Dunajská Streda",
            "Dubnica nad Váhom",
            "Dolný Kubín",
            "Detva",
            "Čadca",
            "Brezno",
            "Bratislava",
            "Banská Bystrica",
            "Bánovce nad Bebravou"
        ],
        "Sierra Leone" => [
            "Waterloo",
            "Segbwema",
            "Port Loko",
            "Makeni",
            "Lunsar",
            "Koidu",
            "Kenema",
            "Kabala",
            "Freetown",
            "Bo"
        ],
        "San Marino" => [
            "San Marino"
        ],
        "Senegal" => [
            "Ziguinchor",
            "Vélingara",
            "Touba",
            "Tiébo",
            "Thiès Nones",
            "Tambacounda",
            "Sédhiou",
            "Saint-Louis",
            "Richard-Toll",
            "Pout",
            "Pourham",
            "Pikine",
            "Nioro du Rip",
            "Nguékhokh",
            "Ndibène Dahra",
            "Mékhé",
            "Mbaké",
            "Matam",
            "Louga",
            "Kolda",
            "Kédougou",
            "Kayar",
            "Kaolack",
            "Kaffrine",
            "Joal-Fadiout",
            "Guinguinéo",
            "Dara",
            "Dakar",
            "Bignona"
        ],
        "Somalia" => [
            "Wanlaweyn",
            "Qoryooley",
            "Qandala",
            "Mogadishu",
            "Marka",
            "Luuq",
            "Kismayo",
            "Jilib",
            "Jawhar",
            "Jamaame",
            "Hargeysa",
            "Garoowe",
            "Gaalkacyo",
            "Eyl",
            "Ceerigaabo",
            "Ceeldheer",
            "Buurhakaba",
            "Buulobarde",
            "Burao",
            "Bosaso",
            "Berbera",
            "Beledweyne",
            "Baidoa",
            "Baardheere",
            "Afgooye",
            "Laascaanood",
            "Baki"
        ],
        "Suriname" => [
            "Paramaribo",
            "Lelydorp"
        ],
        "South Sudan" => [
            "Yei",
            "Yambio",
            "Wau",
            "Aweil",
            "Torit",
            "Tonj",
            "Rumbek",
            "Malakal",
            "Juba",
            "Gogrial",
            "Pajok",
            "Bor"
        ],
        "Sao Tome and Principe" => [
            "São Tomé"
        ],
        "El Salvador" => [
            "Zacatecoluca",
            "Usulután",
            "Soyapango",
            "Sonzacate",
            "Sonsonate",
            "Sensuntepeque",
            "San Vicente",
            "Santiago de María",
            "Santa Ana",
            "San Salvador",
            "San Rafael Oriente",
            "San Miguel",
            "San Martín",
            "San Marcos",
            "San Francisco",
            "Quezaltepeque",
            "Puerto El Triunfo",
            "Santa Tecla",
            "Metapán",
            "Mejicanos",
            "La Unión",
            "La Libertad",
            "Izalco",
            "Ilopango",
            "Delgado",
            "Cuscatancingo",
            "Cojutepeque",
            "Chalchuapa",
            "Chalatenango",
            "Ayutuxtepeque",
            "Apopa",
            "Antiguo Cuscatlán",
            "Ahuachapán",
            "Aguilares",
            "Acajutla"
        ],
        "Sint Maarten" => [
            "Philipsburg"
        ],
        "Syria" => [
            "Yabrūd",
            "Ţayyibat al Imām",
            "Tartouss",
            "Tall Rif‘at",
            "Tallkalakh",
            "Tallbīsah",
            "Ţafas",
            "Tadmur",
            "Tādif",
            "Souran",
            "Subaykhān",
            "Ash Shaykh Miskīn",
            "Sarāqib",
            "Salqīn",
            "As Salamīyah",
            "Satita",
            "Qaţanā",
            "Jāsim",
            "Qārah",
            "Nubl",
            "Maşyāf",
            "Manbij",
            "Ma‘arratmişrīn",
            "Khān Shaykhūn",
            "Kafr Zaytā",
            "Kafr Takhārīm",
            "Kafr Nubl",
            "Kafr Lāhā",
            "Jisr ash Shughūr",
            "Jayrūd",
            "Jarābulus",
            "Jablah",
            "‘Irbīn",
            "Inkhil",
            "Idlib",
            "Homs",
            "Ḩarastā",
            "Ḩamāh",
            "Ḩalfāyā",
            "Aleppo",
            "Douma",
            "Damascus",
            "Dayr Ḩāfir",
            "Deir ez-Zor",
            "Ad Darbāsīyah",
            "Dārayyā",
            "Dar‘ā",
            "Binnish",
            "Bāniyās",
            "Az Zabadānī",
            "I‘zāz",
            "‘Ayn al ‘Arab",
            "At Tall",
            "Ath Thawrah",
            "As Suwaydā’",
            "Aş Şanamayn",
            "As Safīrah",
            "Ar Rastan",
            "Ar Raqqah",
            "An Nabk",
            "Al Quţayfah",
            "Al Quşayr",
            "Al Qunayţirah",
            "Al Qaryatayn",
            "Al Mayādīn",
            "Latakia",
            "Al Kiswah",
            "Al Ḩasakah",
            "Al Ḩarāk",
            "Al Bāb",
            "‘Afrīn",
            "Ad Dānā",
            "Ālbū Kamāl",
            "Hajīn"
        ],
        "Swaziland" => [
            "Mbabane",
            "Manzini",
            "Lobamba"
        ],
        "Turks and Caicos Islands" => [
            "Cockburn Town"
        ],
        "Chad" => [
            "Fada",
            "Am Timan",
            "Abéché",
            "Sagh",
            "Pala",
            "Oum Hadjer",
            "N'Djamena",
            "Moussoro",
            "Moundou",
            "Mongo",
            "Mboursou Léré",
            "Massakory",
            "Massaguet",
            "Mao",
            "Laï",
            "Kyabé",
            "Koumra",
            "Kelo",
            "Dourbali",
            "Doba",
            "Bongor",
            "Bitkine",
            "Benoy",
            "Ati"
        ],
        "French Southern Territories" => [
            "Port-aux-Français"
        ],
        "Togo" => [
            "Vogan",
            "Tsévié",
            "Tchamba",
            "Sotouboua",
            "Sokodé",
            "Notsé",
            "Niamtougou",
            "Sansanné-Mango",
            "Lomé",
            "Kpalimé",
            "Kara",
            "Dapaong",
            "Bassar",
            "Bafilo",
            "Badou",
            "Atakpamé",
            "Aného"
        ],
        "Thailand" => [
            "Ban Talat Yai",
            "Ban Talat Nua",
            "Sam Roi Yot",
            "Phetchaburi",
            "Trang",
            "Thung Song",
            "Thoen",
            "Thap Than",
            "Tha Muang",
            "Tha Maka",
            "Tak",
            "Surat Thani",
            "Sukhothai",
            "Si Satchanalai",
            "Sawankhalok",
            "San Pa Tong",
            "San Kamphaeng",
            "Ron Phibun",
            "Ratchaburi",
            "Ranong",
            "Pran Buri",
            "Prachuap Khiri Khan",
            "Phunphin",
            "Phuket",
            "Photharam",
            "Phayao",
            "Pa Sang",
            "Nakhon Si Thammarat",
            "Mae Sot",
            "Mae Sai",
            "Mae Ramat",
            "Mae Chan",
            "Lat Yao",
            "Lang Suan",
            "Lamphun",
            "Lampang",
            "Kui Buri",
            "Krabi",
            "Khao Yoi",
            "Khanu Woralaksaburi",
            "Kathu",
            "Kanchanaburi",
            "Kamphaeng Phet",
            "Huai Yot",
            "Hua Hin",
            "Hang Dong",
            "Dok Kham Tai",
            "Damnoen Saduak",
            "Chumphon",
            "Chom Bueng",
            "Chiang Rai",
            "Chiang Mai",
            "Cha-am",
            "Bo Phloi",
            "Ban Tak",
            "Ko Samui",
            "Ban Pong",
            "Ban Na San",
            "Ban Na",
            "Bang Saphan",
            "Bang Phae",
            "Nong Kung Si",
            "Ban Nong Wua So",
            "Ban Mai",
            "Ban Huai Thalaeng",
            "Ban Khlong Bang Sao Thong",
            "Na Klang",
            "Yasothon",
            "Yaring",
            "Yala",
            "Wiset Chaichan",
            "Wichian Buri",
            "Warin Chamrap",
            "Wang Saphung",
            "Wang Noi",
            "Wang Nam Yen",
            "Uttaradit",
            "Uthai Thani",
            "Udon Thani",
            "Ubon Ratchathani",
            "Trat",
            "Tha Yang",
            "Tha Ruea",
            "Thap Khlo",
            "Tha Mai",
            "Tha Bo",
            "Taphan Hin",
            "Tak Bai",
            "Surin",
            "Suphan Buri",
            "Su-ngai Kolok",
            "Songkhla",
            "Si Sa Ket",
            "Si Racha",
            "Sing Buri",
            "Seka",
            "Sawang Daen Din",
            "Satun",
            "Sattahip",
            "Saraburi",
            "Samut Songkhram",
            "Samut Sakhon",
            "Samut Prakan",
            "Sam Phran",
            "Sakon Nakhon",
            "Sa Kaeo",
            "Sadao",
            "Roi Et",
            "Rayong",
            "Ranot",
            "Ra-ngae",
            "Prakhon Chai",
            "Prachin Buri",
            "Phu Kradueng",
            "Phu Khiao",
            "Phra Pradaeng",
            "Phra Phutthabat",
            "Phra Nakhon Si Ayutthaya",
            "Phrae",
            "Phon Charoen",
            "Phitsanulok",
            "Phichit",
            "Phibun Mangsahan",
            "Phetchabun",
            "Phatthalung",
            "Phan Thong",
            "Phanom Sarakham",
            "Phanat Nikhom",
            "Phak Hai",
            "Pattani",
            "Pathum Thani",
            "Pak Phanang",
            "Pak Kret",
            "Pak Chong",
            "Mueang Nonthaburi",
            "Non Sung",
            "Nong Phai",
            "Nong Khai",
            "Nong Khae",
            "Nong Bua Lamphu",
            "Narathiwat",
            "Nang Rong",
            "Nan",
            "Nam Som",
            "Nakhon Sawan",
            "Nakhon Ratchasima",
            "Nakhon Phanom",
            "Nakhon Pathom",
            "Nakhon Nayok",
            "Nakhon Luang",
            "Mukdahan",
            "Maha Sarakham",
            "Lop Buri",
            "Lom Sak",
            "Loei",
            "Laem Sing",
            "Kut Chap",
            "Kuchinarai",
            "Bangkok",
            "Krathum Baen",
            "Klaeng",
            "Khon Kaen",
            "Khon Buri",
            "Khlong Luang",
            "Khao Wong",
            "Kaset Wisai",
            "Kaset Sombun",
            "Kantharalak",
            "Kamalasai",
            "Kalasin",
            "Kaeng Khoi",
            "Kaeng Khro",
            "Kabin Buri",
            "Hat Yai",
            "Det Udom",
            "Den Chai",
            "Dan Khun Thot",
            "Chum Phae",
            "Chon Daen",
            "Chon Buri",
            "Chok Chai",
            "Chanthaburi",
            "Chaiyaphum",
            "Chai Nat",
            "Chai Badan",
            "Chachoengsao",
            "Buriram",
            "Bua Yai",
            "Betong",
            "Ban Selaphum",
            "Ban Rangsit",
            "Phatthaya",
            "Ban Phan Don",
            "Ban Phai",
            "Ban Phaeo",
            "Ban Mo",
            "Ban Lam Luk Ka",
            "Bang Rakam",
            "Bang Racham",
            "Bang Pakong",
            "Bang Pa-in",
            "Bang Mun Nak",
            "Bang Len",
            "Bang Lamung",
            "Bang Kruai",
            "Bang Krathum",
            "Bang Bua Thong",
            "Bang Ban",
            "Ban Dung",
            "Ban Chang",
            "Ban Bueng",
            "Ban Talat Bueng",
            "Ban Bang Kadi Pathum Thani",
            "Bang Bo District",
            "Aranyaprathet",
            "Amnat Charoen",
            "Amphoe Sikhiu",
            "Wichit",
            "Ban Chalong",
            "Ban Ratsada"
        ],
        "Tajikistan" => [
            "Yovon",
            "Vose’",
            "Vakhsh",
            "Istaravshan",
            "Tursunzoda",
            "Qŭrghonteppa",
            "Panjakent",
            "Farkhor",
            "Vahdat",
            "Norak",
            "Kŭlob",
            "Kolkhozobod",
            "Khorugh",
            "Ishqoshim",
            "Hisor",
            "Dushanbe",
            "Danghara",
            "Chubek",
            "Boshkengash",
            "Proletar",
            "Khŭjand",
            "Konibodom",
            "Isfara",
            "Chkalov",
            "Moskovskiy"
        ],
        "East Timor" => [
            "Suai",
            "Maubara",
            "Maliana",
            "Liquica",
            "Dili",
            "Baucau",
            "Aileu",
            "Same",
            "Lospalos",
            "Venilale"
        ],
        "Turkmenistan" => [
            "Balkanabat",
            "Kaka",
            "Gumdag",
            "Gazanjyk",
            "Abadan",
            "Baharly",
            "Ashgabat",
            "Annau",
            "Yylanly",
            "Tagta",
            "Türkmenbaşy",
            "Köneürgench",
            "Boldumsaz",
            "Daşoguz",
            "Yolöten",
            "Tejen",
            "Seydi",
            "Saýat",
            "Mary",
            "Atamyrat",
            "Gowurdak",
            "Türkmenabat",
            "Bayramaly",
            "Gazojak"
        ],
        "Tunisia" => [
            "Zaghouan",
            "Oued Lill",
            "Tunis",
            "Tozeur",
            "Tataouine",
            "Thala",
            "Takelsa",
            "Tajerouine",
            "Sousse",
            "Siliana",
            "Sidi Bouzid",
            "Skanes",
            "Sfax",
            "La Sebala du Mornag",
            "Radès",
            "Ksour Essaf",
            "Korba",
            "Kélibia",
            "Kebili",
            "Ksar Hellal",
            "Carthage",
            "El Fahs",
            "Galaat el Andeless",
            "Gafsa",
            "Gabès",
            "Nefta",
            "Nabeul",
            "Midoun",
            "Mateur",
            "Msaken",
            "Menzel Jemil",
            "Mennzel Bou Zelfa",
            "Menzel Bourguiba",
            "Menzel Abderhaman",
            "Manouba",
            "Medjez el Bab",
            "Medenine",
            "Jendouba",
            "Zarzis",
            "Djemmal",
            "Houmt Souk",
            "Hammam Sousse",
            "Hammam-Lif",
            "La Goulette",
            "Douz",
            "Douar Tindja",
            "Dar Chabanne",
            "Ben Arous",
            "Bizerte",
            "Beni Khiar",
            "Béja",
            "Zouila",
            "Chebba",
            "Ariana",
            "Ar Rudayyif",
            "Ouardenine",
            "Kairouan",
            "Kasserine",
            "Gremda",
            "Monastir",
            "La Mohammedia",
            "Metlaoui",
            "Al Marsá",
            "Mahdia",
            "El Kef",
            "El Jem",
            "Hammamet",
            "El Hamma",
            "Bekalta",
            "El Alia",
            "Akouda",
            "Douane"
        ],
        "Tonga" => [
            "Nuku‘alofa"
        ],
        "Turkey" => [
            "Yüksekova",
            "Yozgat",
            "Yeşilli",
            "Erzin",
            "Yerköy",
            "Didim",
            "Yatağan",
            "Yalvaç",
            "Yahyalı",
            "Viranşehir",
            "Varto",
            "Van",
            "Cimin",
            "Uşak",
            "Urla",
            "Ürgüp",
            "Şanlıurfa",
            "Turgutlu",
            "Tunceli",
            "Torbalı",
            "Tire",
            "Tekirova",
            "Tavşanlı",
            "Tatvan",
            "Tarsus",
            "Talas",
            "Susurluk",
            "Suruç",
            "Sorgun",
            "Soma",
            "Solhan",
            "Söke",
            "Siverek",
            "Sivas",
            "Şırnak",
            "Simav",
            "Silvan",
            "Silopi",
            "Silifke",
            "Siirt",
            "Seydişehir",
            "Serinyol",
            "Serik",
            "Şereflikoçhisar",
            "Senirkent",
            "Şemdinli",
            "Selçuk",
            "Seferhisar",
            "Şarkışla",
            "Şarkîkaraağaç",
            "Sarayköy",
            "Sandıklı",
            "Salihli",
            "Reyhanlı",
            "Polatlı",
            "Pazarcık",
            "Patnos",
            "Pasinler",
            "Osmaniye",
            "Ortaköy",
            "Ortaca",
            "Ödemiş",
            "Nusaybin",
            "Nizip",
            "Niğde",
            "Nevşehir",
            "Nazilli",
            "Mut",
            "Muş",
            "Muğla",
            "Mucur",
            "Milas",
            "Midyat",
            "Mercin",
            "Menemen",
            "Marmaris",
            "Mardin",
            "Manisa",
            "Manavgat",
            "Malazgirt",
            "Malatya",
            "Mahmutlar",
            "Lice",
            "Kütahya",
            "Kuşadası",
            "Kurtalan",
            "Beykonak",
            "Kulu",
            "Kulp",
            "Kula",
            "Kozluk",
            "Kozan",
            "Kovancılar",
            "Korkuteli",
            "Konya",
            "Kızıltepe",
            "Serinhisar",
            "Kırşehir",
            "Kırkağaç",
            "Kırıkkale",
            "Kırıkhan",
            "Kilis",
            "Keskin",
            "Kemer",
            "Kemalpaşa",
            "Kayseri",
            "Karapınar",
            "Karaman",
            "Ağrı",
            "Karakoçan",
            "Karaçoban",
            "Kaman",
            "Kâhta",
            "Kahramanmaraş",
            "Kadirli",
            "Kadınhanı",
            "İzmir",
            "Isparta",
            "İdil",
            "Hizan",
            "Hınıs",
            "Hilvan",
            "Hadim",
            "Hacılar",
            "Güroymak",
            "Gölbaşı",
            "Göksun",
            "Genç",
            "Gemerek",
            "Gediz",
            "Gazipaşa",
            "Gaziantep",
            "Foça",
            "Fethiye",
            "Ezine",
            "Eskişehir",
            "Erzurum",
            "Erzincan",
            "Ermenek",
            "Ergani",
            "Ereğli",
            "Erdemli",
            "Erciş",
            "Emirdağ",
            "Emet",
            "Elmalı",
            "Elmadağ",
            "Eleşkirt",
            "Elbistan",
            "Elazığ",
            "Eğirdir",
            "Edremit",
            "Dursunbey",
            "Dörtyol",
            "Doğubayazıt",
            "Diyarbakır",
            "Diyadin",
            "Dinar",
            "Develi",
            "Denizli",
            "Demirci",
            "Dargeçit",
            "Darende",
            "Çumra",
            "Menderes",
            "Hakkari",
            "Cizre",
            "Çine",
            "Ceylanpınar",
            "Ceyhan",
            "Çeşme",
            "Çermik",
            "Çay",
            "Çağlayancerit",
            "Burhaniye",
            "Burdur",
            "Bulanık",
            "Bucak",
            "Bozyazı",
            "Bozüyük",
            "Bozova",
            "Bor",
            "Bolvadin",
            "Bodrum",
            "Bitlis",
            "Bismil",
            "Birecik",
            "Bingöl",
            "Bigadiç",
            "Beyşehir",
            "Besni",
            "Bergama",
            "Belen",
            "Belek",
            "Bayındır",
            "Batman",
            "Baskil",
            "Banaz",
            "Balıkesir",
            "Bahçe",
            "Ayvalık",
            "Aydın",
            "Aşkale",
            "Antalya",
            "Antakya",
            "Ankara",
            "Anamur",
            "Aliağa",
            "Alaşehir",
            "Alanya",
            "Akşehir",
            "Aksaray",
            "Akhisar",
            "Akdağmadeni",
            "Akçakale",
            "Ahlat",
            "Afyonkarahisar",
            "Afşin",
            "Adıyaman",
            "Adilcevaz",
            "Adana",
            "Denizciler",
            "Batikent",
            "Dalaman",
            "Zonguldak",
            "Zile",
            "Zeytinburnu",
            "Yomra",
            "Yenişehir",
            "Körfez",
            "Yalova",
            "Yakuplu",
            "Vezirköprü",
            "Vakfıkebir",
            "Uzunköprü",
            "Üsküdar",
            "Ünye",
            "Umraniye",
            "Turhal",
            "Trabzon",
            "Tosya",
            "Tokat",
            "Tirebolu",
            "Terme",
            "Tepecik",
            "Tekkeköy",
            "Tekirdağ",
            "Taşova",
            "Taşköprü",
            "Suşehri",
            "Sürmene",
            "Sungurlu",
            "Suluova",
            "Şişli",
            "Sinop",
            "Silivri",
            "Şebin Karahisar",
            "Sarıkamış",
            "Sapanca",
            "Samsun",
            "Safranbolu",
            "Rize",
            "Osmaneli",
            "Osmancık",
            "Orhangazi",
            "Ordu",
            "Oltu",
            "Of",
            "Niksar",
            "Nallıhan",
            "Mustafakemalpaşa",
            "Mudanya",
            "Mimarsinan",
            "Merzifon",
            "Maltepe",
            "Malkara",
            "Lüleburgaz",
            "Kumru",
            "Korgan",
            "Kocaali",
            "Kızılcahamam",
            "Kırklareli",
            "Kestel",
            "Keşan",
            "Kelkit",
            "Kazan",
            "Kavaklı",
            "Kastamonu",
            "Kars",
            "Karasu",
            "Karamürsel",
            "Karacabey",
            "Karabük",
            "Kağızman",
            "İznik",
            "İzmit",
            "İstanbul",
            "İskilip",
            "İnegol",
            "Horasan",
            "Hopa",
            "Hendek",
            "Hayrabolu",
            "Havza",
            "Gürsu",
            "Gürpınar",
            "Gürgentepe",
            "Gumushkhane",
            "Görele",
            "Gönen",
            "Gölcük",
            "Giresun",
            "Geyve",
            "Gerede",
            "Gemlik",
            "Gelibolu",
            "Gebze",
            "Ferizli",
            "Fatsa",
            "Esenyurt",
            "Esenler",
            "Ereğli",
            "Erdek",
            "Erbaa",
            "Eminönü",
            "Edirne",
            "Düzce",
            "Devrek",
            "Çubuk",
            "Çorum",
            "Çorlu",
            "Çerkezköy",
            "Çerkeş",
            "Çayeli",
            "Çaycuma",
            "Çatalca",
            "Çarşamba",
            "Khanjarah",
            "Çanakkale",
            "Çan",
            "Bursa",
            "Bulancak",
            "Boyabat",
            "Bolu",
            "Bilecik",
            "Biga",
            "Beypazarı",
            "Beşikdüzü",
            "Bayburt",
            "Bartın",
            "Bandırma",
            "Bağcılar",
            "Bafra",
            "Babaeski",
            "Artvin",
            "Arsin",
            "Arhavi",
            "Ardeşen",
            "Ardahan",
            "Araklı",
            "Amasya",
            "Alaplı",
            "Alaca",
            "Akyazı",
            "Akçakoca",
            "Akçaabat",
            "Adapazarı",
            "Espiye",
            "merter keresteciler",
            "güngören merter",
            "Turgutreis",
            "Sarigerme",
            "Ataşehir",
            "Başakşehir",
            "Beylikdüzü",
            "Büyükçekmece",
            "Çankaya",
            "Bahçelievler",
            "Sultangazi",
            "Sultanbeyli",
            "Sancaktepe",
            "Karabağlar",
            "Muratpaşa"
        ],
        "Trinidad and Tobago" => [
            "Tunapuna",
            "Scarborough",
            "Sangre Grande",
            "San Fernando",
            "Rio Claro",
            "Port of Spain",
            "Point Fortin",
            "Paradise",
            "Mon Repos",
            "Marabella",
            "Laventille",
            "Chaguanas",
            "Arima"
        ],
        "Tuvalu" => [
            "Funafuti"
        ],
        "Taiwan" => [
            "Douliu",
            "Yujing",
            "Taipei",
            "Tainan",
            "Taichung",
            "Daxi",
            "Banqiao",
            "Puli",
            "Nantou",
            "Magong",
            "Lugu",
            "Kaohsiung",
            "Yilan",
            "Hualien City",
            "Hsinchu",
            "Hengchun",
            "Jincheng",
            "Keelung",
            "Taoyuan City",
            "Taitung City",
            "Zhongxing New Village"
        ],
        "Tanzania" => [
            "Zanzibar",
            "Wete",
            "Vwawa",
            "Vikindu",
            "Uyovu",
            "Uvinza",
            "Ushirombo",
            "Usevia",
            "Usagara",
            "Usa River",
            "Urambo",
            "Tunduma",
            "Tumbi",
            "Tukuyu",
            "Tinde",
            "Tarime",
            "Tanga",
            "Tabora",
            "Sumbawanga",
            "Songwa",
            "Somanda",
            "Sokoni",
            "Sirari",
            "Singida",
            "Sikonge",
            "Shinyanga",
            "Shelui",
            "Sepuka",
            "Same",
            "Rulenge",
            "Rujewa",
            "Puma",
            "Old Shinyanga",
            "Nzega",
            "Nyamuswa",
            "Nyalikungu",
            "Nyakabindi",
            "Nsunga",
            "Nshamba",
            "Njombe",
            "Nguruka",
            "Ngudu",
            "Ngerengere",
            "Ngara",
            "Nangwa",
            "Namanyere",
            "Mwanza",
            "Mwadui",
            "Mvomero",
            "Musoma",
            "Muriti",
            "Mungaa",
            "Muheza",
            "Mugumu",
            "Mtwango",
            "Mto wa Mbu",
            "Mtinko",
            "Msowero",
            "Mpwapwa",
            "Mpanda",
            "Moshi",
            "Morogoro",
            "Mlowo",
            "Mlimba",
            "Mlangali",
            "Mlandizi",
            "Mlalo",
            "Mkuranga",
            "Mwandiga",
            "Misungwi",
            "Mikumi",
            "Mhango",
            "Mgandu",
            "Mbuguni",
            "Mbeya",
            "Mazinde",
            "Matui",
            "Matai",
            "Maswa",
            "Masumbwe",
            "Maramba",
            "Malinyi",
            "Malampaka",
            "Makuyuni",
            "Makumbako",
            "Mahanje",
            "Kihangara",
            "Magugu",
            "Magomeni",
            "Magole",
            "Mafinga",
            "Mabama",
            "Lushoto",
            "Lugoba",
            "Liwale",
            "Lembeni",
            "Lalago",
            "Laela",
            "Kyela",
            "Kondoa",
            "Kiwira",
            "Kishapu",
            "Kisesa",
            "Kirando",
            "Kiomboi",
            "Kingori",
            "Kilosa",
            "Kigoma",
            "Kidodi",
            "Kidatu",
            "Kibondo",
            "Kibiti",
            "Kibara",
            "Kibakwe",
            "Kibaha",
            "Katumba",
            "Katoro",
            "Katerero",
            "Kasulu",
            "Kasamwa",
            "Kiratu",
            "Kamachumu",
            "Kakonko",
            "Kahama",
            "Kabanga",
            "Izazi",
            "Itigi",
            "Isaka",
            "Iringa",
            "Ipinda",
            "Ilula",
            "Ilongero",
            "Ilembula",
            "Ikungi",
            "Igurusi",
            "Igunga",
            "Igugunu",
            "Ifakara",
            "Hedaru",
            "Geita",
            "Geiro",
            "Galappo",
            "Dongobesh",
            "Dodoma",
            "Dar es Salaam",
            "Dareda",
            "Chimala",
            "Chato",
            "Chanika",
            "Chalinze",
            "Chala",
            "Chake Chake",
            "Butiama",
            "Buseresere",
            "Bungu",
            "Bunda",
            "Bukoba",
            "Bugarama",
            "Biharamulo",
            "Basotu",
            "Bashanet",
            "Bariadi",
            "Bagamoyo",
            "Babati",
            "Arusha",
            "Tingi",
            "Tandahimba",
            "Songea",
            "Nyangao",
            "Newala Kisimani",
            "Nanyamba",
            "Nangomba",
            "Nanganga",
            "Nachingwea",
            "Mtwara",
            "Mbinga",
            "Matiri",
            "Masasi",
            "Maposeni",
            "Lukuledi",
            "Luchingu",
            "Lindi",
            "Kitama",
            "Kigonsera",
            "Merelani"
        ],
        "Ukraine" => [
            "Lebedyn",
            "Druzhkivka",
            "Vasylivka",
            "Zvenyhorodka",
            "Zuhres",
            "Zolotonosha",
            "Zolochiv",
            "Znomenka",
            "Zmiyiv",
            "Zhytomyr",
            "Zhmerynka",
            "Zhovti Vody",
            "Zhashkiv",
            "Zdolbuniv",
            "Zaporizhzhya",
            "Yuzhne",
            "Yevpatoriya",
            "Yenakiyeve",
            "Yasynuvata",
            "Yalta",
            "Yahotyn",
            "Vyshhorod",
            "Vynohradiv",
            "Voznesensk",
            "Volnovakha",
            "Vovchans’k",
            "Volodymyr-Volyns’kyy",
            "Vyshneve",
            "Vinnytsya",
            "Vatutine",
            "Vasylkiv",
            "Uzhhorod",
            "Uman’",
            "Tul’chyn",
            "Tsyurupyns’k",
            "Truskavets",
            "Torez",
            "Tokmak",
            "Ternopil’",
            "Tal’ne",
            "Syevyerodonets’k",
            "Svitlovods’k",
            "Sverdlovs’k",
            "Svatove",
            "Svalyava",
            "Sumy",
            "Stryi",
            "Stebnyk",
            "Starokostyantyniv",
            "Starobil’s’k",
            "Stakhanov",
            "Sokal’",
            "Snizhne",
            "Smila",
            "Sloviansk",
            "Slavuta",
            "Skvyra",
            "Skadovs’k",
            "Synel’nykove",
            "Simferopol",
            "Shpola",
            "Shostka",
            "Shepetivka",
            "Shakhtars’k",
            "Sevastopol",
            "Selydove",
            "Sarny",
            "Sambir",
            "Saky",
            "Rubizhne",
            "Rozdil’na",
            "Roven’ky",
            "Romny",
            "Rivne",
            "Reni",
            "Radomyshl’",
            "Piatykhatky",
            "Putyvl’",
            "Pryluky",
            "Popasna",
            "Poltava",
            "Polonne",
            "Polohy",
            "Pidhorodne",
            "Pyryatyn",
            "Pervomays’k",
            "Pervomays’k",
            "Pereyaslav-Khmel’nyts’kyy",
            "Pereval’s’k",
            "Pavlohrad",
            "Ovruch",
            "Orikhiv",
            "Oleksandriya",
            "Odessa",
            "Ochakiv",
            "Obukhiv",
            "Novyy Buh",
            "Novovolyns’k",
            "Novoukrayinka",
            "Novomoskovs’k",
            "Novohrad-Volyns’kyy",
            "Nova Kakhovka",
            "Nosivka",
            "Nizhyn",
            "Nyzhn’ohirs’kyy",
            "Nikopol’",
            "Netishyn",
            "Nadvirna",
            "Mykolayiv",
            "Mukacheve",
            "Molodohvardiys’k",
            "Mohyliv-Podil’s’kyy",
            "Miskhor",
            "Myrhorod",
            "Merefa",
            "Melitopol’",
            "Mariupol",
            "Marhanets’",
            "Malyn",
            "Makiyivka",
            "Lyubotyn",
            "Lviv",
            "Lutuhyne",
            "Luts’k",
            "Luhansk",
            "Lubny",
            "Lozova",
            "Lysychans’k",
            "Ladyzhyn",
            "Kiev",
            "Kuznetsovs’k",
            "Kurakhovo",
            "Kupjansk",
            "Kryvyi Rih",
            "Krolevets’",
            "Kreminna",
            "Kremenets’",
            "Kremenchuk",
            "Krasnyy Luch",
            "Krasnyy Lyman",
            "Krasnoperekops’k",
            "Krasnohrad",
            "Krasnodon",
            "Krasnoarmiys’k",
            "Krasyliv",
            "Kramators’k",
            "Kivsharivka",
            "Kovel’",
            "Kotovs’k",
            "Kostopil’",
            "Korsun’-Shevchenkivs’kyy",
            "Korostyshiv",
            "Korosten’",
            "Kostyantynivka",
            "Konotop",
            "Komsomol’s’ke",
            "Kolomyya",
            "Kivertsi",
            "Kirovs’k",
            "Kirovohrad",
            "Kiliya",
            "Khust",
            "Khmel’nyts’kyy",
            "Khmil’nyk",
            "Kherson",
            "Khartsyz’k",
            "Kharkiv",
            "Kerch",
            "Kozyatyn",
            "Karlivka",
            "Kaniv",
            "Kamieniec Podolski",
            "Kalush",
            "Kalynivka",
            "Kakhovka",
            "Izyum",
            "Izyaslav",
            "Izmayil",
            "Ivano-Frankivs’k",
            "Irpin",
            "Ilovays’k",
            "Illichivs’k",
            "Horodok",
            "Horlivka",
            "Hlukhiv",
            "Hulyaypole",
            "Horodok",
            "Horodyshche",
            "Hola Prystan’",
            "Heniches’k",
            "Hayvoron",
            "Haysyn",
            "Hadyach",
            "Feodosiya",
            "Fastiv",
            "Energodar",
            "Dzhankoy",
            "Dzerzhyns’k",
            "Dunaivtsi",
            "Dubno",
            "Drohobych",
            "Donetsk",
            "Dolyna",
            "Dolyns'ka",
            "Dokuchayevs’k",
            "Dobropillya",
            "Dnipropetrovsk",
            "Dniprodzerzhyns’k",
            "Dniprorudne",
            "Dymytrov",
            "Derhachi",
            "Debal’tseve",
            "Chuhuyiv",
            "Chortkiv",
            "Chervonopartyzans’k",
            "Chervonohrad",
            "Chernivtsi",
            "Chernihiv",
            "Cherkasy",
            "Bucha",
            "Bryanka",
            "Brovary",
            "Brody",
            "Boyarka",
            "Boryspil’",
            "Boryslav",
            "Bolhrad",
            "Bohuslav",
            "Bohodukhiv",
            "Bilhorod-Dnistrovs’kyy",
            "Bila Tserkva",
            "Бережани",
            "Berehove",
            "Berdychiv",
            "Berdyans’k",
            "Bilopillya",
            "Bilohirs’k",
            "Bar",
            "Balta",
            "Balakliya",
            "Balaklava",
            "Bakhmach",
            "Bakhchysaray",
            "Avdiyivka",
            "Artsyz",
            "Artemivs’k",
            "Armyans’k",
            "Apostolove",
            "Antratsyt",
            "Amvrosiyivka",
            "Alushta",
            "Alchevs’k",
            "Okhtyrka",
            "Komsomolsk",
            "Славутич",
            "Yuzhnoukrains'k",
            "Novoyavorivs'k"
        ],
        "Uganda" => [
            "Yumbe",
            "Wobulenzi",
            "Wakiso",
            "Tororo",
            "Soroti",
            "Pallisa",
            "Paidha",
            "Nyachera",
            "Ntungamo",
            "Ntungamo",
            "Njeru",
            "Nebbi",
            "Namasuba",
            "Mukono",
            "Mubende",
            "Moyo",
            "Mityana",
            "Mbarara",
            "Mbale",
            "Masindi",
            "Masaka",
            "Luwero",
            "Lugazi",
            "Lira",
            "Kyenjojo",
            "Kotido",
            "Kitgum",
            "Kireka",
            "Kayunga",
            "Kasese",
            "Kamwenge",
            "Kampala",
            "Kabale",
            "Jinja",
            "Iganga",
            "Hoima",
            "Gulu",
            "Fort Portal",
            "Entebbe",
            "Bwizibwera",
            "Buwenge",
            "Busia",
            "Busembatia",
            "Bundibugyo",
            "Bugiri",
            "Arua",
            "Adjumani"
        ],
        "United States" => [
            "Fort Hunt",
            "Bessemer",
            "Paducah",
            "Birmingham",
            "Center Point",
            "Daphne",
            "Decatur",
            "Dothan",
            "East Florence",
            "Enterprise",
            "Fairhope",
            "Florence",
            "Gadsden",
            "Helena",
            "Homewood",
            "Hoover",
            "Hueytown",
            "Huntsville",
            "Madison",
            "Mobile",
            "Montgomery",
            "Mountain Brook",
            "Northport",
            "Opelika",
            "Oxford",
            "Pelham",
            "Phenix City",
            "Prattville",
            "Prichard",
            "Selma",
            "Talladega",
            "Tillmans Corner",
            "Troy",
            "Trussville",
            "Tuscaloosa",
            "Vestavia Hills",
            "Bella Vista",
            "Benton",
            "Bentonville",
            "Blytheville",
            "Bryant",
            "Cabot",
            "Conway",
            "El Dorado",
            "Fayetteville",
            "Forrest City",
            "Fort Smith",
            "Hot Springs",
            "Jacksonville",
            "Jonesboro",
            "Little Rock",
            "Maumelle",
            "North Little Rock",
            "Paragould",
            "Pine Bluff",
            "Rogers",
            "Russellville",
            "Searcy",
            "Siloam Springs",
            "Springdale",
            "Texarkana",
            "Van Buren",
            "West Memphis",
            "Washington, D.C.",
            "Bear",
            "Dover",
            "Middletown",
            "Newark",
            "Wilmington",
            "Allapattah",
            "Altamonte Springs",
            "Apopka",
            "Aventura",
            "Bartow",
            "Bayonet Point",
            "Bayshore Gardens",
            "Belle Glade",
            "Bellview",
            "Bloomingdale",
            "Boca Del Mar",
            "Boca Raton",
            "Bonita Springs",
            "Boynton Beach",
            "Bradenton",
            "Brandon",
            "Brent",
            "Brownsville",
            "Buenaventura Lakes",
            "Cantonment",
            "Cape Coral",
            "Carol City",
            "Carrollwood",
            "Carrollwood Village",
            "Casselberry",
            "Citrus Park",
            "Clearwater",
            "Clermont",
            "Cocoa",
            "Coconut Creek",
            "Coconut Grove",
            "Cooper City",
            "Coral Gables",
            "Coral Springs",
            "Coral Terrace",
            "Country Walk",
            "Country Club",
            "Crestview",
            "Cutler",
            "Cutler Ridge",
            "Dania Beach",
            "Davie",
            "Daytona Beach",
            "DeLand",
            "DeBary",
            "Deerfield Beach",
            "Delray Beach",
            "Deltona",
            "Doral",
            "Dunedin",
            "East Lake",
            "East Pensacola Heights",
            "Edgewater",
            "Egypt Lake-Leto",
            "Ensley",
            "Estero",
            "Eustis",
            "Ferry Pass",
            "Flagami",
            "Florida Ridge",
            "Fort Lauderdale",
            "Fort Myers",
            "Fort Pierce",
            "Fort Walton Beach",
            "Fountainebleau",
            "Fruit Cove",
            "Gainesville",
            "Glenvar Heights",
            "Golden Gate",
            "Golden Glades",
            "Greenacres City",
            "Haines City",
            "Hallandale Beach",
            "Hialeah",
            "Hialeah Gardens",
            "Holiday",
            "Hollywood",
            "Homestead",
            "Immokalee",
            "Iona",
            "Ives Estates",
            "Jacksonville",
            "Jacksonville Beach",
            "Jasmine Estates",
            "Jupiter",
            "Kendale Lakes",
            "Kendall",
            "Key West",
            "Keystone",
            "Kissimmee",
            "Lake Butler",
            "Lake Magdalene",
            "Lake Worth",
            "Lake Worth Corridor",
            "Lakeland",
            "Lakeside",
            "Land O' Lakes",
            "Largo",
            "Lauderdale Lakes",
            "Lauderhill",
            "Lealman",
            "Leesburg",
            "Lehigh Acres",
            "Leisure City",
            "Lutz",
            "Lynn Haven",
            "Maitland",
            "Margate",
            "Meadow Woods",
            "Melbourne",
            "Merritt Island",
            "Miami",
            "Miami Beach",
            "Miami Gardens",
            "Miami Lakes",
            "Miramar",
            "Myrtle Grove",
            "Naples",
            "Navarre",
            "New Smyrna Beach",
            "Norland",
            "North Fort Myers",
            "North Lauderdale",
            "North Miami",
            "North Miami Beach",
            "North Port",
            "Oak Ridge",
            "Oakland Park",
            "Ocala",
            "Ocoee",
            "Ojus",
            "Opa-locka",
            "Orlando",
            "Ormond Beach",
            "Oviedo",
            "Pace",
            "Palm Bay",
            "Palm Beach Gardens",
            "Palm City",
            "Palm Coast",
            "Palm Harbor",
            "Palm Springs",
            "Palm Valley",
            "Palmetto Bay",
            "Panama City",
            "Parkland",
            "Pembroke Pines",
            "Pensacola",
            "Pine Hills",
            "Pinecrest",
            "Pinellas Park",
            "Pinewood",
            "Plant City",
            "Plantation",
            "Poinciana",
            "Pompano Beach",
            "Ponte Vedra Beach",
            "Port Charlotte",
            "Port Orange",
            "Port Saint Lucie",
            "Princeton",
            "Punta Gorda",
            "Punta Gorda Isles",
            "Richmond West",
            "Riverview",
            "Riviera Beach",
            "Rockledge",
            "Royal Palm Beach",
            "Ruskin",
            "Safety Harbor",
            "Saint Cloud",
            "Saint Petersburg",
            "San Carlos Park",
            "Sanford",
            "Sarasota",
            "Sebastian",
            "Seminole",
            "South Bradenton",
            "South Miami Heights",
            "Southchase",
            "Spring Hill",
            "Stuart",
            "Sun City Center",
            "Sunny Isles Beach",
            "Sunrise",
            "Sunset",
            "Tallahassee",
            "Tamarac",
            "Tamiami",
            "Tampa",
            "Tarpon Springs",
            "Temple Terrace",
            "The Crossings",
            "The Hammocks",
            "The Villages",
            "Three Lakes",
            "Titusville",
            "Town 'n' Country",
            "University Park",
            "Valrico",
            "Venice",
            "Vero Beach",
            "Wekiwa Springs",
            "Wellington",
            "Wesley Chapel",
            "Westchase",
            "West Little River",
            "West Melbourne",
            "West Palm Beach",
            "West Pensacola",
            "West and East Lealman",
            "Westchester",
            "Weston",
            "Winter Garden",
            "Winter Haven",
            "Winter Park",
            "Winter Springs",
            "Wright",
            "Acworth",
            "Albany",
            "Alpharetta",
            "Americus",
            "Athens",
            "Atlanta",
            "Augusta",
            "Belvedere Park",
            "Brookhaven",
            "Brunswick",
            "Calhoun",
            "Canton",
            "Carrollton",
            "Cartersville",
            "Columbus",
            "Conyers",
            "Dalton",
            "Decatur",
            "Douglasville",
            "Dublin",
            "Duluth",
            "Dunwoody",
            "East Point",
            "Evans",
            "Fayetteville",
            "Forest Park",
            "Gainesville",
            "Griffin",
            "Hinesville",
            "Kennesaw",
            "Kingsland",
            "La Grange",
            "Lawrenceville",
            "Lithia Springs",
            "Mableton",
            "Macon",
            "Marietta",
            "Martinez",
            "McDonough",
            "Milledgeville",
            "Newnan",
            "North Decatur",
            "North Druid Hills",
            "Peachtree City",
            "Pooler",
            "Redan",
            "Riverdale",
            "Rome",
            "Roswell",
            "St. Marys",
            "Sandy Springs",
            "Savannah",
            "Smyrna",
            "Snellville",
            "Statesboro",
            "Stockbridge",
            "Sugar Hill",
            "Suwanee",
            "Thomasville",
            "Tifton",
            "Tucker",
            "Union City",
            "Valdosta",
            "Warner Robins",
            "Wilmington Island",
            "Woodstock",
            "Alton",
            "Belleville",
            "Cahokia",
            "Carbondale",
            "Charleston",
            "Collinsville",
            "Decatur",
            "East Saint Louis",
            "Edwardsville",
            "Fairview Heights",
            "Godfrey",
            "Granite City",
            "Jacksonville",
            "Marion",
            "Mattoon",
            "Mount Vernon",
            "O'Fallon",
            "Quincy",
            "Springfield",
            "Upper Alton",
            "Bloomington",
            "Broad Ripple",
            "Brownsburg",
            "Carmel",
            "Clarksville",
            "Columbus",
            "Evansville",
            "Fishers",
            "Greenfield",
            "Greenwood",
            "Indianapolis",
            "Jasper",
            "Jeffersonville",
            "Lawrence",
            "New Albany",
            "New Castle",
            "Plainfield",
            "Richmond",
            "Seymour",
            "Shelbyville",
            "Terre Haute",
            "Vincennes",
            "Derby",
            "Emporia",
            "Gardner",
            "Great Bend",
            "Hays",
            "Hutchinson",
            "Junction City",
            "Kansas City",
            "Lawrence",
            "Leavenworth",
            "Leawood",
            "Lenexa",
            "Manhattan",
            "Newton",
            "Olathe",
            "Overland Park",
            "Pittsburg",
            "Prairie Village",
            "Salina",
            "Shawnee",
            "Topeka",
            "Wichita",
            "Ashland",
            "Bowling Green",
            "Burlington",
            "Covington",
            "Danville",
            "Elizabethtown",
            "Erlanger",
            "Fern Creek",
            "Florence",
            "Fort Thomas",
            "Frankfort",
            "Georgetown",
            "Henderson",
            "Highview",
            "Hopkinsville",
            "Independence",
            "Ironville",
            "Jeffersontown",
            "Lexington",
            "Lexington-Fayette",
            "Louisville",
            "Madisonville",
            "Meads",
            "Murray",
            "Newburg",
            "Newport",
            "Nicholasville",
            "Okolona",
            "Owensboro",
            "Pleasure Ridge Park",
            "Radcliff",
            "Richmond",
            "Saint Matthews",
            "Shively",
            "Valley Station",
            "Winchester",
            "Alexandria",
            "Baton Rouge",
            "Bayou Cane",
            "Bossier City",
            "Central",
            "Chalmette",
            "Estelle",
            "Gretna",
            "Hammond",
            "Harvey",
            "Houma",
            "Kenner",
            "Lafayette",
            "Lake Charles",
            "Laplace",
            "Marrero",
            "Metairie",
            "Metairie Terrace",
            "Monroe",
            "Natchitoches",
            "New Iberia",
            "New Orleans",
            "Opelousas",
            "Prairieville",
            "Ruston",
            "Shenandoah",
            "Shreveport",
            "Slidell",
            "Sulphur",
            "Terrytown",
            "Adelphi",
            "Annapolis",
            "Arbutus",
            "Arnold",
            "Aspen Hill",
            "Baltimore",
            "Ballenger Creek",
            "Beltsville",
            "Bethesda",
            "Bowie",
            "Calverton",
            "Camp Springs",
            "Carney",
            "Catonsville",
            "Chillum",
            "Cloverly",
            "Clinton",
            "Cockeysville",
            "College Park",
            "Columbia",
            "Crofton",
            "Cumberland",
            "Damascus",
            "Dundalk",
            "East Riverdale",
            "Easton",
            "Edgewood",
            "Eldersburg",
            "Elkton",
            "Elkridge",
            "Ellicott City",
            "Essex",
            "Fairland",
            "Ferndale",
            "Fort Washington",
            "Frederick",
            "Gaithersburg",
            "Germantown",
            "Glassmanor",
            "Glen Burnie",
            "Green Haven",
            "Greenbelt",
            "Hagerstown",
            "Hanover",
            "Hillcrest Heights",
            "Hunt Valley",
            "Hyattsville",
            "Ilchester",
            "Lake Shore",
            "Landover",
            "Langley Park",
            "Laurel",
            "Lochearn",
            "Maryland City",
            "Middle River",
            "Milford Mill",
            "Montgomery Village",
            "North Bel Air",
            "North Bethesda",
            "North Potomac",
            "Odenton",
            "Olney",
            "Owings Mills",
            "Oxon Hill",
            "Parkville",
            "Parole",
            "Pasadena",
            "Perry Hall",
            "Pikesville",
            "Potomac",
            "Randallstown",
            "Redland",
            "Reisterstown",
            "Rockville",
            "Rosedale",
            "Rossville",
            "Saint Charles",
            "Salisbury",
            "Seabrook",
            "Severn",
            "Severna Park",
            "Silver Spring",
            "South Bel Air",
            "South Gate",
            "South Laurel",
            "Suitland",
            "Takoma Park",
            "Towson",
            "Waldorf",
            "West Elkridge",
            "Westminster",
            "Wheaton",
            "White Oak",
            "Woodlawn",
            "Affton",
            "Arnold",
            "Ballwin",
            "Belton",
            "Blue Springs",
            "Cape Girardeau",
            "Chesterfield",
            "Clayton",
            "Columbia",
            "Concord",
            "Creve Coeur",
            "East Independence",
            "Farmington",
            "Ferguson",
            "Florissant",
            "Gladstone",
            "Grandview",
            "Hannibal",
            "Hazelwood",
            "Independence",
            "Jefferson City",
            "Joplin",
            "Kansas City",
            "Kirkwood",
            "Lee's Summit",
            "Lemay",
            "Liberty",
            "Manchester",
            "Maryland Heights",
            "Mehlville",
            "Nixa",
            "O'Fallon",
            "Oakville",
            "Overland",
            "Ozark",
            "Poplar Bluff",
            "Raymore",
            "Raytown",
            "Rolla",
            "Saint Charles",
            "Saint Joseph",
            "St. Louis",
            "Saint Peters",
            "Sedalia",
            "Sikeston",
            "Spanish Lake",
            "Springfield",
            "University City",
            "Warrensburg",
            "Webster Groves",
            "Wentzville",
            "Wildwood",
            "Biloxi",
            "Brandon",
            "Clarksdale",
            "Clinton",
            "Columbus",
            "Gautier",
            "Greenville",
            "Greenwood",
            "Gulfport",
            "Hattiesburg",
            "Horn Lake",
            "Jackson",
            "Laurel",
            "Madison",
            "Meridian",
            "Natchez",
            "Ocean Springs",
            "Olive Branch",
            "Oxford",
            "Pascagoula",
            "Pearl",
            "Ridgeland",
            "Southaven",
            "Starkville",
            "Tupelo",
            "Vicksburg",
            "West Gulfport",
            "Albemarle",
            "Apex",
            "Asheboro",
            "Asheville",
            "Boone",
            "Burlington",
            "Carrboro",
            "Cary",
            "Chapel Hill",
            "Charlotte",
            "Clayton",
            "Clemmons",
            "Concord",
            "Cornelius",
            "Durham",
            "Eden",
            "Elizabeth City",
            "Fayetteville",
            "Fuquay-Varina",
            "Garner",
            "Gastonia",
            "Goldsboro",
            "Greensboro",
            "Greenville",
            "Havelock",
            "Henderson",
            "Hickory",
            "High Point",
            "Holly Springs",
            "Hope Mills",
            "Huntersville",
            "Indian Trail",
            "Jacksonville",
            "Kannapolis",
            "Kernersville",
            "Kinston",
            "Laurinburg",
            "Lenoir",
            "Lexington",
            "Lumberton",
            "Matthews",
            "Mint Hill",
            "Monroe",
            "Mooresville",
            "Morganton",
            "Morrisville",
            "New Bern",
            "Raleigh",
            "Roanoke Rapids",
            "Rocky Mount",
            "Salisbury",
            "Sanford",
            "Shelby",
            "Statesville",
            "Thomasville",
            "Wake Forest",
            "West Raleigh",
            "Wilmington",
            "Wilson",
            "Winston-Salem",
            "Atlantic City",
            "Bridgeton",
            "Camden",
            "Cherry Hill",
            "Glassboro",
            "Jackson",
            "Lindenwold",
            "Maple Shade",
            "Millville",
            "Mount Laurel",
            "Ocean Acres",
            "Pennsauken",
            "Pleasantville",
            "Sicklerville",
            "South Vineland",
            "Toms River",
            "Vineland",
            "Williamstown",
            "Athens",
            "Beavercreek",
            "Centerville",
            "Cincinnati",
            "Columbus",
            "Dayton",
            "Fairborn",
            "Fairfield",
            "Forest Park",
            "Grove City",
            "Hamilton",
            "Huber Heights",
            "Kettering",
            "Lancaster",
            "Lebanon",
            "Mason",
            "Miamisburg",
            "Middletown",
            "Norwood",
            "Oxford",
            "Pickerington",
            "Portsmouth",
            "Reynoldsburg",
            "Riverside",
            "Springboro",
            "Springfield",
            "Trotwood",
            "Upper Arlington",
            "Vandalia",
            "White Oak",
            "Whitehall",
            "Xenia",
            "Zanesville",
            "Ada",
            "Altus",
            "Ardmore",
            "Bartlesville",
            "Bethany",
            "Bixby",
            "Broken Arrow",
            "Chickasha",
            "Claremore",
            "Del City",
            "Duncan",
            "Durant",
            "Edmond",
            "El Reno",
            "Enid",
            "Jenks",
            "Lawton",
            "McAlester",
            "Midwest City",
            "Moore",
            "Muskogee",
            "Mustang",
            "Norman",
            "Oklahoma City",
            "Owasso",
            "Ponca City",
            "Sand Springs",
            "Sapulpa",
            "Shawnee",
            "Stillwater",
            "Tahlequah",
            "Tulsa",
            "Yukon",
            "Chambersburg",
            "Chester",
            "Drexel Hill",
            "Hanover",
            "Philadelphia",
            "Springfield",
            "West Chester",
            "York",
            "Aiken",
            "Anderson",
            "Charleston",
            "Columbia",
            "Conway",
            "Easley",
            "Florence",
            "Goose Creek",
            "Greenville",
            "Greenwood",
            "Greer",
            "Hanahan",
            "Hilton Head Island",
            "Lexington",
            "Mauldin",
            "Mount Pleasant",
            "Myrtle Beach",
            "North Augusta",
            "North Charleston",
            "Rock Hill",
            "Saint Andrews",
            "Seven Oaks",
            "Simpsonville",
            "Socastee",
            "Spartanburg",
            "Summerville",
            "Sumter",
            "Taylors",
            "Wade Hampton",
            "Bartlett",
            "Brentwood",
            "Brentwood Estates",
            "Bristol",
            "Chattanooga",
            "Clarksville",
            "Cleveland",
            "Collierville",
            "Columbia",
            "Cookeville",
            "Dyersburg",
            "East Brainerd",
            "East Chattanooga",
            "East Ridge",
            "Farragut",
            "Franklin",
            "Gallatin",
            "Germantown",
            "Goodlettsville",
            "Greeneville",
            "Hendersonville",
            "Jackson",
            "Johnson City",
            "Kingsport",
            "Knoxville",
            "La Vergne",
            "Lebanon",
            "Maryville",
            "Memphis",
            "Morristown",
            "Mount Juliet",
            "Murfreesboro",
            "Nashville",
            "New South Memphis",
            "Oak Ridge",
            "Shelbyville",
            "Smyrna",
            "Spring Hill",
            "Springfield",
            "Tullahoma",
            "Abilene",
            "Alamo",
            "Aldine",
            "Alice",
            "Allen",
            "Alvin",
            "Angleton",
            "Arlington",
            "Atascocita",
            "Austin",
            "Balch Springs",
            "Baytown",
            "Beaumont",
            "Bedford",
            "Bellaire",
            "Belton",
            "Benbrook",
            "Brenham",
            "Brownsville",
            "Brownwood",
            "Brushy Creek",
            "Bryan",
            "Burleson",
            "Canyon Lake",
            "Carrollton",
            "Cedar Hill",
            "Cedar Park",
            "Channelview",
            "Cibolo",
            "Cinco Ranch",
            "Cleburne",
            "Cloverleaf",
            "College Station",
            "Colleyville",
            "Conroe",
            "Converse",
            "Coppell",
            "Copperas Cove",
            "Corinth",
            "Corpus Christi",
            "Corsicana",
            "Cypress",
            "Dallas",
            "DeSoto",
            "Deer Park",
            "Denison",
            "Denton",
            "Dickinson",
            "Donna",
            "Duncanville",
            "Edinburg",
            "Ennis",
            "Euless",
            "Farmers Branch",
            "Flower Mound",
            "Fort Worth",
            "Fresno",
            "Friendswood",
            "Frisco",
            "Gainesville",
            "Galveston",
            "Garland",
            "Gatesville",
            "Georgetown",
            "Grand Prairie",
            "Grapevine",
            "Greenville",
            "Groves",
            "Haltom City",
            "Harker Heights",
            "Harlingen",
            "Highland Village",
            "Houston",
            "Humble",
            "Huntsville",
            "Hurst",
            "Irving",
            "West Hartford",
            "West Haven",
            "West Torrington",
            "Westport",
            "Wethersfield",
            "Willimantic",
            "Wilton",
            "Windham",
            "Windsor",
            "Wolcott",
            "Ames",
            "Ankeny",
            "Bettendorf",
            "Burlington",
            "Cedar Falls",
            "Cedar Rapids",
            "Clinton",
            "Clive",
            "Coralville",
            "Council Bluffs",
            "Davenport",
            "Des Moines",
            "Dubuque",
            "Fort Dodge",
            "Iowa City",
            "Johnston",
            "Marion",
            "Marshalltown",
            "Mason City",
            "Muscatine",
            "Newton",
            "Ottumwa",
            "Sioux City",
            "Urbandale",
            "Waterloo",
            "West Des Moines",
            "Addison",
            "Algonquin",
            "Alsip",
            "Arlington Heights",
            "Aurora",
            "Bartlett",
            "Batavia",
            "Bellwood",
            "Belvidere",
            "Bensenville",
            "Berwyn",
            "Bloomingdale",
            "Bloomington",
            "Blue Island",
            "Bolingbrook",
            "Bourbonnais",
            "Bradley",
            "Bridgeview",
            "Brookfield",
            "Buffalo Grove",
            "Burbank",
            "Calumet City",
            "Carol Stream",
            "Carpentersville",
            "Cary",
            "Champaign",
            "Chicago",
            "Chicago Heights",
            "Cicero",
            "Country Club Hills",
            "Crest Hill",
            "Crystal Lake",
            "Danville",
            "Darien",
            "DeKalb",
            "Deerfield",
            "Des Plaines",
            "Dixon",
            "Dolton",
            "Downers Grove",
            "East Moline",
            "East Peoria",
            "Elgin",
            "Elk Grove Village",
            "Elmhurst",
            "Elmwood Park",
            "Evanston",
            "Evergreen Park",
            "Frankfort",
            "Franklin Park",
            "Freeport",
            "Galesburg",
            "Geneva",
            "Glen Ellyn",
            "Glenview",
            "Goodings Grove",
            "Grayslake",
            "Gurnee",
            "Hanover Park",
            "Harvey",
            "Highland Park",
            "Hinsdale",
            "Hoffman Estates",
            "Homer Glen",
            "Homewood",
            "Huntley",
            "Joliet",
            "Kankakee",
            "La Grange",
            "Lake Forest",
            "Lake Zurich",
            "Lake in the Hills",
            "Lansing",
            "Lemont",
            "Libertyville",
            "Lisle",
            "Lockport",
            "Lombard",
            "Loves Park",
            "Machesney Park",
            "Macomb",
            "Matteson",
            "Maywood",
            "McHenry",
            "Melrose Park",
            "Mokena",
            "Moline",
            "Montgomery",
            "Morton",
            "Morton Grove",
            "Mount Prospect",
            "Mundelein",
            "Naperville",
            "New Lenox",
            "Niles",
            "Normal",
            "North Aurora",
            "North Chicago",
            "North Peoria",
            "Northbrook",
            "Oak Forest",
            "Oak Lawn",
            "Oak Park",
            "Orland Park",
            "Oswego",
            "Ottawa",
            "Palatine",
            "Palos Hills",
            "Park Forest",
            "Park Ridge",
            "Pekin",
            "Peoria",
            "Plainfield",
            "Prospect Heights",
            "Rock Island",
            "Rockford",
            "Rolling Meadows",
            "Romeoville",
            "Roselle",
            "Round Lake",
            "Round Lake Beach",
            "Saint Charles",
            "Schaumburg",
            "Shorewood",
            "Skokie",
            "South Elgin",
            "South Holland",
            "Sterling",
            "Streamwood",
            "Sycamore",
            "Tinley Park",
            "Urbana",
            "Vernon Hills",
            "Villa Park",
            "Wasco",
            "Washington",
            "Waukegan",
            "West Chicago",
            "Westchester",
            "Westmont",
            "Wheaton",
            "Wheeling",
            "Wilmette",
            "Woodridge",
            "Woodstock",
            "Yorkville",
            "Zion",
            "Anderson",
            "Crawfordsville",
            "Crown Point",
            "Dyer",
            "East Chicago",
            "Elkhart",
            "Fort Wayne",
            "Frankfort",
            "Gary",
            "Goshen",
            "Granger",
            "Griffith",
            "Hammond",
            "Highland",
            "Hobart",
            "Huntington",
            "Kokomo",
            "LaPorte",
            "Lafayette",
            "Lebanon",
            "Logansport",
            "Marion",
            "Merrillville",
            "Michigan City",
            "Mishawaka",
            "Muncie",
            "Munster",
            "Noblesville",
            "Portage",
            "Schererville",
            "South Bend",
            "Valparaiso",
            "West Lafayette",
            "Westfield",
            "Abington",
            "Acton",
            "Agawam",
            "Amesbury",
            "Amherst Center",
            "Arlington",
            "Ashland",
            "Attleboro",
            "Auburn",
            "Barnstable",
            "Belmont",
            "Beverly",
            "Beverly Cove",
            "Billerica",
            "Boston",
            "Braintree",
            "Brockton",
            "Brookline",
            "Burlington",
            "Cambridge",
            "Canton",
            "Chelmsford",
            "Chelsea",
            "Chicopee",
            "Concord",
            "Danvers",
            "Dedham",
            "Dracut",
            "East Longmeadow",
            "Easthampton",
            "Easton",
            "Everett",
            "Fairhaven",
            "Fall River",
            "Fitchburg",
            "Framingham",
            "Framingham Center",
            "Franklin",
            "Gardner",
            "Gloucester",
            "Grafton",
            "Greenfield",
            "Hanover",
            "Haverhill",
            "Holden",
            "Holyoke",
            "Jamaica Plain",
            "Lawrence",
            "Leominster",
            "Lexington",
            "Longmeadow",
            "Lowell",
            "Ludlow",
            "Lynn",
            "Malden",
            "Mansfield",
            "Marblehead",
            "Marlborough",
            "Medford",
            "Melrose",
            "Methuen",
            "Milford",
            "Milton",
            "Natick",
            "Needham",
            "New Bedford",
            "Newburyport",
            "Newton",
            "North Chicopee",
            "Northampton",
            "Norton",
            "Norwood",
            "Palmer",
            "Peabody",
            "Pittsfield",
            "Quincy",
            "Randolph",
            "Reading",
            "Rockland",
            "Salem",
            "Saugus",
            "Shrewsbury",
            "Somerset",
            "Somerville",
            "South Boston",
            "South Hadley",
            "South Peabody",
            "Southbridge",
            "Springfield",
            "Stoneham",
            "Stoughton",
            "Sudbury",
            "Swansea",
            "Taunton",
            "Tewksbury",
            "Wakefield",
            "Waltham",
            "Watertown",
            "Wellesley",
            "West Springfield",
            "Westfield",
            "Westford",
            "Weymouth",
            "Wilmington",
            "Winchester",
            "Winthrop",
            "Woburn",
            "Worcester",
            "Yarmouth",
            "Auburn",
            "Augusta",
            "Bangor",
            "Biddeford",
            "Brunswick",
            "Lewiston",
            "Portland",
            "Saco",
            "South Portland",
            "South Portland Gardens",
            "Waterville",
            "West Scarborough",
            "Westbrook",
            "Adrian",
            "Allen Park",
            "Allendale",
            "Ann Arbor",
            "Auburn Hills",
            "Battle Creek",
            "Bay City",
            "Birmingham",
            "Burton",
            "Canton",
            "Clinton",
            "Dearborn",
            "Dearborn Heights",
            "Detroit",
            "East Lansing",
            "Eastpointe",
            "Farmington Hills",
            "Ferndale",
            "Flint",
            "Forest Hills",
            "Garden City",
            "Grand Rapids",
            "Grandville",
            "Grosse Pointe Woods",
            "Hamtramck",
            "Haslett",
            "Hazel Park",
            "Holland",
            "Holt",
            "Iron River",
            "Jackson",
            "Jenison",
            "Kalamazoo",
            "Kentwood",
            "Lansing",
            "Lincoln Park",
            "Livonia",
            "Madison Heights",
            "Marquette",
            "Midland",
            "Monroe",
            "Mount Clemens",
            "Mount Pleasant",
            "Muskegon",
            "Norton Shores",
            "Novi",
            "Oak Park",
            "Okemos",
            "Owosso",
            "Pontiac",
            "Port Huron",
            "Portage",
            "Redford",
            "Rochester Hills",
            "Romulus",
            "Roseville",
            "Royal Oak",
            "Saginaw",
            "Shelby",
            "Southfield",
            "Southgate",
            "Saint Clair Shores",
            "Sterling Heights",
            "Taylor",
            "Trenton",
            "Troy",
            "Walker",
            "Warren",
            "Waterford",
            "Waverly",
            "Wayne",
            "Westland",
            "Wyandotte",
            "Wyoming",
            "Ypsilanti",
            "Albert Lea",
            "Andover",
            "Anoka",
            "Apple Valley",
            "Austin",
            "Blaine",
            "Bloomington",
            "Brooklyn Center",
            "Brooklyn Park",
            "Buffalo",
            "Burnsville",
            "Champlin",
            "Chanhassen",
            "Chaska",
            "Columbia Heights",
            "Coon Rapids",
            "Cottage Grove",
            "Crystal",
            "Duluth",
            "Eagan",
            "Eden Prairie",
            "Edina",
            "Elk River",
            "Faribault",
            "Farmington",
            "Forest Lake",
            "Fridley",
            "Golden Valley",
            "Ham Lake",
            "Hastings",
            "Hibbing",
            "Hopkins",
            "Inver Grove Heights",
            "Lakeville",
            "Lino Lakes",
            "Mankato",
            "Maple Grove",
            "Maplewood",
            "Minneapolis",
            "Minnetonka",
            "Minnetonka Mills",
            "Moorhead",
            "New Brighton",
            "New Hope",
            "Northfield",
            "Oakdale",
            "Owatonna",
            "Plymouth",
            "Prior Lake",
            "Ramsey",
            "Red Wing",
            "Richfield",
            "Rochester",
            "Rosemount",
            "Roseville",
            "Saint Cloud",
            "Saint Louis Park",
            "Saint Michael",
            "Saint Paul",
            "Sartell",
            "Savage",
            "Shakopee",
            "Shoreview",
            "South Saint Paul",
            "Stillwater",
            "West Coon Rapids",
            "West Saint Paul",
            "White Bear Lake",
            "Willmar",
            "Winona",
            "Woodbury",
            "Kirksville",
            "Fargo",
            "Grand Forks",
            "Jamestown",
            "West Fargo",
            "Bellevue",
            "Columbus",
            "Fremont",
            "Grand Island",
            "Hastings",
            "Kearney",
            "La Vista",
            "Lincoln",
            "Norfolk",
            "Omaha",
            "Papillion",
            "Bedford",
            "Concord",
            "Derry",
            "Derry Village",
            "Dover",
            "East Concord",
            "Keene",
            "Laconia",
            "Manchester",
            "Merrimack",
            "Nashua",
            "Portsmouth",
            "Rochester",
            "Salem",
            "Asbury Park",
            "Avenel",
            "Bayonne",
            "Belleville",
            "Bergenfield",
            "Bloomfield",
            "Carteret",
            "Cliffside Park",
            "Clifton",
            "Colonia",
            "Cranford",
            "Dover",
            "Dumont",
            "East Brunswick",
            "East Orange",
            "Edison",
            "Elizabeth",
            "Elmwood Park",
            "Englewood",
            "Ewing",
            "Fair Lawn",
            "Fords",
            "Fort Lee",
            "Garfield",
            "Hackensack",
            "Hawthorne",
            "Hillside",
            "Hoboken",
            "Hopatcong",
            "Hopatcong Hills",
            "Irvington",
            "Iselin",
            "Jersey City",
            "Kearny",
            "Lakewood",
            "Linden",
            "Livingston",
            "Lodi",
            "Long Branch",
            "Lyndhurst",
            "Madison",
            "Mahwah",
            "Maplewood",
            "Marlboro",
            "Montclair",
            "Morristown",
            "New Brunswick",
            "New Milford",
            "Newark",
            "North Arlington",
            "North Bergen",
            "North Plainfield",
            "Nutley",
            "Old Bridge",
            "Orange",
            "Palisades Park",
            "Paramus",
            "Parsippany",
            "Passaic",
            "Paterson",
            "Perth Amboy",
            "Piscataway",
            "Plainfield",
            "Point Pleasant",
            "Rahway",
            "Ridgewood",
            "Roselle",
            "Rutherford",
            "Sayreville",
            "Sayreville Junction",
            "Scotch Plains",
            "Secaucus",
            "Somerset",
            "South Old Bridge",
            "South Orange",
            "South Plainfield",
            "South River",
            "Summit",
            "Teaneck",
            "Tinton Falls",
            "Trenton",
            "Union",
            "Union City",
            "Wayne",
            "West Milford",
            "West New York",
            "West Orange",
            "Westfield",
            "Willingboro",
            "Woodbridge",
            "Wyckoff",
            "Albany",
            "Amherst",
            "Amsterdam",
            "Auburn",
            "Baldwin",
            "Batavia",
            "Bay Shore",
            "Beacon",
            "Bellmore",
            "Bensonhurst",
            "Bethpage",
            "Binghamton",
            "Brentwood",
            "Brighton",
            "The Bronx",
            "Brooklyn",
            "Buffalo",
            "Centereach",
            "Central Islip",
            "Cheektowaga",
            "Cohoes",
            "Commack",
            "Coney Island",
            "Copiague",
            "Coram",
            "Cortland",
            "Deer Park",
            "Depew",
            "Dix Hills",
            "East Meadow",
            "East Massapequa",
            "East New York",
            "East Northport",
            "East Patchogue",
            "East Setauket",
            "Eastchester",
            "Eggertsville",
            "Elmira",
            "Elmont",
            "Farmingville",
            "Floral Park",
            "Franklin Square",
            "Freeport",
            "Garden City",
            "Glen Cove",
            "Gloversville",
            "Greenburgh",
            "Harrison",
            "Hauppauge",
            "Hempstead",
            "Hicksville",
            "Holbrook",
            "Holtsville",
            "Huntington",
            "Huntington Station",
            "Irondequoit",
            "Islip",
            "Ithaca",
            "Jamaica",
            "Jamestown",
            "Johnson City",
            "Kenmore",
            "Kings Park",
            "Kingston",
            "Kiryas Joel",
            "Lackawanna",
            "Lake Ronkonkoma",
            "Levittown",
            "Lindenhurst",
            "Lockport",
            "Long Beach",
            "Long Island City",
            "Lynbrook",
            "Mamaroneck",
            "Manhattan",
            "Massapequa",
            "Massapequa Park",
            "Mastic",
            "Medford",
            "Melville",
            "Merrick",
            "Middletown",
            "Mineola",
            "Monsey",
            "Mount Vernon",
            "Nanuet",
            "New City",
            "New Rochelle",
            "New York City",
            "Newburgh",
            "Niagara Falls",
            "North Amityville",
            "North Babylon",
            "North Bay Shore",
            "North Bellmore",
            "North Massapequa",
            "North Tonawanda",
            "North Valley Stream",
            "Oceanside",
            "Ossining",
            "Oswego",
            "Pearl River",
            "Peekskill",
            "Plainview",
            "Plattsburgh",
            "Port Chester",
            "Port Washington",
            "Poughkeepsie",
            "Borough of Queens",
            "Rochester",
            "Rockville Centre",
            "Rome",
            "Ronkonkoma",
            "Roosevelt",
            "Rotterdam",
            "Rye",
            "Saratoga Springs",
            "Sayville",
            "Scarsdale",
            "Schenectady",
            "Seaford",
            "Selden",
            "Shirley",
            "Smithtown",
            "Spring Valley",
            "Staten Island",
            "Syosset",
            "Syracuse",
            "Tonawanda",
            "Troy",
            "Uniondale",
            "Utica",
            "Valley Stream",
            "Wantagh",
            "Watertown",
            "West Albany",
            "West Babylon",
            "West Hempstead",
            "West Islip",
            "West Seneca",
            "Westbury",
            "White Plains",
            "Woodmere",
            "Yonkers",
            "Akron",
            "Alliance",
            "Ashland",
            "Ashtabula",
            "Aurora",
            "Austintown",
            "Avon",
            "Avon Center",
            "Avon Lake",
            "Barberton",
            "Bay Village",
            "Berea",
            "Boardman",
            "Bowling Green",
            "Broadview Heights",
            "Brook Park",
            "Brunswick",
            "Canton",
            "Cleveland",
            "Cuyahoga Falls",
            "Defiance",
            "Delaware",
            "Dublin",
            "East Cleveland",
            "Eastlake",
            "Elyria",
            "Euclid",
            "Fairview Park",
            "Findlay",
            "Fremont",
            "Gahanna",
            "Garfield Heights",
            "Green",
            "Hilliard",
            "Hudson",
            "Kent",
            "Lakewood",
            "Lima",
            "Lorain",
            "Mansfield",
            "Maple Heights",
            "Marion",
            "Marysville",
            "Massillon",
            "Mayfield Heights",
            "Medina",
            "Mentor",
            "Middleburg Heights",
            "Mount Vernon",
            "New Philadelphia",
            "Newark",
            "Niles",
            "North Canton",
            "North Olmsted",
            "North Ridgeville",
            "North Royalton",
            "Norwalk",
            "Oregon",
            "Painesville",
            "Parma",
            "Parma Heights",
            "Perrysburg",
            "Piqua",
            "Rocky River",
            "Sandusky",
            "Shaker Heights",
            "Sidney",
            "Solon",
            "South Euclid",
            "Steubenville",
            "Stow",
            "Streetsboro",
            "Strongsville",
            "Sylvania",
            "Tallmadge",
            "Tiffin",
            "Toledo",
            "Troy",
            "Twinsburg",
            "Wadsworth",
            "Warren",
            "Westerville",
            "Westlake",
            "Willoughby",
            "Wooster",
            "Youngstown",
            "Allentown",
            "Allison Park",
            "Altoona",
            "Back Mountain",
            "Baldwin",
            "Bethel Park",
            "Bethlehem",
            "Carlisle",
            "Easton",
            "Erie",
            "Harrisburg",
            "Hazleton",
            "Hermitage",
            "Johnstown",
            "King of Prussia",
            "Lancaster",
            "Lansdale",
            "Lebanon",
            "Levittown",
            "Limerick",
            "McKeesport",
            "Monroeville",
            "Mount Lebanon",
            "Mountain Top",
            "Murrysville",
            "New Castle",
            "Norristown",
            "Penn Hills",
            "Phoenixville",
            "Pittsburgh",
            "Plum",
            "Pottstown",
            "Radnor",
            "Reading",
            "Scranton",
            "State College",
            "Upper Saint Clair",
            "Wayne",
            "West Mifflin",
            "Whitehall Township",
            "Wilkes-Barre",
            "Wilkinsburg",
            "Williamsport",
            "Willow Grove",
            "Barrington",
            "Bristol",
            "Central Falls",
            "Coventry",
            "Cranston",
            "Cumberland",
            "East Providence",
            "Middletown",
            "Newport",
            "North Kingstown",
            "North Providence",
            "Pawtucket",
            "Portsmouth",
            "Providence",
            "Smithfield",
            "Warwick",
            "West Warwick",
            "Westerly",
            "Woonsocket",
            "Aberdeen",
            "Brookings",
            "Mitchell",
            "Sioux Falls",
            "Watertown",
            "Burlington",
            "Colchester",
            "Rutland",
            "South Burlington",
            "Appleton",
            "Ashwaubenon",
            "Beaver Dam",
            "Beloit",
            "Brookfield",
            "Caledonia",
            "Cudahy",
            "De Pere",
            "Eau Claire",
            "Fitchburg",
            "Fond du Lac",
            "Franklin",
            "Germantown",
            "Green Bay",
            "Greenfield",
            "Howard",
            "Janesville",
            "Kaukauna",
            "Kenosha",
            "La Crosse",
            "Madison",
            "Manitowoc",
            "Marshfield",
            "Menasha",
            "Menomonee Falls",
            "Menomonie",
            "Mequon",
            "Middleton",
            "Milwaukee",
            "Muskego",
            "Neenah",
            "New Berlin",
            "North La Crosse",
            "Oak Creek",
            "Oconomowoc",
            "Onalaska",
            "Oshkosh",
            "Pleasant Prairie",
            "Racine",
            "Sheboygan",
            "South Milwaukee",
            "Stevens Point",
            "Sun Prairie",
            "Superior",
            "Watertown",
            "Waukesha",
            "Wausau",
            "Wauwatosa",
            "West Allis",
            "West Bend",
            "Wisconsin Rapids",
            "Weirton",
            "Weirton Heights",
            "Wheeling",
            "Ansonia",
            "Bridgeport",
            "Bristol",
            "Branford",
            "Cheshire",
            "Fillmore",
            "Buckeye",
            "Bullhead City",
            "Casa Grande",
            "Casas Adobes",
            "Catalina Foothills",
            "Chandler",
            "Douglas",
            "Drexel Heights",
            "El Mirage",
            "Eloy",
            "Flagstaff",
            "Florence",
            "Flowing Wells",
            "Fortuna Foothills",
            "Fountain Hills",
            "Gilbert",
            "Glendale",
            "Goodyear",
            "Green Valley",
            "Kingman",
            "Lake Havasu City",
            "Marana",
            "Maricopa",
            "Mesa",
            "Nogales",
            "Oro Valley",
            "Payson",
            "Peoria",
            "Phoenix",
            "Prescott",
            "Prescott Valley",
            "Queen Creek",
            "Rio Rico",
            "Sahuarita",
            "San Luis",
            "Scottsdale",
            "Sierra Vista",
            "Sun City",
            "Sun City West",
            "Surprise",
            "Tanque Verde",
            "Tempe",
            "Tempe Junction",
            "Tucson",
            "Yuma",
            "Adelanto",
            "Agoura",
            "Agoura Hills",
            "Alameda",
            "Albany",
            "Alhambra",
            "Aliso Viejo",
            "Altadena",
            "Alum Rock",
            "American Canyon",
            "Anaheim",
            "Antelope",
            "Antioch",
            "Apple Valley",
            "Arcadia",
            "Arroyo Grande",
            "Artesia",
            "Arvin",
            "Ashland",
            "Atascadero",
            "Atwater",
            "Avenal",
            "Avocado Heights",
            "Azusa",
            "Bakersfield",
            "Baldwin Park",
            "Banning",
            "Barstow",
            "Barstow Heights",
            "Bay Point",
            "Beaumont",
            "Bell",
            "Bell Gardens",
            "Bellflower",
            "Belmont",
            "Benicia",
            "Berkeley",
            "Beverly Hills",
            "Bloomington",
            "Blythe",
            "Bostonia",
            "Boyle Heights",
            "Brawley",
            "Brea",
            "Brentwood",
            "Buena Park",
            "Burbank",
            "Burlingame",
            "Calabasas",
            "Calexico",
            "Camarillo",
            "Cameron Park",
            "Campbell",
            "Canoga Park",
            "Carlsbad",
            "Carmichael",
            "Carson",
            "Castaic",
            "Castro Valley",
            "Cathedral City",
            "Ceres",
            "Cerritos",
            "Chatsworth",
            "Chico",
            "Chino",
            "Chino Hills",
            "Chowchilla",
            "Chula Vista",
            "Citrus Heights",
            "Claremont",
            "Clearlake",
            "Clovis",
            "Coachella",
            "Colton",
            "Compton",
            "Concord",
            "Corcoran",
            "Corona",
            "Coronado",
            "Costa Mesa",
            "Covina",
            "Cudahy",
            "Culver City",
            "Cupertino",
            "Cypress",
            "Daly City",
            "Dana Point",
            "Danville",
            "Davis",
            "Delano",
            "Desert Hot Springs",
            "Diamond Bar",
            "Dinuba",
            "Dixon",
            "Downey",
            "Duarte",
            "Dublin",
            "East Rancho Dominguez",
            "East Hemet",
            "East Los Angeles",
            "East Palo Alto",
            "El Cajon",
            "El Centro",
            "El Cerrito",
            "El Dorado Hills",
            "El Monte",
            "El Segundo",
            "Elk Grove",
            "Encinitas",
            "Escondido",
            "Fair Oaks",
            "Fairfield",
            "Fallbrook",
            "Florin",
            "Folsom",
            "Fontana",
            "Foothill Farms",
            "Foster City",
            "Fountain Valley",
            "Fremont",
            "Fresno",
            "Fullerton",
            "Galt",
            "Garden Grove",
            "Gardena",
            "Gilroy",
            "Glen Avon",
            "Glendale",
            "Glendora",
            "Goleta",
            "Granite Bay",
            "Greenfield",
            "Hacienda Heights",
            "Hanford",
            "Hawthorne",
            "Hayward",
            "Hemet",
            "Hercules",
            "Hermosa Beach",
            "Hesperia",
            "Highland",
            "Hollister",
            "Hollywood",
            "Huntington Beach",
            "Huntington Park",
            "Imperial Beach",
            "Indio",
            "Inglewood",
            "Irvine",
            "Lodi",
            "Loma Linda",
            "Lomita",
            "Lompoc",
            "Long Beach",
            "Los Altos",
            "Los Angeles",
            "Los Banos",
            "Los Gatos",
            "Lynwood",
            "Madera",
            "Manhattan Beach",
            "Manteca",
            "Marina",
            "Martinez",
            "Maywood",
            "Mead Valley",
            "Menifee",
            "Menlo Park",
            "Merced",
            "Millbrae",
            "Milpitas",
            "Mira Loma",
            "Mission Viejo",
            "Modesto",
            "Monrovia",
            "Montclair",
            "Montebello",
            "Monterey",
            "Monterey Park",
            "Moorpark",
            "Moraga",
            "Moreno Valley",
            "Morgan Hill",
            "Mountain View",
            "Murrieta",
            "Napa",
            "National City",
            "Newark",
            "Newport Beach",
            "Nipomo",
            "Norco",
            "North Glendale",
            "North Highlands",
            "North Hollywood",
            "Northridge",
            "Norwalk",
            "Novato",
            "Oakdale",
            "Oakland",
            "Oakley",
            "Oceanside",
            "Oildale",
            "Ontario",
            "Orange",
            "Orangevale",
            "Orcutt",
            "Orinda",
            "Oroville",
            "Oxnard",
            "Oxnard Shores",
            "Pacifica",
            "Pacific Grove",
            "Palm Desert",
            "Palm Springs",
            "Palmdale",
            "Palo Alto",
            "Paradise",
            "Paramount",
            "Pasadena",
            "Paso Robles",
            "Patterson",
            "Perris",
            "Petaluma",
            "Pico Rivera",
            "Pinole",
            "Pittsburg",
            "Placentia",
            "Pleasant Hill",
            "Pleasanton",
            "Pomona",
            "Port Hueneme",
            "Porterville",
            "Poway",
            "Prunedale",
            "Ramona",
            "Rancho Cordova",
            "Rancho Cucamonga",
            "Rancho Mirage",
            "Rancho Palos Verdes",
            "Rancho San Diego",
            "Rancho Santa Margarita",
            "Redlands",
            "Redondo Beach",
            "Redwood City",
            "Reedley",
            "Rialto",
            "Richmond",
            "Ridgecrest",
            "Rio Linda",
            "Riverbank",
            "Riverside",
            "Rocklin",
            "Rohnert Park",
            "Rosamond",
            "Rosemead",
            "Rosemont",
            "Roseville",
            "Rowland Heights",
            "Rubidoux",
            "Sacramento",
            "Salinas",
            "San Bernardino",
            "San Bruno",
            "San Carlos",
            "San Clemente",
            "San Diego",
            "San Dimas",
            "San Fernando",
            "San Francisco",
            "San Gabriel",
            "San Jacinto",
            "San Jose",
            "San Juan Capistrano",
            "San Leandro",
            "San Lorenzo",
            "San Luis Obispo",
            "San Marcos",
            "San Mateo",
            "San Pablo",
            "San Pedro",
            "San Rafael",
            "San Ramon",
            "Sanger",
            "Santa Ana",
            "Santa Barbara",
            "Santa Clara",
            "Santa Clarita",
            "Santa Cruz",
            "Santa Fe Springs",
            "Santa Maria",
            "Santa Monica",
            "Santa Paula",
            "Santa Rosa",
            "Santee",
            "Saratoga",
            "Seal Beach",
            "Seaside",
            "Selma",
            "Shafter",
            "Sherman Oaks",
            "Simi Valley",
            "Soledad",
            "South El Monte",
            "South Gate",
            "South Lake Tahoe",
            "South Pasadena",
            "South San Francisco",
            "South San Jose Hills",
            "South Whittier",
            "South Yuba City",
            "Spring Valley",
            "Stanton",
            "Stockton",
            "Suisun",
            "Sun City",
            "Sunnyvale",
            "Temecula",
            "Temple City",
            "Thousand Oaks",
            "Torrance",
            "Tracy",
            "Truckee",
            "Tulare",
            "Turlock",
            "Tustin",
            "North Tustin",
            "Twentynine Palms",
            "Ukiah",
            "Union City",
            "Universal City",
            "Upland",
            "Walnut Park",
            "Watsonville",
            "West Carson",
            "West Covina",
            "West Hollywood",
            "West Puente Valley",
            "West Sacramento",
            "Westminster",
            "Westmont",
            "Whittier",
            "Wildomar",
            "Willowbrook",
            "Windsor",
            "Winter Gardens",
            "Woodland",
            "Woodland Hills",
            "Yorba Linda",
            "Yuba City",
            "Yucaipa",
            "Yucca Valley",
            "Arvada",
            "Aurora",
            "Brighton",
            "Broomfield",
            "Cañon City",
            "Castle Rock",
            "Castlewood",
            "Centennial",
            "Cimarron Hills",
            "Clifton",
            "Colorado Springs",
            "Columbine",
            "Commerce City",
            "Denver",
            "Durango",
            "Englewood",
            "Fountain",
            "Golden",
            "Grand Junction",
            "Highlands Ranch",
            "Ken Caryl",
            "Lafayette",
            "Lakewood",
            "Littleton",
            "Louisville",
            "Montrose",
            "Northglenn",
            "Parker",
            "Pueblo",
            "Pueblo West",
            "Sherrelwood",
            "Southglenn",
            "Thornton",
            "Westminster",
            "Wheat Ridge",
            "Dodge City",
            "Garden City",
            "Liberal",
            "Alamogordo",
            "Albuquerque",
            "Carlsbad",
            "Clovis",
            "Farmington",
            "Gallup",
            "Hobbs",
            "Las Cruces",
            "Rio Rancho",
            "Roswell",
            "Santa Fe",
            "South Valley",
            "Boulder City",
            "Carson City",
            "Enterprise",
            "Fernley",
            "Henderson",
            "Las Vegas",
            "Mesquite",
            "North Las Vegas",
            "Pahrump",
            "Paradise",
            "Reno",
            "Spanish Springs",
            "Sparks",
            "Spring Valley",
            "Sun Valley",
            "Sunrise Manor",
            "Whitney",
            "Winchester",
            "Amarillo",
            "Big Spring",
            "Del Rio",
            "Eagle Pass",
            "El Paso",
            "Hereford",
            "Horizon City",
            "Lubbock",
            "Midland",
            "Odessa",
            "Pampa",
            "Plainview",
            "San Angelo",
            "Socorro",
            "Socorro Mission Number 1 Colonia",
            "West Odessa",
            "Cedar City",
            "Saint George",
            "Washington",
            "Wasco",
            "Anthem",
            "Apache Junction",
            "Avondale",
            "Juneau",
            "Arcata",
            "Bayside",
            "Eureka",
            "McKinleyville",
            "Redding",
            "Susanville",
            "Boulder",
            "Erie",
            "Evans",
            "Fort Collins",
            "Greeley",
            "Longmont",
            "Loveland",
            "Windsor",
            "Boise",
            "Caldwell",
            "Coeur d'Alene",
            "Eagle",
            "Idaho Falls",
            "Kuna",
            "Lewiston",
            "Lewiston Orchards",
            "Meridian",
            "Moscow",
            "Nampa",
            "Pocatello",
            "Post Falls",
            "Rexburg",
            "Twin Falls",
            "Billings",
            "Bozeman",
            "Butte",
            "Great Falls",
            "Helena",
            "Kalispell",
            "Missoula",
            "Bismarck",
            "Dickinson",
            "Mandan",
            "Minot",
            "North Platte",
            "Scottsbluff",
            "Elko",
            "Albany",
            "Aloha",
            "Altamont",
            "Ashland",
            "Beaverton",
            "Bend",
            "Bethany",
            "Canby",
            "Central Point",
            "Coos Bay",
            "Corvallis",
            "Eugene",
            "Forest Grove",
            "Four Corners",
            "Grants Pass",
            "Gresham",
            "Hayesville",
            "Hermiston",
            "Hillsboro",
            "Keizer",
            "Klamath Falls",
            "Lake Oswego",
            "Lebanon",
            "Lents",
            "McMinnville",
            "Medford",
            "Milwaukie",
            "Newberg",
            "Oak Grove",
            "Oregon City",
            "Pendleton",
            "Portland",
            "Redmond",
            "Roseburg",
            "Salem",
            "Sherwood",
            "Springfield",
            "Tigard",
            "Troutdale",
            "Tualatin",
            "West Linn",
            "Wilsonville",
            "Woodburn",
            "Rapid City",
            "Bountiful",
            "Brigham City",
            "Centerville",
            "Clearfield",
            "Clinton",
            "Cottonwood Heights",
            "Draper",
            "Eagle Mountain",
            "East Millcreek",
            "Farmington",
            "Herriman",
            "Highland",
            "Holladay",
            "Kaysville",
            "Kearns",
            "Layton",
            "Lehi",
            "Logan",
            "Magna",
            "Midvale",
            "Millcreek",
            "Murray",
            "North Ogden",
            "North Salt Lake",
            "Ogden",
            "Orem",
            "Payson",
            "Pleasant Grove",
            "Provo",
            "Riverton",
            "Roy",
            "Salt Lake City",
            "Sandy City",
            "Sandy Hills",
            "Saratoga Springs",
            "South Jordan Heights",
            "South Jordan",
            "South Ogden",
            "South Salt Lake",
            "Spanish Fork",
            "Springville",
            "Syracuse",
            "Taylorsville",
            "Tooele",
            "West Jordan",
            "West Valley City",
            "Aberdeen",
            "Anacortes",
            "Arlington",
            "Auburn",
            "Battle Ground",
            "Bellevue",
            "Bellingham",
            "Bonney Lake",
            "Bothell",
            "Bremerton",
            "Burien",
            "Camas",
            "Centralia",
            "Cottage Lake",
            "Covington",
            "Des Moines",
            "Edmonds",
            "Ellensburg",
            "Everett",
            "Fairwood",
            "Federal Way",
            "Five Corners",
            "Frederickson",
            "Graham",
            "Hazel Dell",
            "Issaquah",
            "Kenmore",
            "Kennewick",
            "Kent",
            "Kirkland",
            "Lacey",
            "Lake Stevens",
            "Lakewood",
            "Longview",
            "Lynnwood",
            "Maple Valley",
            "Martha Lake",
            "Marysville",
            "Mercer Island",
            "Mill Creek",
            "Monroe",
            "Moses Lake",
            "Mount Vernon",
            "Mountlake Terrace",
            "Mukilteo",
            "North Creek",
            "Oak Harbor",
            "Olympia",
            "Opportunity",
            "Orchards",
            "Parkland",
            "Pasco",
            "Port Angeles",
            "Pullman",
            "Puyallup",
            "Redmond",
            "Renton",
            "Richland",
            "Salmon Creek",
            "Sammamish",
            "SeaTac",
            "Seattle",
            "Shoreline",
            "Silverdale",
            "South Hill",
            "Spanaway",
            "Spokane",
            "Spokane Valley",
            "Sunnyside",
            "Tacoma",
            "Tukwila",
            "Tumwater",
            "University Place",
            "Vancouver",
            "Walla Walla",
            "Wenatchee",
            "West Lake Sammamish",
            "West Lake Stevens",
            "Bainbridge Island",
            "Yakima",
            "Casper",
            "Cheyenne",
            "Gillette",
            "Laramie",
            "Rock Springs",
            "Sheridan",
            "American Fork",
            "Kahului",
            "Kailua",
            "Kāne‘ohe",
            "Kīhei",
            "Makakilo City",
            "Mililani Town",
            "Pearl City",
            "Wahiawā",
            "Wailuku",
            "Waipahu",
            "‘Ewa Gentry",
            "Hilo",
            "Honolulu",
            "Eagle River",
            "Fairbanks",
            "Anchorage",
            "Badger",
            "Milton",
            "Johns Creek",
            "Cutler Bay",
            "Alafaya",
            "Fort Bragg",
            "City of Milford (balance)",
            "Butte-Silver Bow (Balance)",
            "City of Sammamish",
            "Silver Firs",
            "Vineyard",
            "Wallingford Center",
            "Bel Air North",
            "Bel Air South",
            "Setauket-East Setauket",
            "Tonawanda",
            "Fort Leonard Wood",
            "West Bloomfield Township",
            "East Lake-Orient Park",
            "Four Corners",
            "Greater Northdale",
            "Candler-McAfee",
            "University",
            "Vero Beach South",
            "Kendall West",
            "Palm River-Clair Mel",
            "Arden-Arcade",
            "Bryn Mawr-Skyway",
            "Casa de Oro-Mount Helix",
            "Florence-Graham",
            "Fort Hood",
            "Inglewood-Finn Hill",
            "La Crescenta-Montrose",
            "East Hill-Meridian",
            "Security-Widefield",
            "Union Hill-Novelty Hill",
            "West Whittier-Los Nietos",
            "Summerlin South",
            "Makakilo",
            "Schofield Barracks",
            "San Tan Valley",
            "Enchanted Hills",
            "West Hills",
            "Oak Hill",
            "Bridgewater",
            "Warren Township",
            "Fairfield Heights",
            "Randolph",
            "Hot Springs National Park",
            "Dixiana",
            "Cranberry Township",
            "Silver Lake",
            "Echo Park"
        ],
        "Uruguay" => [
            "Young",
            "Trinidad",
            "Trinidad",
            "Treinta y Tres",
            "Tacuarembó",
            "Santa Lucía",
            "San José de Mayo",
            "San Carlos",
            "Salto",
            "Rocha",
            "Rivera",
            "Progreso",
            "Paysandú",
            "Paso de Carrasco",
            "Pando",
            "Montevideo",
            "Minas",
            "Mercedes",
            "Melo",
            "Maldonado",
            "Las Piedras",
            "La Paz",
            "Fray Bentos",
            "Florida",
            "Durazno",
            "Dolores",
            "Delta del Tigre",
            "Colonia del Sacramento",
            "Carmelo",
            "Canelones",
            "Artigas"
        ],
        "Uzbekistan" => [
            "Nukus",
            "Khŭjayli",
            "Oltinko’l",
            "Zomin",
            "Urgut",
            "Tirmiz",
            "Sho’rchi",
            "Shahrisabz",
            "Samarqand",
            "Qarshi",
            "Muborak",
            "Kitob",
            "Kattaqo’rg’on",
            "Koson",
            "Karakul’",
            "Kogon",
            "G’uzor",
            "Galaosiyo",
            "Juma",
            "Denov",
            "Chiroqchi",
            "Chelak",
            "Bulung’ur",
            "Bukhara",
            "Beshkent",
            "Boysun",
            "Oqtosh",
            "Zafar",
            "Yaypan",
            "Yangiyŭl",
            "Yangiyer",
            "Yangirabot",
            "Yangiqo‘rg‘on",
            "Yangiobod",
            "Wobkent",
            "Uychi",
            "Urganch",
            "Dashtobod",
            "Uchqŭrghon Shahri",
            "Tŭytepa",
            "Tŭragŭrghon",
            "Toshloq",
            "Tashkent",
            "Toshbuloq",
            "Sirdaryo",
            "Showot",
            "Shofirkon",
            "Salor",
            "Qŭshkŭpir",
            "Qo‘qon",
            "Piskent",
            "Payshanba",
            "Parkent",
            "Pop",
            "Paxtakor",
            "Olmaliq",
            "Ohangaron",
            "Nurota",
            "Novyy Turtkul’",
            "Navoiy",
            "Namangan",
            "Marg‘ilon",
            "Manghit",
            "Asaka",
            "Quvasoy",
            "Qŭrghontepa",
            "Kirguli",
            "Qibray",
            "Khŭjaobod",
            "Khiwa",
            "Haqqulobod",
            "Kosonsoy",
            "Jizzax",
            "Iskandar",
            "Hazorasp",
            "Gurlan",
            "Guliston",
            "Ghijduwon",
            "G‘azalkent",
            "Gagarin",
            "Fergana",
            "Dŭstlik",
            "Chust Shahri",
            "Chirchiq",
            "Chinoz",
            "Chortoq",
            "Bŭka",
            "Beshariq",
            "Beruniy",
            "Bektemir",
            "Bekobod",
            "Angren",
            "Andijon",
            "Oltiariq",
            "Quva",
            "Navoiy"
        ],
        "Vatican" => [
            "Vatican City"
        ],
        "Saint Vincent and the Grenadines" => [
            "Kingstown",
            "Kingstown Park"
        ],
        "Venezuela" => [
            "La Asunción",
            "Anaco",
            "Alto Barinas",
            "Zaraza",
            "Yaritagua",
            "Villa de Cura",
            "Villa Bruzual",
            "Valle de La Pascua",
            "Valera",
            "Valencia",
            "Upata",
            "Turmero",
            "Tucupita",
            "Trujillo",
            "Tinaquillo",
            "Táriba",
            "Santa Teresa",
            "Santa Rita",
            "Santa Elena de Uairén",
            "San Mateo",
            "San Juan de los Morros",
            "San Juan de Colón",
            "San José de Guanipa",
            "San Joaquín",
            "San Felipe",
            "San Cristóbal",
            "San Carlos del Zulia",
            "San Carlos",
            "San Antonio del Táchira",
            "San Antonio de Los Altos",
            "Rubio",
            "La Villa del Rosario",
            "Quíbor",
            "Punto Fijo",
            "Punta Cardón",
            "Puerto La Cruz",
            "Puerto Cabello",
            "Puerto Ayacucho",
            "Porlamar",
            "Petare",
            "Palo Negro",
            "Ocumare del Tuy",
            "Nirgua",
            "Mucumpiz",
            "Morón",
            "Mérida",
            "Mariara",
            "Maracay",
            "Maracaibo",
            "Maiquetía",
            "Machiques",
            "Los Teques",
            "Los Rastrojos",
            "Los Dos Caminos",
            "La Victoria",
            "Las Tejerías",
            "Lagunillas",
            "La Guaira",
            "Juan Griego",
            "Güiria",
            "Güigüe",
            "Guatire",
            "Guarenas",
            "Guanare",
            "Guacara",
            "El Vigía",
            "El Tocuyo",
            "El Tigre",
            "El Limón",
            "El Hatillo",
            "Ejido",
            "Cumaná",
            "Cúa",
            "Coro",
            "Ciudad Guayana",
            "Ciudad Bolívar",
            "Chivacoa",
            "Charallave",
            "Chacao",
            "Tacarigua",
            "Caucagüito",
            "Catia La Mar",
            "Carúpano",
            "Carrizal",
            "Carora",
            "Caracas",
            "Caraballeda",
            "Cantaura",
            "Calabozo",
            "Cagua",
            "Cabimas",
            "Baruta",
            "Barquisimeto",
            "Barinitas",
            "Barinas",
            "Barcelona",
            "Araure",
            "Altagracia de Orituco",
            "Acarigua",
            "Maturín",
            "La Fría",
            "El Cafetal",
            "Caucaguita",
            "La Dolorita",
            "Guasdualito",
            "San Fernando de Apure"
        ],
        "British Virgin Islands" => [
            "Road Town",
            "Tortola"
        ],
        "U.S. Virgin Islands" => [
            "Charlotte Amalie",
            "Saint Croix"
        ],
        "Vietnam" => [
            "Yên Vinh",
            "Yên Bái",
            "Vũng Tàu",
            "Vị Thanh",
            "Vĩnh Yên",
            "Vĩnh Long",
            "Vinh",
            "Việt Trì",
            "Thành Phố Uông Bí",
            "Tuy Hòa",
            "Thành Phố Tuyên Quang",
            "Trà Vinh",
            "Thủ Dầu Một",
            "Ho Chi Minh City",
            "Thanh Hóa",
            "Thành Phố Thái Nguyên",
            "Thành Phố Thái Bình",
            "Tây Ninh",
            "Tân An",
            "Tam Kỳ",
            "Sơn Tây",
            "Sơn La",
            "Sông Cầu",
            "Sóc Trăng",
            "Sa Pá",
            "Sadek",
            "Rạch Giá",
            "Qui Nhon",
            "Quảng Ngãi",
            "Pleiku",
            "Thành Phố Phủ Lý",
            "Phú Khương",
            "Phan Thiết",
            "Phan Rang-Tháp Chàm",
            "Thành Phố Ninh Bình",
            "Nha Trang",
            "Thành Phố Nam Định",
            "Mỹ Tho",
            "Móng Cái",
            "Long Xuyên",
            "Lào Cai",
            "Thành Phố Lạng Sơn",
            "La Gi",
            "Kon Tum",
            "Hưng Yên",
            "Huế",
            "Thành Phố Hạ Long",
            "Hội An",
            "Thành Phố Hòa Bình",
            "Hà Tĩnh",
            "Hà Tiên",
            "Hanoi",
            "Haiphong",
            "Thành Phố Hải Dương",
            "Thành Phố Hà Giang",
            "Hà Đông",
            "Don Luan",
            "Kwang Binh",
            "Ðông Hà",
            "Dien Bien Phu",
            "Da Nang",
            "Ðà Lạt",
            "Củ Chi",
            "Cho Dok",
            "Cát Bà",
            "Cao Lãnh",
            "Thành Phố Cao Bằng",
            "Cần Thơ",
            "Cần Giờ",
            "Cần Giuộc",
            "Cam Ranh",
            "Cẩm Phả Mines",
            "Cà Mau",
            "Buôn Ma Thuột",
            "Bỉm Sơn",
            "Biên Hòa",
            "Bến Tre",
            "Bảo Lộc",
            "Bắc Ninh",
            "Thành phố Bạc Liêu",
            "Bắc Giang",
            "Bắc Kạn",
            "Đinh Văn"
        ],
        "Vanuatu" => [
            "Port-Vila"
        ],
        "Wallis and Futuna" => [
            "Mata-Utu"
        ],
        "Samoa" => [
            "Apia"
        ],
        "Kosovo" => [
            "Zvečan",
            "Vushtrri",
            "Vitina",
            "Ferizaj",
            "Suva Reka",
            "Shtime",
            "Prizren",
            "Pristina",
            "Podujeva",
            "Pejë",
            "Orahovac",
            "Llazicë",
            "Leposaviq",
            "Mitrovicë",
            "Kosovo Polje",
            "Istok",
            "Gjilan",
            "Glogovac",
            "Dragash",
            "Deçan",
            "Gjakovë"
        ],
        "Yemen" => [
            "Zinjibār",
            "Zabīd",
            "Yarīm",
            "Ta‘izz",
            "Sayyān",
            "Sanaa",
            "Saḩar",
            "Sa'dah",
            "Ma'rib",
            "Laḩij",
            "Ibb",
            "Ḩajjah",
            "Dhī as Sufāl",
            "Dhamār",
            "Bayt al Faqīh",
            "Bājil",
            "Ataq",
            "‘Amrān",
            "Al Mukallā",
            "Al Ḩudaydah",
            "Al Ḩazm",
            "Al Bayḑā’",
            "Aden"
        ],
        "Mayotte" => [
            "Mamoudzou",
            "Dzaoudzi",
            "Koungou"
        ],
        "South Africa" => [
            "Roodepoort",
            "Zeerust",
            "Wolmaransstad",
            "White River",
            "Witbank",
            "Westonaria",
            "Wesselsbron",
            "Welkom",
            "Warrenton",
            "Warmbaths",
            "Vryheid",
            "Vryburg",
            "Volksrust",
            "Virginia",
            "Viljoenskroon",
            "Vereeniging",
            "Vanderbijlpark",
            "Upington",
            "Mthatha",
            "Umkomaas",
            "Ulundi",
            "Uitenhage",
            "Tzaneen",
            "Thohoyandou",
            "Theunissen",
            "Thaba Nchu",
            "Tembisa",
            "Stutterheim",
            "Stilfontein",
            "Stanger",
            "Standerton",
            "Springs",
            "Soweto",
            "Somerset East",
            "Siyabuswa",
            "Senekal",
            "Secunda",
            "Scottburgh",
            "Schweizer-Reneke",
            "Sasolburg",
            "Rustenburg",
            "Richmond",
            "Richards Bay",
            "Reitz",
            "Randfontein",
            "Queenstown",
            "Queensdale",
            "Pretoria",
            "Mokopane",
            "Potchefstroom",
            "Port Shepstone",
            "Port Elizabeth",
            "Port Alfred",
            "Plettenberg Bay",
            "Piet Retief",
            "Polokwane",
            "Pietermaritzburg",
            "Phuthaditjhaba",
            "Phalaborwa",
            "Parys",
            "Pampierstad",
            "Oudtshoorn",
            "Orkney",
            "Modimolle",
            "Nkowakowa",
            "Nigel",
            "Newcastle",
            "Nelspruit",
            "Mpumalanga",
            "Mpophomeni",
            "Mossel Bay",
            "Mondlo",
            "Mmabatho",
            "Middelburg",
            "Middelburg",
            "Messina",
            "Margate",
            "Mabopane",
            "Lydenburg",
            "Louis Trichardt",
            "Lichtenburg",
            "Lebowakgomo",
            "Lady Frere",
            "Ladybrand",
            "Kutloanong",
            "Kruisfontein",
            "Krugersdorp",
            "Kroonstad",
            "Kriel",
            "Komatipoort",
            "Kokstad",
            "Knysna",
            "Klerksdorp",
            "Kimberley",
            "Johannesburg",
            "Howick",
            "Hennenman",
            "Hendrina",
            "Heilbron",
            "Heidelberg",
            "Harrismith",
            "Grahamstown",
            "Graaff-Reinet",
            "Giyani",
            "George",
            "Ga-Rankuwa",
            "Fort Beaufort",
            "Fochville",
            "eSikhawini",
            "Ermelo",
            "Empangeni",
            "eMbalenhle",
            "East London",
            "Durban",
            "Dundee",
            "Duiwelskloof",
            "Driefontein",
            "Delmas",
            "De Aar",
            "Cullinan",
            "Cradock",
            "Christiana",
            "Carletonville",
            "Butterworth",
            "Bronkhorstspruit",
            "Brits",
            "Brakpan",
            "Botshabelo",
            "Bothaville",
            "Boksburg",
            "Bloemhof",
            "Bloemfontein",
            "Bhisho",
            "Bethlehem",
            "Bethal",
            "Benoni",
            "Beaufort West",
            "Barberton",
            "Ballitoville",
            "Balfour",
            "Allanridge",
            "Aliwal North",
            "Ekangala",
            "Midrand",
            "Centurion",
            "Worcester",
            "Stellenbosch",
            "Saldanha",
            "Paarl",
            "Malmesbury",
            "Lansdowne",
            "Kraaifontein",
            "Hermanus",
            "Grabouw",
            "Ceres",
            "Cape Town",
            "Atlantis",
            "Rondebosch",
            "Retreat",
            "Diepsloot"
        ],
        "Zambia" => [
            "Nchelenge",
            "Mbala",
            "Kawambwa",
            "Siavonga",
            "Sesheke",
            "Samfya",
            "Petauke",
            "Ndola",
            "Mumbwa",
            "Mufulira",
            "Mpika",
            "Monze",
            "Mongu",
            "Mazabuka",
            "Mansa",
            "Lusaka",
            "Luanshya",
            "Livingstone",
            "Kitwe",
            "Kasama",
            "Kapiri Mposhi",
            "Kansanshi",
            "Kalulushi",
            "Kafue",
            "Kabwe",
            "Choma",
            "Chipata",
            "Chingola",
            "Chililabombwe"
        ],
        "Zimbabwe" => [
            "Zvishavane",
            "Victoria Falls",
            "Shurugwi",
            "Rusape",
            "Redcliff",
            "Norton",
            "Mutare",
            "Masvingo",
            "Marondera",
            "Kwekwe",
            "Karoi",
            "Kariba",
            "Kadoma",
            "Hwange",
            "Harare",
            "Gweru",
            "Gokwe",
            "Chiredzi",
            "Chipinge",
            "Chinhoyi",
            "Chegutu",
            "Bulawayo",
            "Bindura",
            "Beitbridge",
            "Epworth",
            "Chitungwiza"
        ]
    ],

    "fake_profile_locations" => [
      'random' => 'Random',
      'arabic-jordan' => 'Arabic (Jordan)',
      'bulgarian-bulgaria' => 'Bulgarian (Bulgaria)',
      'bengali-bangladesh' => 'Bengali (Bangladesh)',
      'czech-czech-republic' => 'Czech (Czech Republic)',
      'danish-denmark' => 'Danish (Denmark)',
      'german-austria' => 'German (Austria)',
      'german_germany' => 'German (Germany)',
      'greek-greece' => 'Greek (Greece)',
      'english-australia' => 'English (Australia)',
      'english-canada' => 'English (Canada)',
      'english-united-kingdom' => 'English (United Kingdom)',
      'english-new-zealand' => 'English (New Zealand)',
      'english-philippines' => 'English (Philippines)',
      'english-uganda' => 'English (Uganda)',
      'english-united-states' => 'English (United States)',
      'english-south-africa' => 'English (South Africa)',
      'spanish-argentina' => 'Spanish (Argentina)',
      'spanish-spain' => 'Spanish (Spain)',
      'spanish-peru' => 'Spanish (Peru)',
      'spanish-venezuela' => 'Spanish (Venezuela)',
      'persian_Iran' => 'Persian (Iran)',
      'finnish-finland' => 'Finnish (Finland)',
      'french-belgium' => 'French (Belgium)',
      'french-canada' => 'French (Canada)',
      'french-france' => 'French (France)',
      'hungarian-hungary' => 'Hungarian (Hungary)',
      'armenian-armenia' => 'Armenian (Armenia)',
      'indonesian-indonesia' => 'Indonesian (Indonesia)',
      'icelandic-iceland' => 'Icelandic (Iceland)',
      'italian-italy' => 'Italian (Italy)',
      'japanese-japan' => 'Japanese (Japan)',
      'georgian-georgia' => 'Georgian (Georgia)',
      'kazakh-kazakhstan' => 'Kazakh (Kazakhstan)',
      'korean-south-korea' => 'Korean (South Korea)',
      'latvian-latvia' => 'Latvian (Latvia)',
      'montenegro-montenegrin' => 'Montenegro (Montenegrin)',
      'nepali-nepal' => 'Nepali (Nepal)',
      'dutch-belgium' => 'Dutch (Belgium)',
      'dutch-netherlands' => 'Dutch (Netherlands)',
      'norwegian-norway' => 'Norwegian (Norway)',
      'polish-poland' => 'Polish (Poland)',
      'portuguese-brazil' => 'Portuguese (Brazil)',
      'portuguese-portugal' => 'Portuguese (Portugal)',
      'romanian-moldova' => 'Romanian (Moldova)',
      'romanian-romania' => 'Romanian (Romania)',
      'russian-russia' => 'Russian (Russia)',
      'slovak-slovakia' => 'Slovak (Slovakia)',
      'slovenian-slovenia' => 'Slovenian (Slovenia)',
      'serbian-cyrillic-serbia' => 'Serbian (Cyrillic, Serbia)',
      'serbian-latin-serbia' => 'Serbian (Latin, Serbia)',
      'serbian-serbia' => 'Serbian (Serbia)',
      'swedish-sweden' => 'Swedish (Sweden)',
      'turkish-turkey' => 'Turkish (Turkey)',
      'ukrainian-ukraine' => 'Ukrainian (Ukraine)',
      'vietnamese-vietnam' => 'Vietnamese (Vietnam)',
      'chinese-china' => 'Chinese (China)',
      'chinese-taiwan' => 'Chinese (Taiwan)',
    ],
    
    "iso_codes" => [
        "afghanistan" => "AF",
        "albania" => "AL",
        "algeria" => "DZ",
        "argentina" => "AR",
        "armenia" => "AM",
        "australia" => "AU",
        "austria" => "AT",
        "bangladesh" => "BD",
        "belarus" => "BY",
        "belgium" => "BE",
        "belize" => "BZ",
        "benin" => "BJ",
        "burkina faso" => "BF",
        "bolivia" => "BO",
        "bosnia and herzegovina" => "BA",
        "botswana" => "BW",
        "brazil" => "BR",
        "brunei" => "BN",
        "bulgaria" => "BG",
        "burma" => "MM",
        "cambodia" => "KH",
        "cameroon" => "CM",
        "canada" => "CA",
        "central african republic" => "CF",
        "chad" => "TD",
        "chile" => "CL",
        "china" => "CN",
        "colombia" => "CO",
        "congo" => "CD",
        "costa rica" => "CR",
        "cote d'ivoire" => "CI",
        "croatia" => "HR",
        "cuba" => "CU",
        "cyprus" => "CY",
        "czech republic" => "CZ",
        "denmark" => "DK",
        "djibouti" => "DJ",
        "dr congo" => "CD",
        "ecuador" => "EC",
        "egypt" => "EG",
        "el salvador" => "SV",
        "equatorial guinea" => "GQ",
        "eritrea" => "ER",
        "estonia" => "EE",
        "ethiopia" => "ET",
        "finland" => "FI",
        "france" => "FR",
        "french guiana" => "GF",
        "gabon" => "GA",
        "gambia" => "GM",
        "georgia" => "GE",
        "germany" => "DE",
        "greece" => "GR",
        "greenland" => "GL",
        "guatemala" => "GT",
        "guinea bissau" => "GW",
        "guinea" => "GW",
        "guyana" => "GY",
        "honduras" => "HN",
        "hungary" => "HU",
        "iceland" => "IS",
        "india" => "IN",
        "indonesia" => "ID",
        "iran" => "IR",
        "ireland" => "IE",
        "italy" => "IT",
        "japan" => "JP",
        "jordan" => "JO",
        "kazakhstan" => "KZ",
        "kenya" => "KE",
        "kuwait" => "KW",
        "latvia" => "LV",
        "lebanon" => "LB",
        "lesotho" => "LS",
        "liberia" => "LR",
        "libya" => "LY",
        "lithuania" => "LT",
        "madagascar" => "MG",
        "malawi" => "MW",
        "malaysia" => "MY",
        "mali" => "ML",
        "mauritania" => "MR",
        "mexico" => "MX",
        "moldova" => "MD",
        "mongolia" => "MN",
        "montenegro" => "ME",
        "morocco" => "MA",
        "mozambique" => "MZ",
        "namibia" => "NA",
        "netherlands" => "BQ",
        "new zealand" => "NZ",
        "nicaragua" => "NI",
        "north korea" => "KP",
        "norway" => "NO",
        "oman" => "OM",
        "pakistan" => "PK",
        "palestine" => "PS",
        "panama" => "PA",
        "papua new guinea" => "PG",
        "paraguay" => "PY",
        "peru" => "PE",
        "philippines" => "PH",
        "poland" => "PL",
        "portugal" => "PT",
        "puerto rico" => "PR",
        "russia" => "RU",
        "saudi arabia" => "SA",
        "senegal" => "SN",
        "serbia" => "RS",
        "sierra leone" => "SL",
        "singapore" => "SG",
        "slovakia" => "SK",
        "slovenia" => "SI",
        "somalia" => "SO",
        "south africa" => "ZA",
        "south korea" => "KR",
        "spain" => "ES",
        "sri lanka" => "LK",
        "sudan" => "SD",
        "suriname" => "SR",
        "sweden" => "SE",
        "syria" => "SY",
        "taiwan" => "TW",
        "tajikistan" => "TJ",
        "tanzania" => "TZ",
        "thailand" => "TH",
        "togo" => "TG",
        "tunisia" => "TN",
        "turkey" => "TR",
        "turkmenistan" => "TM",
        "ukraine" => "UA",
        "united kingdom" => "GB",
        "united states" => "US",
        "uruguay" => "UY",
        "uzbekistan" => "UZ",
        "venezuela" => "VE",
        "vietnam" => "VN",
        "western sahara" => "EH",
        "yemen" => "YE",
        "zambia" => "ZM",
        "zimbabwe" => "ZW",
        "switzerland" => "CH",
        "netherlands" => "NL",
        "united arab emirates" => "AE",
        "romania" => "RO",
        "iraq" => "IQ",
        "nigeria" => "NG",
        "niger" => "NE",
        "ghana" => "GH",
        "luxembourg" => "LU",
        "nepal" => "NP",
        "uganda" => "UG",
        "rwanda" => "RW",
    ]
];
